var plugins_bb40132b_638b_4a9f_b028_d3fe47acc8d1 = 
{
    "init": function () {

	console.log("插件编写测试");

	this._afterLoadResources = function () {
		// 本函数将在所有资源加载完毕后，游戏开启前被执行
		// 可以在这个函数里面对资源进行一些操作。
		// 若需要进行切分图片，可以使用 core.splitImage() 函数，或直接在全塔属性-图片切分中操作
		// 
		core.ui.statusBar.init();
	}

	// 可以在任何地方（如afterXXX或自定义脚本事件）调用函数，方法为 core.plugin.xxx();
	// 从V2.6开始，插件中用this.XXX方式定义的函数也会被转发到core中，详见文档-脚本-函数的转发。
},
    "resizeTo11": function () {
	if (main.mode == 'editor') {
		return;
	}

	// 在不修改libs的情况下将页面适配为11x11
	core.__SIZE__ = 11;
	core.__PIXELS__ = core.__SIZE__ * 32;
	core.__HALF_SIZE__ = 5;
	// core.bigmap.width = core.__SIZE__;
	// core.bigmap.height = core.__SIZE__;
	core.actions.SIZE = core.__SIZE__;
	core.actions.HSIZE = core.__HALF_SIZE__;
	core.actions.LAST = core.__SIZE__ - 1;
	core.actions.CHOICES_LEFT = 3;
	core.actions.CHOICES_RIGHT = core.actions.LAST - core.actions.CHOICES_LEFT;
	core.ui.SIZE = core.__SIZE__;
	core.ui.HSIZE = core.__HALF_SIZE__;
	core.ui.LAST = core.__SIZE__ - 1;
	core.ui.PIXEL = core.__PIXELS__;
	core.ui.HPIXEL = core.__PIXELS__ / 2;
},
    "statusBar": function () {
	main.dom.floorMsgGroup.style.display = 'none';
	main.dom.statusBar.style.display = 'none';
	main.dom.toolBar.style.display = 'none';

	const GAMEVIEW_WIDTH = 640;
	const GAMEVIEW_HEIGHT = 422;

	const GAMEVIEW_WIDTH_VERTICAL = 388;
	const GAMEVIEW_HEIGHT_VERTICAL = 630;

	const BAR_WIDTH = 125;
	const BAR_HEIGHT_VERTICAL = 130;
	const BORDER_WIDTH = 18;
	const BORDER_HEIGHT = 24;
	
	const ITEM_BOX_LEFT = 13;
	const ITEM_BOX_TOP = 190;
	const ITEM_BOX_LEFT_VERTICAL = 219;
	const ITEM_BOX_TOP_VERTICAL = 10;

	const ITEM_ICON_OUTER_SIZE = 33;

	const EQUIP_BLOCK_LEFT = 525;
	const EQUIP_BLOCK_TOP = 40;
	const EQUIP_BLOCK_LEFT_VERTICAL = 108;
	const EQUIP_BLOCK_TOP_VERTICAL = 0;

	const KEY_BLOCK_LEFT = EQUIP_BLOCK_LEFT;
	const KEY_BLOCK_LEFT_VERTICAL = EQUIP_BLOCK_LEFT_VERTICAL;
	const KEY_BLOCK_TOP_VERTICAL = 86;

	const INFO_BLOCK_LEFT = EQUIP_BLOCK_LEFT;
	const INFO_BLOCK_TOP = 220;
	const INFO_BLOCK_LEFT_VERTICAL = 8;
	const INFO_BLOCK_TOP_VERTICAL = 538;

	const TOOL_BOX_LEFT = EQUIP_BLOCK_LEFT;
	const TOOL_BOX_TOP = 318;
	const TOOL_BOX_LEFT_VERTICAL = 278;
	const TOOL_BOX_TOP_VERTICAL = INFO_BLOCK_TOP_VERTICAL;

	const TOOL_ICON_OUTER_SIZE = 34;

	const INFO_BAR_HEIGHT = 22;
	const INFO_BAR_HEIGHT_VERTICAL = 18;
	const INFO_BAR_TOP = GAMEVIEW_HEIGHT - INFO_BAR_HEIGHT;
	const INFO_BAR_TOP_VERTICAL = GAMEVIEW_HEIGHT_VERTICAL - INFO_BAR_HEIGHT_VERTICAL;

	const TEXT_COLOR = "#E1E1E1";

	const FORCE_COUNTABLE_ITEMS = ["centerFly"];

	const outerBackground = document.createElement('canvas');
	outerBackground.style.position = 'absolute';
	outerBackground.style.zIndex = 5;
	outerBackground.id = 'outerBackground';
	main.dom.outerBackground = outerBackground;
	main.dom.startPanel.insertAdjacentElement('afterend', outerBackground);

	const outerUI = document.createElement('canvas');
	outerUI.style.position = 'absolute';
	outerUI.style.zIndex = 165;
	outerUI.id = 'outerUI';
	main.dom.outerUI = outerUI;
	outerBackground.insertAdjacentElement('afterend', outerUI);
	setTimeout(function () {
		// Should be executed immediately after init()
		main.canvas.outerUI = outerUI.getContext('2d');
	});
	outerUI.onclick = function (e) {
		try {
			e.preventDefault();
			if (!core.isPlaying()) return false;
			const left = core.dom.gameGroup.offsetLeft;
			const top = core.dom.gameGroup.offsetTop;
			const px = parseInt((e.clientX - left) / core.domStyle.scale),
				py = parseInt((e.clientY - top) / core.domStyle.scale);
			core.ui.statusBar.onclick(px, py);
		} catch (ee) {
			main.log(ee);
		}
	}

	const _resize_gameGroup = function (obj) {
		const gameGroup = core.dom.gameGroup;
		gameGroup.style.width = obj.totalWidth + "px";
		gameGroup.style.height = obj.totalHeight + "px";
		gameGroup.style.left = (obj.clientWidth - obj.totalWidth) / 2 + "px";
		gameGroup.style.top = (obj.clientHeight - obj.totalHeight) / 2 + "px";

		core.dom.musicBtn.style.right = (obj.clientWidth - obj.totalWidth) / 2 + "px";
		core.dom.musicBtn.style.bottom = (obj.clientHeight - obj.totalHeight) / 2 - 27 + "px";
		core.dom.enlargeBtn.style.right = (obj.clientWidth - obj.totalWidth) / 2 + 31 + "px";
		core.dom.enlargeBtn.style.bottom = (obj.clientHeight - obj.totalHeight) / 2 - 27 + "px";

		main.dom.startBackground.src = main.styles.startBackground;
	}

	const _resize_canvas = function (obj) {
		main.dom.outerBackground.style.width = obj.totalWidth + 'px';
		main.dom.outerBackground.style.height = obj.totalHeight + 'px';
		main.dom.outerUI.style.width = obj.totalWidth + 'px';
		main.dom.outerUI.style.height = obj.totalHeight + 'px';

		const innerSize = (obj.canvasWidth * core.domStyle.scale) + "px";
		for (let i = 0; i < core.dom.gameCanvas.length; ++i)
			core.dom.gameCanvas[i].style.width = core.dom.gameCanvas[i].style.height = innerSize;
		core.dom.gif.style.width = core.dom.gif.style.height = innerSize;
		core.dom.gif2.style.width = core.dom.gif2.style.height = innerSize;
		core.dom.gameDraw.style.width = core.dom.gameDraw.style.height = innerSize;
		core.dom.gameDraw.style.top = obj.gameDrawBox.top * core.domStyle.scale + "px";
		core.dom.gameDraw.style.left = (obj.gameDrawBox.left) * core.domStyle.scale + "px";

		// resize bigmap
		core.bigmap.canvas.forEach(function (cn) {
			const ratio = core.canvas[cn].canvas.hasAttribute('isHD') ? core.domStyle.ratio : 1;
			core.canvas[cn].canvas.style.width = core.canvas[cn].canvas.width / ratio * core.domStyle.scale + "px";
			core.canvas[cn].canvas.style.height = core.canvas[cn].canvas.height / ratio * core.domStyle.scale + "px";
		});
		// resize dynamic canvas
		for (const name in core.dymCanvas) {
			const ctx = core.dymCanvas[name],
				canvas = ctx.canvas;
			const ratio = canvas.hasAttribute('isHD') ? core.domStyle.ratio : 1;
			canvas.style.width = canvas.width / ratio * core.domStyle.scale + "px";
			canvas.style.height = canvas.height / ratio * core.domStyle.scale + "px";
			canvas.style.left = parseFloat(canvas.getAttribute("_left")) * core.domStyle.scale + "px";
			canvas.style.top = parseFloat(canvas.getAttribute("_top")) * core.domStyle.scale + "px";
		}
		// resize next
		main.dom.next.style.width = main.dom.next.style.height = 5 * core.domStyle.scale + "px";
		main.dom.next.style.borderBottomWidth = main.dom.next.style.borderRightWidth = 4 * core.domStyle.scale + "px";

	}

	core.control.resize = function () {
		if (main.mode == 'editor') return;

		const clientWidth = main.dom.body.clientWidth,
			clientHeight = main.dom.body.clientHeight;
		const canvasWidth = core.__PIXELS__;

		const isVertical = clientHeight > clientWidth;
		core.domStyle.isVertical = isVertical;

		const totalWidth = isVertical ? GAMEVIEW_WIDTH_VERTICAL : GAMEVIEW_WIDTH,
			totalHeight = isVertical ? GAMEVIEW_HEIGHT_VERTICAL : GAMEVIEW_HEIGHT;

		const maxRatio = Math.min(clientWidth / totalWidth, clientHeight / totalHeight);

		core.domStyle.availableScale = [];
		[1, 1.25, 1.5, 1.75, 2].forEach(function (v) {
			if (maxRatio >= v) {
				core.domStyle.availableScale.push(v);
			}
		});

		if (core.domStyle.availableScale.indexOf(core.domStyle.scale) < 0) {
			core.domStyle.scale = Math.min(1, maxRatio);
		} else if (core.getLocalStorage('scale') == null && core.domStyle.availableScale.length >= 2) {
			core.domStyle.scale = core.domStyle.availableScale[core.domStyle.availableScale.length - 2];
			core.setLocalStorage('scale', core.domStyle.scale);
		}

		const totalWidthScaled = totalWidth * core.domStyle.scale,
			totalHeightScaled = totalHeight * core.domStyle.scale;

		const gameDrawBox = isVertical ? { left: BORDER_WIDTH, top: BAR_HEIGHT_VERTICAL + BORDER_HEIGHT } : { left: BAR_WIDTH + BORDER_WIDTH, top: BORDER_HEIGHT };

		const obj = {
			clientWidth: clientWidth,
			clientHeight: clientHeight,
			canvasWidth: canvasWidth,
			totalWidth: totalWidthScaled,
			totalHeight: totalHeightScaled,
			gameDrawBox: gameDrawBox,
			globalAttribute: core.status.globalAttribute || core.initStatus.globalAttribute,
		};

		_resize_gameGroup(obj);
		_resize_canvas(obj);

		if (core.status.automaticRoute == null) core.status.automaticRoute = {};
		core.control.setViewport(32, 32);
		core.updateStatusBar();
	}

	class StatusBar {
		constructor() {
			this.itemMx = [
				["book", "wand", "fly"],
				["cross", "superPotion", "pickaxe"],
				["bomb", "centerFly", "upFly"],
				["downFly", "knife", "snow"],
				["bigKey", "earthquake", "coin"],
			];
		}
		init() {
			this.toolbarAction = [
				[main.core.openKeyBoard, main.core.openQuickShop, function () { core.insertAction([{ type: "insert", name: "游戏说明" }]); } ],
				[main.core.save, main.core.load, main.core.openSettings]
			];
			this.replayAction = [
				[core.triggerReplay, core.stopReplay, core.rewindReplay],
				[core.speedDownReplay, core.speedUpReplay, core.saveReplay]
			];
		}
		update() {
			this._update_background();
			this._update_props();
			this._update_items();
			this._update_equips();
			this._update_keys();
			this._update_infoWindow();
			this._update_infoBar();
		}
		_update_background(updatedFloorTitle) {
			const bgctx = main.dom.outerBackground.getContext("2d");
			const uictx = main.dom.outerUI.getContext("2d");
			if (core.domStyle.isVertical) {
				bgctx.canvas.width = GAMEVIEW_WIDTH_VERTICAL;
				bgctx.canvas.height = GAMEVIEW_HEIGHT_VERTICAL;
				uictx.canvas.width = GAMEVIEW_WIDTH_VERTICAL;
				uictx.canvas.height = GAMEVIEW_HEIGHT_VERTICAL;
				const bg = core.material.images.images["statusBackground_vertical.png"];
				bgctx.drawImage(bg, 0, 0, GAMEVIEW_WIDTH_VERTICAL, GAMEVIEW_HEIGHT_VERTICAL);
				core.setTextAlign('outerUI', 'center');
			} else {
				bgctx.canvas.width = GAMEVIEW_WIDTH;
				bgctx.canvas.height = GAMEVIEW_HEIGHT;
				uictx.canvas.width = GAMEVIEW_WIDTH;
				uictx.canvas.height = GAMEVIEW_HEIGHT;
				const bg = core.material.images.images["statusBackground.jpg"];
				bgctx.drawImage(bg, 0, 0, GAMEVIEW_WIDTH, GAMEVIEW_HEIGHT - INFO_BAR_HEIGHT);
				bgctx.fillStyle = "#676767";
				bgctx.fillRect(0, INFO_BAR_TOP, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT);
				core.setTextAlign('outerUI', 'center');
			}
		}
		// 更新属性
		_update_props(updatedFloorTitle) {
			if (!updatedFloorTitle && core.status.floorId) {
				updatedFloorTitle = core.status.maps[core.status.floorId].title;
			}
			const statusList = ['hp', 'atk', 'def', 'money'];
			const drawStatusList = (baseX, baseY) => {
				let curh = baseY;
				core.setTextAlign('outerUI', 'right');
				statusList.forEach((item) => {
					// 四舍五入
					core.status.hero[item] = Math.round(core.status.hero[item]);
					// 大数据格式化
					if (item == 'def'){
						core.fillText("outerUI", core.getRealStatus(item) + '('+core.getRealStatus('mdef')+')', baseX, curh, TEXT_COLOR, null, 69);
					} else if (item == 'atk' && core.getFlag('swordxx',0)==1){
						core.fillText("outerUI", core.getRealStatus(item), baseX, curh, '#ED1C24', null, 69);
					} else
						core.fillText("outerUI", core.getRealStatus(item), baseX, curh, TEXT_COLOR, null, 69);
					curh += 24;
				});
				core.setTextAlign('outerUI', 'center');
			};
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", 10, 0, 105, 120);
				core.setFont("outerUI", 'bold 14px Verdana');
				if (updatedFloorTitle) {
					core.fillText("outerUI", updatedFloorTitle, 54, 22, TEXT_COLOR);
				}
				drawStatusList(96, 46);
			} else {
				core.clearMap("outerUI", 10, 40, 105, 130);
				core.setFont("outerUI", 'bold 16px Verdana');
				if (updatedFloorTitle) {
					core.fillText("outerUI", updatedFloorTitle, 62, 61, TEXT_COLOR);
				}
				drawStatusList(110, 93);
			}
		}
		_update_items(){
			const drawItemMx = (drawFn) => {
				for (let i = 0; i < this.itemMx.length; i++) {
					for (let j = 0; j < this.itemMx[i].length; j++) {
						var item = this.itemMx[i][j];
						drawFn(i, j, item);
					}
				}
			};
			const drawItem = (item, posx, posy) => {
				const icon = core.material.icons.items[item], image = core.material.images.items;
				core.drawImage('outerUI', image, 0, 32 * icon, 32, 32, posx, posy, 32, 32);
				const cnt = core.itemCount(item);
				if (item == "wand"){
					core.fillText('outerUI', core.getFlag('edge'), posx + 25, posy + 8, '#DA20E8', "bold 10px Verdana");
					core.fillText('outerUI', (100 + 5 * core.getFlag('edge'))-core.getFlag('cutting'), posx + 25, posy + 28, '#C23232', "bold 10px Verdana");
				}else if ((core.items.items[item].cls === "tools" && cnt > 1) || FORCE_COUNTABLE_ITEMS.includes(item)) {
					core.fillText('outerUI', cnt, posx + 25, posy + 28, '#FFFFFF', "bold 12px Verdana");
				}
				// if (this.selectId == item)
				//     core.strokeRect('outerUI', posx + 17, posy - 4, 40, 40, '#FFD700');
			}
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", ITEM_BOX_LEFT_VERTICAL, ITEM_BOX_TOP_VERTICAL, 105, 185);
				drawItemMx((i, j, item) => {
					if (core.hasItem(item)) {
						const posx = ITEM_BOX_LEFT_VERTICAL + i * 33, posy = ITEM_BOX_TOP_VERTICAL + j * 32;
						drawItem(item, posx, posy);
					}
				});
			} else {
				core.clearMap("outerUI", ITEM_BOX_LEFT, ITEM_BOX_TOP, 105, 185);
				drawItemMx((i, j, item) => {
					if (core.hasItem(item)) {
						const posx = ITEM_BOX_LEFT + j * 33, posy = ITEM_BOX_TOP + i * 32;
						drawItem(item, posx, posy);
					}
				});
			}
		}
		_update_equips() {
			core.setFont("outerUI", 'bold 16px Verdana');
			const drawEquip = (baseX, baseY, id, color, back) => {
				if (!id) core.fillText("outerUI", back, baseX + 50, baseY + 22, color);
				else {
					core.fillText("outerUI", core.material.items[id].name, baseX + 32, baseY + 22, color);
					var icon = core.material.icons.items[id];
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, baseX + 64, baseY, 32, 32);
				}
			};
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL, 105, 95);
				drawEquip(EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL + 9, core.getFlag("nowWeapon"), "#FFCFAE", "无武器");
				drawEquip(EQUIP_BLOCK_LEFT_VERTICAL, EQUIP_BLOCK_TOP_VERTICAL + 49, core.getFlag("nowShield"), "#D1CEFF", "无武器");
			} else {
				core.clearMap("outerUI", EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP, 105, 95);
				drawEquip(EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP + 8, core.getFlag("nowWeapon"), "#FFCFAE", "无武器");
				drawEquip(EQUIP_BLOCK_LEFT, EQUIP_BLOCK_TOP + 56, core.getFlag("nowShield"), "#D1CEFF", "无武器");
			}
		}
		_update_keys() {
			const drawKeyList = (baseX, baseY, lines, rows) => {
				const todraw = [], keyList = ['yellowKey', 'blueKey', 'redKey'];
				let total = 0;
				keyList.forEach(function (key, i) {
					todraw[i] = core.itemCount(key);
					total += todraw[i];
				});
				if (total > lines * rows) {
					let dn = 2;
					for (let i = 0; i <= dn; i++) {
						let deltaX = i * 32, deltaY = parseInt((lines - 1) / 2 * 14);
						this.drawKey(keyList[i], baseX + deltaX, baseY + deltaY);
						core.setFont("outerUI", 'bold 14px Verdana');
						core.setTextAlign("outerUI", "left");
						core.fillText("outerUI", todraw[i], baseX + deltaX + 10, baseY + deltaY + 20, TEXT_COLOR);
					}
				} else {
					let dn = 2, dc = 0;
					while (dn >= 0 && dc < lines * rows) {
						if (todraw[dn]) {
							this.drawKey(keyList[dn], baseX + (dc % rows) * 14, baseY + parseInt(dc / rows) * 17);
							todraw[dn]--, dc++;
						} else dn--;
					}
				}
			};
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", KEY_BLOCK_LEFT_VERTICAL, KEY_BLOCK_TOP_VERTICAL, 105, 75);
				drawKeyList(KEY_BLOCK_LEFT_VERTICAL + 3, KEY_BLOCK_TOP_VERTICAL + 2, 2, 7);
			} else {
				core.clearMap("outerUI", KEY_BLOCK_LEFT, 140, 105, 75);
				drawKeyList(KEY_BLOCK_LEFT + 3, 142, 3, 7);
			}
		}
		drawKey(key, x, y) {
			let sx = 3, sy = 0;
			if (key == "blueKey") sx += 16;
			else if (key == "yellowKey") sy += 16;
			core.drawImage("outerUI", core.statusBar.icons.keys, sx, sy, 10, 16, x, y, 10, 16);
		}
		_update_infoWindow() {
			const itemId = this.selectedItem;
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", INFO_BLOCK_LEFT_VERTICAL, INFO_BLOCK_TOP_VERTICAL, 260, 64);
				if (this.selectedItem) {
					const icon = core.material.icons.items[itemId];
					core.fillText("outerUI", core.material.items[itemId].name, INFO_BLOCK_LEFT_VERTICAL + 32, INFO_BLOCK_TOP_VERTICAL + 35, "#D1CEFF");
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, INFO_BLOCK_LEFT_VERTICAL + 64, INFO_BLOCK_TOP_VERTICAL + 15, 32, 32);
					core.ui.drawTextContent("outerUI", core.material.items[itemId].text, {
						left: INFO_BLOCK_LEFT_VERTICAL + 100,
						top: INFO_BLOCK_TOP_VERTICAL + 3,
						maxWidth: 160,
						color: "#D1CEFF"
					});
				}
			} else {
				core.clearMap("outerUI", INFO_BLOCK_LEFT, INFO_BLOCK_TOP, 105, 100);
				if (this.selectedItem) {
					const icon = core.material.icons.items[itemId];
					core.fillText("outerUI", core.material.items[itemId].name, INFO_BLOCK_LEFT + 32, INFO_BLOCK_TOP + 25, "#D1CEFF");
					core.drawImage('outerUI', core.material.images.items, 0, 32 * icon, 32, 32, INFO_BLOCK_LEFT + 64, INFO_BLOCK_TOP + 4, 32, 32);
					core.ui.drawTextContent("outerUI", core.material.items[itemId].text, {
						left: INFO_BLOCK_LEFT + 1,
						top: INFO_BLOCK_TOP + 36,
						maxWidth: 105,
						color: "#D1CEFF"
					});
				}
			}
		}
		showItemInfo(itemId) {
			this.selectedItem = itemId;
			this._update_infoWindow();
		}
		clearItemInfo() {
			this.selectedItem = null;
			this._update_infoWindow();
		}
		_update_toolBox() {
			const tools = core.isReplaying() ?
				[
					[core.status.replay.pausing ? "play" : "pause", "stop", "rewind"],
					["speedDown", "speedUp", "save"],
				] : [
					["keyboard", "shop", "help"],
					["save", "load", "settings"],
				];
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", TOOL_BOX_LEFT_VERTICAL, TOOL_BOX_TOP_VERTICAL, 115, 80);
				for (let i = 0; i < tools.length; i++) {
					for (let j = 0; j < tools[i].length; j++) {
						core.drawIcon("outerUI", tools[i][j], TOOL_BOX_LEFT_VERTICAL + j * 34, TOOL_BOX_TOP_VERTICAL + i * 34, 32, 32);
					}
				}
			} else {
				core.clearMap("outerUI", TOOL_BOX_LEFT, TOOL_BOX_TOP, 115, 80);
				for (let i = 0; i < tools.length; i++) {
					for (let j = 0; j < tools[i].length; j++) {
						core.drawIcon("outerUI", tools[i][j], TOOL_BOX_LEFT + j * 34, TOOL_BOX_TOP + i * 34, 32, 32);
					}
				}
			}
		}
		onclick(x, y) {
			const makeBox = ([x, y], [w, h]) => {
				return [[x, y], [x + w, y + h]];
			}
			const gridify = ([x, y], [gw, gh]) => {
				return [parseInt(x / gw), parseInt(y / gh)];
			}
			const useItem = (itemId) => {
				if (!core.hasItem(itemId)) return;
				if (core.material.items[itemId].cls == "constants") {
					switch (itemId) {
						case "book":
							core.openBook(true);
							break;
						case "fly":
							core.useFly(true);
							break;
						case "wand":
							//core.insertAction({
							//	type: "useItem",
							//	id: itemId
							//});
							core.useItem("wand");
							break;
						case "snow":
							core.useItem("snow");
							break;
						default:
							this.showItemInfo(itemId);
					}
				} else if (itemId != this.selectedItem) {
					this.showItemInfo(itemId);
				} else {
					switch (itemId) {
						case "centerFly":
							core.ui._drawCenterFly();
							break;
						default:
							core.useItem(itemId);
					}
				}
			}
			const inRect = ([x, y], [[sx, sy], [dx, dy]]) => {
				return sx <= x && x <= dx && sy <= y && y <= dy;
			};
			const relativeTo = ([x, y], [ax, ay]) => {
				return [x - ax, y - ay];
			}
			const pos = [x, y];
			if (core.domStyle.isVertical) {
				const itemBox = makeBox([ITEM_BOX_LEFT_VERTICAL, ITEM_BOX_TOP_VERTICAL], [32 * 5, 33 * 3]);
				if (inRect(pos, itemBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					const [gx, gy] = gridify(relativeTo(pos, itemBox[0]), [32, 33]);
					const itemId = this.itemMx[gx][gy];
					useItem(itemId);
					return;
				}
				const toolBox = makeBox([TOOL_BOX_LEFT_VERTICAL, TOOL_BOX_TOP_VERTICAL], [34 * 3, 34 * 2]);
				if (inRect(pos, toolBox)) {
					const [row, col] = gridify(relativeTo(pos, toolBox[0]), [34, 34]);
					if (core.isReplaying()) {
						this.replayAction[col][row].call(core);
					} else if (core.isPlaying()) {
						this.toolbarAction[col][row].call(core, true);
					}
					return;
				}
			} else {
				const itemBox = makeBox([ITEM_BOX_LEFT, ITEM_BOX_TOP], [33 * 3, 32 * 5]);
				if (inRect(pos, itemBox)) {
					if (core.isReplaying() || core.status.lockControl || core.isMoving()) return;
					const [gx, gy] = gridify(relativeTo(pos, itemBox[0]), [33, 32]);
					const itemId = this.itemMx[gy][gx];
					useItem(itemId);
					return;
				}
				const toolBox = makeBox([TOOL_BOX_LEFT, TOOL_BOX_TOP], [34 * 3, 34 * 2]);
				if (inRect(pos, toolBox)) {
					const [row, col] = gridify(relativeTo(pos, toolBox[0]), [34, 34]);
					if (core.isReplaying()) {
						this.replayAction[col][row].call(core);
					} else if (core.isPlaying()) {
						this.toolbarAction[col][row].call(core, true);
					}
					return;
				}
			}
		}
		infoText;
		infocnt = 0;
		_update_infoBar() {
			core.setTextAlign('outerUI', 'left');
			const text = this.infoText;
			if (core.domStyle.isVertical) {
				core.clearMap("outerUI", 0, INFO_BAR_TOP_VERTICAL, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT_VERTICAL);
				core.setFont("outerUI", 'bold 14px Verdana');
				if (text) {
					core.fillText("outerUI", text, 10, INFO_BAR_TOP_VERTICAL + 14, TEXT_COLOR);
				}
			} else {
				core.clearMap("outerUI", 0, INFO_BAR_TOP, GAMEVIEW_WIDTH, INFO_BAR_HEIGHT);
				core.setFont("outerUI", 'bold 16px Verdana');
				if (text) {
					core.fillText("outerUI", text, 10, INFO_BAR_TOP + 16, TEXT_COLOR);
				}
			}
			core.setTextAlign('outerUI', 'center');
		}
		print(text, cnt = 1) {
			this.infoText = text;
			this.infocnt = cnt;
			this._update_infoBar();
		}
		static infoRules = [
			{ id: "lava", text: "岩浆好热啊!" },
			{ id: "upFloor", text: "你看到了楼梯" },
			{ id: "downFloor", text: "你看到了楼梯" },
			{ id: "blueShop", text: "你看到了一个祭坛" },
			{ id: "man", text: "你看到了一个老人" },
			{ id: "woman", text: "你看到了一个商人" },
			{ id: "fairy", text: "你看到了一个商人" },
			{ id: "thief", text: "你看到了一个小偷" },
		]
		printEnvironmentInfo() {
			if (!this.infocnt) {
				return;
			}
			const ids = [];
			for (const block of core.status.thisMap.blocks) {
				if (!block.disable && core.nearHero(block.x, block.y)) ids.push(block.event.id);
			}
			for (const infoRule of StatusBar.infoRules) {
				if (ids.indexOf(infoRule.id) >= 0) {
					this.print(infoRule.text);
					return;
				}
			}
		}
		clearInfo(etype) {
			this.clearItemInfo();
			if (this.infocnt == 1) {
				setTimeout(() => {
					if (this.infocnt === 0) {
						this.infoText = void 0;
						this._update_infoBar();
					}
				}, 200);
				this.infocnt = 0;
			} else if (this.infocnt > 1) {
				this.infocnt--;
			}
		}
	}

	core.ui.statusBar = new StatusBar();

	core.control.clearStatusBar = function () {
		core.clearMap("outerUI");
	}
	// init() called in `afterLoadResources`.
},
    "override": function () {

	core.statusBar.icons = {
		'floor': 0,
		'name': null,
		'lv': 1,
		'hpmax': 2,
		'hp': 3,
		'atk': 4,
		'def': 5,
		'mdef': 6,
		'money': 7,
		'experience': 8,
		'up': 9,
		'book': 10,
		'fly': 11,
		'toolbox': 12,
		'keyboard': 13,
		'shop': 14,
		'save': 15,
		'load': 16,
		'settings': 17,
		'play': 18,
		'pause': 19,
		'stop': 20,
		'speedDown': 21,
		'speedUp': 22,
		'rewind': 23,
		'equipbox': 24,
		'mana': 25,
		'skill': 26,
		'paint': 27,
		'erase': 28,
		'empty': 29,
		'exit': 30,
		'btn1': 31,
		'btn2': 32,
		'btn3': 33,
		'btn4': 34,
		'btn5': 35,
		'btn6': 36,
		'btn7': 37,
		'btn8': 38,
		'keys': 39,
		'help': 40,
		'battle': 41
	};

	core.actions._clickCenterFly = function (x, y) {
		var posX = core.status.event.data.posX,
			posY = core.status.event.data.posY;
		core.ui.closePanel();
		if (x == posX && y == posY) {
			if (core.canUseItem('centerFly')) {
				core.useItem('centerFly');
			} else {
				core.drawTip('当前不能使用中心对称飞行器');
			}
		} else core.drawTip('取消使用');
	}

	var _clickSL = core.actions._clickSL;
	core.actions._clickSL = function (x, y) {
		var page = core.status.event.data.page,
			offset = core.status.event.data.offset;
		var index = page * 10 + offset;

		// 上一页
		if ((x == this.HSIZE - 1 || x == this.HSIZE - 2) && y == this.LAST) {
			core.ui._drawSLPanel(10 * (page - 1) + offset);
			return;
		}
		// 下一页
		if ((x == this.HSIZE + 1 || x == this.HSIZE + 2) && y == this.LAST) {
			core.ui._drawSLPanel(10 * (page + 1) + offset);
			return;
		}
		if ((x == this.HSIZE - 3 || x == this.HSIZE + 3) && y == this.LAST) {
			return;
		}
		_clickSL.call(this, x, y);
	}

	var _sys_longClick_lockControl = core.actions._sys_longClick_lockControl;
	core.actions._sys_longClick_lockControl = function (x, y) {
		if (!core.status.lockControl) return false;

		// 长按SL上下页快速翻页
		if (["save", "load", "replayLoad", "replayRemain"].indexOf(core.status.event.id) >= 0) {
			if (y == this.LAST && x <= this.HSIZE + 3 && x >= this.HSIZE - 3) {
				core.actions._clickSL(x, y);
				return true;
			}
		}
		return _sys_longClick_lockControl.call(this, x, y);
	}
	core.registerAction('longClick', '_sys_longClick_lockControl', core.actions._sys_longClick_lockControl, 50);

	core.control._moveHero_moving = function () {
		core.status.heroStop = false;
		core.status.automaticRoute.moveDirectly = false;
		var move = function () {
			if (!core.status.heroStop) {
				if (core.hasFlag('debug') && core.status.ctrlDown) {
					if (core.status.heroMoving != 0) return;
					// 检测是否穿出去
					var nx = core.nextX(),
						ny = core.nextY();
					if (nx < 1 || nx >= core.bigmap.width - 1 || ny < 1 || ny >= core.bigmap.height - 1) return;
					core.eventMoveHero([core.getHeroLoc('direction')], core.values.moveSpeed, move);
				} else {
					core.moveAction();
					setTimeout(move, 50);
				}
			}
		}
		move();
	}

	core.control._drawHero_updateViewport = function (x, y, offset) {}

	var _drawThumbnail_drawTempCanvas = core.maps._drawThumbnail_drawTempCanvas;
	core.maps._drawThumbnail_drawTempCanvas = function (floorId, blocks, options) {
		if (main.mode == 'editor') {
			_drawThumbnail_drawTempCanvas.call(this, floorId, blocks, options);
			return;
		}

		var width = core.floors[floorId].width;
		var height = core.floors[floorId].height;
		// 绘制到tempCanvas上面
		var tempCanvas = core.bigmap.tempCanvas;
		options.v2 = false;
		tempCanvas.canvas.width = width * 32;
		tempCanvas.canvas.height = height * 32;
		options.ctx = tempCanvas;

		var hasHero = core.status.hero != null,
			flags = null;
		if (options.flags) {
			if (!hasHero) core.status.hero = {};
			flags = core.status.hero.flags;
			core.status.hero.flags = options.flags;
		}
		this._drawThumbnail_realDrawTempCanvas(floorId, blocks, options);

		if (!hasHero) delete core.status.hero;
		else if (flags != null) core.status.hero.flags = flags;
		tempCanvas.setTransform(1, 0, 0, 1, 0, 0);
	}

	var _drawThumbnail_drawToTarget = core.maps._drawThumbnail_drawToTarget;
	core.maps._drawThumbnail_drawToTarget = function (floorId, options) {
		if (main.mode == 'editor') {
			_drawThumbnail_drawToTarget.call(this, floorId, options);
			return;
		}

		var ctx = core.getContextByName(options.ctx);
		if (ctx == null) return;
		var x = options.x || 0,
			y = options.y || 0,
			size = options.size || core.__PIXELS__;
		var tempCanvas = core.bigmap.tempCanvas;
		core.drawImage(ctx, tempCanvas.canvas, 32, 32, core.__PIXELS__, core.__PIXELS__, x, y, size, size);
	}

	var _drawWindowSkin = core.ui.drawWindowSkin;
	core.ui.drawWindowSkin = function (background, ctx, x, y, w, h, direction, px, py) {
		_drawWindowSkin.call(this, background, ctx, x, y, w, h, direction, px, py);

		var c = parseInt(w / 2);
		core.drawImage(ctx, background, 160, 90, 16, 6, x + c - 8, y, 16, 6);
	}

	var _drawPagination = ui.prototype.drawPagination;
	core.ui.drawPagination = function (page, totalPage, y) {
		if (["save", "load", "replayLoad", "replayRemain", "replaySince"].indexOf(core.status.event.id) >= 0) {
			if (totalPage <= 1) return;
			if (y == null) y = this.LAST;

			core.setFillStyle('ui', '#DDDDDD');
			var length = core.calWidth('ui', page, this._buildFont(15, true));

			core.setTextAlign('ui', 'left');
			core.fillText('ui', page, parseInt((this.PIXEL - length) / 2), y * 32 + 19);

			core.setTextAlign('ui', 'center');
			if (page > 1)
				core.fillText('ui', '上一页', this.HPIXEL - 48, y * 32 + 19);
			if (page < totalPage)
				core.fillText('ui', '下一页', this.HPIXEL + 48, y * 32 + 19);
			return;
		}
		_drawPagination.call(this, page, totalPage, y);
	}

	core.ui._drawCenterFly = function () {
		core.lockControl();
		core.status.event.id = 'centerFly';
		var fillstyle = 'rgba(255,0,0,0.5)';
		if (core.canUseItem('centerFly')) fillstyle = 'rgba(0,255,0,0.5)';
		var toX = core.bigmap.width - 1 - core.getHeroLoc('x'),
			toY = core.bigmap.height - 1 - core.getHeroLoc('y');
		this.clearUI();
		core.fillRect('ui', 0, 0, this.PIXEL, this.PIXEL, '#000000');
		core.drawThumbnail(null, null, { heroLoc: core.status.hero.loc, heroIcon: core.status.hero.image, ctx: 'ui', centerX: toX, centerY: toY });
		var offsetX = 1,
			offsetY = 1;
		core.fillRect('ui', (toX - offsetX) * 32, (toY - offsetY) * 32, 32, 32, fillstyle);
		core.status.event.data = { "x": toX, "y": toY, "posX": toX - offsetX, "posY": toY - offsetY };
		core.playSound('打开界面');
		core.drawTip("请确认当前" + core.material.items['centerFly'].name + "的位置", 'centerFly');
		return;
	}

	core.ui.drawHelp = function () {
		core.clearUI();
		core.status.event.id = 'help';
		core.lockControl();
		core.setAlpha('ui', 1);
		core.fillRect('ui', 0, 0, this.PIXEL, this.PIXEL, '#FFFFFF');
		core.drawImage('ui', core.material.images.keyboard, 0, 0, 416, 416, 0, 0, 352, 352);
	}

	core.actions._getClickLoc = function (x, y) {
		var size = 32 * core.domStyle.scale;
		var left = main.dom.gameDraw.offsetLeft + main.dom.gameGroup.offsetLeft;
		var top = main.dom.gameDraw.offsetTop + main.dom.gameGroup.offsetTop;
		var loc = { 'x': Math.max(x - left, 0), 'y': Math.max(y - top, 0), 'size': size };
		return loc;
	}

	core.enemys.getDamageString = function (enemy, x, y, floorId) {
		if (typeof enemy == 'string') enemy = core.material.enemys[enemy];
		var damage = this.getDamage(enemy, x, y, floorId);

		var color = '#000000';

		if (damage == null) {
			damage = "???";
			color = '#FF2222';
		} else {
			if (core.hasFlag('addhp')) {
				if (damage < core.status.hero.hp) color = '#11FF11';
				else color = '#FF2222';
			} else if (damage <= 0) color = '#11FF11';
			else if (damage < core.status.hero.hp / 3) color = '#FFFFFF';
			else if (damage < core.status.hero.hp * 2 / 3) color = '#FFFF00';
			else if (damage < core.status.hero.hp) color = '#FF9933';
			else color = '#FF2222';

			var origin_damage = (Math.abs(damage) + core.getFlag('cutting'));
			damage = core.formatBigNumber(damage, true);
			if (origin_damage >= (100 + 5 * core.getFlag('edge')) && core.status.floorId != "MT50") {
				var forecut = 0;
				var foresee = 0;
				do {
					forecut += Math.max(0, core.status.hero.atk - core.status.hero.def - core.status.hero.mdef);
					origin_damage -= (100 + 5 * core.getFlag('edge'));
					origin_damage += Math.max(0, core.status.hero.atk - core.status.hero.def - core.status.hero.mdef);
					foresee++;
					if (foresee > 9) break;
				} while (origin_damage >= (100 + 5 * (core.getFlag('edge') + foresee)));
				if (foresee > 9) forecut = "x";
				damage += "+" + forecut;
			}
			if (core.enemys.hasSpecial(enemy, 19))
				damage += "+";
			if (core.enemys.hasSpecial(enemy, 21))
				damage += "-";
			if (core.enemys.hasSpecial(enemy, 11))
				damage += "^";
		}

		return {
			"damage": damage,
			"color": color
		};
	}

	core.ui._drawBook_drawDamage = function (index, enemy, offset, position) {
		core.setTextAlign('ui', 'center');
		var damage = enemy.damage,
			color = '#FFFF00';
		var origin_damage = (Math.abs(damage) + core.getFlag('cutting'));
		if (damage == null) {
			damage = '不可攻击';
			color = '#FF2222';
		}
		if (damage == 0) {
			damage = '无危险';
			color = '#11FF11';
		} else {
			if (damage >= core.status.hero.hp) color = '#FF2222';
			else if (damage >= core.status.hero.hp * 2 / 3) color = '#FF9933';
			else if (damage <= 0) color = '#11FF11';
			damage = core.formatBigNumber(damage);
			if (core.enemys.hasSpecial(enemy, 19)) damage += "+";
			if (core.enemys.hasSpecial(enemy, 21)) damage += "-";
			if (core.enemys.hasSpecial(enemy, 11)) damage += "^";
		}
		if (origin_damage >= (100 + 5 * core.getFlag('edge')) && core.status.floorId != "MT50") {
			var forecut = 0;
			var foresee = 0;
			do {
				forecut += Math.max(0, core.status.hero.atk - core.status.hero.def - core.status.hero.mdef);
				origin_damage -= (100 + 5 * core.getFlag('edge'));
				origin_damage += Math.max(0, core.status.hero.atk - core.status.hero.def - core.status.hero.mdef);
				foresee++;
				if (foresee > 99) break;
			} while (origin_damage >= (100 + 5 * (core.getFlag('edge') + foresee)));
			if (foresee > 99) foresee = "99+";
			damage += "[" + foresee + "]";
		}
		if (enemy.notBomb) damage += "[b]";
		core.fillText('ui', damage, offset, position, color, this._buildFont(13, true));
	}

	core.control.checkBlock = function () {
		var x = core.getHeroLoc('x'),
			y = core.getHeroLoc('y'),
			loc = x + "," + y;
		var damage = core.status.checkBlock.damage[loc];
		if (damage) {
			core.status.hero.hp -= damage;
			if (core.getFlag('shield5') >= 1) {
				core.drawTip("你用神圣剑进行了防御，受到 " + Math.floor(damage) + " 点魔法伤害");
			} else {
				core.drawTip("你没有神圣剑不能防御，受到 " + Math.floor(damage) + " 点魔法伤害");
			}
			core.playSound('zone.mp3');
			this._checkBlock_disableQuickShop();
			core.status.hero.statistics.extraDamage += damage;
			if (core.status.hero.hp <= 0) {
				core.status.hero.hp = 0;
				core.updateStatusBar();
				core.events.lose();
				return;
			} else {
				core.updateStatusBar();
			}
		}
		this._checkBlock_ambush(core.status.checkBlock.ambush[loc]);
		this._checkBlock_repulse(core.status.checkBlock.repulse[loc]);
	}

	core.registerSystemEvent("man", function (data, callback) {
		var a = parseInt(core.status.floorId.substring(2));
		var b = core.nextX();
		var c = core.nextY();
		core.insertAction([
			{ "type": "insert", "name": "对话", "args": [a, b, c, 0] },
		]);
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("woman", function (data, callback) {
		var name = core.status.floorId + '@' + core.nextX() + '@' + core.nextY() + '@' + 'A';
		if (core.getFlag(name, 0) == 1) {
			var a = parseInt(core.status.floorId.substring(2));
			var b = core.nextX();
			var c = core.nextY();
			core.insertAction([
				{ "type": "insert", "name": "对话", "args": [a, b, c, 1] },
			]);
		} else {
			core.insertAction([
				{ "type": "insert", "name": "商人", "args": [0] },
			]);
		}
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("specialwall", function (data, callback) {
		if (data.event.id == 'whiteWall' || core.getFlag('talking') > 0) {
			core.insertAction({ 'type': 'openDoor', loc: [data.x, data.y] });
			if (data.event.id != 'whiteWall') {
				core.setFlag('end', 1);
			}
			core.setFlag('talking', 0); //穿墙之后不能再次穿墙
		}
		//console.log(data);
		if (callback) callback();
	});

	core.registerSystemEvent("fakeWall", function (data, callback) {
		if (data.event.id == 'blueWall') {
			core.insertAction([
				{ "type": "openDoor", loc: [data.x, data.y] },
			]);
		}
		//console.log(data);
		if (callback) callback();
	});

	core.ui._drawWindowSelector = function (background, x, y, w, h) {
		w = Math.round(w) + 48;
		h = Math.round(h);
		var ctx = core.ui.createCanvas("_selector", x - 24, y, w, h, 165);
		ctx.canvas.id = '';
		this._drawSelector(ctx, background, w, h);
	}

	core.ui._drawSelector = function (ctx, background, w, h, left, top) {
		left = left || 0;
		top = top || 0;
		ctx = this.getContextByName(ctx);
		if (!ctx) return;
		if (typeof background == 'string')
			background = core.material.images.images[background];
		if (!(background instanceof Image)) return;
		// badge
		ctx.drawImage(background, 132, 68, 24, 24, left + 4, top + 4, 24, 24);
		ctx.drawImage(background, 132, 68, 24, 24, w - left - 28, top + 4, 24, 24);
	}

	core.ui.drawTip = function (text, id, clear) {
		core.ui.statusBar.print(text);
	}

	core.ui.clearMap = function (name, x, y, width, height) {
		if (name == 'all') {
			for (var m in core.canvas) {
				core.canvas[m].clearRect(0, 0, core.bigmap.width * 32, core.bigmap.height * 32);
			}
			core.clearMap("outerUI");
			core.dom.gif.innerHTML = "";
			core.removeGlobalAnimate();
		} else {
			var ctx = this.getContextByName(name);
			if (ctx) ctx.clearRect(x || 0, y || 0, width || ctx.canvas.width, height || ctx.canvas.height);
		}
	}

	core.control._updateStatusBar_setToolboxIcon = function () {
		core.ui.statusBar._update_toolBox();
	}

	var _changeFloor_getInfo = core.events._changeFloor_getInfo;
	core.events._changeFloor_getInfo = function (floorId, stair, heroLoc, time) {
		var info = _changeFloor_getInfo.call(this, floorId, stair, heroLoc, time);
		if (info == null) return null;
		info.time = 0;
		info.origin = floorId;
		return info;
	}

	core.events._changeFloor_afterChange = function (info, callback) {
		if (!info.locked) core.unlockControl();
		core.status.replay.animate = false;
		core.events.afterChangeFloor(info.floorId);

		if (info.origin == ':before') core.ui.statusBar.print('走下了楼梯')
		else if (info.origin == ':next') core.ui.statusBar.print('登上了楼梯')
		if (callback) callback();
	}

	if (window.jsinterface && window.jsinterface.requestLandscape) {
		window.jsinterface.requestLandscape();
	}
},
    "shop": function () {
	// 【全局商店】相关的功能
	// 
	// 打开一个全局商店
	// shopId：要打开的商店id；noRoute：是否不计入录像
	this.openShop = function (shopId, noRoute) {
		var shop = core.status.shops[shopId];
		// Step 1: 检查能否打开此商店
		if (!this.canOpenShop(shopId)) {
			core.drawTip("该商店尚未开启");
			return false;
		}

		// Step 2: （如有必要）记录打开商店的脚本事件
		if (!noRoute) {
			core.status.route.push("shop:" + shopId);
		}

		// Step 3: 检查道具商店 or 公共事件
		if (shop.item) {
			if (core.openItemShop) {
				core.openItemShop(shopId);
			} else {
				core.playSound('操作失败');
				core.insertAction("道具商店插件不存在！请检查是否存在该插件！");
			}
			return;
		}
		if (shop.commonEvent) {
			core.insertCommonEvent(shop.commonEvent, shop.args);
			return;
		}

		_shouldProcessKeyUp = true;

		// Step 4: 执行标准公共商店    
		core.insertAction(this._convertShop(shop));
		return true;
	}

	////// 将一个全局商店转变成可预览的公共事件 //////
	this._convertShop = function (shop) {
		return [
			{ "type": "function", "function": "function() {core.addFlag('@temp@shop', 1);}" },
			{
				"type": "while",
				"condition": "true",
				"data": [
					// 检测能否访问该商店
					{
						"type": "if",
						"condition": "core.isShopVisited('" + shop.id + "')",
						"true": [
							// 可以访问，直接插入执行效果
							{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', false) }" },
						],
						"false": [
							// 不能访问的情况下：检测能否预览
							{
								"type": "if",
								"condition": shop.disablePreview,
								"true": [
									// 不可预览，提示并退出
									{ "type": "playSound", "name": "操作失败" },
									"当前无法访问该商店！",
									{ "type": "break" },
								],
								"false": [
									// 可以预览：将商店全部内容进行替换
									{ "type": "tip", "text": "当前处于预览模式，不可购买" },
									{ "type": "function", "function": "function() { core.plugin._convertShop_replaceChoices('" + shop.id + "', true) }" },
								]
							}
						]
					}
				]
			},
			{ "type": "function", "function": "function() {core.addFlag('@temp@shop', -1);}" }
		];
	}

	this._convertShop_replaceChoices = function (shopId, previewMode) {
		var shop = core.status.shops[shopId];
		var choices = (shop.choices || []).filter(function (choice) {
			if (choice.condition == null || choice.condition == '') return true;
			try { return core.calValue(choice.condition); } catch (e) { return true; }
		}).map(function (choice) {
			var ableToBuy = core.calValue(choice.need);
			return {
				"text": choice.text,
				"icon": choice.icon,
				"color": ableToBuy && !previewMode ? choice.color : [153, 153, 153, 1],
				"action": ableToBuy && !previewMode ? [{ "type": "playSound", "name": "商店" }].concat(choice.action) : [
					{ "type": "playSound", "name": "操作失败" },
					{ "type": "tip", "text": previewMode ? "预览模式下不可购买" : "购买条件不足" }
				]
			};
		}).concat({ "text": "离开", "action": [{ "type": "playSound", "name": "取消" }, { "type": "break" }] });
		core.insertAction({ "type": "choices", "text": shop.text, "choices": choices });
	}

	/// 是否访问过某个快捷商店
	this.isShopVisited = function (id) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		return shops[id].visited;
	}

	/// 当前应当显示的快捷商店列表
	this.listShopIds = function () {
		return Object.keys(core.status.shops).filter(function (id) {
			return core.isShopVisited(id) || !core.status.shops[id].mustEnable;
		});
	}

	/// 是否能够打开某个商店
	this.canOpenShop = function (id) {
		if (this.isShopVisited(id)) return true;
		var shop = core.status.shops[id];
		if (shop.item || shop.commonEvent || shop.mustEnable) return false;
		return true;
	}

	/// 启用或禁用某个快捷商店
	this.setShopVisited = function (id, visited) {
		if (!core.hasFlag("__shops__")) core.setFlag("__shops__", {});
		var shops = core.getFlag("__shops__");
		if (!shops[id]) shops[id] = {};
		if (visited) shops[id].visited = true;
		else delete shops[id].visited;
	}

	/// 能否使用快捷商店
	this.canUseQuickShop = function (id) {
		// 如果返回一个字符串，表示不能，字符串为不能使用的提示
		// 返回null代表可以使用

		// 检查当前楼层的canUseQuickShop选项是否为false
		if (core.status.thisMap.canUseQuickShop === false)
			return '当前楼层不能使用快捷商店。';
		return null;
	}

	var _shouldProcessKeyUp = true;

	/// 允许商店X键退出
	core.registerAction('keyUp', 'shops', function (keycode) {
		if (!core.status.lockControl || core.status.event.id != 'action') return false;
		if ((keycode == 13 || keycode == 32) && !_shouldProcessKeyUp) {
			_shouldProcessKeyUp = true;
			return true;
		}

		if (!core.hasFlag("@temp@shop") || core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (keycode == 88 || keycode == 27) { // X, ESC
			core.actions._clickAction(core.actions.HSIZE, topIndex + choices.length - 1);
			return true;
		}
		return false;
	}, 60);

	/// 允许长按空格或回车连续执行操作
	core.registerAction('keyDown', 'shops', function (keycode) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (keycode == 13 || keycode == 32) { // Space, Enter
			core.actions._clickAction(core.actions.HSIZE, topIndex + core.status.event.selection);
			_shouldProcessKeyUp = false;
			return true;
		}
		return false;
	}, 60);

	// 允许长按屏幕连续执行操作
	core.registerAction('longClick', 'shops', function (x, y, px, py) {
		if (!core.status.lockControl || !core.hasFlag("@temp@shop") || core.status.event.id != 'action') return false;
		if (core.status.event.data.type != 'choices') return false;
		var data = core.status.event.data.current;
		var choices = data.choices;
		var topIndex = core.actions._getChoicesTopIndex(choices.length);
		if (x >= core.actions.CHOICES_LEFT && x <= core.actions.CHOICES_RIGHT && y >= topIndex && y < topIndex + choices.length) {
			core.actions._clickAction(x, y);
			return true;
		}
		return false;
	}, 60);
},
    "编辑器显伤": function () {
	// 在此增加新插件
	/////// 用户设置 ///////
	// 将__enable置为false将关闭插件
	var __enable = true;
	// 魔防攻速之类的属性可以在这里加 ['atk', 'def', 'mdef']
	var heroStatus = ['atk', 'def', 'mdef', 'hp'];
	// saveHero为true 将会把每次造塔测试时的角色数据存下来 否则会读取初始属性
	// 用不着可以关了 节约缓存空间 (虽然根本没多少 还没一个存档大
	// 也可以手动清理 控制台输入core.removeLocalStorage('editorHero')即可
	var saveHero = true;

	// 下为具体实现 懒得写注释了 大概就是写HTML然后注册交互
	if (!__enable || main.mode != 'editor') return;
	core.plugin.initEditorDamage = false;
	if (heroStatus.length >= 4 && !editor.isMobile) editor.dom.mid2.style.top = 650 + 30 * (heroStatus.length - 3) + 'px';
	editor.statusRatio = core.getLocalStorage('statusRatio', 1);
	editor.saveHero = saveHero;
	editor._heroStatus = heroStatus;
	editor.dom.mapEdit.appendChild(core.canvas.damage.canvas)
	var HTML = "<input type='button' value='←'/><input type='button' value='↑'/><input type='button' value='↓'/><input type='button' value='→'/><input type='button' id='bigmapBtn' value='大地图'' style='margin-left: '5px'/>";

	//if (heroStatus.length >= 4 && !editor.isMobile) editor.dom.mid2.style.top = 650 + 30 * (heroStatus.length - 3) + 'px';
	heroStatus.forEach(function (status) {
		var id = status + 'set',
			id2 = status + 'add',
			id3 = status + 'rec',
			id4 = status + 'help';
		HTML += "<br/><input type='text' size='15' id='" + id + "'><input type='button' id='" + id2 + "' value = '+'><input type='button' id='" + id3 + "' value = '-'><input type='button' value='?' id = '" + id4 + "'>"
	});
	document.getElementById('viewportButtons').innerHTML = HTML;
	['set', 'add', 'rec', 'help'].forEach(function (e) {
		heroStatus.forEach(function (status) {
			editor.dom[status + e] = document.getElementById(status + e);
		});
	});
	var _hasItem = core.items.hasItem;
	core.items.hasItem = function (itemId) {
		if (itemId == 'book' && main.mode == 'editor') return true;
		return _hasItem.call(core.items, itemId);
	}
	if (main.mode == "editor") {
		var applyList = ["getDamageString", "nextCriticals", "getEnemyInfo", "getEnemyValue"];
		applyList.forEach(function (name) {
			var func = core.enemys[name];
			core.enemys[name] = function () {
				var args = (arguments.length === 1 ? [arguments[0]] : Array.apply(null, arguments));
				if (typeof args[0] == "string") args[0] = core.enemys.enemys[args[0]];
				return func.apply(core.enemys, args);
			}
		});
	}

	////// 获得勇士属性 //////
	core.control.getStatus = function (name) {
		if (!core.status.hero) return null;
		if (name == 'x' || name == 'y' || name == 'direction')
			return this.getHeroLoc(name);
		/*if ( main.mode == 'editor' && !core.hasFlag('__statistics__')) {
			return data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d.firstData.hero[name];
		}*/
		return core.status.hero[name];
	}

	core.control.updateDamage = function (floorId, ctx) {
		floorId = floorId || core.status.floorId;
		if (!floorId || core.status.gameOver) return;
		var onMap = ctx == null;
		if (main.mode == 'editor') {
			ctx = core.canvas.damage;
			core.updateCheckBlock();
			core.clearMap(ctx);
			if (editor.uivalues.bigmap) return;
		}

		// 没有怪物手册
		if (!core.hasItem('book')) return;
		core.status.damage.posX = core.bigmap.posX;
		core.status.damage.posY = core.bigmap.posY;
		if (!onMap) {
			var width = core.floors[floorId].width,
				height = core.floors[floorId].height;
			// 地图过大的缩略图不绘制显伤
			if (width * height > core.bigmap.threshold) return;
		}
		this._updateDamage_damage(floorId, onMap);
		this._updateDamage_extraDamage(floorId, onMap);
		this.drawDamage(ctx);
	}

	core.control.drawDamage = function (ctx) {
		if (core.status.gameOver || !core.status.damage /* || main.mode != 'play'*/ ) return;
		var onMap = false;
		if (ctx == null) {
			ctx = core.canvas.damage;
			core.clearMap('damage');
			onMap = true;
		}

		if (onMap && core.bigmap.v2) {
			// 检查是否需要重算...
			if (Math.abs(core.bigmap.posX - core.status.damage.posX) >= core.bigmap.extend - 1 ||
				Math.abs(core.bigmap.posY - core.status.damage.posY) >= core.bigmap.extend - 1) {
				return this.updateDamage();
			}
		}
		return this._drawDamage_draw(ctx, onMap);
	}

	////// 以x,y的形式返回每个点的事件 //////
	core.maps.getMapBlocksObj = function (floorId, noCache) {
		floorId = floorId || core.status.floorId;
		if (core.status.mapBlockObjs[floorId] && !noCache && main.mode != 'editor')
			return core.status.mapBlockObjs[floorId];

		var obj = {};
		core.extractBlocks(floorId);
		core.status.maps[floorId].blocks.forEach(function (block) {
			obj[block.x + "," + block.y] = block;
		});
		core.status.mapBlockObjs[floorId] = obj
		return obj;
	}

	this.bignum = function (num, defaultValue) {
		if (num == null || num == "") return defaultValue;
		num = num + "";
		var list = {
			'w': 1e4,
			'e': 1e8,
			'z': 1e12,
			'j': 1e16,
			'g': 1e20
		};
		// 浮点数问题
		function checkFloat(num) {
			if (!core.isset(num)) return 0;
			num = num + "";
			var index = num.indexOf(".");
			if (index < 0) return 0;
			else return num.slice(index + 1).length;
		}
		var index = num.search(/w|e|z|j|g/);
		if (index <= 0) {
			num = parseInt(num);
			if (core.isset(num)) return num;
			else {
				alert('不正确的输入');
				return defaultValue;
			}
		}
		for (; index > 0; index = num.search(/w|e|z|j|g/)) {
			var p = num[index],
				q = list[p],
				n = num.slice(0, index),
				m = Math.pow(10, checkFloat(n));
			num = n * m * q / m + num.slice(index + 1);
		}
		return parseInt(num);
	}

	this.updateEditorDamage = function (noSave) {
		core.updateDamage();
		heroStatus.forEach(function (status) {
			editor.dom[status + 'set'].value = core.status.hero[status];
		});
		if (!noSave && editor.saveHero) core.setLocalStorage('editorHero', core.status.hero);
	}

	var _resizeMap = core.maps.resizeMap;
	core.maps.resizeMap = function (floorId) {
		_resizeMap.call(core.maps, floorId);
		if (!core.plugin.initEditorDamage && main.mode == 'editor') {
			core.plugin.initEditorDamage = true;
			var editorHero = core.getLocalStorage('editorHero');
			if (editorHero && saveHero) core.status.hero = editorHero;
			else core.removeLocalStorage('editorHero');
			editor._heroStatus.forEach(function (e) {
				editor.dom[e + 'set'].onchange = function () {
					var status = this.id.slice(0, -3);
					core.status.hero[status] = core.bignum(this.value, core.status.hero[status]);
					core.updateEditorDamage();
				}
				editor.dom[e + 'add'].onclick = function () {
					var status = this.id.slice(0, -3);
					core.status.hero[status] += editor.statusRatio;
					core.updateEditorDamage();
				}
				editor.dom[e + 'rec'].onclick = function () {
					var status = this.id.slice(0, -3);
					core.status.hero[status] -= editor.statusRatio;
					core.updateEditorDamage();
				}
				editor.dom[e + 'help'].onclick = function () {
					var status = this.id.slice(0, -4),
						name = core.getStatusLabel(status);
					var ratio = parseInt(prompt("当前属性:" + name + "\n现在的点击按钮变化值:" + editor.statusRatio + ",请输入按下一次+/-按钮的属性变化量,可以写4w 10.2e这种字母缩写"));
					if (!core.isset(ratio)) {
						printe('不合法的输入');
						return;
					}
					editor.statusRatio = ratio;
					core.setLocalStorage('statusRatio', ratio);
				}
			});
			var _updateMap = editor.updateMap;
			editor.updateMap = function () {
				_updateMap.call(editor);
				core.updateEditorDamage(true);
			}
			editor.mode.onmode = function (mode, callback) {
				if (editor_mode.mode != mode) {
					if (mode === 'save') {
						editor_mode.doActionList(editor_mode.mode, editor_mode.actionList, function () {
							if (callback) callback();
							core.updateEditorDamage();
						});
					}
					if (editor_mode.mode === 'nextChange' && mode) editor_mode.showMode(mode);
					if (mode !== 'save') editor_mode.mode = mode;
					editor_mode.actionList = [];
				}
			}
		}
	}
},
    "血瓶宝石显示": function () {/* 宝石血瓶左下角显示数值
 * 注意！！！不要在道具属性中直接操作flags，使用core.status.hero.flags或core.setFlag系列函数代替！
 * 需要将 变量：itemDetail改为true才可正常运行
 * 请尽量减少勇士的属性数量，否则可能会出现严重卡顿（划掉，现在你放一万个属性也不会卡）
 * 注意：这里的属性必须是core.status.hero里面的，flag无法显示
 * 如果不想显示，可以core.setFlag("itemDetail", false);
 * 然后再core.getItemDetail();
 * 如有bug在大群或造塔群@古祠
 */

// 忽略的道具
const ignore = ['superPotion'];

// 取消注释下面这句可以减少超大地图的判定。
// 如果地图宝石过多，可能会略有卡顿，可以尝试取消注释下面这句话来解决。
// core.bigmap.threshold = 256;
const origin = core.control.updateStatusBar;
core.updateStatusBar = core.control.updateStatusBar = function () {
    if (core.getFlag('__statistics__')) return;
    else return origin.apply(core.control, arguments);
}

core.control.updateDamage = function (floorId, ctx) {
    floorId = floorId || core.status.floorId;
    if (!floorId || core.status.gameOver || main.mode != 'play') return;
    const onMap = ctx == null;

    // 没有怪物手册
    if (!core.hasItem('book')) return;
    core.status.damage.posX = core.bigmap.posX;
    core.status.damage.posY = core.bigmap.posY;
    if (!onMap) {
        const width = core.floors[floorId].width,
            height = core.floors[floorId].height;
        // 地图过大的缩略图不绘制显伤
        if (width * height > core.bigmap.threshold) return;
    }
    this._updateDamage_damage(floorId, onMap);
    this._updateDamage_extraDamage(floorId, onMap);
    core.getItemDetail(floorId); // 宝石血瓶详细信息
    this.drawDamage(ctx);
};
// 获取宝石信息 并绘制
this.getItemDetail = function (floorId) {
    if (!core.getFlag('itemDetail')) return;
    if (!core.status.thisMap) return;
    floorId = floorId ?? core.status.thisMap.floorId;
    const beforeRatio = core.status.thisMap.ratio;
    core.status.thisMap.ratio = core.status.maps[floorId].ratio;
    let diff = {};
    const before = core.status.hero;
    const hero = core.clone(core.status.hero);
    const handler = {
        set(target, key, v) {
            diff[key] = v - (target[key] || 0);
            if (!diff[key]) diff[key] = void 0;
            return true;
        }
    };
    core.status.hero = new Proxy(hero, handler);
    core.status.maps[floorId].blocks.forEach(function (block) {
        if (
            block.event.cls !== 'items' ||
            ignore.includes(block.event.id) ||
            block.disable
        )
            return;
        const x = block.x,
            y = block.y;
        // v2优化，只绘制范围内的部分
        if (core.bigmap.v2) {
            if (
                x < core.bigmap.posX - core.bigmap.extend ||
                x > core.bigmap.posX + core._WIDTH_ + core.bigmap.extend ||
                y < core.bigmap.posY - core.bigmap.extend ||
                y > core.bigmap.posY + core._HEIGHT_ + core.bigmap.extend
            ) {
                return;
            }
        }
        diff = {};
        const id = block.event.id;
        const item = core.material.items[id];
        if (item.cls === 'equips') {
            // 装备也显示
            const diff = item.equip.value ?? {};
            const per = item.equip.percentage ?? {};
            for (const name in per) {
                diff[name + 'per'] = per[name].toString() + '%';
            }
            drawItemDetail(diff, x, y);
            return;
        }
        // 跟数据统计原理一样 执行效果 前后比较
        core.setFlag('__statistics__', true);
        try {
            eval(item.itemEffect);
        } catch (error) { }
        drawItemDetail(diff, x, y);
    });
    core.status.thisMap.ratio = beforeRatio;
    core.status.hero = before;
    window.hero = before;
    window.flags = before.flags;
};

// 绘制
function drawItemDetail(diff, x, y) {
    const px = 32 * x + 2,
        py = 32 * y + 30;
    let content = '';
    // 获得数据和颜色
    let i = 0;
    for (const name in diff) {
        if (!diff[name]) continue;
        let color = '#fff';

        if (typeof diff[name] === 'number')
            content = core.formatBigNumber(diff[name], true);
        else content = diff[name];
        switch (name) {
            case 'atk':
            case 'atkper':
                color = '#FF7A7A';
                break;
            case 'def':
            case 'defper':
                color = '#00E6F1';
                break;
            case 'mdef':
            case 'mdefper':
                color = '#6EFF83';
                break;
            case 'hp':
                color = '#A4FF00';
                break;
            case 'hpmax':
            case 'hpmaxper':
                color = '#F9FF00';
                break;
            case 'mana':
                color = '#c66';
                break;
        }
        // 绘制
        core.status.damage.data.push({
            text: content,
            px: px,
            py: py - 10 * i,
            color: color
        });
        i++;
    }
}
},
    "大化便利功能": function () {
	//战斗函数修复，避免与不存在的敌人战斗导致卡死
	events.prototype.battle = function (id, x, y, force, callback) {
		core.saveAndStopAutomaticRoute();
		id = id || core.getBlockId(x, y);
		if (!id || !core.material.enemys[id]) return core.clearContinueAutomaticRoute(callback);
		// 非强制战斗
		if (!core.enemys.canBattle(id, x, y) && !force && !core.status.event.id) {
			core.stopSound();
			core.playSound('操作失败');
			core.drawTip("你打不过此怪物！", id);
			return core.clearContinueAutomaticRoute(callback);
		}
		// 自动存档
		if (!core.status.event.id) core.autosave(true);
		// 战前事件
		if (!this.beforeBattle(id, x, y))
			return core.clearContinueAutomaticRoute(callback);
		// 战后事件
		this.afterBattle(id, x, y);
		if (callback) callback();
	}
	control.prototype.getRealStatusOrDefault = function (status, name) {
		if (status && name in status)
			return Math.floor(status[name]);
		return Math.floor(this.getStatus(name) * this.getBuff(name));
	}
	//临界函数修复，现在会计入敌人的额外属性加成
	enemys.prototype._nextCriticals_overAtk = function (enemy, x, y, floorId) {
		var hero_atk = core.getRealStatusOrDefault(null, 'atk');
		var enemyInfo = core.enemys.getEnemyInfo(enemy, null, x, y, floorId);
		var calNext = function (currAtk, maxAtk) {
			var start = currAtk,
				end = maxAtk;
			if (start > end) return null;

			while (start < end) {
				var mid = Math.floor((start + end) / 2);
				if (mid - start > end - mid) mid--;
				var nextInfo = core.enemys.getDamageInfo(enemy, { "atk": mid }, x, y, floorId);
				if (nextInfo != null) end = mid;
				else start = mid + 1;
			}
			var nextInfo = core.enemys.getDamageInfo(enemy, { "atk": start }, x, y, floorId);
			return nextInfo == null ? null : [start - hero_atk, nextInfo];
		}
		return calNext(hero_atk + 1,
			enemyInfo.hp + enemyInfo.def);
	}
	//临界计算现在会以当前勇士攻击力为准，也就是会计入buff
	enemys.prototype._nextCriticals_useBinarySearch = function (enemy, info, number, x, y, floorId) {
		var mon_hp = info.mon_hp,
			hero_atk = core.getRealStatusOrDefault(null, 'atk'),
			mon_def = info.mon_def,
			pre = info.damage;
		var list = [];
		var start_atk = hero_atk;
		if (info.__over__) {
			start_atk += info.__overAtk__;
			list.push([info.__overAtk__, -info.damage]);
		}
		var calNext = function (currAtk, maxAtk) {
			var start = Math.floor(currAtk),
				end = Math.floor(maxAtk);
			if (start > end) return null;

			while (start < end) {
				var mid = Math.floor((start + end) / 2);
				if (mid - start > end - mid) mid--;
				var nextInfo = core.enemys.getDamageInfo(enemy, { "atk": mid }, x, y, floorId);
				if (nextInfo == null || (typeof nextInfo == 'number')) return null;
				if (pre > nextInfo.damage) end = mid;
				else start = mid + 1;
			}
			var nextInfo = core.enemys.getDamageInfo(enemy, { "atk": start }, x, y, floorId);
			return nextInfo == null || (typeof nextInfo == 'number') || nextInfo.damage >= pre ? null : [start, nextInfo.damage];
		}
		var currAtk = start_atk;
		while (true) {
			var next = calNext(currAtk + 1, mon_hp + mon_def, pre);
			if (next == null) break;
			currAtk = next[0];
			pre = next[1];
			list.push([currAtk - hero_atk, info.damage - pre]);
			if (pre <= 0 && !core.flags.enableNegativeDamage) break;
			if (list.length >= number) break;
		}
		if (list.length == 0) list.push([0, 0]);
		return list;
	}
	//自动寻路会智能避开楼梯
	maps.prototype._automaticRoute_bfs = function (startX, startY, destX, destY) {
		var route = {},
			canMoveArray = this.generateMovableArray();
		// 使用优先队列
		var queue = new PriorityQueue({ comparator: function (a, b) { return a.depth - b.depth; } });
		route[startX + "," + startY] = '';
		queue.queue({ depth: 0, x: startX, y: startY });
		var blocks = core.getMapBlocksObj();
		while (queue.length != 0) {
			var curr = queue.dequeue(),
				deep = curr.depth,
				nowX = curr.x,
				nowY = curr.y;
			for (var direction in core.utils.scan) {
				if (!core.inArray(canMoveArray[nowX][nowY], direction)) continue;
				var nx = nowX + core.utils.scan[direction].x;
				var ny = nowY + core.utils.scan[direction].y;
				if (nx < 0 || nx >= core.bigmap.width || ny < 0 || ny >= core.bigmap.height || route[nx + "," + ny] != null) continue;
				// 重点
				if (nx == destX && ny == destY) {
					route[nx + "," + ny] = direction;
					break;
				}
				// 不可通行
				if (core.noPass(nx, ny)) continue;
				let block = core.getBlock(nx, ny);
				if (block && block.event.trigger === 'changeFloor') {
					var ignore = core.flags.ignoreChangeFloor;
					if (block.event.data && block.event.data.ignoreChangeFloor != null)
						ignore = block.event.data.ignoreChangeFloor;
					if (!ignore) continue;
				}
				route[nx + "," + ny] = direction;
				queue.queue({ depth: deep + this._automaticRoute_deepAdd(nx, ny, blocks), x: nx, y: ny });
			}
			if (route[destX + "," + destY] != null) break;
		}
		return route;
	}
	//楼传操作页面按钮加大
	actions.prototype._sys_longClick_lockControl = function (x, y, px, py) {
		if (!core.status.lockControl) return false;
		if (core.status.event.id == 'text') {
			core.drawText();
			return true;
		}
		if (core.status.event.id == 'action' && core.status.event.data.type == 'text') {
			core.doAction();
			return true;
		}
		// 长按楼传器的箭头可以快速翻页
		if (core.status.event.id == 'fly') {
			if ((x >= this.SIZE - 4 && x <= this.SIZE - 1) && ((y >= this.HSIZE - 1 && y <= this.HSIZE) || (y >= this.HSIZE + 2 && y <= this.HSIZE + 3))) {
				this._clickFly(x, y);
				return true;
			}
		}
		// 长按SL上下页快速翻页
		if (["save", "load", "replayLoad", "replayRemain", "replaySince"].indexOf(core.status.event.id) >= 0) {
			if ([this.HSIZE - 2, this.HSIZE - 3, this.HSIZE + 2, this.HSIZE + 3].indexOf(x) >= 0 && y == this.LAST) {
				this._clickSL(x, y);
				return true;
			}
		}
		// 长按可以跳过等待事件
		if (core.status.event.id == 'action' && core.status.event.data.type == 'sleep' &&
			!core.status.event.data.current.noSkip) {
			if (core.timeout.sleepTimeout && !core.hasAsync()) {
				clearTimeout(core.timeout.sleepTimeout);
				core.timeout.sleepTimeout = null;
				core.doAction();
				return true;
			}
		}
		return false;
	}
	//增加报错信息
	utils.prototype.calValue = function (value, prefix) {
		if (!core.isset(value)) return null;

		try {
			if (typeof value === 'string') {
				let original = value;
				if (value.indexOf(':') >= 0 || value.indexOf("flag：") >= 0 || value.indexOf('global：') >= 0) {
					if (value.indexOf('switch:') >= 0)
						value = value.replace(/switch:([a-zA-Z0-9_]+)/g, "core.getFlag('" + (prefix || ":f@x@y") + "@$1', 0)");
					value = this.replaceValue(value);
				}
				return eval(value);
			}
			if (value instanceof Function) {
				return value();
			}
			return value;
		} catch (e) {
			console.error("【calValue 错误】");
			console.error("原始值:", value);
			console.error("前缀:", prefix);
			console.error("错误信息:", e);
			throw e; // 或 return null; 看你是否希望继续运行
		}
	}
	//播放标题页面bgm
	control.prototype._playBgm_play = function (bgm, startTime) {
		if (core.musicStatus.playingBgm === bgm && !core.material.bgms[bgm].paused) return;

		if (core.musicStatus.playingBgm) {
			core.material.bgms[core.musicStatus.playingBgm].pause();
		}

		core.loader.loadBgm(bgm);
		const audio = core.material.bgms[bgm];
		audio.volume = core.musicStatus.userVolume * core.musicStatus.designVolume;
		audio.currentTime = startTime || 0;

		// 创建播放Promise并处理错误
		const playPromise = audio.play();
		if (playPromise !== undefined) {
			playPromise.then(() => {
				core.musicStatus.playingBgm = bgm;
				core.musicStatus.lastBgm = bgm;
			}).catch(e => {
				console.warn("播放失败:", e);

				if (e.name === 'NotAllowedError') {
					core.musicStatus.pendingBgm = { bgm, startTime };

					if (!core.userInteractionListenerAdded) {
						core.userInteractionListenerAdded = true;

						const playPendingBgm = () => {
							document.removeEventListener('click', playPendingBgm);
							core.userInteractionListenerAdded = false;

							const pending = core.musicStatus.pendingBgm;
							if (!pending) return;

							const audio = core.material.bgms[pending.bgm];
							audio.currentTime = pending.startTime || 0;

							// 添加重试播放逻辑
							const retryPlay = () => {
								audio.play().then(() => {
									core.musicStatus.playingBgm = pending.bgm;
									core.musicStatus.lastBgm = pending.bgm;
									core.musicStatus.pendingBgm = null;
								}).catch(retryError => {
									console.warn("重试播放失败:", retryError);
									if (retryError.name === 'NotAllowedError') {
										// 再次添加监听
										document.addEventListener('click', playPendingBgm);
										core.userInteractionListenerAdded = true;
									} else {
										core.musicStatus.pendingBgm = null;
									}
								});
							};

							retryPlay();
						};

						document.addEventListener('click', playPendingBgm);
					}
				} else {
					core.musicStatus.playingBgm = null;
				}
			});
		}
	};
	/**
	 * 强制触发一个自动事件（无视其触发条件），并立即将其标记为“已执行”。
	 * @param {string} symbol 要强制触发的自动事件的唯一标识符 (symbol)。
	 * @param {boolean} [setExecuted=true] 是否要将此事件标记为“已执行”，以防止其再次自动触发。默认为 true。
	 */
	this.forceTriggerAutoEvent = function (x, y, f = core.status.floorId, n = 0, setExecuted) {
		if (setExecuted == null) setExecuted = true;
		const symbol = `${f}@${x}@${y}@${n}`;
		// 1. 在所有自动事件中查找具有指定 symbol 的事件
		var autoEvent = core.status.autoEvents.find(function (event) {
			return event.symbol === symbol;
		});

		// 如果没找到，就在控制台报错并退出
		if (!autoEvent) {
			console.error("错误：未找到 symbol 为 '" + symbol + "' 的自动事件。");
			return;
		}

		// 2. (可选) 将事件标记为“已执行”，这样 checkAutoEvents 就不会再触发它了
		if (setExecuted) {
			core.autoEventExecuted(symbol, true);
		}

		// 3. 准备要执行的事件内容，这部分逻辑和 checkAutoEvents 中完全一样
		var event;
		var x = autoEvent.x,
			y = autoEvent.y,
			floorId = autoEvent.floorId;

		if (x == null && y == null) {
			// 全局事件
			event = [
				{ "type": "dowhile", "condition": "false", "data": autoEvent.data }
			];
		} else {
			// 地图事件
			event = [
				{ "type": "function", "function": "function() { core.pushEventLoc(" + x + ", " + y + ", '" + floorId + "' ); }" },
				{ "type": "dowhile", "condition": "false", "data": autoEvent.data },
				{ "type": "function", "function": "function() { core.popEventLoc(); }" }
			];
		}

		// 4. 将事件插入到队列中立即执行，从而绕过所有条件检查
		core.insertAction(event);

		console.log("已成功强制触发事件 '" + symbol + "'。");
	}
	//录像中自动存档
	control.prototype._replay_SL = function () {
		if (!core.isPlaying() || !core.isReplaying()) return;
		if (!core.status.replay.pausing) {
			core.playSound('操作失败');
			return core.drawTip("请先暂停录像");
		}
		if (core.isMoving() || core.status.replay.animate || core.status.event.id) {
			core.playSound('操作失败');
			return core.drawTip("请等待当前事件的处理结束");
		}
		if (core.hasFlag('__forbidSave__')) {
			core.playSound('操作失败');
			return core.drawTip('当前禁止存档');
		}
		if (core.dymCanvas.replay)
			core.dymCanvas.replay.canvas.style.display = 'none';

		core.lockControl();
		core.status.event.id = 'save';
		var saveIndex = core.saves.saveIndex;
		var page = parseInt((saveIndex - 1) / 5),
			offset = saveIndex - 5 * page;

		core.ui._drawSLPanel(10 * page + offset);
	}
	//怪物手册中自定义怪物合并
	enemys.prototype._getCurrentEnemys_addEnemy = function (enemyId, enemys, used, x, y, floorId) {
		var enemy = this._getCurrentEnemys_getEnemy(enemyId);
		if (enemy == null) return;

		var id = enemy.id;

		var enemyInfo = this.getEnemyInfo(enemy, null, null, null, floorId);
		var locEnemyInfo = this.getEnemyInfo(enemy, null, x, y, floorId);

		// 定义需要比较的属性列表 (添加需要比较的新属性)
		var compareProps = ['atk', 'def', 'hp', 'money', 'exp', 'special', 'point']; // 示例属性

		// 检查属性是否全部相等
		var allPropsEqual = true;
		for (var i = 0; i < compareProps.length; i++) {
			var prop = compareProps[i];
			if (!(Object.is(locEnemyInfo[prop], enemyInfo[prop]))) {
				allPropsEqual = false;
				break;
			}
		}

		if (!core.flags.enableEnemyPoint || allPropsEqual) {
			x = null;
			y = null;
		} else {
			// 检查enemys中是否存在相同属性的怪物
			for (var i = 0; i < enemys.length; ++i) {
				var one = enemys[i];
				if (id == one.id && one.locs != null) {
					// 检查所有定义的属性
					var propsMatch = true;
					for (var j = 0; j < compareProps.length; j++) {
						var prop = compareProps[j];
						if (!Object.is(locEnemyInfo[prop], one[prop])) {
							propsMatch = false;
							break;
						}
					}

					if (propsMatch) {
						one.locs.push([x, y]);
						return;
					}
				}
			}
			enemyInfo = locEnemyInfo;
		}
		var id = enemy.id + ":" + x + ":" + y;
		if (used[id]) return;
		used[id] = true;

		var specialText = core.enemys.getSpecialText(enemy);
		var specialColor = core.enemys.getSpecialColor(enemy);

		var critical = this.nextCriticals(enemy, 1, x, y, floorId);
		if (critical.length > 0) critical = critical[0];

		var e = core.clone(enemy);
		for (var v in enemyInfo) {
			e[v] = enemyInfo[v];
		}
		if (x != null && y != null) {
			e.locs = [
				[x, y]
			];
		}
		e.name = core.getEnemyValue(enemy, 'name', x, y, floorId);
		e.specialText = specialText;
		e.specialColor = specialColor;
		e.damage = this.getDamage(enemy, x, y, floorId);
		e.critical = critical[0];
		e.criticalDamage = critical[1];
		e.defDamage = this._getCurrentEnemys_addEnemy_defDamage(enemy, x, y, floorId);
		enemys.push(e);
	}
	//加防改为一防
	ui.prototype._drawBook_drawRow3 = function (index, enemy, top, left, width, position) {
		// 绘制第三行
		core.setTextAlign('ui', 'left');
		var b13 = this._buildFont(13, true),
			f13 = this._buildFont(13, false);
		var col1 = left,
			col2 = left + width * 9 / 25,
			col3 = left + width * 17 / 25;
		core.fillText('ui', '临界', col1, position, '#DDDDDD', f13);
		core.fillText('ui', core.formatBigNumber(enemy.critical || 0), col1 + 30, position, null, b13);
		core.fillText('ui', '减伤', col2, position, null, f13);
		core.fillText('ui', core.formatBigNumber(enemy.criticalDamage || 0), col2 + 30, position, null, b13);
		core.fillText('ui', '1防', col3, position, null, f13);
		core.fillText('ui', core.formatBigNumber(enemy.defDamage || 0), col3 + 30, position, null, b13);
	}
	enemys.prototype._getCurrentEnemys_addEnemy_defDamage = function (enemy, x, y, floorId) {
		return this.getDefDamage(enemy, 1, x, y, floorId);
	}
	//拾取道具前存档
	control.prototype.moveAction = function (callback) {
		if (core.status.heroMoving > 0) return;
		var noPass = core.noPass(core.nextX(), core.nextY()),
			canMove = core.canMoveHero();
		// 下一个点如果不能走
		if (noPass || !canMove) return this._moveAction_noPass(canMove, callback);
		if (core.getFlag('道具存档', false) && core.getBlockCls(core.nextX(), core.nextY()) === 'items') core.autosave();
		this._moveAction_moving(callback);
	}
	//使用道具前存档
	items.prototype.useItem = function (itemId, noRoute, callback) {
		if (!this.canUseItem(itemId)) {
			if (callback) callback();
			return;
		}
		if (core.material.items[itemId].cls === 'tools') {
			if (noRoute) core.autosave(true);
			else core.autosave(false);
		}
		// 执行道具效果
		this._useItemEffect(itemId);
		// 执行完毕
		this._afterUseItem(itemId);
		// 记录路线
		if (!noRoute) core.status.route.push("item:" + itemId);
		if (callback) callback();
	}
},
    "楼传增强": function () {
	// 在此增加新插件

	// +++ 核心寻路逻辑函数 +++

	/**
	 * @description 检查寻路过程中的一个点是否可以通行。
	 */
	function _checkPointForPathfinding(blocksObj, x, y, floorId) {
		var index = x + "," + y;
		var block = blocksObj[index];

		if (block && !block.disable && (block.event.noPass || block.event.script || block.event.event))
			return false;

		if (block && !block.disable && block.event.trigger) {
			if (block.event.trigger != 'changeFloor') return false;
			var ignore = core.flags.ignoreChangeFloor;
			if (block.event.data && block.event.data.ignoreChangeFloor != null)
				ignore = block.event.data.ignoreChangeFloor;
			if (!ignore) return false;
		}

		if (core.status.checkBlock.damage[index]) return false;
		if (core.status.checkBlock.repulse[index]) return false;
		if (core.status.checkBlock.ambush[index]) return false;

		return true;
	};

	/**
	 * @description 使用BFS算法，检查在指定楼层上，从起点到终点是否存在一条可通行的路径。
	 */
	function canReach(startX, startY, endX, endY, floorId) {
		floorId = floorId || core.status.floorId;
		var map = core.status.maps[floorId];
		if (!map) return false;

		if (startX < 0 || startX >= map.width || startY < 0 || startY >= map.height) return false;
		if (endX < 0 || endX >= map.width || endY < 0 || endY >= map.height) return false;
		if (startX == endX && startY == endY) return true;

		var canMoveArray = core.maps.generateMovableArray(floorId);
		var blocksObj = core.maps.getMapBlocksObj(floorId);
		var bgMap = core.maps.getBgMapArray(floorId);
		core.updateCheckBlock(floorId);

		var queue = [];
		var visited = {};

		var startIndex = startX + "," + startY;
		queue.push(startIndex);
		visited[startIndex] = true;

		var head = 0;
		while (head < queue.length) {
			var now = queue[head++].split(","),
				x = parseInt(now[0]),
				y = parseInt(now[1]);

			for (var direction in core.utils.scan) {
				if (!core.inArray(canMoveArray[x][y], direction)) continue;

				var nx = x + core.utils.scan[direction].x;
				var ny = y + core.utils.scan[direction].y;
				var nindex = nx + "," + ny;

				if (nx == endX && ny == endY)
					return true;

				if (nx < 0 || nx >= map.width || ny < 0 || ny >= map.height) continue;
				if (visited[nindex]) continue;
				if (core.onSki(bgMap[ny][nx])) continue;

				if (!_checkPointForPathfinding(blocksObj, nx, ny, floorId)) continue;

				visited[nindex] = true;
				queue.push(nindex);
			}
		}
		return false;
	};


	// +++ 性能优化：混合策略寻路缓存 +++

	/**
	 * @name clearPathfindingCache
	 * @description 清空寻路缓存。主要用于跨楼层改变地形的罕见事件。
	 * @param {string} [floorId] - 如果提供，则只清除指定楼层的缓存和所有跨楼层路径的缓存。
	 * 如果不提供，则清除所有缓存。
	 * @example
	 * // 某个事件改变了'MT10'层的地形，手动清除其缓存
	 * core.clearPathfindingCache('MT10');
	 */
	core.clearPathfindingCache = function (floorId) {
		if (floorId) {
			if (core.status.hero.flags.pathfindingCache[floorId]) {
				delete core.status.hero.flags.pathfindingCache[floorId];
			}
			// crossFloor 缓存已被移除，但保留此逻辑以兼容旧版或意外情况
			if (core.status.hero.flags.pathfindingCache.crossFloor) {
				delete core.status.hero.flags.pathfindingCache.crossFloor;
			}
		} else {
			core.status.hero.flags.pathfindingCache = {};
		}
	};

	/**
	 * @description 实际执行寻路计算的内部函数
	 */
	function _calculateCanToStair(stair, toIndex, startstair) {
		let targetFloorId = core.floorIds[toIndex];

		let sx, sy;
		let currentFloorId = core.status.floorId;
		if (currentFloorId === targetFloorId && !startstair) {
			sx = core.getHeroLoc('x');
			sy = core.getHeroLoc('y');
		} else {
			const startPoint = core.status.maps[targetFloorId][startstair];
			if (!startPoint) return false;
			[sx, sy] = startPoint;
		}

		core.extractBlocks(targetFloorId);
		const floor = core.status.maps[targetFloorId];

		var destLocs = [];
		for (const block of floor.blocks) {
			if (block.event && block.event.id === stair) {
				destLocs.push([block.x, block.y]);
			}
		}
		if (destLocs.length === 0) return false;

		for (const dest of destLocs) {
			if (canReach(sx, sy, dest[0], dest[1], targetFloorId)) {
				return true;
			}
		}
		return false;
	}

	// +++ 重构后的函数（采用混合缓存策略） +++

	/**
	 * @name canToStair
	 * @description (混合缓存) 检查在指定楼层上，是否能从一个起点到达指定的楼梯口。
	 * 只对非当前楼层进行缓存。
	 */
	const canToStair = function (stair, toIndex, startstair) {
		let targetFloorId = core.floorIds[toIndex];
		let currentFloorId = core.status.floorId;

		// 策略核心：如果是当前楼层，总进行实时计算，不使用缓存
		if (targetFloorId === currentFloorId) {
			return _calculateCanToStair(stair, toIndex, startstair);
		}

		// 对于其他楼层，使用缓存
		if (!core.status.hero.flags.pathfindingCache[targetFloorId]) {
			core.status.hero.flags.pathfindingCache[targetFloorId] = {};
		}
		const floorCache = core.status.hero.flags.pathfindingCache[targetFloorId];
		const cacheKey = `canToStair:${stair}:${startstair}`;
		if (floorCache[cacheKey] != null) {
			return floorCache[cacheKey];
		}

		const result = _calculateCanToStair(stair, toIndex, startstair);
		floorCache[cacheKey] = result;
		return result;
	};

	/**
	 * @name canToFloor
	 * @description (已优化) 检查是否能从当前楼层到达目标楼层。
	 * 此函数不再拥有自己的缓存，而是依赖 canToStair 的缓存策略。
	 * 这确保了涉及当前楼层的计算总是实时的。
	 */
	const canToFloor = function (toFloorId) {
		let floorId = core.status.floorId;
		let index = core.floorIds.indexOf(floorId);
		let toIndex = core.floorIds.indexOf(toFloorId);

		// --- 逻辑修正 ---
		// 如果是同层传送，则检查是否能到达本层的下楼梯处
		if (index === toIndex) {
			// 第一个参数 "downFloor" 指目标是下楼梯
			// 第二个参数 "index" 指当前楼层
			// 第三个参数 null 表示从勇士当前位置开始寻路
			return canToStair("downFloor", index, null);
		}

		if (index < toIndex) { // 上楼
			for (let i = index; i < toIndex; i++) {
				// 对第一段路程(i === index)，起点是勇士当前位置(null)
				// 对后续路程，起点是上一层的上楼梯口，即本层的下楼梯口("downFloor")
				if (!canToStair("upFloor", i, i === index ? null : "downFloor")) {
					return false;
				}
			}
			return true;
		} else { // 下楼
			for (let i = index; i > toIndex; i--) {
				// 对第一段路程(i === index)，起点是勇士当前位置(null)
				// 对后续路程，起点是上一层的下楼梯口，即本层的上楼梯口("upFloor")
				if (!canToStair("downFloor", i, i === index ? null : "upFloor")) {
					return false;
				}
			}
			return true;
		}
	};

	// --- 以下为文件中原有的其他函数，保持不变 ---

	const flyTo = function () {
		let floorId = core.floorIds[core.status.event.data];
		if (core.status.maps[floorId].canFlyTo && core.hasVisitedFloor(floorId)) {
			if (canToFloor(floorId)) {
				core.flyTo(floorId);
			} else {
				core.ui.statusBar.print("勇士无法到达指定楼层");
			}
		} else {
			core.ui.statusBar.print("勇士无法到达指定楼层");
		}
	}

	core.ui.drawFly = function (page) {
		core.status.event.data = page;
		let floorId = core.floorIds[page];
		let index = core.floorIds.indexOf(floorId)
		let title = "魔塔 第" + index.toString().padStart(2, "0") + "层"
		core.clearMap('ui');
		core.setAlpha('ui', 0.85);
		core.fillRect('ui', 0, 0, this.PIXEL, this.PIXEL, '#000000');
		core.setAlpha('ui', 1);
		core.setTextAlign('ui', 'center');
		let str = "\r[\#FFFFFF]" + '楼层跳跃';
		if (core.getFlag('楼传削弱')) {
			if (core.status.maps[floorId].canFlyTo) {
				if (core.hasVisitedFloor(floorId)) {
					// 此处调用canToFloor，其内部的canToStair会智能地使用混合缓存策略
					if (canToFloor(floorId)) {
						str += '（\r[\#00FF00]允许传送\r[\#FFFFFF]）';
					} else {
						str += '（\r[\#FF8247]路线堵塞\r[\#FFFFFF]）';
					}
				} else {
					str += '（\r[\#FF8247]尚未抵达\r[\#FFFFFF]）';
				}
			} else {
				str += '（\r[\#FF0000]禁止传送\r[\#FFFFFF]）';
			}
		}

		core.fillText('ui', str, this.HPIXEL, 40, '#FFFFFF', this._buildFont(20, true));
		core.fillText('ui', '返回游戏', this.HPIXEL, this.PIXEL - 13, null, this._buildFont(15, true))

		if (core.getFlag('楼传削弱')) {
			if (core.status.showOnlyReachableFloors == null) {
				core.status.showOnlyReachableFloors = true;
			}
			let modeText = core.status.showOnlyReachableFloors ? '仅可到达' : '显示全部';
			core.fillText('ui', modeText, 80, this.PIXEL - 13, null, this._buildFont(15, true));
		}

		core.setTextAlign('ui', 'center');

		let middle = this.HPIXEL + 39;

		let lines = core.splitLines('ui', title, 120, this._buildFont(19, true));
		let start_y = middle - (lines.length - 1) * 11;
		for (let i in lines) {
			core.fillText('ui', lines[i], this.PIXEL - 60, start_y, '#FFFFFF');
			start_y += 22;
		}
		let radio = core.status.maps[floorId].ratio
		let wallNum = flags["wallNum" + radio]
		if (wallNum && wallNum[floorId]) {
			let num = wallNum[floorId]
			let lines = core.splitLines('ui', title, 120, this._buildFont(19, true));
			core.fillText('ui', "(" + num + ")", this.PIXEL - 30, start_y, '#FFFF00');
		}

		if (core.actions._getNextFlyFloor(1) != page) {
			core.fillText('ui', '▲', this.PIXEL - 40, middle - 64, '#FFFFFF', this._buildFont(17, false));
			core.fillText('ui', '▲', this.PIXEL - 40, middle - 96);
			core.fillText('ui', '▲', this.PIXEL - 40, middle - 96 - 7);
		}
		if (core.actions._getNextFlyFloor(-1) != page) {
			core.fillText('ui', '▼', this.PIXEL - 40, middle + 64, '#FFFFFF', this._buildFont(17, false));
			core.fillText('ui', '▼', this.PIXEL - 40, middle + 96);
			core.fillText('ui', '▼', this.PIXEL - 40, middle + 96 + 7);
		}
		let size = this.PIXEL - 93;
		core.strokeRect('ui', 20, 53, size, size, '#FFFFFF', 2);
		if (floorId === core.status.floorId) {
			core.drawThumbnail(floorId, null, { ctx: 'ui', x: 20, y: 53, size: size, damage: true, heroLoc: core.status.hero.loc });
		} else {
			core.drawThumbnail(floorId, null, { ctx: 'ui', x: 20, y: 53, size: size, damage: true });
		}
	}

	core.actions._getNextFlyFloor = function (delta, index) {
		if (index == null) index = core.status.event.data;
		if (delta == 0) return index;
		var sign = Math.sign(delta);
		delta = Math.abs(delta);
		var ans = index;
		while (true) {
			index += sign;
			if (index < 0 || index >= core.floorIds.length) break;
			var floorId = core.floorIds[index];

			var canFly = core.status.maps[floorId].canFlyTo && core.hasVisitedFloor(floorId);
			if (canFly) {
				if (core.getFlag('楼传削弱') && core.status.showOnlyReachableFloors) {
					if (canToFloor(floorId)) {
						delta--;
						ans = index;
					}
				} else {
					delta--;
					ans = index;
				}
			}
			if (delta == 0) break;
		}
		return ans;
	}

	core.actions._clickFly = function (x, y, px, py) {
		var button_x = core.__PIXELS__ - 40;
		var button_y = core.__PIXELS__ / 2 + 39;
		var size = core.__PIXELS__ - 93;
		if ((px >= button_x - 16 && px <= button_x + 16) && (py >= button_y + 64 - 16 && py <= button_y + 64 + 16)) {
			core.playSound('光标移动');
			core.ui.drawFly(this._getNextFlyFloor(-1));
		}
		if ((px >= button_x - 16 && px <= button_x + 16) && (py >= button_y - 64 - 7 - 16 && py <= button_y - 64 + 16)) {
			core.playSound('光标移动');
			core.ui.drawFly(this._getNextFlyFloor(1));
		}
		if ((px >= button_x - 16 && px <= button_x + 16) && (py >= button_y + 96 - 16 && py <= button_y + 96 + 7 + 16)) {
			core.playSound('光标移动');
			core.ui.drawFly(this._getNextFlyFloor(-10));
		}
		if ((px >= button_x - 16 && px <= button_x + 16) && (py >= button_y - 96 - 16 && py <= button_y - 96 - 7 + 16)) {
			core.playSound('光标移动');
			core.ui.drawFly(this._getNextFlyFloor(10));
		}

		if (core.getFlag('楼传削弱')) {
			if ((px >= 63 && px <= 97) && (py >= core.__PIXELS__ - 28 && py <= core.__PIXELS__ - 9)) {
				core.playSound('光标移动');
				core.status.showOnlyReachableFloors = !core.status.showOnlyReachableFloors;
				core.ui.drawFly(core.status.event.data);
			}
		}

		if (x >= this.HSIZE - 1 && x <= this.HSIZE + 1 && y == this.LAST) {
			core.updateCheckBlock(core.status.floorId);
			core.playSound('取消');
			core.ui.closePanel();
		}
		if ((px >= 20 && px <= 20 + size) && (py >= 53 && py <= 53 + size)) {
			if (core.getFlag('楼传削弱'))
				flyTo();
			else
				core.flyTo(core.floorIds[core.status.event.data]);
		}
		return;
	}

	core.actions._keyUpFly = function (keycode) {
		if (keycode == 71 || keycode == 27) {
			core.updateCheckBlock(core.status.floorId);
			core.playSound('取消');
			core.ui.closePanel();
		}
		if (keycode == 88) {
			if (core.hasItem("book")) core.openBook(true);
		}
		if (keycode == 13 || keycode == 32 || keycode == 67) {
			if (core.getFlag('楼传削弱'))
				flyTo();
			else
				core.flyTo(core.floorIds[core.status.event.data]);
		}
		if (core.getFlag('楼传削弱') && keycode == 81) {
			core.playSound('光标移动');
			core.status.showOnlyReachableFloors = !core.status.showOnlyReachableFloors;
			core.ui.drawFly(core.status.event.data);
		}
		return;
	}

	events.prototype.useFly = function (fromUserAction) {
		if (core.isReplaying()) return;
		if (core.getFlag('楼传削弱')) {
			if (!this._checkStatus('fly', fromUserAction, true)) return;
		} else {
			if (core.status.event.id == 'viewMaps') {
				if (!core.hasItem('fly')) {
					core.playSound('操作失败');
					core.drawTip('你没有' + core.material.items['fly'].name, 'fly');
					return;
				} else if (!core.canUseItem('fly')) {
					core.playSound('操作失败');
					core.drawTip('无法传送到当前层', 'fly');
					return;
				} else {
					core.flyTo(core.status.event.data.floorId);
				}

			}
			if (!this._checkStatus('fly', fromUserAction, true)) return;

			// --- 逻辑修正 ---
			// 如果flyNearStair为true，则检查是否能到达楼梯，而不是是否在楼梯边
			if (core.flags.flyNearStair) {
				let floorId = core.status.floorId;
				let index = core.floorIds.indexOf(floorId);
				// 检查是否能从当前位置到达上楼或下楼梯口
				let canReachUp = canToStair("upFloor", index, null);
				let canReachDown = canToStair("downFloor", index, null);

				if (!canReachUp && !canReachDown) {
					core.playSound('操作失败');
					core.drawTip("附近没有可到达的楼梯，无法使用" + core.material.items['fly'].name, 'fly');
					core.unlockControl();
					core.status.event.data = null;
					core.status.event.id = null;
					return;
				}
			}

			if (!core.canUseItem('fly')) {
				core.playSound('操作失败');
				core.drawTip(core.material.items['fly'].name + "好像失效了", 'fly');
				core.unlockControl();
				core.status.event.data = null;
				core.status.event.id = null;
				return;
			}
		}
		if (core.status.showOnlyReachableFloors == null) {
			core.status.showOnlyReachableFloors = true;
		}
		core.playSound('打开界面');
		core.useItem('fly', true);
		return;
	}

	control.prototype._replayAction_fly = function (action) {
		if (action.indexOf("fly:") != 0) return false;

		// --- 录像回放安全校验 ---
		// 增加与 useFly 中相同的校验，防止通过录像绕过限制
		// 楼传未削弱时，如果 flyNearStair 为 true，检查是否能到达楼梯
		if (!core.getFlag('楼传削弱') && core.flags.flyNearStair) {
			let currentFloorId = core.status.floorId;
			let index = core.floorIds.indexOf(currentFloorId);
			let canReachUp = canToStair("upFloor", index, null);
			let canReachDown = canToStair("downFloor", index, null);

			if (!canReachUp && !canReachDown) {
				// 无法到达楼梯，此步操作在当时是非法的，中止回放
				core.control._replay_error(action);
				return false;
			}
		}

		var floorId = action.substring(4);
		var toIndex = core.floorIds.indexOf(floorId);

		// 检查目标楼层是否存在
		if (toIndex < 0) {
			core.control._replay_error(action);
			return false;
		}

		if (!core.canUseItem('fly')) return false;

		// --- 原有回放逻辑 ---
		core.ui.drawFly(toIndex);
		if (core.status.replay.speed == 24) {
			if (!core.flyTo(floorId, core.replay))
				core.control._replay_error(action);
			return true;
		}
		setTimeout(function () {
			if (!core.flyTo(floorId, core.replay))
				core.control._replay_error(action);
		}, core.control.__replay_getTimeout());
		return true;
	}


	////// 点击怪物手册时的打开操作 //////
	core.events.openBook = function (fromUserAction) {
		if (core.isReplaying()) return;
		// 如果能恢复事件（从callBook事件触发）
		if (core.status.event.id == 'book' && core.events.recoverEvents(core.status.event.interval))
			return;
		// 当前是book，且从“浏览地图”打开
		if (core.status.event.id == 'book' && core.status.event.ui) {
			core.status.boxAnimateObjs = [];
			core.ui.drawFly(core.status.event.ui);
			return;
		}
		// 从“浏览地图”页面打开
		if (core.status.event.id == 'viewMaps' || core.status.event.id == 'fly') {
			fromUserAction = false;
			core.status.event.ui = core.status.event.data;
		}
		if (!this._checkStatus('book', fromUserAction, true)) return;
		core.playSound('打开界面');
		core.useItem('book', true);
	}

	////// 怪物手册界面时，放开某个键的操作 //////
	core.actions._keyUpBook = function (keycode) {
		if (keycode == 27 || keycode == 88) {
			core.playSound('取消');
			if (core.events.recoverEvents(core.status.event.interval)) {
				return;
			} else if (core.status.event.ui != null) {
				core.status.boxAnimateObjs = [];
				if (typeof core.status.event.ui === "number") {
					core.status.event.id = "fly"
					core.ui.drawFly(core.status.event.ui);
				} else {
					core.ui._drawViewMaps(core.status.event.ui);
				}
			} else core.ui.closePanel();
			return;
		}
		if (keycode == 13 || keycode == 32 || keycode == 67) {
			var data = core.status.event.data;
			if (data != null) {
				core.ui._drawBookDetail(data);
			}
			return;
		}
	}

	////// 怪物手册界面的点击操作 //////
	core.actions._clickBook = function (x, y) {
		var pageinfo = core.ui._drawBook_pageinfo();
		// 上一页
		if ((x == this.HSIZE - 2 || x == this.HSIZE - 3) && y == this.LAST) {
			core.playSound('光标移动');
			core.ui.drawBook(core.status.event.data - pageinfo.per_page);
			return;
		}
		// 下一页
		if ((x == this.HSIZE + 2 || x == this.HSIZE + 3) && y == this.LAST) {
			core.playSound('光标移动');
			core.ui.drawBook(core.status.event.data + pageinfo.per_page);
			return;
		}
		// 返回
		if (x >= this.LAST - 2 && y == this.LAST) {
			core.playSound('取消');
			if (core.events.recoverEvents(core.status.event.interval)) {
				return;
			} else if (core.status.event.ui != null) {
				core.status.boxAnimateObjs = [];
				if (typeof core.status.event.ui === "number") {
					core.status.event.id = "fly"
					core.ui.drawFly(core.status.event.ui);
				} else {
					core.ui._drawViewMaps(core.status.event.ui);
				}
			} else core.ui.closePanel();
			return;
		}
		// 怪物信息
		var data = core.status.event.data;
		if (data != null && y < this.LAST) {
			var per_page = pageinfo.per_page,
				page = parseInt(data / per_page);
			var u = this.LAST / per_page;
			for (var i = 0; i < per_page; ++i) {
				if (y >= u * i && y < u * (i + 1)) {
					var index = per_page * page + i;
					core.ui.drawBook(index);
					core.ui._drawBookDetail(index);
					break;
				}
			}
			return;
		}
		return;
	}

	////// 绘制怪物手册 //////
	ui.prototype.drawBook = function (index) {
		var floorId = core.status.floorId;
		if (core.status.event.ui) {
			if (typeof core.status.event.ui === "number") {
				floorId = core.floorIds[core.status.event.ui]
			} else {
				floorId = core.floorIds[(core.status.event.ui || {}).index] || core.status.floorId;
			}
		}
		// 清除浏览地图时的光环缓存
		if (floorId != core.status.floorId && core.status.checkBlock) {
			core.status.checkBlock.cache = {};
		}
		var enemys = core.enemys.getCurrentEnemys(floorId);
		core.clearUI();
		core.clearMap('data');
		// 生成groundPattern
		core.maps.generateGroundPattern(floorId);
		this._drawBook_drawBackground();
		core.setAlpha('ui', 1);

		if (enemys.length == 0) {
			return this._drawBook_drawEmpty();
		}

		index = core.clamp(index, 0, enemys.length - 1);
		core.status.event.data = index;
		var pageinfo = this._drawBook_pageinfo();
		var perpage = pageinfo.per_page,
			page = parseInt(index / perpage) + 1,
			totalPage = Math.ceil(enemys.length / perpage);

		var start = (page - 1) * perpage;
		enemys = enemys.slice(start, page * perpage);

		for (var i = 0; i < enemys.length; i++)
			this._drawBook_drawOne(floorId, i, enemys[i], pageinfo, index == start + i);

		core.drawBoxAnimate();
		this.drawPagination(page, totalPage);
		core.setTextAlign('ui', 'center');
		core.fillText('ui', '返回游戏', this.PIXEL - 46, this.PIXEL - 13, '#DDDDDD', this._buildFont(15, true));
	}
	ui.prototype._drawBookDetail_getInfo = function (index) {
		var floorId = core.status.floorId;
		if (core.status.event.ui) {
			if (typeof core.status.event.ui === "number") {
				floorId = core.floorIds[core.status.event.ui]
			} else {
				floorId = core.floorIds[(core.status.event.ui || {}).index] || core.status.floorId;
			}
		}
		// 清除浏览地图时的光环缓存
		if (floorId != core.status.floorId && core.status.checkBlock) {
			core.status.checkBlock.cache = {};
		}
		var enemys = core.enemys.getCurrentEnemys(floorId);
		if (enemys.length == 0) return [];
		index = core.clamp(index, 0, enemys.length - 1);
		var enemy = enemys[index],
			enemyId = enemy.id;
		var texts = core.enemys.getSpecialHint(enemyId);
		if (texts.length == 0) texts.push("该怪物无特殊属性。");
		if (enemy.description) texts.push(enemy.description + "\r");
		texts.push("");
		this._drawBookDetail_getTexts(enemy, floorId, texts);
		return [enemy, texts];
	}

},
    "砍价": function () {
	//砍价
	this.cut = function (origin_damage) {
		var rank = core.status.thisMap.ratio;
		var hero_hp = Math.max(0, core.status.hero.hp),
			hero_atk = Math.max(0, core.status.hero.atk),
			hero_def = Math.max(0, core.status.hero.def),
			hero_mdef = Math.max(0, core.status.hero.mdef);
		var damage = Math.abs(origin_damage) + core.getFlag('cutting', 0);
		core.addFlag('cutting', Math.abs(origin_damage));
		var wound = 0;
		var reverse = 0;
		//var reward = ['greenGem', 'greenGem', 'blueGem', 'blueGem', 'blueGem', 'blueGem', 'blueGem', 'redPotion', 'redPotion', 'bluePotion'];
		var reward = ['29', '29', '28', '28', '28', '28', '28', '31', '31', '32'];
		if (core.getFlag('knight') >= 1) {
			//	reward.push('yellowGem', 'greenGem', 'blueGem', 'blueGem', 'blueGem', 'redPotion', 'bluePotion', 'yellowKnight', 'yellowKnight', 'yellowKnight');
			reward.push('30', '29', '28', '28', '28', '31', '32', '32', '226', '226');
		}
		if (core.getFlag('hard') == 3) {
			var reward = ['mon', 'mon', 'mon', 'mon', 'mon', 'mon', 'mon', '31', '31', '32'];
			if (core.getFlag('knight') >= 1) {
				reward.push('mon', 'mon', 'mon', 'mon', 'mon', '31', '32', '32', '226', '226');
			}
			reverse = 1;
		}
		if (core.getFlag('hard') == 5) {
			//	reward.push('greenGem', 'blueGem', 'blueGem', 'bluePotion');
			reward.push('29', '28', '28', '32');
			for (var i = 0; i++; i < Math.max(3, (core.getFlag('knight') / 3))) {
				//		reward.push('yellowGem', 'yellowKnight', 'bluePotion');
				reward.push('30', '226', '32');
			}
		}
		while (damage >= (100 + 5 * core.getFlag('edge'))) {
			damage -= (100 + 5 * core.getFlag('edge'));
			core.addFlag('cutting', -(100 + 5 * core.getFlag('edge')));
			wound = Math.max(0, hero_atk - hero_def - hero_mdef);
			// 判定是否致死
			if (wound >= core.status.hero.hp) {
				core.status.hero.hp = 0;
				core.updateStatusBar();
				core.events.lose('战斗失败');
				return;
			}
			if (wound > 0) {
				if (core.getFlag('addhp', 0) == 1) {
					wound *= -1;
					core.insertAction([
						{ "type": "playSound", "name": "bomb.mp3" },
						{ "type": "screenFlash", "color": [22, 222, 22, 0.3], "time": 200, "times": 1, "moveMode": "easeOut", "async": true },
						{ "type": "waitAsync" },
					]);
				} else {
					core.insertAction([
						{ "type": "playSound", "name": "bomb.mp3" },
						{ "type": "screenFlash", "color": [222, 22, 22, 0.3], "time": 200, "times": 1, "moveMode": "easeOut", "async": true },
						{ "type": "waitAsync" },
					]);
				}
			} else {
				core.insertAction([
					{ "type": "playSound", "name": "bomb.mp3" },
					{ "type": "screenFlash", "color": [222, 222, 222, 0.3], "time": 200, "times": 1, "moveMode": "easeOut", "async": true },
					{ "type": "waitAsync" },
				]);
			}
			// 扣减体力值并记录统计数据
			core.status.hero.hp -= wound;
			core.status.hero.statistics.battleDamage += wound;
			core.addFlag('cutting', wound);
			core.addFlag('cutter', wound);
			core.addFlag('edge', 1);
			// 爆金币
			var success = 0;
			var drop = reward[core.rand(reward.length)];
			if (core.getFlag('hard') == 4) {
				if (drop == '32') drop = 22;
			}
			if (drop == 'mon') {
				var monlist = [
					['greenSlime', 'greenSlime', 'redSlime', 'redSlime', 'bat', 'bat', 'bluePriest', 'skeleton', 'skeletonSoilder', 'yellowGuard'],
					['bat', 'bat', 'blackSlime', 'blackSlime', 'bigBat', 'bigBat', 'zombie', 'redPriest', 'rock', 'zombieKnight'],
					['yellowKnight'],
					['zombieKnight', 'zombieKnight', 'slimeMan', 'slimeMan', 'ghostSkeleton', 'ghostSkeleton', 'soldier', 'blueGuard', 'swordsman', 'redKnight'],
					['slimelord', 'slimelord', 'redBat', 'redBat', 'brownWizard', 'brownWizard', 'redWizard', 'whiteKing', 'darkKnight', 'redGuard']
				];
				if (core.status.floorId == "MT25") {
					drop = monlist[3];
				} else {
					var monster = Math.min(9, Math.floor(core.getFlag('edge') / (3 * rank)));
					drop = monlist[rank - 1][monster];
					//core.ui.statusBar.print(monster, 2);
				}
			}
			for (var direction in core.utils.scan2) {
				var delta = core.utils.scan2[direction];
				var nx = core.getHeroLoc('x') + delta.x,
					ny = core.getHeroLoc('y') + delta.y;
				if (reverse) {
					nx = Math.abs(12 - nx);
					ny = Math.abs(12 - ny);
				}
				if (core.getBlockId(nx, ny) == null || core.getBlockId(nx, ny) == 'blueShop-left' || core.getBlockId(nx, ny) == 'blueShop-right') {
					core.setBlock(drop, nx, ny);
					success = 1;
					break;
				}
			}
			if (!success && reverse) {
				var nx = Math.abs(12 - core.getHeroLoc('x')),
					ny = Math.abs(12 - core.getHeroLoc('y'));
				if (core.getBlockId(nx, ny) == null || core.getBlockId(nx, ny) == 'blueShop-left' || core.getBlockId(nx, ny) == 'blueShop-right') {
					core.setBlock(drop, nx, ny);
				}
			}
			core.setFlag('talking', 1);
			if (core.getFlag('hard') == 2) core.setFlag('swordxx', 1);
			if (core.getFlag('hard') == 4) {
				core.insertCommonEvent("守卫开门", null, null, null, null, true);
			}
		}
		core.updateStatusBar();
		if (core.getFlag('cutting') >= (100 + 5 * core.getFlag('edge'))) {
			core.plugin.cut(0);
		}
	}
	this.transheal = function (heal) {
		var stack = 200;
		core.addFlag('healed', heal);
		while (core.getFlag('healed') >= stack && core.status.hero.mdef >= 1) {
			core.addFlag('healed', -stack);
			core.status.hero.mdef -= 1;
			core.status.hero.def += 1;
		}
	}
}
}