var wa = Object.defineProperty;
var xa = (e, s, t) => s in e ? wa(e, s, { enumerable: !0, configurable: !0, writable: !0, value: t }) : e[s] = t;
var d = (e, s, t) => xa(e, typeof s != "symbol" ? s + "" : s, t);
const vs = class vs {
  constructor(s) {
    /** 所有元素的集合 */
    d(this, "items", /* @__PURE__ */ new Set());
    /** 适配器的id */
    d(this, "id");
    d(this, "execute", /* @__PURE__ */ new Map());
    d(this, "syncExecutes", /* @__PURE__ */ new Map());
    d(this, "globalExecutes", /* @__PURE__ */ new Map());
    this.id = s, vs.adapters.set(s, this);
  }
  /**
   * 添加一个元素
   */
  add(s) {
    this.items.add(s);
  }
  /**
   * 移除一个元素
   */
  remove(s) {
    this.items.delete(s);
  }
  /**
   * 定义一个类似于静态函数的函数，只会调用一次，不会对每个元素执行
   * @param id 函数名称
   * @param fn 执行的函数
   */
  receiveGlobal(s, t) {
    this.globalExecutes.set(s, t);
  }
  /**
   * 设置执行函数
   * @param fn 对于每个元素执行的函数
   */
  receive(s, t) {
    this.execute.set(s, t);
  }
  /**
   * 设置同步执行函数
   * @param fn 对于每个元素执行的函数
   */
  receiveSync(s, t) {
    this.syncExecutes.set(s, t);
  }
  /**
   * 对所有元素执行函数，当所有元素都运行完毕后兑现，类似于Promise.all
   * @returns 包含每个元素运行结果的数组
   */
  all(s, ...t) {
    const r = this.execute.get(s);
    return r ? Promise.all(
      [...this.items].map((i) => r(i, ...t))
    ) : Promise.reject();
  }
  /**
   * 对所有元素执行函数，当任意一个元素运行完毕后兑现，类似于Promise.any
   * @returns 最先运行完毕的元素的结果
   */
  any(s, ...t) {
    const r = this.execute.get(s);
    return r ? Promise.any(
      [...this.items].map((i) => r(i, ...t))
    ) : Promise.reject();
  }
  /**
   * 对所有元素执行同步函数
   * @returns 包含每个元素运行结果的数组
   */
  sync(s, ...t) {
    const r = this.syncExecutes.get(s);
    return r ? [...this.items].map((i) => r(i, ...t)) : [];
  }
  /**
   * 调用一个全局函数
   */
  global(s, ...t) {
    const r = this.globalExecutes.get(s);
    return r ? r(...t) : Promise.reject();
  }
  /**
   * 销毁这个adapter
   */
  destroy() {
    vs.adapters.delete(this.id);
  }
  /**
   * 获取适配器
   */
  static get(s) {
    return this.adapters.get(s);
  }
};
d(vs, "adapters", /* @__PURE__ */ new Map());
let Yi = vs;
function Na(e) {
  return e && e.__esModule && Object.prototype.hasOwnProperty.call(e, "default") ? e.default : e;
}
var Ir = { exports: {} }, qi;
function Ta() {
  return qi || (qi = 1, (function(e) {
    var s = Object.prototype.hasOwnProperty, t = "~";
    function r() {
    }
    Object.create && (r.prototype = /* @__PURE__ */ Object.create(null), new r().__proto__ || (t = !1));
    function i(c, l, f) {
      this.fn = c, this.context = l, this.once = f || !1;
    }
    function n(c, l, f, h, p) {
      if (typeof f != "function")
        throw new TypeError("The listener must be a function");
      var m = new i(f, h || c, p), v = t ? t + l : l;
      return c._events[v] ? c._events[v].fn ? c._events[v] = [c._events[v], m] : c._events[v].push(m) : (c._events[v] = m, c._eventsCount++), c;
    }
    function o(c, l) {
      --c._eventsCount === 0 ? c._events = new r() : delete c._events[l];
    }
    function a() {
      this._events = new r(), this._eventsCount = 0;
    }
    a.prototype.eventNames = function() {
      var l = [], f, h;
      if (this._eventsCount === 0) return l;
      for (h in f = this._events)
        s.call(f, h) && l.push(t ? h.slice(1) : h);
      return Object.getOwnPropertySymbols ? l.concat(Object.getOwnPropertySymbols(f)) : l;
    }, a.prototype.listeners = function(l) {
      var f = t ? t + l : l, h = this._events[f];
      if (!h) return [];
      if (h.fn) return [h.fn];
      for (var p = 0, m = h.length, v = new Array(m); p < m; p++)
        v[p] = h[p].fn;
      return v;
    }, a.prototype.listenerCount = function(l) {
      var f = t ? t + l : l, h = this._events[f];
      return h ? h.fn ? 1 : h.length : 0;
    }, a.prototype.emit = function(l, f, h, p, m, v) {
      var _ = t ? t + l : l;
      if (!this._events[_]) return !1;
      var x = this._events[_], I = arguments.length, M, N;
      if (x.fn) {
        switch (x.once && this.removeListener(l, x.fn, void 0, !0), I) {
          case 1:
            return x.fn.call(x.context), !0;
          case 2:
            return x.fn.call(x.context, f), !0;
          case 3:
            return x.fn.call(x.context, f, h), !0;
          case 4:
            return x.fn.call(x.context, f, h, p), !0;
          case 5:
            return x.fn.call(x.context, f, h, p, m), !0;
          case 6:
            return x.fn.call(x.context, f, h, p, m, v), !0;
        }
        for (N = 1, M = new Array(I - 1); N < I; N++)
          M[N - 1] = arguments[N];
        x.fn.apply(x.context, M);
      } else {
        var $ = x.length, w;
        for (N = 0; N < $; N++)
          switch (x[N].once && this.removeListener(l, x[N].fn, void 0, !0), I) {
            case 1:
              x[N].fn.call(x[N].context);
              break;
            case 2:
              x[N].fn.call(x[N].context, f);
              break;
            case 3:
              x[N].fn.call(x[N].context, f, h);
              break;
            case 4:
              x[N].fn.call(x[N].context, f, h, p);
              break;
            default:
              if (!M) for (w = 1, M = new Array(I - 1); w < I; w++)
                M[w - 1] = arguments[w];
              x[N].fn.apply(x[N].context, M);
          }
      }
      return !0;
    }, a.prototype.on = function(l, f, h) {
      return n(this, l, f, h, !1);
    }, a.prototype.once = function(l, f, h) {
      return n(this, l, f, h, !0);
    }, a.prototype.removeListener = function(l, f, h, p) {
      var m = t ? t + l : l;
      if (!this._events[m]) return this;
      if (!f)
        return o(this, m), this;
      var v = this._events[m];
      if (v.fn)
        v.fn === f && (!p || v.once) && (!h || v.context === h) && o(this, m);
      else {
        for (var _ = 0, x = [], I = v.length; _ < I; _++)
          (v[_].fn !== f || p && !v[_].once || h && v[_].context !== h) && x.push(v[_]);
        x.length ? this._events[m] = x.length === 1 ? x[0] : x : o(this, m);
      }
      return this;
    }, a.prototype.removeAllListeners = function(l) {
      var f;
      return l ? (f = t ? t + l : l, this._events[f] && o(this, f)) : (this._events = new r(), this._eventsCount = 0), this;
    }, a.prototype.off = a.prototype.removeListener, a.prototype.addListener = a.prototype.on, a.prefixed = t, a.EventEmitter = a, e.exports = a;
  })(Ir)), Ir.exports;
}
var Oa = Ta();
const vi = /* @__PURE__ */ Na(Oa);
class Ss extends vi {
  /**
   * 创建一个新的离屏画布\
   * **注意**：如果你在自定义渲染元素中使用，请避免使用此构造函数，而应该使用 `RenderItem.requireCanvas`
   * @param alpha 是否启用透明度通道
   * @param canvas 指定画布，不指定时会自动创建一个新画布
   */
  constructor(t = !0, r) {
    super();
    d(this, "canvas");
    d(this, "ctx");
    d(this, "width");
    d(this, "height");
    /** 是否是高清画布 */
    d(this, "highResolution", !0);
    /** 是否启用抗锯齿 */
    d(this, "antiAliasing", !0);
    d(this, "scale", 1);
    /** 更新标识符，如果发生变化则说明画布被动清空 */
    d(this, "symbol", 0);
    this.canvas = r ?? document.createElement("canvas"), this.ctx = this.canvas.getContext("2d", { alpha: t }), this.width = this.canvas.width / devicePixelRatio, this.height = this.canvas.height / devicePixelRatio;
  }
  /**
   * 设置画布的缩放比
   * @param scale 缩放比
   */
  setScale(t) {
    this.scale = t;
    let r = this.highResolution ? devicePixelRatio : 1;
    r *= this.scale, this.canvas.width = this.width * r, this.canvas.height = this.height * r, this.ctx.setTransform(1, 0, 0, 1, 0, 0), this.ctx.scale(r, r), this.ctx.imageSmoothingEnabled = this.antiAliasing;
  }
  /**
   * 设置画布的大小
   */
  size(t, r) {
    const i = Math.max(t, 1), n = Math.max(r, 1);
    let o = this.highResolution ? devicePixelRatio : 1;
    o *= this.scale, this.canvas.width = i * o, this.canvas.height = n * o, this.width = i, this.height = n, this.ctx.setTransform(1, 0, 0, 1, 0, 0), this.ctx.scale(o, o), this.ctx.imageSmoothingEnabled = this.antiAliasing;
  }
  /**
   * 设置当前画布是否为高清画布
   */
  setHD(t) {
    this.highResolution = t, this.size(this.width, this.height);
  }
  /**
   * 设置当前画布的抗锯齿设置
   */
  setAntiAliasing(t) {
    this.antiAliasing = t, this.ctx.imageSmoothingEnabled = t;
  }
  /**
   * 清空画布
   */
  clear() {
    this.ctx.save(), this.ctx.setTransform(1, 0, 0, 1, 0, 0), this.ctx.clearRect(0, 0, this.canvas.width, this.canvas.height), this.ctx.restore();
  }
  /**
   * 复制一个离屏Canvas2D对象，一般用于缓存等操作
   * @param canvas 被复制的MotaOffscreenCanvas2D对象
   */
  static clone(t) {
    const r = new Ss();
    return r.setHD(t.highResolution), r.size(t.width, t.height), r.ctx.drawImage(
      t.canvas,
      0,
      0,
      t.width,
      t.height
    ), r;
  }
}
var le = /* @__PURE__ */ ((e) => (e[e.None = 0] = "None", e[e.Left = 1] = "Left", e[e.Middle = 2] = "Middle", e[e.Right = 4] = "Right", e[e.Back = 8] = "Back", e[e.Forward = 16] = "Forward", e))(le || {}), ns = /* @__PURE__ */ ((e) => (e[e.None = 0] = "None", e[e.Pixel = 1] = "Pixel", e[e.Line = 2] = "Line", e[e.Page = 3] = "Page", e))(ns || {}), B = /* @__PURE__ */ ((e) => (e[e.Click = 0] = "Click", e[e.Down = 1] = "Down", e[e.Move = 2] = "Move", e[e.Up = 3] = "Up", e[e.Enter = 4] = "Enter", e[e.Leave = 5] = "Leave", e[e.Wheel = 6] = "Wheel", e))(B || {}), wt = /* @__PURE__ */ ((e) => (e[e.Capture = 0] = "Capture", e[e.Bubble = 1] = "Bubble", e))(wt || {});
const Pr = {
  0: "click",
  1: "down",
  2: "move",
  3: "up",
  4: "enter",
  5: "leave",
  6: "wheel"
};
var Qn = typeof global == "object" && global && global.Object === Object && global, Aa = typeof self == "object" && self && self.Object === Object && self, Je = Qn || Aa || Function("return this")(), Ht = Je.Symbol, eo = Object.prototype, Sa = eo.hasOwnProperty, Da = eo.toString, es = Ht ? Ht.toStringTag : void 0;
function Ra(e) {
  var s = Sa.call(e, es), t = e[es];
  try {
    e[es] = void 0;
    var r = !0;
  } catch {
  }
  var i = Da.call(e);
  return r && (s ? e[es] = t : delete e[es]), i;
}
var Ca = Object.prototype, Ia = Ca.toString;
function Pa(e) {
  return Ia.call(e);
}
var Ma = "[object Null]", $a = "[object Undefined]", Gi = Ht ? Ht.toStringTag : void 0;
function Wt(e) {
  return e == null ? e === void 0 ? $a : Ma : Gi && Gi in Object(e) ? Ra(e) : Pa(e);
}
function zt(e) {
  return e != null && typeof e == "object";
}
var Fa = "[object Symbol]";
function Ua(e) {
  return typeof e == "symbol" || zt(e) && Wt(e) == Fa;
}
var tr = Array.isArray, ka = /\s/;
function ja(e) {
  for (var s = e.length; s-- && ka.test(e.charAt(s)); )
    ;
  return s;
}
var La = /^\s+/;
function Ba(e) {
  return e && e.slice(0, ja(e) + 1).replace(La, "");
}
function ys(e) {
  var s = typeof e;
  return e != null && (s == "object" || s == "function");
}
var Ji = NaN, Ha = /^[-+]0x[0-9a-f]+$/i, za = /^0b[01]+$/i, Va = /^0o[0-7]+$/i, Ka = parseInt;
function cs(e) {
  if (typeof e == "number")
    return e;
  if (Ua(e))
    return Ji;
  if (ys(e)) {
    var s = typeof e.valueOf == "function" ? e.valueOf() : e;
    e = ys(s) ? s + "" : s;
  }
  if (typeof e != "string")
    return e === 0 ? e : +e;
  e = Ba(e);
  var t = za.test(e);
  return t || Va.test(e) ? Ka(e.slice(2), t ? 2 : 8) : Ha.test(e) ? Ji : +e;
}
var Wa = "[object AsyncFunction]", Xa = "[object Function]", Ya = "[object GeneratorFunction]", qa = "[object Proxy]";
function to(e) {
  if (!ys(e))
    return !1;
  var s = Wt(e);
  return s == Xa || s == Ya || s == Wa || s == qa;
}
var Mr = Je["__core-js_shared__"], Zi = (function() {
  var e = /[^.]+$/.exec(Mr && Mr.keys && Mr.keys.IE_PROTO || "");
  return e ? "Symbol(src)_1." + e : "";
})();
function Ga(e) {
  return !!Zi && Zi in e;
}
var Ja = Function.prototype, Za = Ja.toString;
function Ct(e) {
  if (e != null) {
    try {
      return Za.call(e);
    } catch {
    }
    try {
      return e + "";
    } catch {
    }
  }
  return "";
}
var Qa = /[\\^$.*+?()[\]{}|]/g, ec = /^\[object .+?Constructor\]$/, tc = Function.prototype, sc = Object.prototype, rc = tc.toString, ic = sc.hasOwnProperty, nc = RegExp(
  "^" + rc.call(ic).replace(Qa, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
);
function oc(e) {
  if (!ys(e) || Ga(e))
    return !1;
  var s = to(e) ? nc : ec;
  return s.test(Ct(e));
}
function ac(e, s) {
  return e == null ? void 0 : e[s];
}
function Xt(e, s) {
  var t = ac(e, s);
  return oc(t) ? t : void 0;
}
var Yr = Xt(Je, "WeakMap"), cc = 9007199254740991, lc = /^(?:0|[1-9]\d*)$/;
function hc(e, s) {
  var t = typeof e;
  return s = s ?? cc, !!s && (t == "number" || t != "symbol" && lc.test(e)) && e > -1 && e % 1 == 0 && e < s;
}
function so(e, s) {
  return e === s || e !== e && s !== s;
}
var fc = 9007199254740991;
function ro(e) {
  return typeof e == "number" && e > -1 && e % 1 == 0 && e <= fc;
}
function uc(e) {
  return e != null && ro(e.length) && !to(e);
}
var dc = Object.prototype;
function pc(e) {
  var s = e && e.constructor, t = typeof s == "function" && s.prototype || dc;
  return e === t;
}
function gc(e, s) {
  for (var t = -1, r = Array(e); ++t < e; )
    r[t] = s(t);
  return r;
}
var mc = "[object Arguments]";
function Qi(e) {
  return zt(e) && Wt(e) == mc;
}
var io = Object.prototype, vc = io.hasOwnProperty, bc = io.propertyIsEnumerable, _c = Qi(/* @__PURE__ */ (function() {
  return arguments;
})()) ? Qi : function(e) {
  return zt(e) && vc.call(e, "callee") && !bc.call(e, "callee");
};
function yc() {
  return !1;
}
var no = typeof exports == "object" && exports && !exports.nodeType && exports, en = no && typeof module == "object" && module && !module.nodeType && module, Ec = en && en.exports === no, tn = Ec ? Je.Buffer : void 0, wc = tn ? tn.isBuffer : void 0, qr = wc || yc, xc = "[object Arguments]", Nc = "[object Array]", Tc = "[object Boolean]", Oc = "[object Date]", Ac = "[object Error]", Sc = "[object Function]", Dc = "[object Map]", Rc = "[object Number]", Cc = "[object Object]", Ic = "[object RegExp]", Pc = "[object Set]", Mc = "[object String]", $c = "[object WeakMap]", Fc = "[object ArrayBuffer]", Uc = "[object DataView]", kc = "[object Float32Array]", jc = "[object Float64Array]", Lc = "[object Int8Array]", Bc = "[object Int16Array]", Hc = "[object Int32Array]", zc = "[object Uint8Array]", Vc = "[object Uint8ClampedArray]", Kc = "[object Uint16Array]", Wc = "[object Uint32Array]", ie = {};
ie[kc] = ie[jc] = ie[Lc] = ie[Bc] = ie[Hc] = ie[zc] = ie[Vc] = ie[Kc] = ie[Wc] = !0;
ie[xc] = ie[Nc] = ie[Fc] = ie[Tc] = ie[Uc] = ie[Oc] = ie[Ac] = ie[Sc] = ie[Dc] = ie[Rc] = ie[Cc] = ie[Ic] = ie[Pc] = ie[Mc] = ie[$c] = !1;
function Xc(e) {
  return zt(e) && ro(e.length) && !!ie[Wt(e)];
}
function Yc(e) {
  return function(s) {
    return e(s);
  };
}
var oo = typeof exports == "object" && exports && !exports.nodeType && exports, ls = oo && typeof module == "object" && module && !module.nodeType && module, qc = ls && ls.exports === oo, $r = qc && Qn.process, sn = (function() {
  try {
    var e = ls && ls.require && ls.require("util").types;
    return e || $r && $r.binding && $r.binding("util");
  } catch {
  }
})(), rn = sn && sn.isTypedArray, ao = rn ? Yc(rn) : Xc, Gc = Object.prototype, Jc = Gc.hasOwnProperty;
function Zc(e, s) {
  var t = tr(e), r = !t && _c(e), i = !t && !r && qr(e), n = !t && !r && !i && ao(e), o = t || r || i || n, a = o ? gc(e.length, String) : [], c = a.length;
  for (var l in e)
    Jc.call(e, l) && !(o && // Safari 9 has enumerable `arguments.length` in strict mode.
    (l == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
    i && (l == "offset" || l == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
    n && (l == "buffer" || l == "byteLength" || l == "byteOffset") || // Skip index properties.
    hc(l, c))) && a.push(l);
  return a;
}
function Qc(e, s) {
  return function(t) {
    return e(s(t));
  };
}
var el = Qc(Object.keys, Object), tl = Object.prototype, sl = tl.hasOwnProperty;
function rl(e) {
  if (!pc(e))
    return el(e);
  var s = [];
  for (var t in Object(e))
    sl.call(e, t) && t != "constructor" && s.push(t);
  return s;
}
function il(e) {
  return uc(e) ? Zc(e) : rl(e);
}
var Es = Xt(Object, "create");
function nl() {
  this.__data__ = Es ? Es(null) : {}, this.size = 0;
}
function ol(e) {
  var s = this.has(e) && delete this.__data__[e];
  return this.size -= s ? 1 : 0, s;
}
var al = "__lodash_hash_undefined__", cl = Object.prototype, ll = cl.hasOwnProperty;
function hl(e) {
  var s = this.__data__;
  if (Es) {
    var t = s[e];
    return t === al ? void 0 : t;
  }
  return ll.call(s, e) ? s[e] : void 0;
}
var fl = Object.prototype, ul = fl.hasOwnProperty;
function dl(e) {
  var s = this.__data__;
  return Es ? s[e] !== void 0 : ul.call(s, e);
}
var pl = "__lodash_hash_undefined__";
function gl(e, s) {
  var t = this.__data__;
  return this.size += this.has(e) ? 0 : 1, t[e] = Es && s === void 0 ? pl : s, this;
}
function Dt(e) {
  var s = -1, t = e == null ? 0 : e.length;
  for (this.clear(); ++s < t; ) {
    var r = e[s];
    this.set(r[0], r[1]);
  }
}
Dt.prototype.clear = nl;
Dt.prototype.delete = ol;
Dt.prototype.get = hl;
Dt.prototype.has = dl;
Dt.prototype.set = gl;
function ml() {
  this.__data__ = [], this.size = 0;
}
function mr(e, s) {
  for (var t = e.length; t--; )
    if (so(e[t][0], s))
      return t;
  return -1;
}
var vl = Array.prototype, bl = vl.splice;
function _l(e) {
  var s = this.__data__, t = mr(s, e);
  if (t < 0)
    return !1;
  var r = s.length - 1;
  return t == r ? s.pop() : bl.call(s, t, 1), --this.size, !0;
}
function yl(e) {
  var s = this.__data__, t = mr(s, e);
  return t < 0 ? void 0 : s[t][1];
}
function El(e) {
  return mr(this.__data__, e) > -1;
}
function wl(e, s) {
  var t = this.__data__, r = mr(t, e);
  return r < 0 ? (++this.size, t.push([e, s])) : t[r][1] = s, this;
}
function st(e) {
  var s = -1, t = e == null ? 0 : e.length;
  for (this.clear(); ++s < t; ) {
    var r = e[s];
    this.set(r[0], r[1]);
  }
}
st.prototype.clear = ml;
st.prototype.delete = _l;
st.prototype.get = yl;
st.prototype.has = El;
st.prototype.set = wl;
var ws = Xt(Je, "Map");
function xl() {
  this.size = 0, this.__data__ = {
    hash: new Dt(),
    map: new (ws || st)(),
    string: new Dt()
  };
}
function Nl(e) {
  var s = typeof e;
  return s == "string" || s == "number" || s == "symbol" || s == "boolean" ? e !== "__proto__" : e === null;
}
function vr(e, s) {
  var t = e.__data__;
  return Nl(s) ? t[typeof s == "string" ? "string" : "hash"] : t.map;
}
function Tl(e) {
  var s = vr(this, e).delete(e);
  return this.size -= s ? 1 : 0, s;
}
function Ol(e) {
  return vr(this, e).get(e);
}
function Al(e) {
  return vr(this, e).has(e);
}
function Sl(e, s) {
  var t = vr(this, e), r = t.size;
  return t.set(e, s), this.size += t.size == r ? 0 : 1, this;
}
function It(e) {
  var s = -1, t = e == null ? 0 : e.length;
  for (this.clear(); ++s < t; ) {
    var r = e[s];
    this.set(r[0], r[1]);
  }
}
It.prototype.clear = xl;
It.prototype.delete = Tl;
It.prototype.get = Ol;
It.prototype.has = Al;
It.prototype.set = Sl;
function Dl(e, s) {
  for (var t = -1, r = s.length, i = e.length; ++t < r; )
    e[i + t] = s[t];
  return e;
}
function Rl(e, s, t) {
  return e === e && (t !== void 0 && (e = e <= t ? e : t), s !== void 0 && (e = e >= s ? e : s)), e;
}
function nn(e, s, t) {
  return t === void 0 && (t = s, s = void 0), t !== void 0 && (t = cs(t), t = t === t ? t : 0), s !== void 0 && (s = cs(s), s = s === s ? s : 0), Rl(cs(e), s, t);
}
function Cl() {
  this.__data__ = new st(), this.size = 0;
}
function Il(e) {
  var s = this.__data__, t = s.delete(e);
  return this.size = s.size, t;
}
function Pl(e) {
  return this.__data__.get(e);
}
function Ml(e) {
  return this.__data__.has(e);
}
var $l = 200;
function Fl(e, s) {
  var t = this.__data__;
  if (t instanceof st) {
    var r = t.__data__;
    if (!ws || r.length < $l - 1)
      return r.push([e, s]), this.size = ++t.size, this;
    t = this.__data__ = new It(r);
  }
  return t.set(e, s), this.size = t.size, this;
}
function ft(e) {
  var s = this.__data__ = new st(e);
  this.size = s.size;
}
ft.prototype.clear = Cl;
ft.prototype.delete = Il;
ft.prototype.get = Pl;
ft.prototype.has = Ml;
ft.prototype.set = Fl;
function Ul(e, s) {
  for (var t = -1, r = e == null ? 0 : e.length, i = 0, n = []; ++t < r; ) {
    var o = e[t];
    s(o, t, e) && (n[i++] = o);
  }
  return n;
}
function kl() {
  return [];
}
var jl = Object.prototype, Ll = jl.propertyIsEnumerable, on = Object.getOwnPropertySymbols, Bl = on ? function(e) {
  return e == null ? [] : (e = Object(e), Ul(on(e), function(s) {
    return Ll.call(e, s);
  }));
} : kl;
function Hl(e, s, t) {
  var r = s(e);
  return tr(e) ? r : Dl(r, t(e));
}
function an(e) {
  return Hl(e, il, Bl);
}
var Gr = Xt(Je, "DataView"), Jr = Xt(Je, "Promise"), Zr = Xt(Je, "Set"), cn = "[object Map]", zl = "[object Object]", ln = "[object Promise]", hn = "[object Set]", fn = "[object WeakMap]", un = "[object DataView]", Vl = Ct(Gr), Kl = Ct(ws), Wl = Ct(Jr), Xl = Ct(Zr), Yl = Ct(Yr), nt = Wt;
(Gr && nt(new Gr(new ArrayBuffer(1))) != un || ws && nt(new ws()) != cn || Jr && nt(Jr.resolve()) != ln || Zr && nt(new Zr()) != hn || Yr && nt(new Yr()) != fn) && (nt = function(e) {
  var s = Wt(e), t = s == zl ? e.constructor : void 0, r = t ? Ct(t) : "";
  if (r)
    switch (r) {
      case Vl:
        return un;
      case Kl:
        return cn;
      case Wl:
        return ln;
      case Xl:
        return hn;
      case Yl:
        return fn;
    }
  return s;
});
var dn = Je.Uint8Array, ql = "__lodash_hash_undefined__";
function Gl(e) {
  return this.__data__.set(e, ql), this;
}
function Jl(e) {
  return this.__data__.has(e);
}
function sr(e) {
  var s = -1, t = e == null ? 0 : e.length;
  for (this.__data__ = new It(); ++s < t; )
    this.add(e[s]);
}
sr.prototype.add = sr.prototype.push = Gl;
sr.prototype.has = Jl;
function Zl(e, s) {
  for (var t = -1, r = e == null ? 0 : e.length; ++t < r; )
    if (s(e[t], t, e))
      return !0;
  return !1;
}
function Ql(e, s) {
  return e.has(s);
}
var eh = 1, th = 2;
function co(e, s, t, r, i, n) {
  var o = t & eh, a = e.length, c = s.length;
  if (a != c && !(o && c > a))
    return !1;
  var l = n.get(e), f = n.get(s);
  if (l && f)
    return l == s && f == e;
  var h = -1, p = !0, m = t & th ? new sr() : void 0;
  for (n.set(e, s), n.set(s, e); ++h < a; ) {
    var v = e[h], _ = s[h];
    if (r)
      var x = o ? r(_, v, h, s, e, n) : r(v, _, h, e, s, n);
    if (x !== void 0) {
      if (x)
        continue;
      p = !1;
      break;
    }
    if (m) {
      if (!Zl(s, function(I, M) {
        if (!Ql(m, M) && (v === I || i(v, I, t, r, n)))
          return m.push(M);
      })) {
        p = !1;
        break;
      }
    } else if (!(v === _ || i(v, _, t, r, n))) {
      p = !1;
      break;
    }
  }
  return n.delete(e), n.delete(s), p;
}
function sh(e) {
  var s = -1, t = Array(e.size);
  return e.forEach(function(r, i) {
    t[++s] = [i, r];
  }), t;
}
function rh(e) {
  var s = -1, t = Array(e.size);
  return e.forEach(function(r) {
    t[++s] = r;
  }), t;
}
var ih = 1, nh = 2, oh = "[object Boolean]", ah = "[object Date]", ch = "[object Error]", lh = "[object Map]", hh = "[object Number]", fh = "[object RegExp]", uh = "[object Set]", dh = "[object String]", ph = "[object Symbol]", gh = "[object ArrayBuffer]", mh = "[object DataView]", pn = Ht ? Ht.prototype : void 0, Fr = pn ? pn.valueOf : void 0;
function vh(e, s, t, r, i, n, o) {
  switch (t) {
    case mh:
      if (e.byteLength != s.byteLength || e.byteOffset != s.byteOffset)
        return !1;
      e = e.buffer, s = s.buffer;
    case gh:
      return !(e.byteLength != s.byteLength || !n(new dn(e), new dn(s)));
    case oh:
    case ah:
    case hh:
      return so(+e, +s);
    case ch:
      return e.name == s.name && e.message == s.message;
    case fh:
    case dh:
      return e == s + "";
    case lh:
      var a = sh;
    case uh:
      var c = r & ih;
      if (a || (a = rh), e.size != s.size && !c)
        return !1;
      var l = o.get(e);
      if (l)
        return l == s;
      r |= nh, o.set(e, s);
      var f = co(a(e), a(s), r, i, n, o);
      return o.delete(e), f;
    case ph:
      if (Fr)
        return Fr.call(e) == Fr.call(s);
  }
  return !1;
}
var bh = 1, _h = Object.prototype, yh = _h.hasOwnProperty;
function Eh(e, s, t, r, i, n) {
  var o = t & bh, a = an(e), c = a.length, l = an(s), f = l.length;
  if (c != f && !o)
    return !1;
  for (var h = c; h--; ) {
    var p = a[h];
    if (!(o ? p in s : yh.call(s, p)))
      return !1;
  }
  var m = n.get(e), v = n.get(s);
  if (m && v)
    return m == s && v == e;
  var _ = !0;
  n.set(e, s), n.set(s, e);
  for (var x = o; ++h < c; ) {
    p = a[h];
    var I = e[p], M = s[p];
    if (r)
      var N = o ? r(M, I, p, s, e, n) : r(I, M, p, e, s, n);
    if (!(N === void 0 ? I === M || i(I, M, t, r, n) : N)) {
      _ = !1;
      break;
    }
    x || (x = p == "constructor");
  }
  if (_ && !x) {
    var $ = e.constructor, w = s.constructor;
    $ != w && "constructor" in e && "constructor" in s && !(typeof $ == "function" && $ instanceof $ && typeof w == "function" && w instanceof w) && (_ = !1);
  }
  return n.delete(e), n.delete(s), _;
}
var wh = 1, gn = "[object Arguments]", mn = "[object Array]", Us = "[object Object]", xh = Object.prototype, vn = xh.hasOwnProperty;
function Nh(e, s, t, r, i, n) {
  var o = tr(e), a = tr(s), c = o ? mn : nt(e), l = a ? mn : nt(s);
  c = c == gn ? Us : c, l = l == gn ? Us : l;
  var f = c == Us, h = l == Us, p = c == l;
  if (p && qr(e)) {
    if (!qr(s))
      return !1;
    o = !0, f = !1;
  }
  if (p && !f)
    return n || (n = new ft()), o || ao(e) ? co(e, s, t, r, i, n) : vh(e, s, c, t, r, i, n);
  if (!(t & wh)) {
    var m = f && vn.call(e, "__wrapped__"), v = h && vn.call(s, "__wrapped__");
    if (m || v) {
      var _ = m ? e.value() : e, x = v ? s.value() : s;
      return n || (n = new ft()), i(_, x, t, r, n);
    }
  }
  return p ? (n || (n = new ft()), Eh(e, s, t, r, i, n)) : !1;
}
function lo(e, s, t, r, i) {
  return e === s ? !0 : e == null || s == null || !zt(e) && !zt(s) ? e !== e && s !== s : Nh(e, s, t, r, lo, i);
}
var Ur = function() {
  return Je.Date.now();
}, Th = "Expected a function", Oh = Math.max, Ah = Math.min;
function Sh(e, s, t) {
  var r, i, n, o, a, c, l = 0, f = !1, h = !1, p = !0;
  if (typeof e != "function")
    throw new TypeError(Th);
  s = cs(s) || 0, ys(t) && (f = !!t.leading, h = "maxWait" in t, n = h ? Oh(cs(t.maxWait) || 0, s) : n, p = "trailing" in t ? !!t.trailing : p);
  function m(P) {
    var Y = r, V = i;
    return r = i = void 0, l = P, o = e.apply(V, Y), o;
  }
  function v(P) {
    return l = P, a = setTimeout(I, s), f ? m(P) : o;
  }
  function _(P) {
    var Y = P - c, V = P - l, Z = s - Y;
    return h ? Ah(Z, n - V) : Z;
  }
  function x(P) {
    var Y = P - c, V = P - l;
    return c === void 0 || Y >= s || Y < 0 || h && V >= n;
  }
  function I() {
    var P = Ur();
    if (x(P))
      return M(P);
    a = setTimeout(I, _(P));
  }
  function M(P) {
    return a = void 0, p && r ? m(P) : (r = i = void 0, o);
  }
  function N() {
    a !== void 0 && clearTimeout(a), l = 0, r = c = i = a = void 0;
  }
  function $() {
    return a === void 0 ? o : M(Ur());
  }
  function w() {
    var P = Ur(), Y = x(P);
    if (r = arguments, i = this, c = P, Y) {
      if (a === void 0)
        return v(c);
      if (h)
        return clearTimeout(a), a = setTimeout(I, s), m(c);
    }
    return a === void 0 && (a = setTimeout(I, s)), o;
  }
  return w.cancel = N, w.flush = $, w;
}
function ut(e, s) {
  return lo(e, s);
}
function ne(e) {
  return e == null;
}
var Dh = Object.defineProperty, Rh = (e, s, t) => s in e ? Dh(e, s, { enumerable: !0, configurable: !0, writable: !0, value: t }) : e[s] = t, J = (e, s, t) => (Rh(e, typeof s != "symbol" ? s + "" : s, t), t);
let Hs = [];
const ho = (e) => {
  for (const s of Hs)
    if (s.status === "running")
      try {
        for (const t of s.funcs)
          t(e - s.startTime);
      } catch (t) {
        s.destroy(), console.error(t);
      }
  requestAnimationFrame(ho);
};
requestAnimationFrame(ho);
class bi {
  constructor() {
    J(this, "funcs", /* @__PURE__ */ new Set()), J(this, "status", "stop"), J(this, "startTime", 0), this.status = "running", Hs.push(this), requestAnimationFrame((s) => this.startTime = s);
  }
  add(s) {
    return this.funcs.add(s), this;
  }
  remove(s) {
    return this.funcs.delete(s), this;
  }
  clear() {
    this.funcs.clear();
  }
  destroy() {
    this.clear(), this.stop();
  }
  stop() {
    this.status = "stop", Hs = Hs.filter((s) => s !== this);
  }
}
class fo {
  constructor() {
    J(this, "timing"), J(this, "relation", "absolute"), J(this, "easeTime", 0), J(this, "applying", {}), J(this, "getTime", Date.now), J(this, "ticker", new bi()), J(this, "value", {}), J(this, "listener", {}), this.timing = (s) => s;
  }
  async all() {
    if (Object.values(this.applying).every((s) => s === !0))
      throw new ReferenceError("There is no animates to be waited.");
    await new Promise((s) => {
      const t = () => {
        Object.values(this.applying).every((r) => r === !1) && (this.unlisten("end", t), s("all animated."));
      };
      this.listen("end", t);
    });
  }
  async n(s) {
    const t = Object.values(this.applying).filter((i) => i === !0).length;
    if (t < s)
      throw new ReferenceError(
        `You are trying to wait ${s} animate, but there are only ${t} animate animating.`
      );
    let r = 0;
    await new Promise((i) => {
      const n = () => {
        r++, r === s && (this.unlisten("end", n), i(`${s} animated.`));
      };
      this.listen("end", n);
    });
  }
  async w(s) {
    if (this.applying[s] === !1)
      throw new ReferenceError(`The ${s} animate is not animating.`);
    await new Promise((t) => {
      const r = () => {
        this.applying[s] === !1 && (this.unlisten("end", r), t(`${s} animated.`));
      };
      this.listen("end", r);
    });
  }
  listen(s, t) {
    var r;
    (r = this.listener)[s] != null || (r[s] = []), this.listener[s].push(t);
  }
  unlisten(s, t) {
    const r = this.listener[s].findIndex((i) => i === t);
    if (r === -1)
      throw new ReferenceError(
        "You are trying to remove a nonexistent listener."
      );
    this.listener[s].splice(r, 1);
  }
  hook(...s) {
    const t = Object.entries(this.listener).filter(
      (r) => s.includes(r[0])
    );
    for (const [r, i] of t)
      for (const n of i)
        n(this, r);
  }
}
function Qr(e) {
  return e != null;
}
class Ch extends fo {
  constructor() {
    super(), J(this, "shakeTiming"), J(this, "path"), J(this, "multiTiming"), J(this, "value", {}), J(this, "size", 1), J(this, "angle", 0), J(this, "targetValue", {
      system: {
        move: [0, 0],
        moveAs: [0, 0],
        resize: 0,
        rotate: 0,
        shake: 0,
        "@@bind": []
      },
      custom: {}
    }), J(this, "animateFn", {
      system: {
        move: [() => 0, () => 0],
        moveAs: () => 0,
        resize: () => 0,
        rotate: () => 0,
        shake: () => 0,
        "@@bind": () => 0
      },
      custom: {}
    }), J(this, "ox", 0), J(this, "oy", 0), J(this, "sx", 0), J(this, "sy", 0), J(this, "bindInfo", []), this.timing = (s) => s, this.shakeTiming = (s) => s, this.multiTiming = (s) => [s, s], this.path = (s) => [s, s], this.applying = {
      move: !1,
      scale: !1,
      rotate: !1,
      shake: !1
    }, this.ticker.add(() => {
      const { running: s } = this.listener;
      if (Qr(s))
        for (const t of s)
          t(this, "running");
    });
  }
  get x() {
    return this.ox + this.sx;
  }
  get y() {
    return this.oy + this.sy;
  }
  mode(s, t = !1) {
    return typeof s(0) == "number" ? t ? this.shakeTiming = s : this.timing = s : this.multiTiming = s, this;
  }
  time(s) {
    return this.easeTime = s, this;
  }
  relative() {
    return this.relation = "relative", this;
  }
  absolute() {
    return this.relation = "absolute", this;
  }
  bind(...s) {
    return this.applying["@@bind"] === !0 && this.end(!1, "@@bind"), this.bindInfo = s, this;
  }
  unbind() {
    return this.applying["@@bind"] === !0 && this.end(!1, "@@bind"), this.bindInfo = [], this;
  }
  move(s, t) {
    return this.applying.move && this.end(!0, "move"), this.applySys("ox", s, "move"), this.applySys("oy", t, "move"), this;
  }
  rotate(s) {
    return this.applySys("angle", s, "rotate"), this;
  }
  scale(s) {
    return this.applySys("size", s, "resize"), this;
  }
  shake(s, t) {
    this.applying.shake === !0 && this.end(!0, "shake"), this.applying.shake = !0;
    const { easeTime: r, shakeTiming: i } = this, n = this.getTime();
    if (this.hook("start", "shakestart"), r <= 0)
      return this.end(!1, "shake"), this;
    const o = () => {
      const a = this.getTime() - n;
      if (a > r) {
        this.ticker.remove(o), this.applying.shake = !1, this.sx = 0, this.sy = 0, this.hook("end", "shakeend");
        return;
      }
      const c = a / r, l = i(c);
      this.sx = l * s, this.sy = l * t;
    };
    return this.ticker.add(o), this.animateFn.system.shake = o, this;
  }
  moveAs(s) {
    this.applying.moveAs && this.end(!0, "moveAs"), this.applying.moveAs = !0, this.path = s;
    const { easeTime: t, relation: r, timing: i } = this, n = this.getTime(), [o, a] = [this.x, this.y], [c, l] = (() => {
      if (r === "absolute")
        return s(1);
      {
        const [h, p] = s(1);
        return [o + h, a + p];
      }
    })();
    if (this.hook("start", "movestart"), t <= 0)
      return this.end(!1, "moveAs"), this;
    const f = () => {
      const h = this.getTime() - n;
      if (h > t) {
        this.end(!0, "moveAs");
        return;
      }
      const p = h / t, [m, v] = s(i(p));
      r === "absolute" ? (this.ox = m, this.oy = v) : (this.ox = o + m, this.oy = a + v);
    };
    return this.ticker.add(f), this.animateFn.system.moveAs = f, this.targetValue.system.moveAs = [c, l], this;
  }
  register(s, t) {
    if (typeof this.value[s] == "number")
      return this.error(
        `Property ${s} has been regietered twice.`,
        "reregister"
      );
    this.value[s] = t, this.applying[s] = !1;
  }
  apply(s, t) {
    this.applying[s] === !0 && this.end(!1, s), s in this.value || this.error(
      `You are trying to execute nonexistent property ${s}.`
    ), this.applying[s] = !0;
    const r = this.value[s], i = this.getTime(), { timing: n, relation: o, easeTime: a } = this, c = o === "absolute" ? t - r : t;
    if (this.hook("start"), a <= 0)
      return this.end(!1, s), this;
    const l = () => {
      const f = this.getTime() - i;
      if (f > a) {
        this.end(!1, s);
        return;
      }
      const h = f / a, p = n(h);
      this.value[s] = r + p * c;
    };
    return this.ticker.add(l), this.animateFn.custom[s] = l, this.targetValue.custom[s] = c + r, this;
  }
  applyMulti() {
    this.applying["@@bind"] === !0 && this.end(!1, "@@bind"), this.applying["@@bind"] = !0;
    const s = this.bindInfo, t = s.map((l) => this.value[l]), r = this.getTime(), { multiTiming: i, relation: n, easeTime: o } = this, a = i(1);
    if (a.length !== t.length)
      throw new TypeError(
        `The number of binded animate attributes and timing function returns's length does not match. binded: ${s.length}, timing: ${a.length}`
      );
    if (this.hook("start"), o <= 0)
      return this.end(!1, "@@bind"), this;
    const c = () => {
      const l = this.getTime() - r;
      if (l > o) {
        this.end(!1, "@@bind");
        return;
      }
      const f = l / o, h = i(f);
      s.forEach((p, m) => {
        n === "absolute" ? this.value[p] = h[m] : this.value[p] = t[m] + h[m];
      });
    };
    return this.ticker.add(c), this.animateFn.custom["@@bind"] = c, this.targetValue.system["@@bind"] = a, this;
  }
  applySys(s, t, r) {
    r !== "move" && this.applying[r] === !0 && this.end(!0, r), this.applying[r] = !0;
    const i = this[s], n = this.getTime(), o = this.timing, a = this.relation, c = this.easeTime, l = a === "absolute" ? t - i : t;
    if (this.hook("start", `${r}start`), c <= 0)
      return this.end(!0, r);
    const f = () => {
      const h = this.getTime() - n;
      if (h > c) {
        this.end(!0, r);
        return;
      }
      const p = h / c, m = o(p);
      this[s] = i + l * m, s !== "oy" && this.hook(r);
    };
    this.ticker.add(f), s === "ox" ? this.animateFn.system.move[0] = f : s === "oy" ? this.animateFn.system.move[1] = f : this.animateFn.system[r] = f, r === "move" ? (s === "ox" && (this.targetValue.system.move[0] = l + i), s === "oy" && (this.targetValue.system.move[1] = l + i)) : r !== "shake" && (this.targetValue.system[r] = l + i);
  }
  error(s, t) {
    throw t === "repeat" ? new Error(
      `Cannot execute the same animation twice. Info: ${s}`
    ) : t === "reregister" ? new Error(
      `Cannot register an animated property twice. Info: ${s}`
    ) : new Error(s);
  }
  end(s, t) {
    if (s === !0)
      if (this.applying[t] = !1, t === "move" ? (this.ticker.remove(this.animateFn.system.move[0]), this.ticker.remove(this.animateFn.system.move[1])) : t === "moveAs" ? this.ticker.remove(this.animateFn.system.moveAs) : t === "@@bind" ? this.ticker.remove(this.animateFn.system["@@bind"]) : this.ticker.remove(
        this.animateFn.system[t]
      ), t === "move") {
        const [r, i] = this.targetValue.system.move;
        this.ox = r, this.oy = i, this.hook("moveend", "end");
      } else if (t === "moveAs") {
        const [r, i] = this.targetValue.system.moveAs;
        this.ox = r, this.oy = i, this.hook("moveend", "end");
      } else
        t === "rotate" ? (this.angle = this.targetValue.system.rotate, this.hook("rotateend", "end")) : t === "resize" ? (this.size = this.targetValue.system.resize, this.hook("resizeend", "end")) : t === "@@bind" ? this.bindInfo.forEach((r, i) => {
          this.value[r] = this.targetValue.system["@@bind"][i];
        }) : (this.sx = 0, this.sy = 0, this.hook("shakeend", "end"));
    else
      this.applying[t] = !1, this.ticker.remove(this.animateFn.custom[t]), this.value[t] = this.targetValue.custom[t], this.hook("end");
  }
}
class Ih extends fo {
  constructor() {
    super(), J(this, "now", {}), J(this, "target", {}), J(this, "transitionFn", {}), J(this, "value"), J(this, "handleSet", (s, t, r) => (this.transition(t, r), !0)), J(this, "handleGet", (s, t) => this.now[t]), this.timing = (s) => s, this.value = new Proxy(this.target, {
      set: this.handleSet,
      get: this.handleGet
    });
  }
  mode(s) {
    return this.timing = s, this;
  }
  time(s) {
    return this.easeTime = s, this;
  }
  relative() {
    return this.relation = "relative", this;
  }
  absolute() {
    return this.relation = "absolute", this;
  }
  transition(s, t) {
    if (t === this.target[s])
      return this;
    if (!Qr(this.now[s]))
      return this.now[s] = t, this;
    this.applying[s] && this.end(s, !0), this.applying[s] = !0, this.hook("start");
    const r = this.getTime(), i = this.easeTime, n = this.timing, o = this.now[s], a = t + (this.relation === "absolute" ? 0 : o), c = a - o;
    this.target[s] = a;
    const l = () => {
      const f = this.getTime() - r;
      if (f >= i) {
        this.end(s);
        return;
      }
      const h = f / i;
      this.now[s] = n(h) * c + o, this.hook("running");
    };
    return this.transitionFn[s] = l, this.ticker.add(l), i <= 0 ? (this.end(s), this) : this;
  }
  end(s, t = !1) {
    const r = this.transitionFn[s];
    if (!Qr(r))
      throw new ReferenceError(
        `You are trying to end an ended transition: ${s}`
      );
    this.ticker.remove(this.transitionFn[s]), delete this.transitionFn[s], this.applying[s] = !1, this.hook("end"), t || (this.now[s] = this.target[s]);
  }
}
var zs = 1e-6, dt = typeof Float32Array < "u" ? Float32Array : Array;
function kr() {
  var e = new dt(9);
  return dt != Float32Array && (e[1] = 0, e[2] = 0, e[3] = 0, e[5] = 0, e[6] = 0, e[7] = 0), e[0] = 1, e[4] = 1, e[8] = 1, e;
}
function Ph(e) {
  var s = new dt(9);
  return s[0] = e[0], s[1] = e[1], s[2] = e[2], s[3] = e[3], s[4] = e[4], s[5] = e[5], s[6] = e[6], s[7] = e[7], s[8] = e[8], s;
}
function Mh(e, s, t, r, i, n, o, a, c) {
  var l = new dt(9);
  return l[0] = e, l[1] = s, l[2] = t, l[3] = r, l[4] = i, l[5] = n, l[6] = o, l[7] = a, l[8] = c, l;
}
function $h(e, s, t, r, i, n, o, a, c, l) {
  return e[0] = s, e[1] = t, e[2] = r, e[3] = i, e[4] = n, e[5] = o, e[6] = a, e[7] = c, e[8] = l, e;
}
function Fh(e) {
  return e[0] = 1, e[1] = 0, e[2] = 0, e[3] = 0, e[4] = 1, e[5] = 0, e[6] = 0, e[7] = 0, e[8] = 1, e;
}
function bn(e, s) {
  var t = s[0], r = s[1], i = s[2], n = s[3], o = s[4], a = s[5], c = s[6], l = s[7], f = s[8], h = f * o - a * l, p = -f * n + a * c, m = l * n - o * c, v = t * h + r * p + i * m;
  return v ? (v = 1 / v, e[0] = h * v, e[1] = (-f * r + i * l) * v, e[2] = (a * r - i * o) * v, e[3] = p * v, e[4] = (f * t - i * c) * v, e[5] = (-a * t + i * n) * v, e[6] = m * v, e[7] = (-l * t + r * c) * v, e[8] = (o * t - r * n) * v, e) : null;
}
function _n(e, s, t) {
  var r = s[0], i = s[1], n = s[2], o = s[3], a = s[4], c = s[5], l = s[6], f = s[7], h = s[8], p = t[0], m = t[1], v = t[2], _ = t[3], x = t[4], I = t[5], M = t[6], N = t[7], $ = t[8];
  return e[0] = p * r + m * o + v * l, e[1] = p * i + m * a + v * f, e[2] = p * n + m * c + v * h, e[3] = _ * r + x * o + I * l, e[4] = _ * i + x * a + I * f, e[5] = _ * n + x * c + I * h, e[6] = M * r + N * o + $ * l, e[7] = M * i + N * a + $ * f, e[8] = M * n + N * c + $ * h, e;
}
function yn(e, s, t) {
  var r = s[0], i = s[1], n = s[2], o = s[3], a = s[4], c = s[5], l = s[6], f = s[7], h = s[8], p = t[0], m = t[1];
  return e[0] = r, e[1] = i, e[2] = n, e[3] = o, e[4] = a, e[5] = c, e[6] = p * r + m * o + l, e[7] = p * i + m * a + f, e[8] = p * n + m * c + h, e;
}
function En(e, s, t) {
  var r = s[0], i = s[1], n = s[2], o = s[3], a = s[4], c = s[5], l = s[6], f = s[7], h = s[8], p = Math.sin(t), m = Math.cos(t);
  return e[0] = m * r + p * o, e[1] = m * i + p * a, e[2] = m * n + p * c, e[3] = m * o - p * r, e[4] = m * a - p * i, e[5] = m * c - p * n, e[6] = l, e[7] = f, e[8] = h, e;
}
function wn(e, s, t) {
  var r = t[0], i = t[1];
  return e[0] = r * s[0], e[1] = r * s[1], e[2] = r * s[2], e[3] = i * s[3], e[4] = i * s[4], e[5] = i * s[5], e[6] = s[6], e[7] = s[7], e[8] = s[8], e;
}
function xn() {
  var e = new dt(16);
  return dt != Float32Array && (e[1] = 0, e[2] = 0, e[3] = 0, e[4] = 0, e[6] = 0, e[7] = 0, e[8] = 0, e[9] = 0, e[11] = 0, e[12] = 0, e[13] = 0, e[14] = 0), e[0] = 1, e[5] = 1, e[10] = 1, e[15] = 1, e;
}
function Uh(e, s) {
  return e[0] = s[0], e[1] = s[1], e[2] = s[2], e[3] = s[3], e[4] = s[4], e[5] = s[5], e[6] = s[6], e[7] = s[7], e[8] = s[8], e[9] = s[9], e[10] = s[10], e[11] = s[11], e[12] = s[12], e[13] = s[13], e[14] = s[14], e[15] = s[15], e;
}
function uo(e) {
  return e[0] = 1, e[1] = 0, e[2] = 0, e[3] = 0, e[4] = 0, e[5] = 1, e[6] = 0, e[7] = 0, e[8] = 0, e[9] = 0, e[10] = 1, e[11] = 0, e[12] = 0, e[13] = 0, e[14] = 0, e[15] = 1, e;
}
function kh(e, s) {
  var t = s[0], r = s[1], i = s[2], n = s[3], o = s[4], a = s[5], c = s[6], l = s[7], f = s[8], h = s[9], p = s[10], m = s[11], v = s[12], _ = s[13], x = s[14], I = s[15], M = t * a - r * o, N = t * c - i * o, $ = t * l - n * o, w = r * c - i * a, P = r * l - n * a, Y = i * l - n * c, V = f * _ - h * v, Z = f * x - p * v, ae = f * I - m * v, ce = h * x - p * _, oe = h * I - m * _, me = p * I - m * x, te = M * me - N * oe + $ * ce + w * ae - P * Z + Y * V;
  return te ? (te = 1 / te, e[0] = (a * me - c * oe + l * ce) * te, e[1] = (i * oe - r * me - n * ce) * te, e[2] = (_ * Y - x * P + I * w) * te, e[3] = (p * P - h * Y - m * w) * te, e[4] = (c * ae - o * me - l * Z) * te, e[5] = (t * me - i * ae + n * Z) * te, e[6] = (x * $ - v * Y - I * N) * te, e[7] = (f * Y - p * $ + m * N) * te, e[8] = (o * oe - a * ae + l * V) * te, e[9] = (r * ae - t * oe - n * V) * te, e[10] = (v * P - _ * $ + I * M) * te, e[11] = (h * $ - f * P - m * M) * te, e[12] = (a * Z - o * ce - c * V) * te, e[13] = (t * ce - r * Z + i * V) * te, e[14] = (_ * N - v * w - x * M) * te, e[15] = (f * w - h * N + p * M) * te, e) : null;
}
function jh(e, s, t) {
  var r = s[0], i = s[1], n = s[2], o = s[3], a = s[4], c = s[5], l = s[6], f = s[7], h = s[8], p = s[9], m = s[10], v = s[11], _ = s[12], x = s[13], I = s[14], M = s[15], N = t[0], $ = t[1], w = t[2], P = t[3];
  return e[0] = N * r + $ * a + w * h + P * _, e[1] = N * i + $ * c + w * p + P * x, e[2] = N * n + $ * l + w * m + P * I, e[3] = N * o + $ * f + w * v + P * M, N = t[4], $ = t[5], w = t[6], P = t[7], e[4] = N * r + $ * a + w * h + P * _, e[5] = N * i + $ * c + w * p + P * x, e[6] = N * n + $ * l + w * m + P * I, e[7] = N * o + $ * f + w * v + P * M, N = t[8], $ = t[9], w = t[10], P = t[11], e[8] = N * r + $ * a + w * h + P * _, e[9] = N * i + $ * c + w * p + P * x, e[10] = N * n + $ * l + w * m + P * I, e[11] = N * o + $ * f + w * v + P * M, N = t[12], $ = t[13], w = t[14], P = t[15], e[12] = N * r + $ * a + w * h + P * _, e[13] = N * i + $ * c + w * p + P * x, e[14] = N * n + $ * l + w * m + P * I, e[15] = N * o + $ * f + w * v + P * M, e;
}
function Lh(e, s, t) {
  var r = t[0], i = t[1], n = t[2], o, a, c, l, f, h, p, m, v, _, x, I;
  return s === e ? (e[12] = s[0] * r + s[4] * i + s[8] * n + s[12], e[13] = s[1] * r + s[5] * i + s[9] * n + s[13], e[14] = s[2] * r + s[6] * i + s[10] * n + s[14], e[15] = s[3] * r + s[7] * i + s[11] * n + s[15]) : (o = s[0], a = s[1], c = s[2], l = s[3], f = s[4], h = s[5], p = s[6], m = s[7], v = s[8], _ = s[9], x = s[10], I = s[11], e[0] = o, e[1] = a, e[2] = c, e[3] = l, e[4] = f, e[5] = h, e[6] = p, e[7] = m, e[8] = v, e[9] = _, e[10] = x, e[11] = I, e[12] = o * r + f * i + v * n + s[12], e[13] = a * r + h * i + _ * n + s[13], e[14] = c * r + p * i + x * n + s[14], e[15] = l * r + m * i + I * n + s[15]), e;
}
function Bh(e, s, t) {
  var r = t[0], i = t[1], n = t[2];
  return e[0] = s[0] * r, e[1] = s[1] * r, e[2] = s[2] * r, e[3] = s[3] * r, e[4] = s[4] * i, e[5] = s[5] * i, e[6] = s[6] * i, e[7] = s[7] * i, e[8] = s[8] * n, e[9] = s[9] * n, e[10] = s[10] * n, e[11] = s[11] * n, e[12] = s[12], e[13] = s[13], e[14] = s[14], e[15] = s[15], e;
}
function Hh(e, s, t, r) {
  var i = r[0], n = r[1], o = r[2], a = Math.sqrt(i * i + n * n + o * o), c, l, f, h, p, m, v, _, x, I, M, N, $, w, P, Y, V, Z, ae, ce, oe, me, te, we;
  return a < zs ? null : (a = 1 / a, i *= a, n *= a, o *= a, c = Math.sin(t), l = Math.cos(t), f = 1 - l, h = s[0], p = s[1], m = s[2], v = s[3], _ = s[4], x = s[5], I = s[6], M = s[7], N = s[8], $ = s[9], w = s[10], P = s[11], Y = i * i * f + l, V = n * i * f + o * c, Z = o * i * f - n * c, ae = i * n * f - o * c, ce = n * n * f + l, oe = o * n * f + i * c, me = i * o * f + n * c, te = n * o * f - i * c, we = o * o * f + l, e[0] = h * Y + _ * V + N * Z, e[1] = p * Y + x * V + $ * Z, e[2] = m * Y + I * V + w * Z, e[3] = v * Y + M * V + P * Z, e[4] = h * ae + _ * ce + N * oe, e[5] = p * ae + x * ce + $ * oe, e[6] = m * ae + I * ce + w * oe, e[7] = v * ae + M * ce + P * oe, e[8] = h * me + _ * te + N * we, e[9] = p * me + x * te + $ * we, e[10] = m * me + I * te + w * we, e[11] = v * me + M * te + P * we, s !== e && (e[12] = s[12], e[13] = s[13], e[14] = s[14], e[15] = s[15]), e);
}
function zh(e, s, t, r, i) {
  var n = 1 / Math.tan(s / 2);
  if (e[0] = n / t, e[1] = 0, e[2] = 0, e[3] = 0, e[4] = 0, e[5] = n, e[6] = 0, e[7] = 0, e[8] = 0, e[9] = 0, e[11] = -1, e[12] = 0, e[13] = 0, e[15] = 0, i != null && i !== 1 / 0) {
    var o = 1 / (r - i);
    e[10] = (i + r) * o, e[14] = 2 * i * r * o;
  } else
    e[10] = -1, e[14] = -2 * r;
  return e;
}
var Vh = zh;
function Kh(e, s, t, r, i, n, o) {
  var a = 1 / (s - t), c = 1 / (r - i), l = 1 / (n - o);
  return e[0] = -2 * a, e[1] = 0, e[2] = 0, e[3] = 0, e[4] = 0, e[5] = -2 * c, e[6] = 0, e[7] = 0, e[8] = 0, e[9] = 0, e[10] = 2 * l, e[11] = 0, e[12] = (s + t) * a, e[13] = (i + r) * c, e[14] = (o + n) * l, e[15] = 1, e;
}
var Wh = Kh;
function Xh(e, s, t, r) {
  var i, n, o, a, c, l, f, h, p, m, v = s[0], _ = s[1], x = s[2], I = r[0], M = r[1], N = r[2], $ = t[0], w = t[1], P = t[2];
  return Math.abs(v - $) < zs && Math.abs(_ - w) < zs && Math.abs(x - P) < zs ? uo(e) : (f = v - $, h = _ - w, p = x - P, m = 1 / Math.sqrt(f * f + h * h + p * p), f *= m, h *= m, p *= m, i = M * p - N * h, n = N * f - I * p, o = I * h - M * f, m = Math.sqrt(i * i + n * n + o * o), m ? (m = 1 / m, i *= m, n *= m, o *= m) : (i = 0, n = 0, o = 0), a = h * o - p * n, c = p * i - f * o, l = f * n - h * i, m = Math.sqrt(a * a + c * c + l * l), m ? (m = 1 / m, a *= m, c *= m, l *= m) : (a = 0, c = 0, l = 0), e[0] = i, e[1] = a, e[2] = f, e[3] = 0, e[4] = n, e[5] = c, e[6] = h, e[7] = 0, e[8] = o, e[9] = l, e[10] = p, e[11] = 0, e[12] = -(i * v + n * _ + o * x), e[13] = -(a * v + c * _ + l * x), e[14] = -(f * v + h * _ + p * x), e[15] = 1, e);
}
function ei() {
  var e = new dt(3);
  return dt != Float32Array && (e[0] = 0, e[1] = 0, e[2] = 0), e;
}
function Nn(e, s, t) {
  var r = s[0], i = s[1], n = s[2], o = t[3] * r + t[7] * i + t[11] * n + t[15];
  return o = o || 1, e[0] = (t[0] * r + t[4] * i + t[8] * n + t[12]) / o, e[1] = (t[1] * r + t[5] * i + t[9] * n + t[13]) / o, e[2] = (t[2] * r + t[6] * i + t[10] * n + t[14]) / o, e;
}
(function() {
  var e = ei();
  return function(s, t, r, i, n, o) {
    var a, c;
    for (t || (t = 3), r || (r = 0), i ? c = Math.min(i * t + r, s.length) : c = s.length, a = r; a < c; a += t)
      e[0] = s[a], e[1] = s[a + 1], e[2] = s[a + 2], n(e, e, o), s[a] = e[0], s[a + 1] = e[1], s[a + 2] = e[2];
    return s;
  };
})();
class Nt {
  constructor() {
    d(this, "mat", kr());
    d(this, "x", 0);
    d(this, "y", 0);
    d(this, "scaleX", 1);
    d(this, "scaleY", 1);
    d(this, "rad", 0);
    /** 有没有对这个Transform进行过修改，用于优化常规表现 */
    d(this, "modified", !1);
    /** 绑定的可更新元素 */
    d(this, "bindedObject");
  }
  /**
   * 对这个变换实例添加绑定对象，当矩阵变换时，自动调用其 update 函数
   * @param obj 要绑定的对象
   */
  bind(s) {
    this.bindedObject = s;
  }
  /**
   * 重设所有参数
   */
  reset() {
    var s, t;
    Fh(this.mat), this.x = 0, this.y = 0, this.scaleX = 1, this.scaleY = 1, this.rad = 0, this.modified = !1, (t = (s = this.bindedObject) == null ? void 0 : s.updateTransform) == null || t.call(s);
  }
  /**
   * 修改缩放，叠加关系
   */
  scale(s, t = s) {
    var r, i;
    return wn(this.mat, this.mat, [s, t]), this.scaleX *= s, this.scaleY *= t, this.modified = !0, (i = (r = this.bindedObject) == null ? void 0 : r.updateTransform) == null || i.call(r), this;
  }
  /**
   * 移动，叠加关系
   */
  translate(s, t) {
    var r, i;
    return yn(this.mat, this.mat, [s, t]), this.x += s, this.y += t, this.modified = !0, (i = (r = this.bindedObject) == null ? void 0 : r.updateTransform) == null || i.call(r), this;
  }
  /**
   * 旋转，叠加关系
   */
  rotate(s) {
    var t, r;
    if (En(this.mat, this.mat, s), this.rad += s, this.rad >= Math.PI * 2) {
      const i = Math.floor(this.rad / Math.PI / 2);
      this.rad -= i * Math.PI * 2;
    }
    return this.modified = !0, (r = (t = this.bindedObject) == null ? void 0 : t.updateTransform) == null || r.call(t), this;
  }
  /**
   * 设置缩放，非叠加关系
   */
  setScale(s, t = s) {
    var r, i;
    return wn(this.mat, this.mat, [s / this.scaleX, t / this.scaleY]), this.scaleX = s, this.scaleY = t, this.modified = !0, (i = (r = this.bindedObject) == null ? void 0 : r.updateTransform) == null || i.call(r), this;
  }
  /**
   * 设置位置，非叠加关系
   */
  setTranslate(s, t) {
    var r, i;
    return yn(this.mat, this.mat, [s - this.x, t - this.y]), this.x = s, this.y = t, this.modified = !0, (i = (r = this.bindedObject) == null ? void 0 : r.updateTransform) == null || i.call(r), this;
  }
  /**
   * 设置旋转，非叠加关系
   */
  setRotate(s) {
    var t, r;
    return En(this.mat, this.mat, s - this.rad), this.rad = s, this.modified = !0, (r = (t = this.bindedObject) == null ? void 0 : t.updateTransform) == null || r.call(t), this;
  }
  /**
   * 设置变换矩阵，叠加模式
   * @param a 水平缩放
   * @param b 垂直倾斜
   * @param c 水平倾斜
   * @param d 垂直缩放
   * @param e 水平移动
   * @param f 垂直移动
   */
  transform(s, t, r, i, n, o) {
    var a, c;
    return _n(
      this.mat,
      this.mat,
      Mh(s, t, 0, r, i, 0, n, o, 1)
    ), this.calAttributes(), (c = (a = this.bindedObject) == null ? void 0 : a.updateTransform) == null || c.call(a), this;
  }
  /**
   * 设置变换矩阵，非叠加模式
   * @param a 水平缩放
   * @param b 垂直倾斜
   * @param c 水平倾斜
   * @param d 垂直缩放
   * @param e 水平移动
   * @param f 垂直移动
   */
  setTransform(s, t, r, i, n, o) {
    var a, c;
    return $h(this.mat, s, t, 0, r, i, 0, n, o, 1), this.calAttributes(), (c = (a = this.bindedObject) == null ? void 0 : a.updateTransform) == null || c.call(a), this;
  }
  /**
   * 重新计算 translation scaling rotation
   */
  calAttributes() {
    const [s, t] = Yh(this.mat), [r, i] = qh(this.mat), n = Gh(this.mat);
    this.x = s, this.y = t, this.scaleX = r, this.scaleY = i, this.rad = n, s === 0 && t === 0 && r === 1 && i === 1 && n === 0 ? this.modified = !1 : this.modified = !0;
  }
  /**
   * 与一个矩阵相乘，返回其计算结果（不改变原矩阵）
   * @param transform 变换矩阵
   */
  multiply(s) {
    if (this.modified) {
      const t = new Nt();
      return _n(t.mat, this.mat, s.mat), t;
    } else
      return s.clone();
  }
  /**
   * 复制这个变换矩阵
   */
  clone() {
    const s = new Nt();
    return s.mat = Ph(this.mat), s;
  }
  /**
   * 根据变换矩阵的信息，将一个点转换为计算后的位置
   * @param x 横坐标
   * @param y 纵坐标
   */
  transformed(s, t) {
    return this.modified ? ks(this.mat, [s, t, 1]) : [s, t, 1];
  }
  /**
   * 根据变换矩阵的信息，将一个计算后的位置逆转换为原位置
   * @param x 横坐标
   * @param y 纵坐标
   */
  untransformed(s, t) {
    if (!this.modified) return [s, t, 1];
    const r = kr();
    return bn(r, this.mat), ks(r, [s, t, 1]);
  }
  /**
   * 根据变换矩阵的信息，将一个点转换为计算后的位置
   * @param transform 变换矩阵
   * @param x 横坐标
   * @param y 纵坐标
   */
  static transformed(s, t, r) {
    return ks(s.mat, [t, r, 1]);
  }
  /**
   * 根据变换矩阵的信息，将一个计算后的位置逆转换为原位置
   * @param transform 变换矩阵
   * @param x 横坐标
   * @param y 纵坐标
   */
  static untransformed(s, t, r) {
    const i = kr();
    return bn(i, s.mat), ks(i, [t, r, 1]);
  }
  /** 单位矩阵 */
  static get identity() {
    return new Nt();
  }
}
function ks(e, s) {
  const t = s[0], r = s[1], i = s[2];
  return [
    e[0] * t + e[3] * r + e[6] * i,
    e[1] * t + e[4] * r + e[7] * i,
    e[2] * t + e[5] * r + e[8] * i
  ];
}
function Yh(e) {
  return [e[6], e[7]];
}
function qh(e) {
  return [Math.hypot(e[0], e[3]), Math.hypot(e[1], e[4])];
}
function Gh(e) {
  return Math.atan2(e[3], e[0]);
}
class Vs {
  constructor() {
    d(this, "mat", xn());
    /** 绑定的可更新元素 */
    d(this, "bindedObject");
  }
  /**
   * 绑定可更新对象
   * @param obj 要绑定的对象
   */
  bind(s) {
    this.bindedObject = s;
  }
  /**
   * 重置为单位矩阵
   */
  reset() {
    var s, t;
    return uo(this.mat), (t = (s = this.bindedObject) == null ? void 0 : s.updateTransform) == null || t.call(s), this;
  }
  /**
   * 应用缩放变换
   * @param x X轴缩放
   * @param y Y轴缩放
   * @param z Z轴缩放
   */
  scale(s, t, r) {
    var i, n;
    return Bh(this.mat, this.mat, [s, t, r]), (n = (i = this.bindedObject) == null ? void 0 : i.updateTransform) == null || n.call(i), this;
  }
  /**
   * 应用平移变换
   * @param x X轴平移
   * @param y Y轴平移
   * @param z Z轴平移
   */
  translate(s, t, r) {
    var i, n;
    return Lh(this.mat, this.mat, [s, t, r]), (n = (i = this.bindedObject) == null ? void 0 : i.updateTransform) == null || n.call(i), this;
  }
  /**
   * 应用旋转变换
   * @param rad 旋转角度（弧度）
   * @param axis 旋转轴
   */
  rotate(s, t) {
    var r, i;
    return Hh(this.mat, this.mat, s, t), (i = (r = this.bindedObject) == null ? void 0 : r.updateTransform) == null || i.call(r), this;
  }
  /**
   * 应用绕X轴旋转
   * @param rad 旋转角度（弧度）
   */
  rotateX(s) {
    return this.rotate(s, [1, 0, 0]);
  }
  /**
   * 应用绕Y轴旋转
   * @param rad 旋转角度（弧度）
   */
  rotateY(s) {
    return this.rotate(s, [0, 1, 0]);
  }
  /**
   * 应用绕Z轴旋转
   * @param rad 旋转角度（弧度）
   */
  rotateZ(s) {
    return this.rotate(s, [0, 0, 1]);
  }
  /**
   * 设置视图矩阵
   * @param eye 摄像机位置
   * @param center 目标位置
   * @param up 上方向量
   */
  lookAt(s, t, r) {
    var i, n;
    return Xh(this.mat, s, t, r), (n = (i = this.bindedObject) == null ? void 0 : i.updateTransform) == null || n.call(i), this;
  }
  /**
   * 设置透视投影矩阵
   * @param fovy 垂直视野角度（弧度）
   * @param aspect 宽高比
   * @param near 近平面
   * @param far 远平面
   */
  perspective(s, t, r, i) {
    var n, o;
    return Vh(this.mat, s, t, r, i), (o = (n = this.bindedObject) == null ? void 0 : n.updateTransform) == null || o.call(n), this;
  }
  /**
   * 设置正交投影矩阵
   * @param left 左平面
   * @param right 右平面
   * @param bottom 底平面
   * @param top 顶平面
   * @param near 近平面
   * @param far 远平面
   */
  ortho(s, t, r, i, n, o) {
    var a, c;
    return Wh(this.mat, s, t, r, i, n, o), (c = (a = this.bindedObject) == null ? void 0 : a.updateTransform) == null || c.call(a), this;
  }
  /**
   * 与另一个变换矩阵相乘
   * @param transform 另一个变换矩阵
   */
  multiply(s) {
    const t = new Vs();
    return jh(t.mat, this.mat, s.mat), t;
  }
  /**
   * 克隆当前变换矩阵
   */
  clone() {
    const s = new Vs();
    return Uh(s.mat, this.mat), s;
  }
  /**
   * 将点应用变换
   * @param point 要变换的点
   */
  transformed(s) {
    const t = ei();
    return Nn(t, s, this.mat), t;
  }
  /**
   * 将点应用逆变换
   * @param point 要逆变换的点
   */
  untransformed(s) {
    const t = xn();
    kh(t, this.mat);
    const r = ei();
    return Nn(r, s, t), r;
  }
  /**
   * 静态方法：单位矩阵
   */
  static get identity() {
    return new Vs();
  }
}
const Jh = { 1: "Unexpected error when posting danmaku. Error info: $1", 2: "Unexpected loading error in loading resource '$1/$2'. Error info: $3", 3: "Syntax error in parsing CSS: Unexpected ':'. Col: $1. CSS string: '$2'", 4: "Syntax error in parsing CSS: Unexpected ';'. Col: $1. CSS string: '$2'", 5: "Syntax error in parsing CSS: Missing property name after '-'. Col: $1. CSS string: '$2'", 6: "Syntax error in parsing CSS: Unexpected end of css, expecting ':'. Col: $1. CSS string: '$2'", 7: "Syntax error in parsing CSS: Unexpected end of css, expecting property value. Col: $1. CSS string: '$2'", 8: "Post danmaku with not allowed css. Info: $1", 9: "Cannot initialize shader program. Error info: $1", 10: "Cannot compile $1 shader. Error info: $2", 11: "Cache depth cannot larger than 31.", 12: "Cannot move while status is not 'moving'. Call 'readyMove' first.", 13: "Cannot compile $1 shader. Error info: $2", 14: "", 15: "", 16: "Cannot find log message for $1 code $2.", 17: "Cannot use shader program for shader element that does not belong to it.", 18: "Cannot delete shader program for shader element that does not belong to it.", 19: "Cannot create MotaRenderer instance for nonexistent canvas.", 20: "Cannot create render element for tag '$1', since there's no registration for it.", 21: "Incorrect render prop type is delivered. key: '$1', expected type: '$2', delivered type: '$3'", 22: "Incorrect props for custom tag. Please ensure you have delivered 'item' prop and other required props.", 23: "Cannot get reader when fetching '$1'.", 24: "Cannot decode source type of '$1', since there is no registered decoder for that type.", 25: "Unknown audio type. Header: '$1'", 26: "Uncaught error when fetching stream data from '$1'. Error info: $2.", 1101: "Shadow extension needs 'floor-hero' extension as dependency.", 1201: "Floor-damage extension needs 'floor-binder' extension as dependency.", 1301: "Portal extension need 'floor-binder' extension as dependency.", 1401: "Halo extension needs 'floor-binder' extension as dependency." }, Zh = { 1: "Resource with type of 'none' is loaded.", 2: "Repeat load of resource '$1/$2'.", 3: "Unknown danmaku tag: $1", 4: "Ignored a mismatched ']' in danmaku.", 5: "Repeat post danmaku.", 6: "Registered special danmaku element: $1.", 7: "Unknown special danmaku element: '$1'.", 8: "Incomplete render data is put. None will be filled to the lacked data.", 9: "Data transfered is partially (or totally) out of range. Overflowed data will be ignored.", 10: "Cannot resolve big image of enemy '$1'.", 11: "Cannot resolve material $1. Material not exists.", 12: "Cannot mark buffable with a non-number status. Key: '$1'.", 13: "Cannot set buff of non-number status. Key: '$1'.", 14: "Cannot add status of non-number status. Key: '$1'.", 15: "Cannot get item of a non-item block on loc: $1,$2,$3.", 16: "Override repeated state key: '$1'.", 17: "Floor-damage extension needs 'floor-binder' extension as dependency.", 18: "Uncaught error in posting like info for danmaku. Danmaku id: $1.", 19: "Repeat light id: '$1'.", 20: "Cannot apply animation to camera operation that does not belong to it.", 21: "Cannot apply transition to camera operation that does not belong to it.", 22: "There is already an active camera for delivered render item. Consider using 'Camera.for' or disable the active camera to avoid some exceptions.", 23: "Render item with id of '$1' has already exists. Please avoid repeat id since it may cause issues when use 'getElementById'.", 24: "Uniform block can only be used in glsl version es 300.", 25: "Cannot activate weather since there's no weather with id of '$1'.", 26: "Cannot set attribute when only element number specified. Use 'pointer' or 'pointerI' instead.", 27: "Cannot vertex attribute integer point when specified as float. Use 'set' or 'pointer' instead.", 28: "Redefinition of shader $1: '$2'", 29: "Cannot define new texture since texture index is larger than max texture count.", 30: "Cannot use indices named $1 since no definition for it. Please define it in advance.", 31: "Cannot use indices since the indices instance is not belong to the program.", 32: "Sub-image exceeds texture dimensions, auto adjusting size.", 33: "Cannot modify MotaOffscreenCanvas2D that is freezed.", 34: "Repeated render tag registration: '$1'.", 35: "Cannot append child on plain render item, please ensure you have overrided 'appendChild' method in your own element.", 36: "Cannot remove child on plain render item, please ensure you have overrided 'removeChild' method in your own element.", 37: "Cannot execute 'requestSort' on plain render item, please ensure you have overrided 'requestSort' method in your own element.", 38: "Using plain text in jsx is strongly not recommended, since you can hardly modify its attributes. Consider using Text element instead.", 39: "Plain text is not supported outside Text element.", 40: "Cannot return canvas that is not provided by this pool.", 41: "Width of text content components must be positive. receive: $1", 42: "Repeated Textbox id: '$1'.", 43: "Cannot set icon of '$1', since it does not exists. Please ensure you have delivered correct icon id or number.", 44: "Unexpected end when loading stream audio, reason: '$1'", 45: "Audio route with id of '$1' has already existed. New route will override old route.", 46: "Cannot pipe new StreamReader object when stream is loading.", 47: "Audio stream decoder for audio type '$1' has already existed.", 48: "Sample rate in stream audio must be constant.", 49: "Repeated patch for '$1', key: '$2'.", 50: "Unknown audio extension name: '$1'", 51: "Cannot decode sound '$1', since audio file may not supported by 2.b.", 52: "Cannot play sound '$1', since there is no added data named it.", 53: "Cannot $1 audio route '$2', since there is not added route named it.", 54: "Missing start tag for '$1', index: $2.", 55: "Unchildable tag '$1' should follow with param.", 56: "Method '$1' has been deprecated. Consider using '$2' instead.", 57: "Repeated UI controller id '$1'.", 58: "Fail to set ellipse round rect, since length of 'ellipse' property should only be 2, 4, 6 or 8. delivered: $1", 59: "Unknown icon '$1' in parsing text content.", 60: "Repeated Tip id: '$1'.", 61: "Unexpected recursive call of $1.update?$2 in render function. Please ensure you have to do this, if you do, ignore this warn.", 62: "Recursive fallback fonts in '$1'.", 63: "Uncaught promise error in waiting box component. Error reason: $1", 1001: "Item-detail extension needs 'floor-binder' and 'floor-damage' extension as dependency.", 1101: "Cannot add new effect to point effect instance, for there's no more reserve space for it. Please increase the max count of the instance." }, Qh = {
  error: Jh,
  warn: Zh
};
let ot;
if (!main.replayChecking) {
  const e = document.createElement("span");
  ot = e, e.style.position = "fixed", e.style.right = "0", e.style.bottom = "0", e.style.height = "20px", e.style.width = "auto", e.style.textAlign = "right", e.style.padding = "0 5px", e.style.fontSize = "16px", e.style.fontFamily = "Arial", e.style.display = "none", e.style.margin = "2px", document.body.appendChild(e);
}
const Tn = Sh(() => {
  main.replayChecking || (ot.style.display = "none");
}, 5e3), On = new Set("1234567890");
class ef {
  constructor(s, t) {
    d(this, "enabled", !0);
    d(this, "catching", !1);
    d(this, "catchedInfo", []);
    d(this, "catchStack", []);
    this.level = s, this.info = t;
  }
  parseInfo(s, ...t) {
    let r = -1, i = "", n = !1, o = "";
    for (; ++r < s.length; ) {
      const a = s[r];
      if (a === "$" && s[r - 1] !== "\\") {
        n = !0;
        continue;
      }
      if (n) {
        if (On.has(a) && (o += a), !On.has(s[r + 1])) {
          n = !1;
          const c = Number(o);
          o = "", i += t[c - 1] ?? "[not delivered]";
        }
        continue;
      }
      i += a;
    }
    return i;
  }
  /**
   * 输出报错信息
   * @param code 错误代码，每个错误都应当使用唯一的错误代码
   * @param params 参数
   */
  error(s, ...t) {
    const r = this.info.error[s];
    if (!r) {
      q.error(16, "error", s.toString());
      return;
    }
    const i = this.parseInfo(r, ...t);
    if (this.catching && this.catchedInfo.push({
      level: 2,
      message: i,
      code: s
    }), this.level <= 2 && this.enabled) {
      main.replayChecking || (ot.style.color = "lightcoral", ot.style.display = "block", ot.textContent = "Error thrown, please check in console.", Tn());
      const n = Math.floor(s / 50) + 1, o = s % 50, a = `${location.origin}/_docs/logger/error/error${n}.html#error-code-${o}`;
      console.error(`[ERROR Code ${s}] ${i} See ${a}`);
    }
  }
  /**
   * 输出警告信息
   * @param code 警告代码
   * @param text 警告信息
   */
  warn(s, ...t) {
    const r = this.info.warn[s];
    if (!r) {
      q.error(16, "warn", s.toString());
      return;
    }
    const i = this.parseInfo(r, ...t);
    if (this.catching && this.catchedInfo.push({
      level: 2,
      message: i,
      code: s
    }), this.level <= 1 && this.enabled) {
      main.replayChecking || (ot.style.color = "gold", ot.style.display = "block", ot.textContent = "Warning thrown, please check in console.", Tn());
      const n = Math.floor(s / 50) + 1, o = s % 50, a = `${location.origin}/_docs/logger/warn/warn${n}.html#warn-code-${o}`;
      console.warn(`[WARNING Code ${s}] ${i} See ${a}`);
    }
  }
  /**
   * 输出日志
   * @param text 日志信息
   */
  log(s) {
    this.catching && this.catchedInfo.push({
      level: 2,
      message: s
    }), this.level <= 0 && this.enabled && console.log(`[LOG] ${s}`);
  }
  catch(s) {
    var o;
    const t = this.enabled;
    this.catchedInfo = [], this.catchStack.push(this.catchedInfo), this.disable(), this.catching = !0;
    const r = s();
    this.catchStack.length === 0 ? this.catching = !1 : this.catching = !0, t && this.enable(), this.catchStack.pop();
    const i = (o = this.catchStack) == null ? void 0 : o.at(-1), n = this.catchedInfo;
    return this.catchedInfo = i ?? [], { ret: r, info: n };
  }
  disable() {
    this.enabled = !1;
  }
  enable() {
    this.enabled = !0;
  }
}
const q = new ef(0, Qh), { gl: tf, gl2: sf } = rf();
function rf() {
  const e = document.createElement("canvas"), s = document.createElement("canvas"), t = e.getContext("webgl"), r = s.getContext("webgl2");
  return { gl: !!t, gl2: !!r };
}
function pp() {
  return tf;
}
function nf() {
  return sf;
}
function gp(e, s) {
  return (t) => e(t) + s(t);
}
function mp(e, s) {
  return (t) => e(t) * s(t);
}
function vp(e, s) {
  return e === s ? !0 : e.size === s.size && e.isSubsetOf(s);
}
function of(e, s) {
  const { ctx: t } = e, r = s.mat, [i, n, , o, a, , c, l] = r;
  t.transform(i, n, o, a, c, l);
}
const Ks = [], Ws = [], Xs = [];
let af = 0;
const Se = class Se extends vi {
  //#endregion
  constructor(t, r = !0, i = !1) {
    super();
    d(this, "uid", af++);
    //#region 元素属性
    /** 是否是注释元素 */
    d(this, "isComment", !1);
    d(this, "_id", "");
    /** 元素纵深，表示了遮挡关系 */
    d(this, "zIndex", 0);
    d(this, "width", 200);
    d(this, "height", 200);
    /** 渲染锚点，(0,0)表示左上角，(1,1)表示右下角 */
    d(this, "anchorX", 0);
    /** 渲染锚点，(0,0)表示左上角，(1,1)表示右下角 */
    d(this, "anchorY", 0);
    /** 渲染模式，absolute表示绝对位置，static表示跟随摄像机移动 */
    d(this, "type", "static");
    /** 是否是高清画布 */
    d(this, "highResolution", !0);
    /** 是否抗锯齿 */
    d(this, "antiAliasing", !0);
    /** 是否被隐藏 */
    d(this, "hidden", !1);
    /** 滤镜 */
    d(this, "filter", "none");
    /** 混合方式 */
    d(this, "composite", "source-over");
    /** 不透明度 */
    d(this, "alpha", 1);
    /** 缩放比 */
    d(this, "scale", 1);
    /** 鼠标覆盖在此元素上时的光标样式 */
    d(this, "cursor", "inherit");
    /** 该元素是否忽略交互事件 */
    d(this, "noEvent", !1);
    /** 该元素的变换矩阵 */
    d(this, "_transform", new Nt());
    //#endregion
    //#region 父子关系
    d(this, "_parent");
    /** 当前元素是否为根元素，如果是根元素，那么必须实现 `IRenderTreeRoot` 接口 */
    d(this, "isRoot", !1);
    d(this, "_root");
    /** 该渲染元素的子元素 */
    d(this, "children", /* @__PURE__ */ new Set());
    //#endregion
    //#region 渲染配置与缓存
    /** 渲染缓存信息 */
    d(this, "cache");
    /** 是否需要更新缓存 */
    d(this, "cacheDirty", !1);
    /** 是否启用缓存机制 */
    d(this, "enableCache", !0);
    /** 是否启用transform下穿机制，即画布的变换是否会继续作用到下一层画布 */
    d(this, "transformFallThrough", !1);
    /** 这个渲染元素使用到的所有画布 */
    d(this, "canvases", /* @__PURE__ */ new Set());
    /** 这个渲染元素每个画布的配置信息 */
    d(this, "canvasMap", /* @__PURE__ */ new Map());
    //#endregion
    //#region 交互事件
    /** 是否调用了 `ev.stopPropagation` */
    d(this, "propagationStoped", /* @__PURE__ */ new Map());
    /** 捕获阶段缓存的事件对象 */
    d(this, "cachedEvent", /* @__PURE__ */ new Map());
    /** 下穿模式下当前下穿过来的变换矩阵 */
    d(this, "fallTransform");
    /** 是否在元素内 */
    d(this, "inElement", !1);
    /** 鼠标标识符映射，键为按下的鼠标按键类型，值表示本次操作的唯一标识符，在按下、移动、抬起过程中保持一致 */
    d(this, "mouseId", /* @__PURE__ */ new Map());
    /** 当前所有的触摸标识符 */
    d(this, "touchId", /* @__PURE__ */ new Set());
    //#endregion
    //#region debug
    /** 是否需要禁用更新，如果出现更新，那么发出警告并停止更新操作 */
    d(this, "forbidUpdate", !1);
    this.enableCache = r, this.transformFallThrough = i, this.type = t, this._transform.bind(this), this.cache = this.requireCanvas(), r || (this.cache.size(1, 1), this.deleteCanvas(this.cache));
  }
  /**
   * 元素的 id，原则上不可重复
   */
  get id() {
    return this._id;
  }
  set id(t) {
    var i;
    this.checkRoot();
    const r = this._id;
    this._id = t, (i = this._root) == null || i.modifyId(this, r, t);
  }
  get x() {
    return this._transform.x;
  }
  get y() {
    return this._transform.y;
  }
  set transform(t) {
    this._transform.bind(), this._transform = t, t.bind(this);
  }
  get transform() {
    return this._transform;
  }
  /** 当前元素的父元素 */
  get parent() {
    return this._parent;
  }
  get root() {
    return this._root;
  }
  /** 当前元素是否已经连接至任意根元素 */
  get connected() {
    return !!this._root;
  }
  /**
   * 渲染当前对象
   * @param canvas 渲染至的画布
   * @param transform 由父元素传递过来的变换矩阵
   */
  renderContent(t, r) {
    if (this.hidden) return;
    this.forbidUpdate = !0, this.emit("beforeRender", r), this.transformFallThrough && (this.fallTransform = r);
    const i = this.transformFallThrough ? r : this._transform, n = -this.anchorX * this.width, o = -this.anchorY * this.height, a = t.ctx;
    if (a.save(), t.setAntiAliasing(this.antiAliasing), this.type === "static" && of(t, i), a.filter = this.filter, a.globalAlpha = this.alpha, a.globalCompositeOperation = this.composite, this.enableCache) {
      const { width: c, height: l, ctx: f } = this.cache;
      if (this.cacheDirty) {
        const { canvas: h } = this.cache;
        f.clearRect(0, 0, h.width, h.height), this.render(this.cache, i), this.cacheDirty = !1;
      }
      t.ctx.drawImage(this.cache.canvas, n, o, c, l);
    } else
      t.ctx.translate(n, o), this.render(t, i), this.cacheDirty = !1;
    a.restore(), this.emit("afterRender", r), this.forbidUpdate = !1;
  }
  /**
   * 申请一个 `MotaOffscreenCanvas2D`，即申请一个画布
   * @param alpha 是否启用画布的 alpha 通道
   * @param autoScale 是否自动跟随缩放
   */
  requireCanvas(t = !0, r = !0) {
    const i = new Ss(t);
    return r ? i.setScale(this.scale) : i.setScale(1), this.canvases.add(i), this.canvasMap.set(i, { autoScale: r }), i;
  }
  /**
   * 删除由 `requireCanvas` 申请的画布，当画布不再使用时，可以用该方法删除画布
   * @param canvas 要删除的画布
   */
  deleteCanvas(t) {
    this.canvases.delete(t), this.canvasMap.delete(t);
  }
  //#region 事件处理
  onResize(t) {
    this.scale = t, this.canvases.forEach((r) => {
      var i;
      (i = this.canvasMap.get(r)) != null && i.autoScale && r.setScale(t);
    }), this.update();
  }
  /**
   * 获取当前元素的缩放比，它与根元素应当保持一致
   */
  getScale() {
    return this.scale;
  }
  //#region 修改元素属性
  /**
   * 修改这个对象的大小
   */
  size(t, r) {
    t === this.width && r === this.height || (this.width = t, this.height = r, this.enableCache && this.cache.size(t, r), this.update(this));
  }
  /**
   * 设置这个元素的位置，等效于`transform.setTranslate(x, y)`
   * @param x 横坐标
   * @param y 纵坐标
   */
  pos(t, r) {
    this._transform.setTranslate(t, r);
  }
  /**
   * 设置本元素的滤镜
   * @param filter 滤镜
   */
  setFilter(t) {
    var r;
    this.filter = t, (r = this._parent) == null || r.update();
  }
  /**
   * 设置本元素渲染时的混合方式
   * @param composite 混合方式
   */
  setComposite(t) {
    var r;
    this.composite = t, (r = this._parent) == null || r.update();
  }
  /**
   * 设置本元素的不透明度
   * @param alpha 不透明度
   */
  setAlpha(t) {
    var r;
    this.alpha = t, (r = this._parent) == null || r.update();
  }
  setHD(t) {
    this.highResolution = t, this.enableCache && this.cache.setHD(t), this.update(this);
  }
  setAntiAliasing(t) {
    this.antiAliasing = t, this.enableCache && this.cache.setAntiAliasing(t), this.update(this);
  }
  setZIndex(t) {
    var r;
    this.zIndex = t, (r = this.parent) == null || r.requestSort();
  }
  setAnchor(t, r) {
    var i;
    this.anchorX = t, this.anchorY = r, (i = this._parent) == null || i.update();
  }
  /**
   * 隐藏这个元素
   */
  hide() {
    this.hidden || (this.hidden = !0, this.update(this));
  }
  /**
   * 显示这个元素
   */
  show() {
    this.hidden && (this.hidden = !1, this.refreshAllChildren());
  }
  //#endregion
  //#region 功能方法
  /**
   * 获取当前元素的绝对位置（不建议使用，因为应当很少会有获取绝对位置的需求）
   */
  getAbsolutePosition(t = 0, r = 0) {
    if (this.type === "absolute")
      return this.parent ? this.parent.getAbsolutePosition(0, 0) : [0, 0];
    const [i, n] = this._transform.transformed(t, r);
    if (this.parent) {
      const [o, a] = this.parent.getAbsolutePosition();
      return [t + o, r + a];
    } else
      return [i, n];
  }
  /**
   * 获取到可以包围这个元素的最小矩形，相对于父元素
   */
  getBoundingRect() {
    if (this.type === "absolute")
      return new DOMRectReadOnly(0, 0, this.width, this.height);
    const t = this.transformFallThrough ? this.fallTransform : this._transform;
    if (!t) return new DOMRectReadOnly(0, 0, this.width, this.height);
    const [r, i] = t.transformed(
      -this.anchorX * this.width,
      -this.anchorY * this.height
    ), [n, o] = t.transformed(
      this.width * (1 - this.anchorX),
      -this.anchorY * this.height
    ), [a, c] = t.transformed(
      -this.anchorX * this.width,
      this.height * (1 - this.anchorY)
    ), [l, f] = t.transformed(
      this.width * (1 - this.anchorX),
      this.height * (1 - this.anchorY)
    ), h = Math.min(r, n, a, l), p = Math.max(r, n, a, l), m = Math.min(i, o, c, f), v = Math.max(i, o, c, f);
    return new DOMRectReadOnly(h, m, p - h, v - m);
  }
  update(t = this) {
    if (this._parent) {
      if (this.cacheDirty && this._parent.cacheDirty || (this.cacheDirty = !0, this.hidden)) return;
      this._parent.update(t);
    } else {
      if (this.cacheDirty) return;
      this.cacheDirty = !0;
    }
  }
  updateTransform() {
    var t;
    (t = this._parent) == null || t.update(), this.emit("transform", this, this._transform);
  }
  //#endregion
  //#region 动画帧与 ticker
  requestBeforeFrame(t) {
    Ks.push(t);
  }
  requestAfterFrame(t) {
    Ws.push(t);
  }
  requestRenderFrame(t) {
    Xs.push(t);
  }
  delegateTicker(t, r, i) {
    const n = Se.tickerId++;
    if (typeof r == "number" && r === 0) return n;
    const o = {
      fn: t,
      endFn: i
    };
    return Se.tickerMap.set(n, o), typeof r == "number" && r < 2147438647 && r > 0 && (o.timeout = window.setTimeout(() => {
      Se.tickerMap.delete(n), i == null || i();
    }, r)), n;
  }
  removeTicker(t, r = !0) {
    var n;
    const i = Se.tickerMap.get(t);
    return i ? (Se.ticker.remove(i.fn), window.clearTimeout(i.timeout), r && ((n = i.endFn) == null || n.call(i)), Se.tickerMap.delete(t), !0) : !1;
  }
  hasTicker(t) {
    return Se.tickerMap.has(t);
  }
  //#endregion
  //#region 父子关系
  setRoot(t) {
    var r;
    (r = this._root) == null || r.disconnect(this), this._root = t, t.connect(t);
  }
  checkRoot() {
    if (this._root) return this._root;
    if (this.isRoot) return this;
    let t = this;
    for (; !t.isRoot; ) {
      if (t._root)
        return this._root = t._root, this._root;
      if (t._parent)
        t = t._parent;
      else
        return null;
    }
    return this._root = t, t;
  }
  /**
   * 刷新所有子元素
   */
  refreshAllChildren() {
    if (this.children.size > 0) {
      const t = [this];
      for (; t.length > 0; ) {
        const r = t.pop();
        r && (r.cacheDirty = !0, r.children.forEach((i) => t.push(i)));
      }
    }
    this.update(this);
  }
  /**
   * 将这个渲染元素添加到其他父元素上
   * @param parent 父元素
   */
  appendTo(t) {
    var r;
    this.remove(), t.children.add(this), this._parent = t, t.requestSort(), this.update(), this.checkRoot(), (r = this._root) == null || r.connect(this), this._transform.bind(this), this.onResize(t.scale);
  }
  /**
   * 从渲染树中移除这个节点
   * @returns 是否移除成功
   */
  remove() {
    var i;
    if (!this.parent) return !1;
    const t = this.parent, r = t.children.delete(this);
    return this._parent = void 0, t.requestSort(), t.update(), this._transform.bind(), r ? ((i = this._root) == null || i.disconnect(this), this._root = void 0, !0) : !1;
  }
  /**
   * 添加子元素，默认没有任何行为且会抛出警告，你需要在自己的RenderItem继承类中复写它，才可以使用
   * @param child 子元素
   */
  appendChild(...t) {
    q.warn(35);
  }
  /**
   * 移除子元素，默认没有任何行为且会抛出警告，你需要在自己的RenderItem继承类中复写它，才可以使用
   * @param child 子元素
   */
  removeChild(...t) {
    q.warn(36);
  }
  /**
   * 申请对元素进行排序，默认没有任何行为且会抛出警告，你需要在自己的RenderItem继承类中复写它，才可以使用
   */
  requestSort() {
    q.warn(37);
  }
  //#endregion
  //#region 交互事件
  /**
   * 根据事件类型和事件阶段获取事件名称
   * @param type 事件类型
   * @param progress 事件阶段
   */
  getEventName(t, r) {
    return t === B.Enter || t === B.Leave ? Pr[t] : r === wt.Capture ? `${Pr[t]}Capture` : Pr[t];
  }
  /**
   * 传递事件，即将事件传递给父元素或子元素等，可以通过 override 来实现自己的事件传递，
   * 例如 Container 元素就需要在捕获阶段将事件传递给所有子元素，
   * 默认行为是，捕获阶段触发自身冒泡，冒泡阶段触发父元素冒泡，适用于大部分不包含子元素的元素
   * @param type 事件类型
   * @param progress 事件阶段，捕获阶段或冒泡阶段
   * @param event 正在处理的事件对象
   */
  propagateEvent(t, r, i) {
    var n;
    r === wt.Capture ? this.bubbleEvent(t, i) : (n = this.parent) == null || n.bubbleEvent(t, i);
  }
  handleEvent(t, r, i) {
    const n = this.processEvent(t, r, i);
    if (n) {
      const o = this.getEventName(t, r);
      this.emit(o, n), this.propagationStoped.get(t) || this.propagateEvent(t, r, n);
    }
    return this.propagationStoped.set(t, !1), n;
  }
  /**
   * 捕获事件
   * @param type 事件类型
   * @param event 由父元素传递来的事件
   */
  captureEvent(t, r) {
    return this.handleEvent(t, wt.Capture, r);
  }
  /**
   * 冒泡事件
   * @param type 事件类型
   * @param event 由子元素传递来的事件
   */
  bubbleEvent(t, r) {
    return this.handleEvent(t, wt.Bubble, r);
  }
  /**
   * 处理事件，用于根据上一级传递的事件内容生成新的事件内容，并执行一些事件的默认行为
   * @param type 事件类型
   * @param progress 事件阶段，捕获阶段还是冒泡阶段
   * @param event 由上一级（捕获阶段的父元素，冒泡阶段的子元素）传递来的事件内容
   */
  processEvent(t, r, i) {
    if (this.noEvent) return null;
    if (r === wt.Capture) {
      const n = this.transformFallThrough ? this.fallTransform : this._transform;
      if (!n) return null;
      const [o, a] = this.calActionPosition(i, n), c = this.isActionInElement(o, a), l = {
        ...i,
        offsetX: o,
        offsetY: a,
        target: this,
        stopPropagation: () => {
          this.propagationStoped.set(t, !0);
        }
      };
      return this.inElement = c, this.processCapture(t, l, c) ? (this.cachedEvent.set(t, l), l) : null;
    } else {
      const n = this.cachedEvent.get(t);
      return this.processBubble(t, n, this.inElement), this.cachedEvent.delete(t), n;
    }
  }
  /**
   * 处理捕获阶段的事件，可以通过 override 来添加新内容，注意调用 `super.processCapture` 来执行默认行为
   * @param type 事件类型
   * @param event 正在处理的事件对象
   * @param inElement 当前鼠标是否在元素内
   * @returns 是否继续传递事件
   */
  processCapture(t, r, i) {
    var n;
    switch (t) {
      case B.Move: {
        i && ((n = this._root) == null || n.hoverElement(this));
        break;
      }
      case B.Down: {
        if (!i) return !1;
        r.touch ? this.touchId.add(r.identifier) : this.mouseId.set(r.type, r.identifier);
        break;
      }
      case B.Click: {
        if (!i) return !1;
        if (r.touch) {
          if (!this.touchId.has(r.identifier))
            return !1;
          this.touchId.delete(r.identifier);
        } else {
          if (this.mouseId.get(r.type) !== r.identifier)
            return this.mouseId.delete(r.type), !1;
          this.mouseId.delete(r.type);
        }
        break;
      }
    }
    return i;
  }
  /**
   * 处理冒泡阶段的事件，可以通过 override 来添加新内容，注意调用 `super.processBubble` 来执行默认行为
   * @param type 事件类型
   * @param event 正在处理的事件对象
   * @param inElement 当前鼠标是否在元素内
   * @returns 是否继续传递事件
   */
  processBubble(t, r, i) {
    switch (t) {
      case B.Enter:
      case B.Leave:
        return !1;
    }
    return i;
  }
  /**
   * 计算一个点击事件在该元素上的位置
   * @param event 触发的事件
   * @param transform 当前的变换矩阵
   */
  calActionPosition(t, r) {
    const i = this.anchorX * this.width, n = this.anchorY * this.height;
    if (this.type === "absolute")
      return [t.offsetX + i, t.offsetY + n, 0];
    {
      const [o, a] = r.untransformed(
        t.offsetX,
        t.offsetY
      );
      return [o + i, a + n, 0];
    }
  }
  /**
   * 判断一个点击事件是否在元素内，可以通过 override 来修改其行为
   * @param x 横坐标
   * @param y 纵坐标
   */
  isActionInElement(t, r) {
    return t >= 0 && t < this.width && r >= 0 && r < this.height;
  }
  actionClick() {
  }
  actionDown() {
  }
  actionUp() {
  }
  actionMove() {
  }
  actionEnter() {
  }
  actionLeave() {
  }
  actionWheel() {
  }
  assertType(t, r, i) {
    var n;
    if (typeof r == "string") {
      const o = typeof t;
      return o !== r ? (q.error(21, i, r, o), !1) : !0;
    } else
      return t instanceof r ? !0 : (q.error(
        21,
        i,
        r.name,
        ((n = t == null ? void 0 : t.constructor) == null ? void 0 : n.name) ?? typeof t
      ), !1);
  }
  /**
   * 解析事件key
   * @param key 键名
   * @returns 返回字符串表示解析后的键名，返回布尔值表示不是事件
   */
  parseEvent(t) {
    if (t.startsWith("on")) {
      const r = t.charCodeAt(2);
      if (r >= 65 && r <= 90)
        return t[2].toLowerCase() + t.slice(3);
    }
    return !1;
  }
  /**
   * 自定义处理 props，自定义元素需要 override 此函数来处理 props
   * @param key 传入的 props 的键名
   * @param prevValue 这个 props 之前的值
   * @param nextValue 这个 props 传入的值
   * @returns 是否处理成功
   */
  handleProps(t, r, i) {
    return !1;
  }
  patchProp(t, r, i, n, o) {
    if (ne(r) && ne(i) || this.handleProps(t, r, i)) return;
    switch (t) {
      case "x": {
        if (!this.assertType(i, "number", t)) return;
        this.pos(i, this._transform.y);
        return;
      }
      case "y": {
        if (!this.assertType(i, "number", t)) return;
        this.pos(this._transform.x, i);
        return;
      }
      case "anchorX": {
        if (!this.assertType(i, "number", t)) return;
        this.setAnchor(i, this.anchorY);
        return;
      }
      case "anchorY": {
        if (!this.assertType(i, "number", t)) return;
        this.setAnchor(this.anchorX, i);
        return;
      }
      case "zIndex": {
        if (!this.assertType(i, "number", t)) return;
        this.setZIndex(i);
        return;
      }
      case "width": {
        if (!this.assertType(i, "number", t)) return;
        this.size(i, this.height);
        return;
      }
      case "height": {
        if (!this.assertType(i, "number", t)) return;
        this.size(this.width, i);
        return;
      }
      case "filter": {
        if (!this.assertType(i, "string", t)) return;
        this.setFilter(i);
        return;
      }
      case "hd": {
        if (!this.assertType(i, "boolean", t)) return;
        this.setHD(i);
        return;
      }
      case "anti": {
        if (!this.assertType(i, "boolean", t)) return;
        this.setAntiAliasing(i);
        return;
      }
      case "noanti": {
        if (!this.assertType(i, "boolean", t)) return;
        this.setAntiAliasing(!i);
        return;
      }
      case "hidden": {
        if (!this.assertType(i, "boolean", t)) return;
        i ? this.hide() : this.show();
        return;
      }
      case "transform": {
        if (!this.assertType(i, Nt, t)) return;
        this.transform = i, this.update();
        return;
      }
      case "type": {
        if (!this.assertType(i, "string", t)) return;
        this.type = i, this.update();
        return;
      }
      case "id": {
        if (!this.assertType(i, "string", t)) return;
        this.id = i;
        return;
      }
      case "alpha": {
        if (!this.assertType(i, "number", t)) return;
        this.setAlpha(i);
        return;
      }
      case "composite": {
        if (!this.assertType(i, "string", t)) return;
        this.setComposite(i);
        return;
      }
      case "loc": {
        if (ut(i, r) || !this.assertType(i, Array, t)) return;
        !ne(i[0]) && !ne(i[1]) && this.pos(i[0], i[1]), !ne(i[2]) && !ne(i[3]) && this.size(i[2], i[3]), !ne(i[4]) && !ne(i[5]) && this.setAnchor(
          i[4],
          i[5]
        );
        return;
      }
      case "anc": {
        if (ut(i, r) || !this.assertType(i, Array, t)) return;
        this.setAnchor(i[0], i[1]);
        return;
      }
      case "cursor": {
        if (!this.assertType(i, "string", t)) return;
        this.cursor = i;
        return;
      }
      case "scale": {
        if (ut(i, r) || !this.assertType(i, Array, t)) return;
        this._transform.setScale(
          i[0],
          i[1]
        );
        return;
      }
      case "rotate": {
        if (!this.assertType(i, "number", t)) return;
        this._transform.setRotate(i);
        return;
      }
      case "noevent": {
        if (!this.assertType(i, "boolean", t)) return;
        this.noEvent = i;
        return;
      }
    }
    const a = this.parseEvent(t);
    a && (r && this.off(a, r), this.on(a, i));
  }
  //#endregion
  /**
   * 摧毁这个渲染元素，摧毁后不应继续使用
   */
  destroy() {
    this.remove(), this.emit("destroy"), this.removeAllListeners(), this.canvases.clear();
  }
};
/** 渲染的全局ticker */
d(Se, "ticker", new bi()), /** 包括但不限于怪物、npc、自动元件的动画帧数 */
d(Se, "animatedFrame", 0), /** ticker委托映射 */
d(Se, "tickerMap", /* @__PURE__ */ new Map()), /** ticker委托id */
d(Se, "tickerId", 0);
let Ue = Se;
Ue.ticker.add((e) => {
  if (Ks.length > 0) {
    const s = Ks.slice();
    Ks.splice(0), s.forEach((t) => t());
  }
  if (Ue.tickerMap.forEach((s) => {
    s.fn(e);
  }), Xs.length > 0) {
    const s = Xs.slice();
    Xs.splice(0), s.forEach((t) => t());
  }
  if (Ws.length > 0) {
    const s = Ws.slice();
    Ws.splice(0), s.forEach((t) => t());
  }
});
class br extends Ue {
  /**
   * 创建一个容器，容器中可以包含其他渲染对象
   * @param type 渲染模式，absolute表示绝对位置，static表示跟随摄像机移动
   * @param cache 是否启用缓存机制
   */
  constructor(t = "static", r = !0, i = !1) {
    super(t, r, i);
    d(this, "sortedChildren", []);
    d(this, "needSort", !1);
    this.type = t;
  }
  render(t, r) {
    this.sortedChildren.forEach((i) => {
      i.hidden || i.renderContent(t, r);
    });
  }
  onResize(t) {
    this.children.forEach((r) => r.onResize(t)), super.onResize(t);
  }
  requestSort() {
    this.needSort || (this.needSort = !0, this.requestBeforeFrame(() => {
      this.needSort = !1, this.sortChildren();
    }));
  }
  /**
   * 添加子元素到这个容器上，然后在下一个tick执行更新
   * @param children 要添加的子元素
   */
  appendChild(...t) {
    t.forEach((r) => {
      r.appendTo(this);
    }), this.requestSort(), this.update(this);
  }
  removeChild(...t) {
    let r = !1;
    t.forEach((i) => {
      if (i.parent !== this) return;
      i.remove() && (r = !0);
    }), r && this.requestSort(), this.update(this);
  }
  appendTo(t) {
    if (super.appendTo(t), this.root) {
      const r = this.root;
      this.forEachChild((i) => {
        i.setRoot(r);
      });
    }
  }
  /**
   * 遍历这个元素中的每个子元素，并执行传入的函数
   * @param fn 对每个元素执行的函数
   */
  forEachChild(t) {
    const r = [this];
    for (; r.length > 0; ) {
      const i = r.pop();
      r.push(...i.children), t(i);
    }
  }
  sortChildren() {
    this.sortedChildren = [...this.children].filter((t) => !t.isComment).sort((t, r) => t.zIndex - r.zIndex), this.update();
  }
  propagateEvent(t, r, i) {
    var o;
    const n = this.sortedChildren.length;
    if (r === wt.Capture) {
      let a = !1;
      for (let c = n - 1; c >= 0; c--) {
        const l = this.sortedChildren[c];
        if (!l.hidden && l.captureEvent(t, i)) {
          a = !0;
          break;
        }
      }
      a || this.bubbleEvent(t, i);
    } else
      (o = this.parent) == null || o.bubbleEvent(t, i);
  }
  destroy() {
    super.destroy(), this.children.forEach((t) => {
      t.destroy();
    });
  }
}
class cf extends br {
  constructor() {
    super(...arguments);
    d(this, "renderFn");
    d(this, "propagateFn");
  }
  render(t, r) {
    this.renderFn ? this.renderFn(t, this.sortedChildren, r) : super.render(t, r);
  }
  propagateEvent(t, r, i) {
    this.propagateFn ? this.propagateFn(t, r, i, this, () => {
      super.propagateEvent(t, r, i);
    }) : super.propagateEvent(t, r, i);
  }
  /**
   * 设置这个自定义容器的渲染函数
   * @param render 渲染函数
   */
  setRenderFn(t) {
    this.renderFn = t;
  }
  /**
   * 设置这个自定义容器的事件传递函数
   * @param propagate 事件传递函数
   */
  setPropagateFn(t) {
    this.propagateFn = t;
  }
  handleProps(t, r, i) {
    switch (t) {
      case "render":
        return this.assertType(i, "function", t) ? (this.setRenderFn(i), !0) : !1;
      case "propagate":
        return this.assertType(i, "function", t) ? (this.setPropagateFn(i), !0) : !1;
    }
    return super.handleProps(t, r, i);
  }
}
const lf = {
  VERTEX: (
    /* glsl */
    `#version 300 es
precision highp float;
`
  ),
  FRAGMENT: (
    /* glsl */
    `#version 300 es
precision highp float;
`
  )
};
var hf = /* @__PURE__ */ ((e) => (e[e.Uniform1f = 0] = "Uniform1f", e[e.Uniform1fv = 1] = "Uniform1fv", e[e.Uniform1i = 2] = "Uniform1i", e[e.Uniform1iv = 3] = "Uniform1iv", e[e.Uniform1ui = 4] = "Uniform1ui", e[e.Uniform1uiv = 5] = "Uniform1uiv", e[e.Uniform2f = 6] = "Uniform2f", e[e.Uniform2fv = 7] = "Uniform2fv", e[e.Uniform2i = 8] = "Uniform2i", e[e.Uniform2iv = 9] = "Uniform2iv", e[e.Uniform2ui = 10] = "Uniform2ui", e[e.Uniform2uiv = 11] = "Uniform2uiv", e[e.Uniform3f = 12] = "Uniform3f", e[e.Uniform3fv = 13] = "Uniform3fv", e[e.Uniform3i = 14] = "Uniform3i", e[e.Uniform3iv = 15] = "Uniform3iv", e[e.Uniform3ui = 16] = "Uniform3ui", e[e.Uniform3uiv = 17] = "Uniform3uiv", e[e.Uniform4f = 18] = "Uniform4f", e[e.Uniform4fv = 19] = "Uniform4fv", e[e.Uniform4i = 20] = "Uniform4i", e[e.Uniform4iv = 21] = "Uniform4iv", e[e.Uniform4ui = 22] = "Uniform4ui", e[e.Uniform4uiv = 23] = "Uniform4uiv", e))(hf || {}), ff = /* @__PURE__ */ ((e) => (e[e.UMatrix2x2 = 0] = "UMatrix2x2", e[e.UMatrix2x3 = 1] = "UMatrix2x3", e[e.UMatrix2x4 = 2] = "UMatrix2x4", e[e.UMatrix3x2 = 3] = "UMatrix3x2", e[e.UMatrix3x3 = 4] = "UMatrix3x3", e[e.UMatrix3x4 = 5] = "UMatrix3x4", e[e.UMatrix4x2 = 6] = "UMatrix4x2", e[e.UMatrix4x3 = 7] = "UMatrix4x3", e[e.UMatrix4x4 = 8] = "UMatrix4x4", e))(ff || {}), uf = /* @__PURE__ */ ((e) => (e[e.Attrib1f = 0] = "Attrib1f", e[e.Attrib1fv = 1] = "Attrib1fv", e[e.Attrib2f = 2] = "Attrib2f", e[e.Attrib2fv = 3] = "Attrib2fv", e[e.Attrib3f = 4] = "Attrib3f", e[e.Attrib3fv = 5] = "Attrib3fv", e[e.Attrib4f = 6] = "Attrib4f", e[e.Attrib4fv = 7] = "Attrib4fv", e[e.AttribI4i = 8] = "AttribI4i", e[e.AttribI4iv = 9] = "AttribI4iv", e[e.AttribI4ui = 10] = "AttribI4ui", e[e.AttribI4uiv = 11] = "AttribI4uiv", e))(uf || {});
const bs = class bs extends Ue {
  constructor(t = "static") {
    super(t, !1);
    // 会用到的一些常量
    // uniform 类型
    d(this, "UNIFORM_1f", 0);
    d(this, "UNIFORM_1fv", 1);
    d(this, "UNIFORM_1i", 2);
    d(this, "UNIFORM_1iv", 3);
    d(this, "UNIFORM_1ui", 4);
    d(this, "UNIFORM_1uiv", 5);
    d(this, "UNIFORM_2f", 6);
    d(this, "UNIFORM_2fv", 7);
    d(this, "UNIFORM_2i", 8);
    d(this, "UNIFORM_2iv", 9);
    d(this, "UNIFORM_2ui", 10);
    d(this, "UNIFORM_2uiv", 11);
    d(this, "UNIFORM_3f", 12);
    d(this, "UNIFORM_3fv", 13);
    d(this, "UNIFORM_3i", 14);
    d(this, "UNIFORM_3iv", 15);
    d(this, "UNIFORM_3ui", 16);
    d(this, "UNIFORM_3uiv", 17);
    d(this, "UNIFORM_4f", 18);
    d(this, "UNIFORM_4fv", 19);
    d(this, "UNIFORM_4i", 20);
    d(this, "UNIFORM_4iv", 21);
    d(this, "UNIFORM_4ui", 22);
    d(this, "UNIFORM_4uiv", 23);
    // uniform matrix 类型
    d(this, "U_MATRIX_2x2", 0);
    d(this, "U_MATRIX_2x3", 1);
    d(this, "U_MATRIX_2x4", 2);
    d(this, "U_MATRIX_3x2", 3);
    d(this, "U_MATRIX_3x3", 4);
    d(this, "U_MATRIX_3x4", 5);
    d(this, "U_MATRIX_4x2", 6);
    d(this, "U_MATRIX_4x3", 7);
    d(this, "U_MATRIX_4x4", 8);
    // attribute 类型
    d(this, "ATTRIB_1f", 0);
    d(this, "ATTRIB_1fv", 1);
    d(this, "ATTRIB_2f", 2);
    d(this, "ATTRIB_2fv", 3);
    d(this, "ATTRIB_3f", 4);
    d(this, "ATTRIB_3fv", 5);
    d(this, "ATTRIB_4f", 6);
    d(this, "ATTRIB_4fv", 7);
    d(this, "ATTRIB_I4i", 8);
    d(this, "ATTRIB_I4iv", 9);
    d(this, "ATTRIB_I4ui", 10);
    d(this, "ATTRIB_I4uiv", 11);
    // 渲染模式
    d(this, "DRAW_ARRAYS", 0);
    d(this, "DRAW_ELEMENTS", 1);
    d(this, "DRAW_ARRAYS_INSTANCED", 2);
    d(this, "DRAW_ELEMENTS_INSTANCED", 3);
    // 其他常量
    d(this, "MAX_TEXTURE_COUNT", 0);
    d(this, "canvas");
    d(this, "gl");
    /** webgl使用的程序 */
    d(this, "program", null);
    /** 当前渲染实例的所有着色器程序 */
    d(this, "programs", /* @__PURE__ */ new Set());
    /** framebuffer 映射 */
    d(this, "framebufferMap", /* @__PURE__ */ new Map());
    if (this.canvas = document.createElement("canvas"), this.gl = this.canvas.getContext("webgl2"), !bs.support)
      this.canvas.width = 0, this.canvas.height = 0;
    else {
      const r = this.gl.getParameter(this.gl.MAX_TEXTURE_IMAGE_UNITS);
      typeof r == "number" && (this.MAX_TEXTURE_COUNT = r);
    }
    this.init();
  }
  onResize(t) {
    this.sizeGL(this.width, this.height), super.onResize(t);
  }
  setHD(t) {
    super.setHD(t), this.sizeGL(this.width, this.height);
  }
  size(t, r) {
    super.size(t, r), this.sizeGL(t, r);
  }
  sizeGL(t, r) {
    const n = (this.highResolution ? devicePixelRatio : 1) * this.cache.scale;
    this.canvas.width = t * n, this.canvas.height = r * n;
  }
  render(t, r) {
    if (!bs.support || !this.program || !this.gl) return;
    this.program.requestCompile() && this.gl.useProgram(this.program.program);
    const n = this.gl;
    n.viewport(0, 0, this.canvas.width, this.canvas.height), n.clearColor(0, 0, 0, 0), n.clearDepth(1), n.clear(n.COLOR_BUFFER_BIT | n.DEPTH_BUFFER_BIT), this.program.ready(), this.drawScene(t, n, this.program, r), t.clear(), t.ctx.drawImage(this.canvas, 0, 0, this.width, this.height);
  }
  /**
   * 执行顶点绘制
   * @param gl 当前正在渲染的 gl2 画布
   * @param program 当前元素正在使用的着色器程序
   */
  draw(t, r) {
    const i = r.usingIndices, n = r.getDrawParams(r.renderMode);
    if (n)
      switch (r.renderMode) {
        case 0: {
          const { mode: o, first: a, count: c } = n;
          t.drawArrays(o, a, c);
          break;
        }
        case 1: {
          if (!i) return;
          const { mode: o, count: a, type: c, offset: l } = n;
          t.bindBuffer(t.ELEMENT_ARRAY_BUFFER, i.data), t.drawElements(o, a, c, l);
          break;
        }
        case 2: {
          const { mode: o, first: a, count: c, instanceCount: l } = n;
          t.drawArraysInstanced(o, a, c, l);
          break;
        }
        case 3: {
          if (!i) return;
          const {
            mode: o,
            count: a,
            type: c,
            offset: l,
            instanceCount: f
          } = n;
          t.bindBuffer(t.ELEMENT_ARRAY_BUFFER, i.data), t.drawElementsInstanced(o, a, c, l, f);
          break;
        }
      }
  }
  /**
   * 将画面渲染至帧缓冲
   * @param name 帧缓冲名称
   * @param texture 渲染至的纹理
   * @param clear 是否先清空画布再渲染
   */
  framebuffer(t, r, i = !0) {
    const n = this.gl, o = this.framebufferMap.get(t), a = this.program;
    if (!n || !o || !a) return;
    const c = r.texture;
    n.bindTexture(n.TEXTURE_2D, c), n.bindFramebuffer(n.FRAMEBUFFER, o), i && (n.viewport(0, 0, this.canvas.width, this.canvas.height), n.clearColor(0, 0, 0, 0), n.clearDepth(1), n.clear(n.COLOR_BUFFER_BIT | n.DEPTH_BUFFER_BIT)), n.framebufferTexture2D(
      n.FRAMEBUFFER,
      n.COLOR_ATTACHMENT0,
      n.TEXTURE_2D,
      c,
      0
    ), this.draw(n, a), n.bindFramebuffer(n.FRAMEBUFFER, null), n.bindTexture(n.TEXTURE_2D, null);
  }
  /**
   * 创建一个帧缓冲对象
   * @param name 帧缓冲名称
   * @returns 是否创建成功
   */
  createFramebuffer(t) {
    const r = this.gl;
    if (!r) return !1;
    const i = r.createFramebuffer();
    return i ? (this.framebufferMap.set(t, i), !0) : !1;
  }
  /**
   * 删除一个帧缓冲对象
   * @param name 帧缓冲名称
   * @returns 是否删除成功
   */
  deleteFramebuffer(t) {
    const r = this.gl;
    if (!r) return !1;
    const i = this.framebufferMap.get(t);
    return i ? (r.deleteFramebuffer(i), this.framebufferMap.delete(t)) : !1;
  }
  /**
   * 切换着色器程序
   * @param program 着色器程序
   */
  useProgram(t) {
    var r;
    if (this.gl) {
      if (t.element !== this) {
        q.error(17);
        return;
      }
      this.program !== t && ((r = this.program) == null || r.unload(), this.program = t, this.gl.useProgram(t.program), t.load());
    }
  }
  /**
   * 创建一个着色器程序
   * @param vs 顶点着色器，可选
   * @param fs 片元着色器，可选
   */
  createProgram(t, r, i) {
    const n = new t(this, r, i);
    return this.programs.add(n), n;
  }
  /**
   * 删除一个着色器程序
   * @param program 要删除的着色器程序
   */
  deleteProgram(t) {
    if (t.element !== this) {
      q.error(18);
      return;
    }
    t.destroy(), this.programs.delete(t);
  }
  destroy() {
    this.programs.forEach((t) => t.destroy()), this.canvas.remove(), super.destroy();
  }
  init() {
    const t = this.gl;
    t && (t.enable(t.DEPTH_TEST), t.enable(t.BLEND), t.blendFunc(t.SRC_ALPHA, t.ONE_MINUS_SRC_ALPHA), t.depthFunc(t.LEQUAL));
  }
};
/** 是否支持此组件 */
d(bs, "support", nf());
let ti = bs;
class df {
  constructor(s, t, r, i) {
    this.type = s, this.location = t, this.gl = r, this.program = i;
  }
  set(...s) {
    const [t, r, i, n] = s;
    switch (this.type) {
      case 0:
        this.gl.uniform1f(this.location, t);
        break;
      case 1:
        this.gl.uniform1fv(this.location, t, r, i);
        break;
      case 2:
        this.gl.uniform1i(this.location, t);
        break;
      case 3:
        this.gl.uniform1iv(this.location, t, r, i);
        break;
      case 4:
        this.gl.uniform1ui(this.location, t);
        break;
      case 5:
        this.gl.uniform1uiv(this.location, t, r, i);
        break;
      case 6:
        this.gl.uniform2f(this.location, t, r);
        break;
      case 7:
        this.gl.uniform2fv(this.location, t, r, i);
        break;
      case 8:
        this.gl.uniform2i(this.location, t, r);
        break;
      case 9:
        this.gl.uniform2iv(this.location, t, r, i);
        break;
      case 10:
        this.gl.uniform2ui(this.location, t, r);
        break;
      case 11:
        this.gl.uniform2uiv(this.location, t, r, i);
        break;
      case 12:
        this.gl.uniform3f(this.location, t, r, i);
        break;
      case 13:
        this.gl.uniform3fv(this.location, t, r, i);
        break;
      case 14:
        this.gl.uniform3i(this.location, t, r, i);
        break;
      case 15:
        this.gl.uniform3iv(this.location, t, r, i);
        break;
      case 16:
        this.gl.uniform3ui(this.location, t, r, i);
        break;
      case 17:
        this.gl.uniform3uiv(this.location, t, r, i);
        break;
      case 18:
        this.gl.uniform4f(this.location, t, r, i, n);
        break;
      case 19:
        this.gl.uniform4fv(this.location, t, r, i);
        break;
      case 20:
        this.gl.uniform4i(this.location, t, r, i, n);
        break;
      case 21:
        this.gl.uniform4iv(this.location, t, r, i);
        break;
      case 22:
        this.gl.uniform4ui(this.location, t, r, i, n);
        break;
      case 23:
        this.gl.uniform4uiv(this.location, t, r, i);
        break;
    }
  }
}
class pf {
  constructor(s, t, r, i) {
    this.type = s, this.location = t, this.gl = r, this.program = i;
  }
  set(...s) {
    const [t, r, i, n] = s;
    switch (this.type) {
      case 0:
        this.gl.vertexAttrib1f(this.location, t);
        break;
      case 1:
        this.gl.vertexAttrib1fv(this.location, t);
        break;
      case 2:
        this.gl.vertexAttrib2f(this.location, t, r);
        break;
      case 3:
        this.gl.vertexAttrib2fv(this.location, t);
        break;
      case 4:
        this.gl.vertexAttrib3f(this.location, t, r, i);
        break;
      case 5:
        this.gl.vertexAttrib3fv(this.location, t);
        break;
      case 6:
        this.gl.vertexAttrib4f(this.location, t, r, i, n);
        break;
      case 7:
        this.gl.vertexAttrib4fv(this.location, t);
        break;
      case 8:
        this.gl.vertexAttribI4i(this.location, t, r, i, n);
        break;
      case 9:
        this.gl.vertexAttribI4iv(this.location, t);
        break;
      case 10:
        this.gl.vertexAttribI4ui(this.location, t, r, i, n);
        break;
      case 11:
        this.gl.vertexAttribI4uiv(this.location, t);
        break;
      default: {
        q.warn(26);
        return;
      }
    }
  }
}
class gf {
  constructor(s, t, r, i) {
    this.data = s, this.location = t, this.gl = r, this.program = i;
  }
  buffer(s, t, r, i) {
    const n = this.gl;
    n.bindBuffer(n.ARRAY_BUFFER, this.data), typeof r == "number" ? n.bufferData(n.ARRAY_BUFFER, s, t, r, i) : n.bufferData(n.ARRAY_BUFFER, s, t);
  }
  sub(s, t, r, i) {
    const n = this.gl;
    n.bindBuffer(n.ARRAY_BUFFER, this.data), typeof r == "number" ? n.bufferSubData(n.ARRAY_BUFFER, s, t, r, i) : n.bufferSubData(n.ARRAY_BUFFER, s, t);
  }
  pointer(s, t, r, i, n) {
    const o = this.gl;
    o.bindBuffer(o.ARRAY_BUFFER, this.data), o.vertexAttribPointer(this.location, s, t, r, i, n);
  }
  pointerI(s, t, r, i) {
    const n = this.gl;
    n.bindBuffer(n.ARRAY_BUFFER, this.data), n.vertexAttribIPointer(this.location, s, t, r, i);
  }
  divisor(s) {
    this.gl.vertexAttribDivisor(this.location, s);
  }
  enable() {
    this.gl.enableVertexAttribArray(this.location);
  }
  disable() {
    this.gl.disableVertexAttribArray(this.location);
  }
}
class mf {
  constructor(s, t, r) {
    this.data = s, this.gl = t, this.program = r;
  }
  buffer(s, t, r, i) {
    const n = this.gl;
    n.bindBuffer(n.ELEMENT_ARRAY_BUFFER, this.data), typeof r == "number" ? n.bufferData(n.ELEMENT_ARRAY_BUFFER, s, t, r, i) : n.bufferData(n.ELEMENT_ARRAY_BUFFER, s, t);
  }
  sub(s, t, r, i) {
    const n = this.gl;
    n.bindBuffer(n.ELEMENT_ARRAY_BUFFER, this.data), typeof r == "number" ? n.bufferSubData(n.ELEMENT_ARRAY_BUFFER, s, t, r, i) : n.bufferSubData(n.ELEMENT_ARRAY_BUFFER, s, t);
  }
}
class vf {
  constructor(s, t, r, i) {
    this.type = s, this.location = t, this.gl = r, this.program = i;
  }
  set(s, t, r, i) {
    switch (this.type) {
      case 0:
        this.gl.uniformMatrix2fv(this.location, s, t, r, i);
        break;
      case 1:
        this.gl.uniformMatrix2x3fv(this.location, s, t, r, i);
        break;
      case 2:
        this.gl.uniformMatrix2x4fv(this.location, s, t, r, i);
        break;
      case 3:
        this.gl.uniformMatrix3x2fv(this.location, s, t, r, i);
        break;
      case 4:
        this.gl.uniformMatrix3fv(this.location, s, t, r, i);
        break;
      case 5:
        this.gl.uniformMatrix3x4fv(this.location, s, t, r, i);
        break;
      case 6:
        this.gl.uniformMatrix4x2fv(this.location, s, t, r, i);
        break;
      case 7:
        this.gl.uniformMatrix4x3fv(this.location, s, t, r, i);
        break;
      case 8:
        this.gl.uniformMatrix4fv(this.location, s, t, r, i);
        break;
    }
  }
}
class bf {
  constructor(s, t, r, i, n, o) {
    this.location = s, this.size = t, this.buffer = r, this.binding = i, this.gl = n, this.program = o;
  }
  set(s, t, r) {
    const i = this.gl, n = this.buffer;
    i.bindBuffer(i.UNIFORM_BUFFER, n), t !== void 0 ? i.bufferSubData(i.UNIFORM_BUFFER, 0, s, t, r) : i.bufferSubData(i.UNIFORM_BUFFER, 0, s), i.bindBufferBase(i.UNIFORM_BUFFER, this.binding, n);
  }
}
class _f {
  constructor(s, t, r, i, n, o = 0, a = 0) {
    this.texture = s, this.index = t, this.uniform = r, this.gl = i, this.program = n, this.width = o, this.height = a, r.set(t);
  }
  set(s) {
    const t = this.gl;
    t.activeTexture(t.TEXTURE0 + this.index), t.bindTexture(t.TEXTURE_2D, this.texture), t.texParameteri(t.TEXTURE_2D, t.TEXTURE_MAG_FILTER, t.NEAREST), t.texParameteri(t.TEXTURE_2D, t.TEXTURE_MIN_FILTER, t.NEAREST), t.texParameteri(t.TEXTURE_2D, t.TEXTURE_WRAP_S, t.CLAMP_TO_EDGE), t.texParameteri(t.TEXTURE_2D, t.TEXTURE_WRAP_T, t.CLAMP_TO_EDGE), t.texImage2D(
      t.TEXTURE_2D,
      0,
      t.RGBA,
      t.RGBA,
      t.UNSIGNED_BYTE,
      s
    ), s instanceof VideoFrame ? (this.width = s.codedWidth, this.height = s.codedHeight) : (this.width = s.width, this.height = s.height);
  }
  sub(s, t, r, i, n) {
    const o = this.gl;
    o.activeTexture(o.TEXTURE0 + this.index), o.bindTexture(o.TEXTURE_2D, this.texture), (t + i > this.width || r + n > this.height) && (q.warn(32), i = Math.min(i, this.width - t), n = Math.min(n, this.height - r)), o.texSubImage2D(
      o.TEXTURE_2D,
      0,
      t,
      r,
      i,
      n,
      o.RGBA,
      o.UNSIGNED_BYTE,
      s
    );
  }
}
class yf extends vi {
  constructor(t, r, i) {
    super();
    /** 顶点着色器 */
    d(this, "vertex", "");
    /** 片元着色器 */
    d(this, "fragment", "");
    /** webgl2上下文 */
    d(this, "gl");
    /** 当前着色器程序的着色器渲染元素 */
    d(this, "element");
    /** uniform存放地址 */
    d(this, "uniform", /* @__PURE__ */ new Map());
    /** attribute存放地址，300版本里面叫做in */
    d(this, "attribute", /* @__PURE__ */ new Map());
    /** attribute array 存放地址 */
    d(this, "attribArray", /* @__PURE__ */ new Map());
    /** 顶点索引存放地址 */
    d(this, "indices", /* @__PURE__ */ new Map());
    /** uniform矩阵存放地址 */
    d(this, "matrix", /* @__PURE__ */ new Map());
    /** uniform block 存放地址 */
    d(this, "block", /* @__PURE__ */ new Map());
    /** 纹理存放地址 */
    d(this, "texture", /* @__PURE__ */ new Map());
    /** 当前编译完成的shader程序 */
    d(this, "shader", null);
    /** 当前的webgl程序 */
    d(this, "program", null);
    /** 当前正在使用的顶点索引数组 */
    d(this, "usingIndices", null);
    /** 着色器内容是否是默认内容，可以用于优化空着色器 */
    d(this, "modified", !1);
    /** 渲染模式 */
    d(this, "renderMode", 1);
    d(this, "arraysParams", null);
    d(this, "elementsParams", null);
    d(this, "arraysInstancedParams", null);
    d(this, "elementsInstancedParams", null);
    /** 是否需要重新编译着色器 */
    d(this, "shaderDirty", !0);
    /** 着色器代码的前缀，会在设置时自动添加至代码前 */
    d(this, "prefix", lf);
    r && this.vs(r), i && this.fs(i), this.element = t, this.gl = t.gl, (r || i) && this.requestCompile();
  }
  /**
   * 渲染前准备
   */
  ready() {
    return !0;
  }
  /**
   * 设置渲染模式，目前可选 {@link Shader.DRAW_ARRAYS} 至 {@link Shader.DRAW_INSTANCED}
   */
  mode(t) {
    this.renderMode = t;
  }
  /**
   * 获取指定渲染模式的渲染参数
   * @param param 渲染模式
   */
  getDrawParams(t) {
    switch (t) {
      case 0:
        return this.arraysParams;
      case 2:
        return this.arraysInstancedParams;
      case 1:
        return this.elementsParams;
      case 3:
        return this.elementsInstancedParams;
    }
  }
  /**
   * 设置 DRAW_ARRAYS 模式下的渲染参数
   * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/drawArrays
   * @param mode 渲染模式
   * @param first 第一个元素的位置
   * @param count 渲染多少个元素
   */
  paramArrays(t, r, i) {
    this.arraysParams ? (this.arraysParams.mode = t, this.arraysParams.first = r, this.arraysParams.count = i) : this.arraysParams = { mode: t, first: r, count: i };
  }
  /**
   * 设置 DRAW_ARRAYS_INSTANCED 模式下的渲染参数
   * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext/drawArraysInstanced
   * @param mode 渲染模式
   * @param first 第一个元素的位置
   * @param count 渲染多少个元素
   * @param instanceCount 渲染实例数量
   */
  paramArraysInstanced(t, r, i, n) {
    this.arraysInstancedParams ? (this.arraysInstancedParams.mode = t, this.arraysInstancedParams.first = r, this.arraysInstancedParams.count = i, this.arraysInstancedParams.instanceCount = n) : this.arraysInstancedParams = { mode: t, first: r, count: i, instanceCount: n };
  }
  /**
   * 设置 DRAW_ELEMENTS 模式下的渲染参数
   * 参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/drawElements
   * @param mode 渲染模式
   * @param count 渲染元素数量
   * @param type 数据类型
   * @param offset 偏移量
   */
  paramElements(t, r, i, n) {
    this.elementsParams ? (this.elementsParams.mode = t, this.elementsParams.count = r, this.elementsParams.type = i, this.elementsParams.offset = n) : this.elementsParams = { mode: t, count: r, type: i, offset: n };
  }
  /**
   * 设置 DRAW_ELEMENTS 模式下的渲染参数
   * 参考 https://developer.mozilla.org/en-US/docs/Web/API/WebGL2RenderingContext/drawElementsInstanced
   * @param mode 渲染模式
   * @param count 渲染元素数量
   * @param type 数据类型
   * @param offset 偏移量
   * @param instanceCount 渲染实例数量
   */
  paramElementsInstanced(t, r, i, n, o) {
    this.elementsInstancedParams ? (this.elementsInstancedParams.mode = t, this.elementsInstancedParams.count = r, this.elementsInstancedParams.type = i, this.elementsInstancedParams.offset = n, this.elementsInstancedParams.instanceCount = o) : this.elementsInstancedParams = {
      mode: t,
      count: r,
      type: i,
      offset: n,
      instanceCount: o
    };
  }
  /**
   * 切换渲染时使用的顶点索引
   * @param name 要使用的顶点索引名称
   */
  useIndices(t) {
    if (typeof t == "string") {
      const r = this.getIndices(t);
      if (!r) {
        q.warn(30, t);
        return;
      }
      this.usingIndices = r;
    } else
      [...this.indices.values()].includes(t) ? this.usingIndices = t : q.warn(31);
  }
  /**
   * 检查当前是否需要重新编译着色器，如果需要，则重新编译
   * @param force 是否强制重新编译
   */
  requestCompile(t = !1) {
    return !t && !this.shaderDirty ? !1 : this.compile();
  }
  /**
   * 设置顶点着色器内容
   * @param vs 顶点着色器
   */
  vs(t) {
    this.vertex = this.prefix.VERTEX + t, this.shaderDirty = !0, this.modified = !0;
  }
  /**
   * 设置片元着色器内容
   * @param fs 片元着色器
   */
  fs(t) {
    this.fragment = this.prefix.FRAGMENT + t, this.shaderDirty = !0, this.modified = !0;
  }
  /**
   * 当这个程序被卸载时执行的函数
   */
  unload() {
    this.attribArray.forEach((t) => {
      t.disable();
    }), this.emit("load");
  }
  /**
   * 当这个程序被加载（使用）时执行的函数
   */
  load() {
    this.attribArray.forEach((t) => {
      t.enable();
    }), this.emit("unload");
  }
  /**
   * 获取一个uniform，需要事先定义，否则返回null
   * @param uniform uniform名称
   */
  getUniform(t) {
    return this.uniform.get(t) ?? null;
  }
  /**
   * 获取一个attribute，需要事先定义，否则返回null
   * @param attrib attribute名称
   */
  getAttribute(t) {
    return this.attribute.get(t) ?? null;
  }
  /**
   * 获取一个attribute array，需要事先定义，否则返回null
   * @param name attribute array名称
   */
  getAttribArray(t) {
    return this.attribArray.get(t) ?? null;
  }
  /**
   * 获取一个顶点索引数组，需要提前定义，否则返回null
   * @param name 顶点索引数组的名称
   */
  getIndices(t) {
    return this.indices.get(t) ?? null;
  }
  /**
   * 获取一个 uniform matrix，需要事先定义，否则返回null
   * @param matrix uniform matrix 的名称
   */
  getMatrix(t) {
    return this.matrix.get(t) ?? null;
  }
  /**
   * 获取一个 uniform block，例如 UBO，需要事先定义，否则返回null
   * @param block uniform block 的名称
   */
  getUniformBlock(t) {
    return this.block.get(t) ?? null;
  }
  /**
   * 获取一个 texture，需要事先定义，否则返回null
   * @param name texture 的名称
   */
  getTexture(t) {
    return this.texture.get(t) ?? null;
  }
  /**
   * 定义一个 uniform 变量，并存入本着色器程序的 uniform 变量映射
   * @param uniform uniform 变量名
   * @param type uniform 类型，可选 {@link GL2.UNIFORM_1f} 至 {@link GL2.UNIFORM_4uiv}
   * @returns uniform 变量的操作对象，可用于设置其值
   */
  defineUniform(t, r) {
    const i = this.getUniform(t);
    if (i)
      return i.type === r ? i : (q.warn(28, "uniform", t), null);
    const n = this.program, o = this.element.gl;
    if (!n || !o) return null;
    const a = o.getUniformLocation(n, t);
    if (!a) return null;
    const c = new df(r, a, o, this);
    return this.uniform.set(t, c), c;
  }
  /**
   * 定义一个 uniform 矩阵变量，并存入本着色器程序的 uniform 矩阵变量映射
   * @param uniform uniform 矩阵变量名
   * @param type uniform 矩阵类型，可选 {@link GL2.U_MATRIX_2x2} 至 {@link GL2.U_MATRIX_4x4}
   * @returns uniform 矩阵变量的操作对象，可用于设置其值
   */
  defineUniformMatrix(t, r) {
    const i = this.getMatrix(t);
    if (i)
      return i.type === r ? i : (q.warn(28, "uniform matrix", t), null);
    const n = this.program, o = this.element.gl;
    if (!n || !o) return null;
    const a = o.getUniformLocation(n, t);
    if (!a) return null;
    const c = new vf(r, a, o, this);
    return this.matrix.set(t, c), c;
  }
  /**
   * 定义一个 attribute 常量，并存入本着色器程序的 attribute 常量映射，在 es 300 版本中叫做 in
   * @param attrib attribute 常量名
   * @param type attribute 类型，可选 {@link GL2.ATTRIB_1f} 至 {@link GL2.ATTRIB_I4uiv}
   * @returns attribute 常量的操作对象，可用于设置其值
   */
  defineAttribute(t, r) {
    const i = this.getAttribute(t);
    if (i)
      return i.type === r ? i : (q.warn(28, "attribute", t), null);
    const n = this.program, o = this.element.gl;
    if (!n || !o) return null;
    const a = o.getAttribLocation(n, t);
    if (a === -1) return null;
    const c = new pf(r, a, o, this);
    return this.attribute.set(t, c), c;
  }
  /**
   * 定义一个顶点数组
   * @param name 顶点数组名称
   */
  defineAttribArray(t) {
    const r = this.getAttribArray(t);
    if (r) return r;
    const i = this.program, n = this.element.gl;
    if (!i || !n) return null;
    const o = n.createBuffer();
    if (!o) return null;
    const a = n.getAttribLocation(i, t);
    if (a === -1) return null;
    const c = new gf(o, a, n, this);
    return this.attribArray.set(t, c), c;
  }
  /**
   * 定义一个顶点索引数组
   * @param name 顶点索引数组的名称
   */
  defineIndices(t) {
    const r = this.getIndices(t);
    if (r) return r;
    const i = this.program, n = this.element.gl;
    if (!i || !n) return null;
    const o = n.createBuffer();
    if (!o) return null;
    const a = new mf(o, n, this);
    return this.indices.set(t, a), a;
  }
  /**
   * 定义一个 uniform block，例如 UBO，并存入本着色器程序的 uniform block 映射
   * 用于一次性向着色器传输大量数据
   * @param block uniform block 名称
   * @param size 数据量，即数据长度，例如一个vec4就是4个长度
   * @param usage 缓冲区用途，例如 gl.STATIC_DRAW 是指会频繁读取但不会频繁写入
   *              参考 https://developer.mozilla.org/zh-CN/docs/Web/API/WebGLRenderingContext/bufferData
   *              的 `usage` 参数
   * @param binding uniform block 的索引，例如这是你设置的第一个uniform block，就可以填0，第二个填1，以此类推
   * @returns uniform block 的操作对象，可用于设置其值
   */
  defineUniformBlock(t, r, i, n) {
    const o = this.getUniformBlock(t);
    if (o)
      return o.size === r ? o : (q.warn(28, "uniform block", t), null);
    const a = this.program, c = this.element.gl;
    if (!a || !c) return null;
    const l = c.getUniformBlockIndex(a, t);
    if (l === -1) return null;
    const f = c.createBuffer();
    if (!f) return null;
    const h = new Float32Array(r);
    h.fill(0), c.bindBuffer(c.UNIFORM_BUFFER, f), c.bufferData(c.UNIFORM_BUFFER, h, i), c.uniformBlockBinding(a, l, n), c.bindBufferBase(c.UNIFORM_BUFFER, n, f);
    const p = new bf(l, r, f, n, c, this);
    return this.block.set(t, p), p;
  }
  /**
   * 定义一个材质
   * @param name 纹理名称
   * @param index 纹理索引，根据不同浏览器，其最大数量不一定相等，根据标准其数量应该大于等于 8 个，
   *              因此考虑到兼容性，不建议纹理数量超过 8 个。
   * @param w 纹理的宽度
   * @param h 纹理的高度
   * @returns 这个 texture 的操作对象，可以用于设置其内容
   */
  defineTexture(t, r, i, n) {
    const o = this.getTexture(t);
    if (o)
      return o.index === r ? o : (q.warn(28, "texture", t), null);
    if (r > this.element.MAX_TEXTURE_COUNT)
      return q.warn(29), null;
    const a = this.defineUniform(
      t,
      2
      /* Uniform1i */
    );
    if (!a) return null;
    const c = this.program, l = this.element.gl;
    if (!c || !l) return null;
    const f = l.createTexture();
    if (!f) return null;
    const h = new _f(f, r, a, l, this, i, n);
    return this.texture.set(t, h), h;
  }
  /**
   * 摧毁这个着色器程序，不要直接调用，请使用 {@link GL2.deleteProgram} 来删除一个着色器程序
   */
  destroy() {
    this.clearProgram();
  }
  clearProgram() {
    this.gl && (this.uniform.clear(), this.attribute.clear(), this.matrix.clear(), this.gl.deleteProgram(this.program), this.shader && (this.gl.deleteShader(this.shader.vertex), this.gl.deleteShader(this.shader.fragment)), this.block.forEach((t) => {
      this.gl.deleteBuffer(t.buffer);
    }), this.attribArray.forEach((t) => {
      this.gl.deleteBuffer(t.data);
    }), this.texture.forEach((t) => {
      this.gl.deleteTexture(t.texture);
    }), this.indices.forEach((t) => {
      this.gl.deleteBuffer(t.data);
    }), this.texture.clear(), this.indices.clear(), this.attribArray.clear(), this.block.clear());
  }
  compile() {
    this.shaderDirty = !1, this.clearProgram();
    const r = this.element.gl;
    if (!r) return !1;
    const i = r.createProgram();
    if (!i) return !1;
    const n = this.compileShader(r.VERTEX_SHADER, this.vertex), o = this.compileShader(r.FRAGMENT_SHADER, this.fragment);
    return !n || !o ? !1 : (r.attachShader(i, n), r.attachShader(i, o), r.linkProgram(i), r.useProgram(i), this.program = i, this.shader = { vertex: n, fragment: o }, !0);
  }
  compileShader(t, r) {
    const i = this.element.gl, n = i.createShader(t);
    return n ? (i.shaderSource(n, r), i.compileShader(n), i.getShaderParameter(n, i.COMPILE_STATUS) || q.error(
      13,
      t === i.VERTEX_SHADER ? "vertex" : "fragment",
      i.getShaderInfoLog(n) ?? ""
    ), n) : null;
  }
}
const _s = class _s extends br {
  constructor(t) {
    super("static", !1);
    /** 所有连接到此根元素的渲染元素的 id 到元素自身的映射 */
    d(this, "idMap", /* @__PURE__ */ new Map());
    /** 最后一次按下的鼠标按键，用于处理鼠标移动 */
    d(this, "lastMouse", le.None);
    /** 每个触点的信息 */
    d(this, "touchInfo", /* @__PURE__ */ new Map());
    /** 触点列表 */
    d(this, "touchList", /* @__PURE__ */ new Map());
    /** 每个鼠标按键的信息 */
    d(this, "mouseInfo", /* @__PURE__ */ new Map());
    /** 操作的标识符 */
    d(this, "actionIdentifier", 0);
    /** 用于终止 document 上的监听 */
    d(this, "abort");
    /** 根据捕获行为判断光标样式 */
    d(this, "targetCursor", "auto");
    /** 当前鼠标覆盖的元素 */
    d(this, "hoveredElement", /* @__PURE__ */ new Set());
    /** 本次交互前鼠标覆盖的元素 */
    d(this, "beforeHovered", /* @__PURE__ */ new Set());
    d(this, "target");
    d(this, "isRoot", !0);
    const r = this.getMountCanvas(t.canvas);
    if (!r) {
      q.error(19);
      return;
    }
    this.target = new Ss(t.alpha ?? !0, r), this.size(t.width, t.height), this.target.setAntiAliasing(!1), this.setAnchor(0.5, 0.5), _s.list.set(r.id, this);
    const i = () => {
      this.requestRenderFrame(() => {
        this.refresh(), i();
      });
    };
    i(), this.listen(), this.setScale(1);
  }
  /**
   * 设置这个渲染器的缩放比
   * @param scale 缩放比
   */
  setScale(t) {
    this.onResize(t);
  }
  onResize(t) {
    this.target.setScale(t);
    const r = this.target.width * t, i = this.target.height * t;
    this.target.canvas.style.width = `${r}px`, this.target.canvas.style.height = `${i}px`, super.onResize(t);
  }
  getMountCanvas(t) {
    return typeof t == "string" ? document.querySelector(t) : t;
  }
  size(t, r) {
    super.size(t, r), this.target.size(t, r), this.transform.setTranslate(t / 2, r / 2);
  }
  listen() {
    const t = this.target.canvas;
    t.addEventListener("mousedown", (o) => {
      o.preventDefault();
      const a = this.getMouseType(o);
      this.lastMouse = a, this.captureEvent(
        B.Down,
        this.createMouseAction(o, B.Down, a)
      );
    }), t.addEventListener("mouseup", (o) => {
      o.preventDefault();
      const a = this.createMouseAction(o, B.Up);
      this.captureEvent(B.Up, a), this.captureEvent(B.Click, a);
    }), t.addEventListener("mousemove", (o) => {
      o.preventDefault();
      const a = this.createMouseAction(
        o,
        B.Move,
        this.lastMouse
      );
      this.targetCursor = "auto";
      const c = this.beforeHovered;
      c.clear(), this.beforeHovered = this.hoveredElement, this.hoveredElement = c, this.captureEvent(B.Move, a), this.targetCursor !== this.target.canvas.style.cursor && (this.target.canvas.style.cursor = this.targetCursor), this.checkMouseEnterLeave(
        o,
        a,
        this.beforeHovered,
        this.hoveredElement
      );
    }), t.addEventListener("mouseleave", (o) => {
      o.preventDefault();
      const a = this.getMouseIdentifier(
        B.Leave,
        this.getMouseType(o)
      );
      this.hoveredElement.forEach((c) => {
        c.emit("leave", this.createMouseActionBase(o, a, c));
      }), this.hoveredElement.clear(), this.beforeHovered.clear();
    }), document.addEventListener("touchstart", (o) => {
      o.preventDefault(), this.createTouchAction(o, B.Down).forEach((a) => {
        this.captureEvent(B.Down, a);
      });
    }), document.addEventListener("touchend", (o) => {
      o.preventDefault(), this.createTouchAction(o, B.Up).forEach((a) => {
        this.captureEvent(B.Up, a), this.captureEvent(B.Click, a);
      }), [...o.touches].forEach((a) => {
        this.touchInfo.delete(a.identifier);
      });
    }), document.addEventListener("touchcancel", (o) => {
      o.preventDefault(), this.createTouchAction(o, B.Up).forEach((a) => {
        this.captureEvent(B.Up, a);
      }), [...o.touches].forEach((a) => {
        this.touchInfo.delete(a.identifier);
      });
    }), document.addEventListener("touchmove", (o) => {
      o.preventDefault(), this.createTouchAction(o, B.Move).forEach((a) => {
        if (!this.touchInfo.values().some((f) => a.identifier === f.identifier))
          return;
        const l = this.beforeHovered;
        l.clear(), this.beforeHovered = this.hoveredElement, this.hoveredElement = l, this.captureEvent(B.Move, a), this.checkTouchEnterLeave(
          o,
          a,
          this.beforeHovered,
          this.hoveredElement
        );
      });
    }), t.addEventListener("wheel", (o) => {
      o.preventDefault(), this.captureEvent(
        B.Wheel,
        this.createWheelAction(o, B.Wheel)
      );
    });
    const r = new AbortController(), i = r.signal;
    this.abort = r;
    const n = (o) => {
      const a = this.getMouseButtons(o);
      for (const c of this.mouseInfo.keys())
        a & c || this.mouseInfo.delete(c);
    };
    document.addEventListener("click", n, { signal: i }), document.addEventListener("mouseenter", n, { signal: i }), document.addEventListener("mouseleave", n, { signal: i });
  }
  isTouchInCanvas(t, r) {
    const i = this.target.canvas.getBoundingClientRect(), { left: n, right: o, top: a, bottom: c } = i, l = t, f = r;
    return l >= n && l <= o && f >= a && f <= c;
  }
  getMouseType(t) {
    switch (t.button) {
      case 0:
        return le.Left;
      case 1:
        return le.Middle;
      case 2:
        return le.Right;
      case 3:
        return le.Back;
      case 4:
        return le.Forward;
    }
    return le.None;
  }
  getActiveMouseIdentifier(t) {
    if (this.lastMouse === le.None)
      return -1;
    {
      const r = this.mouseInfo.get(t);
      return r ? r.identifier : -1;
    }
  }
  getMouseIdentifier(t, r) {
    switch (t) {
      case B.Down: {
        const i = this.actionIdentifier++;
        return this.mouseInfo.set(r, { identifier: i }), i;
      }
      case B.Move:
      case B.Enter:
      case B.Leave:
      case B.Wheel:
        return this.getActiveMouseIdentifier(r);
      case B.Up:
      case B.Click: {
        const i = this.getActiveMouseIdentifier(r);
        return this.mouseInfo.delete(r), i;
      }
    }
  }
  getMouseButtons(t) {
    if (t.buttons === 0) return le.None;
    let r = 0;
    return t.buttons & 1 && (r |= le.Left), t.buttons & 2 && (r |= le.Right), t.buttons & 4 && (r |= le.Middle), t.buttons & 8 && (r |= le.Back), t.buttons & 16 && (r |= le.Forward), r;
  }
  createMouseActionBase(t, r, i = this, n = this.getMouseType(t)) {
    return {
      identifier: r,
      target: i,
      touch: !1,
      type: n,
      buttons: this.getMouseButtons(t),
      altKey: t.altKey,
      ctrlKey: t.ctrlKey,
      shiftKey: t.shiftKey,
      metaKey: t.metaKey
    };
  }
  createTouchActionBase(t, r, i) {
    return {
      identifier: r,
      target: i,
      touch: !1,
      type: le.Left,
      buttons: le.Left,
      altKey: t.altKey,
      ctrlKey: t.ctrlKey,
      shiftKey: t.shiftKey,
      metaKey: t.metaKey
    };
  }
  createMouseAction(t, r, i = this.getMouseType(t)) {
    const n = this.getMouseIdentifier(r, i), o = t.offsetX / this.scale, a = t.offsetY / this.scale;
    return {
      target: this,
      identifier: n,
      touch: !1,
      offsetX: o,
      offsetY: a,
      absoluteX: o,
      absoluteY: a,
      type: i,
      buttons: this.getMouseButtons(t),
      altKey: t.altKey,
      ctrlKey: t.ctrlKey,
      shiftKey: t.shiftKey,
      metaKey: t.metaKey,
      stopPropagation: () => {
        this.propagationStoped.set(r, !0);
      }
    };
  }
  createWheelAction(t, r, i = this.getMouseType(t)) {
    const n = this.createMouseAction(t, r, i);
    switch (n.wheelX = t.deltaX, n.wheelY = t.deltaY, n.wheelZ = t.deltaZ, t.deltaMode) {
      case 0:
        n.wheelType = ns.Pixel;
        break;
      case 1:
        n.wheelType = ns.Line;
        break;
      case 2:
        n.wheelType = ns.Page;
        break;
      default:
        n.wheelType = ns.None;
        break;
    }
    return n;
  }
  getTouchIdentifier(t, r) {
    if (r === B.Down) {
      const n = this.actionIdentifier++;
      return this.touchInfo.set(t.identifier, {
        identifier: n,
        clientX: t.clientX,
        clientY: t.clientY,
        hovered: this.isTouchInCanvas(t.clientX, t.clientY)
      }), n;
    }
    const i = this.touchInfo.get(t.identifier);
    return i ? i.identifier : -1;
  }
  createTouch(t, r, i, n) {
    const o = (t.clientX - n.left) / this.scale, a = (t.clientY - n.top) / this.scale;
    return {
      target: this,
      identifier: this.getTouchIdentifier(t, r),
      touch: !0,
      offsetX: o,
      offsetY: a,
      absoluteX: o,
      absoluteY: a,
      type: le.Left,
      buttons: le.Left,
      altKey: i.altKey,
      ctrlKey: i.ctrlKey,
      shiftKey: i.shiftKey,
      metaKey: i.metaKey,
      stopPropagation: () => {
        this.propagationStoped.set(r, !0);
      }
    };
  }
  createTouchAction(t, r) {
    const i = [], n = this.target.canvas.getBoundingClientRect();
    if (r === B.Up) {
      const o = Array.from(t.touches).map((a) => a.identifier);
      for (const [a, c] of this.touchList)
        if (!o.includes(a) && this.isTouchInCanvas(c.clientX, c.clientY)) {
          const l = this.createTouch(c, r, t, n);
          i.push(l);
        }
    } else
      Array.from(t.touches).forEach((o) => {
        const a = this.createTouch(o, r, t, n);
        if (r === B.Move) {
          const c = this.touchInfo.get(o.identifier);
          if (!c) return;
          const l = c.clientX - o.clientX, f = c.clientY - o.clientY;
          (l !== 0 || f !== 0) && i.push(a);
        } else r === B.Down && (this.touchList.set(o.identifier, o), this.isTouchInCanvas(o.clientX, o.clientY) && i.push(a));
      });
    return i;
  }
  checkMouseEnterLeave(t, r, i, n) {
    i.forEach((o) => {
      n.has(o) || o.emit(
        "leave",
        this.createMouseActionBase(t, r.identifier, o)
      );
    }), n.forEach((o) => {
      i.has(o) || o.emit(
        "enter",
        this.createMouseActionBase(t, r.identifier, o)
      );
    });
  }
  checkTouchEnterLeave(t, r, i, n) {
    i.forEach((o) => {
      n.has(o) || o.emit(
        "leave",
        this.createTouchActionBase(t, r.identifier, o)
      );
    }), n.forEach((o) => {
      i.has(o) || o.emit(
        "enter",
        this.createTouchActionBase(t, r.identifier, o)
      );
    });
  }
  update(t = this) {
    this.cacheDirty = !0;
  }
  refresh() {
    this.cacheDirty && (this.target.clear(), this.renderContent(this.target, Nt.identity));
  }
  /**
   * 根据渲染元素的id获取一个渲染元素
   * @param id 要获取的渲染元素id
   * @returns
   */
  getElementById(t) {
    if (t.length === 0) return null;
    const r = this.idMap.get(t);
    if (r) return r;
    {
      const i = this.searchElement(this, t);
      return i && this.idMap.set(t, i), i;
    }
  }
  searchElement(t, r) {
    for (const i of t.children) {
      if (i.id === r) return i;
      {
        const n = this.searchElement(i, r);
        if (n) return n;
      }
    }
    return null;
  }
  connect(t) {
    if (t.id.length === 0) return;
    const r = this.idMap.get(t.id);
    if (r) {
      if (r === t) return;
      q.warn(23, t.id);
    } else
      this.idMap.set(t.id, t);
  }
  disconnect(t) {
    this.idMap.delete(t.id);
  }
  modifyId(t, r, i) {
    this.idMap.delete(r), i.length !== 0 && (this.idMap.has(t.id) ? q.warn(23, t.id) : this.idMap.set(t.id, t));
  }
  getCanvas() {
    return this.target.canvas;
  }
  hoverElement(t) {
    t.cursor !== "inherit" && (this.targetCursor = t.cursor), this.hoveredElement.add(t);
  }
  destroy() {
    var t;
    super.destroy(), _s.list.delete(this.id), (t = this.abort) == null || t.abort();
  }
  toTagString(t, r, i) {
    if (t.isComment) return "";
    const n = t.constructor.name;
    return t.children.size === 0 ? `${" ".repeat(i * r)}<${n} ${t.id ? `id="${t.id}" ` : ""}uid="${t.uid}"${t.hidden ? " hidden" : ""} />
` : `${" ".repeat(i * r)}<${n} ${t.id ? `${t.id} ` : ""}uid="${t.uid}" ${t.hidden ? "hidden" : ""}>
${[...t.children].filter((o) => !o.isComment).map((o) => this.toTagString(o, r, i + 1)).join("")}${" ".repeat(i * r)}</${n}>
`;
  }
  /**
   * 调试功能，将渲染树输出为 XML 标签形式，只包含渲染元素类名，以及元素 id 等基础属性，不包含属性值等
   * @param space 缩进空格数
   */
  toTagTree(t = 4) {
    return "";
  }
  static get(t) {
    return this.list.get(t);
  }
};
d(_s, "list", /* @__PURE__ */ new Map());
let xs = _s;
window.addEventListener("resize", () => {
  xs.list.forEach(
    (e) => e.requestAfterFrame(() => e.refreshAllChildren())
  );
});
window.logTagTree = () => {
  var e;
  console.log((e = xs.get("render-main")) == null ? void 0 : e.toTagTree());
};
const Ef = {
  VERTEX: (
    /* glsl */
    `#version 300 es
precision highp float;

in vec4 a_position;
in vec2 a_texCoord;

out vec2 v_texCoord;
`
  ),
  FRAGMENT: (
    /* glsl */
    `#version 300 es
precision highp float;

in vec2 v_texCoord;

uniform sampler2D u_sampler;
`
  )
}, wf = (
  /* glsl */
  `
void main() {
    v_texCoord = a_texCoord;
    gl_Position = a_position;
}
`
), xf = (
  /* glsl */
  `
out vec4 color;

void main() {
    color = texture(u_sampler, v_texCoord);
}
`
);
class An extends ti {
  drawScene(s, t, r) {
    if (!r.modified) return;
    const i = r.getTexture("u_sampler");
    if (!i) return;
    const n = s.canvas;
    i.width === n.width && i.height === n.height ? i.sub(n, 0, 0, n.width, n.height) : i.set(n), this.draw(t, r);
  }
}
class bp extends yf {
  constructor(t, r, i) {
    super(t, r, i);
    d(this, "prefix", Ef);
    r || this.vs(wf), i || this.fs(xf), !r && !i && (this.modified = !1);
  }
  ready() {
    return this.useIndices("defaultIndices"), !0;
  }
  compile() {
    if (!super.compile()) return !1;
    const i = this.element.gl;
    if (!i) return !1;
    const n = this.defineAttribArray("a_texCoord"), o = this.defineAttribArray("a_position"), a = this.defineTexture("u_sampler", 0), c = this.defineIndices("defaultIndices");
    return !n || !o || !a || !c || (o.buffer(
      new Float32Array([1, -1, -1, -1, 1, 1, -1, 1]),
      i.STATIC_DRAW
    ), o.pointer(2, i.FLOAT, !1, 0, 0), o.enable(), n.buffer(new Float32Array([1, 1, 0, 1, 1, 0, 0, 0]), i.STATIC_DRAW), n.pointer(2, i.FLOAT, !1, 0, 0), n.enable(), c.buffer(new Uint16Array([0, 1, 2, 2, 3, 1]), i.STATIC_DRAW), this.useIndices(c), this.mode(this.element.DRAW_ELEMENTS), this.paramElements(i.TRIANGLES, 6, i.UNSIGNED_SHORT, 0)), !0;
  }
}
class Nf extends Ue {
  /**
   * 创建一个精灵，可以自由在上面渲染内容
   * @param type 渲染模式，absolute表示绝对位置，不会跟随自身的Transform改变
   * @param cache 是否启用缓存机制
   */
  constructor(t = "static", r = !0, i = !1) {
    super(t, r, i);
    d(this, "renderFn");
    this.type = t, this.renderFn = () => {
    };
  }
  render(t, r) {
    this.renderFn(t, r);
  }
  setRenderFn(t) {
    this.renderFn = t, this.update(this);
  }
  handleProps(t, r, i) {
    switch (t) {
      case "render":
        return this.assertType(i, "function", t) ? (this.setRenderFn(i), !0) : !1;
    }
    return !1;
  }
}
var Tf = /* @__PURE__ */ ((e) => (e[e.Fill = 0] = "Fill", e[e.Stroke = 1] = "Stroke", e[e.FillAndStroke = 2] = "FillAndStroke", e[e.StrokeAndFill = 3] = "StrokeAndFill", e))(Tf || {});
class mt extends Ue {
  constructor() {
    super(...arguments);
    d(this, "mode", 0);
    d(this, "fill", "#ddd");
    d(this, "stroke", "#ddd");
    d(this, "lineWidth", 2);
    d(this, "lineDash", []);
    d(this, "lineDashOffset", 0);
    d(this, "lineJoin", "bevel");
    d(this, "lineCap", "butt");
    d(this, "miterLimit", 10);
    d(this, "fillRule", "nonzero");
    d(this, "enableCache", !1);
    d(this, "propFill", !0);
    d(this, "propStroke", !1);
    d(this, "strokeAndFill", !1);
    d(this, "propFillSet", !1);
    d(this, "actionStroke", !1);
    d(this, "cachePath");
    d(this, "pathDirty", !0);
  }
  render(t, r) {
    const i = t.ctx;
    this.setCanvasState(t), this.pathDirty && (this.cachePath = this.getPath(), this.pathDirty = !1);
    const n = this.cachePath;
    if (n)
      switch (this.mode) {
        case 0:
          i.fill(n, this.fillRule);
          break;
        case 1:
          i.stroke(n);
          break;
        case 2:
          i.fill(n, this.fillRule), i.stroke(n);
          break;
        case 3:
          i.stroke(n), i.fill(n, this.fillRule);
          break;
      }
  }
  isActionInElement(t, r) {
    const i = this.cache.ctx;
    this.pathDirty && (this.cachePath = this.getPath(), this.pathDirty = !1);
    const n = this.cachePath;
    if (!n) return !1;
    const o = t * devicePixelRatio, a = r * devicePixelRatio;
    if (i.lineWidth = this.lineWidth, i.lineCap = this.lineCap, i.lineJoin = this.lineJoin, i.setLineDash(this.lineDash), this.actionStroke)
      return i.isPointInStroke(n, o, a);
    switch (this.mode) {
      case 0:
        return i.isPointInPath(n, o, a, this.fillRule);
      case 1:
      case 2:
      case 3:
        return i.isPointInPath(n, o, a, this.fillRule) || i.isPointInStroke(n, o, a);
    }
  }
  /**
   * 设置描边绘制的信息
   * @param options 线的信息
   */
  setLineOption(t) {
    ne(t.lineWidth) || (this.lineWidth = t.lineWidth), ne(t.lineDash) || (this.lineDash = t.lineDash), ne(t.lineDashOffset) || (this.lineDashOffset = t.lineDashOffset), ne(t.lineJoin) || (this.lineJoin = t.lineJoin), ne(t.lineCap) || (this.lineCap = t.lineCap), ne(t.miterLimit) || (this.miterLimit = t.miterLimit), this.update();
  }
  /**
   * 设置填充样式
   * @param style 绘制样式
   */
  setFillStyle(t) {
    this.fill = t, this.update();
  }
  /**
   * 设置描边样式
   * @param style 绘制样式
   */
  setStrokeStyle(t) {
    this.stroke = t, this.update();
  }
  /**
   * 设置填充原则
   * @param rule 填充原则
   */
  setFillRule(t) {
    this.fillRule = t, this.update();
  }
  /**
   * 设置绘制模式，是描边还是填充
   * @param mode 绘制模式
   */
  setMode(t) {
    this.mode = t, this.update();
  }
  /**
   * 检查渲染模式，参考 {@link GraphicPropsBase} 中的 fill stroke strokeAndFill 属性
   */
  checkMode(t, r) {
    switch (t) {
      case 0:
        this.propFill = r, this.propFillSet = !0;
        break;
      case 1:
        this.propStroke = r;
        break;
      case 2:
        this.strokeAndFill = r;
        break;
    }
    this.strokeAndFill ? this.mode = 3 : this.propFillSet ? this.propFill && this.propStroke ? this.mode = 2 : this.propFill ? this.mode = 0 : this.propStroke ? this.mode = 1 : this.mode = 0 : this.propStroke ? this.mode = 1 : this.mode = 0, this.update();
  }
  /**
   * 设置画布的渲染状态，在实际渲染前调用
   * @param canvas 要设置的画布
   */
  setCanvasState(t) {
    const r = t.ctx;
    r.fillStyle = this.fill, r.strokeStyle = this.stroke, r.lineWidth = this.lineWidth, r.setLineDash(this.lineDash), r.lineDashOffset = this.lineDashOffset, r.lineJoin = this.lineJoin, r.lineCap = this.lineCap, r.miterLimit = this.miterLimit;
  }
  handleProps(t, r, i) {
    switch (t) {
      case "fill":
        return this.assertType(i, "boolean", t) ? (this.checkMode(0, i), !0) : !1;
      case "stroke":
        return this.assertType(i, "boolean", t) ? (this.checkMode(1, i), !0) : !1;
      case "strokeAndFill":
        return this.assertType(i, "boolean", t) ? (this.checkMode(2, i), !0) : !1;
      case "fillRule":
        return this.assertType(i, "string", t) ? (this.setFillRule(i), !0) : !1;
      case "fillStyle":
        return this.setFillStyle(i), !0;
      case "strokeStyle":
        return this.setStrokeStyle(i), !0;
      case "lineWidth":
        return this.assertType(i, "number", t) ? (this.lineWidth = i, this.update(), !0) : !1;
      case "lineDash":
        return this.assertType(i, Array, t) ? (this.lineDash = i, this.update(), !0) : !1;
      case "lineDashOffset":
        return this.assertType(i, "number", t) ? (this.lineDashOffset = i, this.update(), !0) : !1;
      case "lineJoin":
        return this.assertType(i, "string", t) ? (this.lineJoin = i, this.update(), !0) : !1;
      case "lineCap":
        return this.assertType(i, "string", t) ? (this.lineCap = i, this.update(), !0) : !1;
      case "miterLimit":
        return this.assertType(i, "number", t) ? (this.miterLimit = i, this.update(), !0) : !1;
      case "actionStroke":
        return this.assertType(i, "boolean", t) ? (this.actionStroke = i, !0) : !1;
    }
    return !1;
  }
}
class Of extends mt {
  pos(s, t) {
    super.pos(s, t), this.pathDirty = !0;
  }
  size(s, t) {
    super.size(s, t), this.pathDirty = !0;
  }
  getPath() {
    const s = new Path2D();
    return s.rect(0, 0, this.width, this.height), s;
  }
}
class Af extends mt {
  constructor() {
    super(...arguments);
    d(this, "radius", 10);
    d(this, "start", 0);
    d(this, "end", Math.PI * 2);
    d(this, "anchorX", 0.5);
    d(this, "anchorY", 0.5);
  }
  getPath() {
    const t = new Path2D();
    return t.arc(this.radius, this.radius, this.radius, this.start, this.end), t;
  }
  /**
   * 设置圆的半径
   * @param radius 半径
   */
  setRadius(t) {
    this.radius = t, this.size(t * 2, t * 2), this.pathDirty = !0, this.update();
  }
  /**
   * 设置圆的起始与终止角度
   * @param start 起始角度
   * @param end 终止角度
   */
  setAngle(t, r) {
    this.start = t, this.end = r, this.pathDirty = !0, this.update();
  }
  handleProps(t, r, i) {
    switch (t) {
      case "radius":
        return this.assertType(i, "number", t) ? (this.setRadius(i), !0) : !1;
      case "start":
        return this.assertType(i, "number", t) ? (this.setAngle(i, this.end), !0) : !1;
      case "end":
        return this.assertType(i, "number", t) ? (this.setAngle(this.start, i), !0) : !1;
      case "circle": {
        if (ut(i, r)) return !0;
        const n = i;
        if (!this.assertType(n, Array, t)) return !1;
        const [o, a, c, l, f] = n;
        return !ne(o) && !ne(a) && this.pos(o, a), ne(c) || this.setRadius(c), !ne(l) && !ne(f) && this.setAngle(l, f), !0;
      }
    }
    return super.handleProps(t, r, i);
  }
}
class Sf extends mt {
  constructor() {
    super(...arguments);
    d(this, "radiusX", 10);
    d(this, "radiusY", 10);
    d(this, "start", 0);
    d(this, "end", Math.PI * 2);
    d(this, "anchorX", 0.5);
    d(this, "anchorY", 0.5);
  }
  getPath() {
    const t = new Path2D();
    return t.ellipse(
      this.radiusX,
      this.radiusY,
      this.radiusX,
      this.radiusY,
      0,
      this.start,
      this.end
    ), t;
  }
  /**
   * 设置椭圆的横纵轴长度
   * @param x 横轴长度
   * @param y 纵轴长度
   */
  setRadius(t, r) {
    this.radiusX = t, this.radiusY = r, this.size(t, r), this.pathDirty = !0, this.update();
  }
  /**
   * 设置椭圆的起始与终止角度
   * @param start 起始角度
   * @param end 终止角度
   */
  setAngle(t, r) {
    this.start = t, this.end = r, this.pathDirty = !0, this.update();
  }
  handleProps(t, r, i) {
    switch (t) {
      case "radiusX":
        return this.assertType(i, "number", t) ? (this.setRadius(i, this.radiusY), !0) : !1;
      case "radiusY":
        return this.assertType(i, "number", t) ? (this.setRadius(this.radiusY, i), !0) : !1;
      case "start":
        return this.assertType(i, "number", t) ? (this.setAngle(i, this.end), !0) : !1;
      case "end":
        return this.assertType(i, "number", t) ? (this.setAngle(this.start, i), !0) : !1;
      case "ellipse": {
        if (ut(i, r)) return !0;
        const n = i;
        if (!this.assertType(n, Array, t)) return !1;
        const [o, a, c, l, f, h] = n;
        return !ne(o) && !ne(a) && this.pos(o, a), !ne(c) && !ne(l) && this.setRadius(c, l), !ne(f) && !ne(h) && this.setAngle(f, h), !0;
      }
    }
    return super.handleProps(t, r, i);
  }
}
class Df extends mt {
  constructor() {
    super(...arguments);
    d(this, "x1", 0);
    d(this, "y1", 0);
    d(this, "x2", 0);
    d(this, "y2", 0);
    d(this, "mode", 1);
  }
  getPath() {
    const t = new Path2D(), r = this.x, i = this.y;
    return t.moveTo(this.x1 - r, this.y1 - i), t.lineTo(this.x2 - r, this.y2 - i), t;
  }
  /**
   * 设置第一个点的横纵坐标
   */
  setPoint1(t, r) {
    this.x1 = t, this.y1 = r, this.fitRect(), this.update();
  }
  /**
   * 设置第二个点的横纵坐标
   */
  setPoint2(t, r) {
    this.x2 = t, this.y2 = r, this.fitRect(), this.update();
  }
  fitRect() {
    const t = Math.min(this.x1, this.x2), r = Math.min(this.y1, this.y2), i = Math.max(this.x1, this.x2), n = Math.max(this.y1, this.y2);
    this.pos(t, r), this.size(i - t, n - r), this.pathDirty = !0;
  }
  handleProps(t, r, i) {
    switch (t) {
      case "x1":
        return this.assertType(i, "number", t) ? (this.setPoint1(i, this.y1), !0) : !1;
      case "y1":
        return this.assertType(i, "number", t) ? (this.setPoint1(this.x1, i), !0) : !1;
      case "x2":
        return this.assertType(i, "number", t) ? (this.setPoint2(i, this.y2), !0) : !1;
      case "y2":
        return this.assertType(i, "number", t) ? (this.setPoint2(this.x2, i), !0) : !1;
      case "line":
        return ut(i, r) ? !0 : this.assertType(i, Array, t) ? (this.setPoint1(i[0], i[1]), this.setPoint2(i[2], i[3]), !0) : !1;
    }
    return super.handleProps(t, r, i);
  }
}
class Rf extends mt {
  constructor() {
    super(...arguments);
    d(this, "sx", 0);
    d(this, "sy", 0);
    d(this, "cp1x", 0);
    d(this, "cp1y", 0);
    d(this, "cp2x", 0);
    d(this, "cp2y", 0);
    d(this, "ex", 0);
    d(this, "ey", 0);
    d(this, "mode", 1);
  }
  getPath() {
    const t = new Path2D(), r = this.x, i = this.y;
    return t.moveTo(this.sx - r, this.sy - i), t.bezierCurveTo(
      this.cp1x - r,
      this.cp1y - i,
      this.cp2x - r,
      this.cp2y - i,
      this.ex - r,
      this.ey - i
    ), t;
  }
  /**
   * 设置起始点坐标
   */
  setStart(t, r) {
    this.sx = t, this.sy = r, this.fitRect(), this.update();
  }
  /**
   * 设置控制点1坐标
   */
  setControl1(t, r) {
    this.cp1x = t, this.cp1y = r, this.fitRect(), this.update();
  }
  /**
   * 设置控制点2坐标
   */
  setControl2(t, r) {
    this.cp2x = t, this.cp2y = r, this.fitRect(), this.update();
  }
  /**
   * 设置终点坐标
   */
  setEnd(t, r) {
    this.ex = t, this.ey = r, this.fitRect(), this.update();
  }
  isActionInElement(t, r) {
    return t >= 0 && t < this.width && r >= 0 && r < this.height;
  }
  fitRect() {
    const t = Math.min(this.sx, this.cp1x, this.cp2x, this.ex), r = Math.min(this.sy, this.cp1y, this.cp2y, this.ey), i = Math.max(this.sx, this.cp1x, this.cp2x, this.ex), n = Math.max(this.sy, this.cp1y, this.cp2y, this.ey);
    this.pos(t, r), this.size(i - t, n - r), this.pathDirty = !0;
  }
  handleProps(t, r, i) {
    switch (t) {
      case "sx":
        return this.assertType(i, "number", t) ? (this.setStart(i, this.sy), !0) : !1;
      case "sy":
        return this.assertType(i, "number", t) ? (this.setStart(this.sx, i), !0) : !1;
      case "cp1x":
        return this.assertType(i, "number", t) ? (this.setControl1(i, this.cp1y), !0) : !1;
      case "cp1y":
        return this.assertType(i, "number", t) ? (this.setControl1(this.cp1x, i), !0) : !1;
      case "cp2x":
        return this.assertType(i, "number", t) ? (this.setControl2(i, this.cp2y), !0) : !1;
      case "cp2y":
        return this.assertType(i, "number", t) ? (this.setControl2(this.cp2x, i), !0) : !1;
      case "ex":
        return this.assertType(i, "number", t) ? (this.setEnd(i, this.ey), !0) : !1;
      case "ey":
        return this.assertType(i, "number", t) ? (this.setEnd(this.ex, i), !0) : !1;
      case "curve":
        return ut(i, r) ? !0 : this.assertType(i, Array, t) ? (this.setStart(i[0], i[1]), this.setControl1(i[2], i[3]), this.setControl2(i[4], i[5]), this.setEnd(i[6], i[7]), !0) : !1;
    }
    return super.handleProps(t, r, i);
  }
}
class Cf extends mt {
  constructor() {
    super(...arguments);
    d(this, "sx", 0);
    d(this, "sy", 0);
    d(this, "cpx", 0);
    d(this, "cpy", 0);
    d(this, "ex", 0);
    d(this, "ey", 0);
    d(this, "mode", 1);
  }
  getPath() {
    const t = new Path2D(), r = this.x, i = this.y;
    return t.moveTo(this.sx - r, this.sy - i), t.quadraticCurveTo(
      this.cpx - r,
      this.cpy - i,
      this.ex - r,
      this.ey - i
    ), t;
  }
  render(t, r) {
    const i = t.ctx;
    this.setCanvasState(t), i.beginPath(), i.moveTo(this.sx, this.sy), i.quadraticCurveTo(this.cpx, this.cpy, this.ex, this.ey), i.stroke();
  }
  /**
   * 设置起始点坐标
   */
  setStart(t, r) {
    this.sx = t, this.sy = r, this.fitRect(), this.update();
  }
  /**
   * 设置控制点坐标
   */
  setControl(t, r) {
    this.cpx = t, this.cpy = r, this.fitRect(), this.update();
  }
  /**
   * 设置终点坐标
   */
  setEnd(t, r) {
    this.ex = t, this.ey = r, this.fitRect(), this.update();
  }
  fitRect() {
    const t = Math.min(this.sx, this.cpx, this.ex), r = Math.min(this.sy, this.cpy, this.ey), i = Math.max(this.sx, this.cpx, this.ex), n = Math.max(this.sy, this.cpy, this.ey);
    this.pos(t, r), this.size(i - t, n - r), this.pathDirty = !0;
  }
  isActionInElement(t, r) {
    return t >= 0 && t < this.width && r >= 0 && r < this.height;
  }
  handleProps(t, r, i) {
    switch (t) {
      case "sx":
        return this.assertType(i, "number", t) ? (this.setStart(i, this.sy), !0) : !1;
      case "sy":
        return this.assertType(i, "number", t) ? (this.setStart(this.sx, i), !0) : !1;
      case "cpx":
        return this.assertType(i, "number", t) ? (this.setControl(i, this.cpy), !0) : !1;
      case "cpy":
        return this.assertType(i, "number", t) ? (this.setControl(this.cpx, i), !0) : !1;
      case "ex":
        return this.assertType(i, "number", t) ? (this.setEnd(i, this.ey), !0) : !1;
      case "ey":
        return this.assertType(i, "number", t) ? (this.setEnd(this.ex, i), !0) : !1;
      case "curve":
        return ut(i, r) ? !0 : this.assertType(i, Array, t) ? (this.setStart(i[0], i[1]), this.setControl(i[2], i[3]), this.setEnd(i[4], i[5]), !0) : !1;
    }
    return super.handleProps(t, r, i);
  }
}
class If extends mt {
  constructor() {
    super(...arguments);
    /** 路径 */
    d(this, "path", new Path2D());
  }
  /**
   * 获取当前路径
   */
  getPath() {
    return this.path;
  }
  /**
   * 为路径添加路径
   * @param path 要添加的路径
   */
  addPath(t) {
    this.path.addPath(t), this.pathDirty = !0, this.update();
  }
  isActionInElement(t, r) {
    return t >= 0 && t < this.width && r >= 0 && r < this.height;
  }
  handleProps(t, r, i) {
    switch (t) {
      case "path":
        return this.assertType(i, Path2D, t) ? (this.path = i, this.pathDirty = !0, this.update(), !0) : !1;
    }
    return super.handleProps(t, r, i);
  }
}
var Pf = /* @__PURE__ */ ((e) => (e[e.TopLeft = 0] = "TopLeft", e[e.TopRight = 1] = "TopRight", e[e.BottomRight = 2] = "BottomRight", e[e.BottomLeft = 3] = "BottomLeft", e))(Pf || {});
class Mf extends mt {
  constructor() {
    super(...arguments);
    /** 圆角属性，四元素数组，每个元素是一个二元素数组，表示这个角的半径，顺序为 左上，右上，右下，左下 */
    d(this, "corner", [
      [0, 0],
      [0, 0],
      [0, 0],
      [0, 0]
    ]);
  }
  getPath() {
    const t = new Path2D(), { width: r, height: i } = this, [[n, o], [a, c], [l, f], [h, p]] = this.corner;
    return t.moveTo(n, 0), t.lineTo(r - a, 0), t.ellipse(r - a, c, a, c, 0, -Math.PI / 2, 0), t.lineTo(r, i - f), t.ellipse(r - l, i - f, l, f, 0, 0, Math.PI / 2), t.lineTo(h, i), t.ellipse(h, i - p, h, p, 0, Math.PI / 2, Math.PI), t.lineTo(0, o), t.ellipse(n, o, n, o, 0, Math.PI, -Math.PI / 2), t.closePath(), t;
  }
  /**
   * 设置圆角半径
   * @param x 横向半径
   * @param y 纵向半径
   */
  setRadius(t, r, i) {
    const n = this.width / 2, o = this.height / 2;
    this.corner[i] = [nn(t, 0, n), nn(r, 0, o)], this.pathDirty = !0, this.update();
  }
  /**
   * 设置圆形圆角参数
   * @param circle 圆形圆角参数
   */
  setCircle(t) {
    const [r, i = 0, n = 0, o = 0] = t;
    switch (t.length) {
      case 1: {
        this.setRadius(
          r,
          r,
          3
          /* BottomLeft */
        ), this.setRadius(
          r,
          r,
          2
          /* BottomRight */
        ), this.setRadius(
          r,
          r,
          0
          /* TopLeft */
        ), this.setRadius(
          r,
          r,
          1
          /* TopRight */
        );
        break;
      }
      case 2: {
        this.setRadius(
          r,
          r,
          0
          /* TopLeft */
        ), this.setRadius(
          r,
          r,
          2
          /* BottomRight */
        ), this.setRadius(
          i,
          i,
          3
          /* BottomLeft */
        ), this.setRadius(
          i,
          i,
          1
          /* TopRight */
        );
        break;
      }
      case 3: {
        this.setRadius(
          r,
          r,
          0
          /* TopLeft */
        ), this.setRadius(
          i,
          i,
          1
          /* TopRight */
        ), this.setRadius(
          i,
          i,
          3
          /* BottomLeft */
        ), this.setRadius(
          n,
          n,
          2
          /* BottomRight */
        );
        break;
      }
      case 4: {
        this.setRadius(
          r,
          r,
          0
          /* TopLeft */
        ), this.setRadius(
          i,
          i,
          1
          /* TopRight */
        ), this.setRadius(
          n,
          n,
          2
          /* BottomRight */
        ), this.setRadius(
          o,
          o,
          3
          /* BottomLeft */
        );
        break;
      }
    }
  }
  /**
   * 设置椭圆圆角参数
   * @param ellipse 椭圆圆角参数
   */
  setEllipse(t) {
    const [r, i, n = 0, o = 0, a = 0, c = 0, l = 0, f = 0] = t;
    switch (t.length) {
      case 2: {
        this.setRadius(
          r,
          i,
          3
          /* BottomLeft */
        ), this.setRadius(
          r,
          i,
          2
          /* BottomRight */
        ), this.setRadius(
          r,
          i,
          0
          /* TopLeft */
        ), this.setRadius(
          r,
          i,
          1
          /* TopRight */
        );
        break;
      }
      case 4: {
        this.setRadius(
          r,
          i,
          0
          /* TopLeft */
        ), this.setRadius(
          r,
          i,
          2
          /* BottomRight */
        ), this.setRadius(
          n,
          o,
          3
          /* BottomLeft */
        ), this.setRadius(
          n,
          o,
          1
          /* TopRight */
        );
        break;
      }
      case 6: {
        this.setRadius(
          r,
          i,
          0
          /* TopLeft */
        ), this.setRadius(
          n,
          o,
          1
          /* TopRight */
        ), this.setRadius(
          n,
          o,
          3
          /* BottomLeft */
        ), this.setRadius(
          a,
          c,
          2
          /* BottomRight */
        );
        break;
      }
      case 8: {
        this.setRadius(
          r,
          i,
          0
          /* TopLeft */
        ), this.setRadius(
          n,
          o,
          1
          /* TopRight */
        ), this.setRadius(
          a,
          c,
          2
          /* BottomRight */
        ), this.setRadius(
          l,
          f,
          3
          /* BottomLeft */
        );
        break;
      }
      default:
        q.warn(58, t.length.toString());
    }
  }
  handleProps(t, r, i) {
    switch (t) {
      case "circle": {
        const n = i;
        return this.assertType(n, Array, t) ? (this.setCircle(n), !0) : !1;
      }
      case "ellipse": {
        const n = i;
        return this.assertType(n, Array, t) ? (this.setEllipse(n), !0) : !1;
      }
    }
    return super.handleProps(t, r, i);
  }
}
var $f = /* @__PURE__ */ ((e) => (e[e.Light = 300] = "Light", e[e.Normal = 400] = "Normal", e[e.Bold = 700] = "Bold", e))($f || {});
const ve = class ve {
  constructor(s = ve.defaultFamily, t = ve.defaultSize, r = ve.defaultSizeUnit, i = ve.defaultWeight, n = ve.defaultItalic) {
    d(this, "fallbacks", []);
    d(this, "fontString", "");
    this.family = s, this.size = t, this.sizeUnit = r, this.weight = i, this.italic = n, this.fontString = this.getFont();
  }
  /**
   * 添加后备字体，若当前字体不可用，那么会使用后备字体，后备字体也可以添加后备字体，但是请避免递归添加
   * @param fallback 后备字体
   */
  addFallback(...s) {
    this.fallbacks.push(...s), this.fontString = this.getFont();
  }
  build() {
    return `${this.italic ? "italic " : ""} ${this.weight} ${this.size}${this.sizeUnit} ${this.family}`;
  }
  getFallbackFont(s) {
    let t = this.build();
    return this.fallbacks.forEach((r) => {
      if (s.has(r)) {
        q.warn(62, this.build());
        return;
      }
      s.add(r), t += `, ${r.getFallbackFont(s)}`;
    }), t;
  }
  getFont() {
    if (this.fallbacks.length === 0)
      return this.build();
    {
      const s = /* @__PURE__ */ new Set();
      return this.getFallbackFont(s);
    }
  }
  /**
   * 获取字体的 CSS 字符串
   */
  string() {
    return this.fontString;
  }
  static parseOne(s) {
    if (!s) return new ve();
    let t = this.defaultItalic, r = this.defaultWeight, i = this.defaultSize, n = this.defaultSizeUnit, o = this.defaultFamily;
    const a = s.split(/\s+/);
    let c = 0;
    return a.forEach((l, f) => {
      if (l === "italic") {
        t = !0, c = f;
        return;
      }
      const h = Number(l);
      if (!isNaN(h)) {
        r = h, c = f;
        return;
      }
      const p = parseFloat(l);
      if (!isNaN(p)) {
        i = p, n = l.slice(p.toString().length), c = f;
        return;
      }
    }), o = a.slice(c + 1).join(" ") ?? "Verdana", new ve(o, i, n, r, t);
  }
  /**
   * 从 CSS 字体字符串解析出 Font 实例，不支持的属性将被忽略
   */
  static parse(s) {
    const t = s.split(","), r = this.parseOne(t[0]);
    for (let i = 1; i < t.length; i++)
      r.addFallback(this.parseOne(t[i]));
  }
  /**
   * 设置默认字体
   */
  static setDefaults(s) {
    this.defaultFamily = s.family, this.defaultItalic = s.italic, this.defaultSize = s.size, this.defaultSizeUnit = s.sizeUnit, this.defaultWeight = s.weight;
  }
  /**
   * 获取默认字体
   */
  static defaults() {
    return new ve();
  }
  /**
   * 复制一个字体，同时修改字体的一部分属性
   * @param font 要复制的字体
   */
  static clone(s, {
    family: t = s.family,
    size: r = s.size,
    sizeUnit: i = s.sizeUnit,
    weight: n = s.weight,
    italic: o = s.italic
  }) {
    return new ve(t, r, i, n, o);
  }
};
d(ve, "defaultFamily", "Verdana"), d(ve, "defaultSize", 16), d(ve, "defaultSizeUnit", "px"), d(ve, "defaultWeight", 400), d(ve, "defaultItalic", !1);
let rr = ve;
const jr = 1;
var xt;
let hs = (xt = class extends Ue {
  constructor(t = "", r = "static") {
    super(r, !1);
    d(this, "text");
    d(this, "fillStyle", "#fff");
    d(this, "strokeStyle");
    d(this, "font", new rr());
    d(this, "strokeWidth", 1);
    d(this, "length", 0);
    d(this, "descent", 0);
    this.text = t, t.length > 0 && this.requestBeforeFrame(() => {
      this.calBox(), this.emit("setText", t, this.width, this.height);
    });
  }
  render(t, r) {
    const i = t.ctx, n = this.strokeWidth;
    i.textBaseline = "bottom", i.fillStyle = this.fillStyle ?? "transparent", i.strokeStyle = this.strokeStyle ?? "transparent", i.font = this.font.string(), i.lineWidth = this.strokeWidth, this.strokeStyle && i.strokeText(this.text, n, this.descent + n + jr), this.fillStyle && i.fillText(this.text, n, this.descent + n + jr);
  }
  /**
   * 获取文字的长度
   */
  measure() {
    const t = xt.measureCanvas.ctx;
    return t.textBaseline = "bottom", t.font = this.font.string(), t.measureText(this.text);
  }
  /**
   * 设置显示文字
   * @param text 显示的文字
   */
  setText(t) {
    this.text = t, this.calBox(), this.update(this), this.emit("setText", t, this.width, this.height);
  }
  /**
   * 设置使用的字体
   * @param font 字体
   */
  setFont(t) {
    this.font = t, this.calBox(), this.update(this);
  }
  /**
   * 设置字体样式
   * @param fill 填充样式
   * @param stroke 描边样式
   */
  setStyle(t, r) {
    this.fillStyle = t, this.strokeStyle = r, this.update();
  }
  /**
   * 设置描边宽度
   * @param width 宽度
   */
  setStrokeWidth(t) {
    const r = this.strokeWidth;
    this.strokeWidth = t;
    const i = t - r;
    this.size(this.width + i * 2, this.height + i * 2), this.update();
  }
  /**
   * 计算字体所占空间，从而确定这个元素的大小
   */
  calBox() {
    const { width: t, actualBoundingBoxAscent: r, actualBoundingBoxDescent: i } = this.measure();
    this.length = t, this.descent = r;
    const n = r + i, o = this.strokeWidth * 2;
    this.size(t + o, n + o + jr * 2);
  }
  handleProps(t, r, i) {
    switch (t) {
      case "text":
        return this.assertType(i, "string", t) ? (this.setText(i), !0) : !1;
      case "fillStyle":
        return this.setStyle(i, this.strokeStyle), !0;
      case "strokeStyle":
        return this.setStyle(this.fillStyle, i), !0;
      case "font":
        return this.assertType(i, rr, t) ? (this.setFont(i), !0) : !1;
      case "strokeWidth":
        return this.setStrokeWidth(i), !0;
    }
    return !1;
  }
}, d(xt, "measureCanvas", new Ss()), xt);
class Sn extends Ue {
  constructor(t, r = "static") {
    super(r, !1);
    d(this, "image");
    this.image = t, t instanceof VideoFrame || t instanceof SVGElement ? this.size(200, 200) : this.size(t.width, t.height);
  }
  render(t, r) {
    t.ctx.drawImage(this.image, 0, 0, this.width, this.height);
  }
  /**
   * 设置图片资源
   * @param image 图片资源
   */
  setImage(t) {
    this.image = t, this.update();
  }
  handleProps(t, r, i) {
    switch (t) {
      case "image":
        return this.setImage(i), !0;
    }
    return !1;
  }
}
let ir = class extends Ue {
  constructor(t = "") {
    super("static", !1, !1);
    d(this, "isComment", !0);
    this.text = t, this.hide();
  }
  getBoundingRect() {
    return new DOMRectReadOnly(0, 0, 0, 0);
  }
  render(t, r) {
  }
  handleProps() {
    return !1;
  }
};
/**
* @vue/shared v3.5.20
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/
/*! #__NO_SIDE_EFFECTS__ */
// @__NO_SIDE_EFFECTS__
function Ds(e) {
  const s = /* @__PURE__ */ Object.create(null);
  for (const t of e.split(",")) s[t] = 1;
  return (t) => t in s;
}
const ee = process.env.NODE_ENV !== "production" ? Object.freeze({}) : {}, fs = process.env.NODE_ENV !== "production" ? Object.freeze([]) : [], pe = () => {
}, po = () => !1, _r = (e) => e.charCodeAt(0) === 111 && e.charCodeAt(1) === 110 && // uppercase letter
(e.charCodeAt(2) > 122 || e.charCodeAt(2) < 97), si = (e) => e.startsWith("onUpdate:"), ue = Object.assign, _i = (e, s) => {
  const t = e.indexOf(s);
  t > -1 && e.splice(t, 1);
}, Ff = Object.prototype.hasOwnProperty, X = (e, s) => Ff.call(e, s), j = Array.isArray, kt = (e) => yr(e) === "[object Map]", Uf = (e) => yr(e) === "[object Set]", L = (e) => typeof e == "function", be = (e) => typeof e == "string", Rs = (e) => typeof e == "symbol", re = (e) => e !== null && typeof e == "object", yi = (e) => (re(e) || L(e)) && L(e.then) && L(e.catch), kf = Object.prototype.toString, yr = (e) => kf.call(e), Ei = (e) => yr(e).slice(8, -1), jf = (e) => yr(e) === "[object Object]", wi = (e) => be(e) && e !== "NaN" && e[0] !== "-" && "" + parseInt(e, 10) === e, us = /* @__PURE__ */ Ds(
  // the leading comma is intentional so empty string "" is also included
  ",key,ref,ref_for,ref_key,onVnodeBeforeMount,onVnodeMounted,onVnodeBeforeUpdate,onVnodeUpdated,onVnodeBeforeUnmount,onVnodeUnmounted"
), Lf = /* @__PURE__ */ Ds(
  "bind,cloak,else-if,else,for,html,if,model,on,once,pre,show,slot,text,memo"
), Er = (e) => {
  const s = /* @__PURE__ */ Object.create(null);
  return ((t) => s[t] || (s[t] = e(t)));
}, Bf = /-(\w)/g, et = Er(
  (e) => e.replace(Bf, (s, t) => t ? t.toUpperCase() : "")
), Hf = /\B([A-Z])/g, Vt = Er(
  (e) => e.replace(Hf, "-$1").toLowerCase()
), xi = Er((e) => e.charAt(0).toUpperCase() + e.slice(1)), yt = Er(
  (e) => e ? `on${xi(e)}` : ""
), Tt = (e, s) => !Object.is(e, s), ts = (e, ...s) => {
  for (let t = 0; t < e.length; t++)
    e[t](...s);
}, nr = (e, s, t, r = !1) => {
  Object.defineProperty(e, s, {
    configurable: !0,
    enumerable: !1,
    writable: r,
    value: t
  });
}, zf = (e) => {
  const s = parseFloat(e);
  return isNaN(s) ? e : s;
};
let Dn;
const Cs = () => Dn || (Dn = typeof globalThis < "u" ? globalThis : typeof self < "u" ? self : typeof window < "u" ? window : typeof global < "u" ? global : {});
function Ni(e) {
  if (j(e)) {
    const s = {};
    for (let t = 0; t < e.length; t++) {
      const r = e[t], i = be(r) ? Xf(r) : Ni(r);
      if (i)
        for (const n in i)
          s[n] = i[n];
    }
    return s;
  } else if (be(e) || re(e))
    return e;
}
const Vf = /;(?![^(]*\))/g, Kf = /:([^]+)/, Wf = /\/\*[^]*?\*\//g;
function Xf(e) {
  const s = {};
  return e.replace(Wf, "").split(Vf).forEach((t) => {
    if (t) {
      const r = t.split(Kf);
      r.length > 1 && (s[r[0].trim()] = r[1].trim());
    }
  }), s;
}
function Ti(e) {
  let s = "";
  if (be(e))
    s = e;
  else if (j(e))
    for (let t = 0; t < e.length; t++) {
      const r = Ti(e[t]);
      r && (s += r + " ");
    }
  else if (re(e))
    for (const t in e)
      e[t] && (s += t + " ");
  return s.trim();
}
/**
* @vue/reactivity v3.5.20
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/
function ke(e, ...s) {
  console.warn(`[Vue warn] ${e}`, ...s);
}
let Oe;
class Yf {
  constructor(s = !1) {
    this.detached = s, this._active = !0, this._on = 0, this.effects = [], this.cleanups = [], this._isPaused = !1, this.parent = Oe, !s && Oe && (this.index = (Oe.scopes || (Oe.scopes = [])).push(
      this
    ) - 1);
  }
  get active() {
    return this._active;
  }
  pause() {
    if (this._active) {
      this._isPaused = !0;
      let s, t;
      if (this.scopes)
        for (s = 0, t = this.scopes.length; s < t; s++)
          this.scopes[s].pause();
      for (s = 0, t = this.effects.length; s < t; s++)
        this.effects[s].pause();
    }
  }
  /**
   * Resumes the effect scope, including all child scopes and effects.
   */
  resume() {
    if (this._active && this._isPaused) {
      this._isPaused = !1;
      let s, t;
      if (this.scopes)
        for (s = 0, t = this.scopes.length; s < t; s++)
          this.scopes[s].resume();
      for (s = 0, t = this.effects.length; s < t; s++)
        this.effects[s].resume();
    }
  }
  run(s) {
    if (this._active) {
      const t = Oe;
      try {
        return Oe = this, s();
      } finally {
        Oe = t;
      }
    } else process.env.NODE_ENV !== "production" && ke("cannot run an inactive effect scope.");
  }
  /**
   * This should only be called on non-detached scopes
   * @internal
   */
  on() {
    ++this._on === 1 && (this.prevScope = Oe, Oe = this);
  }
  /**
   * This should only be called on non-detached scopes
   * @internal
   */
  off() {
    this._on > 0 && --this._on === 0 && (Oe = this.prevScope, this.prevScope = void 0);
  }
  stop(s) {
    if (this._active) {
      this._active = !1;
      let t, r;
      for (t = 0, r = this.effects.length; t < r; t++)
        this.effects[t].stop();
      for (this.effects.length = 0, t = 0, r = this.cleanups.length; t < r; t++)
        this.cleanups[t]();
      if (this.cleanups.length = 0, this.scopes) {
        for (t = 0, r = this.scopes.length; t < r; t++)
          this.scopes[t].stop(!0);
        this.scopes.length = 0;
      }
      if (!this.detached && this.parent && !s) {
        const i = this.parent.scopes.pop();
        i && i !== this && (this.parent.scopes[this.index] = i, i.index = this.index);
      }
      this.parent = void 0;
    }
  }
}
function qf() {
  return Oe;
}
let G;
const Lr = /* @__PURE__ */ new WeakSet();
class go {
  constructor(s) {
    this.fn = s, this.deps = void 0, this.depsTail = void 0, this.flags = 5, this.next = void 0, this.cleanup = void 0, this.scheduler = void 0, Oe && Oe.active && Oe.effects.push(this);
  }
  pause() {
    this.flags |= 64;
  }
  resume() {
    this.flags & 64 && (this.flags &= -65, Lr.has(this) && (Lr.delete(this), this.trigger()));
  }
  /**
   * @internal
   */
  notify() {
    this.flags & 2 && !(this.flags & 32) || this.flags & 8 || vo(this);
  }
  run() {
    if (!(this.flags & 1))
      return this.fn();
    this.flags |= 2, Rn(this), bo(this);
    const s = G, t = $e;
    G = this, $e = !0;
    try {
      return this.fn();
    } finally {
      process.env.NODE_ENV !== "production" && G !== this && ke(
        "Active effect was not restored correctly - this is likely a Vue internal bug."
      ), _o(this), G = s, $e = t, this.flags &= -3;
    }
  }
  stop() {
    if (this.flags & 1) {
      for (let s = this.deps; s; s = s.nextDep)
        Si(s);
      this.deps = this.depsTail = void 0, Rn(this), this.onStop && this.onStop(), this.flags &= -2;
    }
  }
  trigger() {
    this.flags & 64 ? Lr.add(this) : this.scheduler ? this.scheduler() : this.runIfDirty();
  }
  /**
   * @internal
   */
  runIfDirty() {
    ri(this) && this.run();
  }
  get dirty() {
    return ri(this);
  }
}
let mo = 0, ds, ps;
function vo(e, s = !1) {
  if (e.flags |= 8, s) {
    e.next = ps, ps = e;
    return;
  }
  e.next = ds, ds = e;
}
function Oi() {
  mo++;
}
function Ai() {
  if (--mo > 0)
    return;
  if (ps) {
    let s = ps;
    for (ps = void 0; s; ) {
      const t = s.next;
      s.next = void 0, s.flags &= -9, s = t;
    }
  }
  let e;
  for (; ds; ) {
    let s = ds;
    for (ds = void 0; s; ) {
      const t = s.next;
      if (s.next = void 0, s.flags &= -9, s.flags & 1)
        try {
          s.trigger();
        } catch (r) {
          e || (e = r);
        }
      s = t;
    }
  }
  if (e) throw e;
}
function bo(e) {
  for (let s = e.deps; s; s = s.nextDep)
    s.version = -1, s.prevActiveLink = s.dep.activeLink, s.dep.activeLink = s;
}
function _o(e) {
  let s, t = e.depsTail, r = t;
  for (; r; ) {
    const i = r.prevDep;
    r.version === -1 ? (r === t && (t = i), Si(r), Gf(r)) : s = r, r.dep.activeLink = r.prevActiveLink, r.prevActiveLink = void 0, r = i;
  }
  e.deps = s, e.depsTail = t;
}
function ri(e) {
  for (let s = e.deps; s; s = s.nextDep)
    if (s.dep.version !== s.version || s.dep.computed && (yo(s.dep.computed) || s.dep.version !== s.version))
      return !0;
  return !!e._dirty;
}
function yo(e) {
  if (e.flags & 4 && !(e.flags & 16) || (e.flags &= -17, e.globalVersion === Ns) || (e.globalVersion = Ns, !e.isSSR && e.flags & 128 && (!e.deps && !e._dirty || !ri(e))))
    return;
  e.flags |= 2;
  const s = e.dep, t = G, r = $e;
  G = e, $e = !0;
  try {
    bo(e);
    const i = e.fn(e._value);
    (s.version === 0 || Tt(i, e._value)) && (e.flags |= 128, e._value = i, s.version++);
  } catch (i) {
    throw s.version++, i;
  } finally {
    G = t, $e = r, _o(e), e.flags &= -3;
  }
}
function Si(e, s = !1) {
  const { dep: t, prevSub: r, nextSub: i } = e;
  if (r && (r.nextSub = i, e.prevSub = void 0), i && (i.prevSub = r, e.nextSub = void 0), process.env.NODE_ENV !== "production" && t.subsHead === e && (t.subsHead = i), t.subs === e && (t.subs = r, !r && t.computed)) {
    t.computed.flags &= -5;
    for (let n = t.computed.deps; n; n = n.nextDep)
      Si(n, !0);
  }
  !s && !--t.sc && t.map && t.map.delete(t.key);
}
function Gf(e) {
  const { prevDep: s, nextDep: t } = e;
  s && (s.nextDep = t, e.prevDep = void 0), t && (t.prevDep = s, e.nextDep = void 0);
}
let $e = !0;
const Eo = [];
function je() {
  Eo.push($e), $e = !1;
}
function Le() {
  const e = Eo.pop();
  $e = e === void 0 ? !0 : e;
}
function Rn(e) {
  const { cleanup: s } = e;
  if (e.cleanup = void 0, s) {
    const t = G;
    G = void 0;
    try {
      s();
    } finally {
      G = t;
    }
  }
}
let Ns = 0;
class Jf {
  constructor(s, t) {
    this.sub = s, this.dep = t, this.version = t.version, this.nextDep = this.prevDep = this.nextSub = this.prevSub = this.prevActiveLink = void 0;
  }
}
class wo {
  // TODO isolatedDeclarations "__v_skip"
  constructor(s) {
    this.computed = s, this.version = 0, this.activeLink = void 0, this.subs = void 0, this.map = void 0, this.key = void 0, this.sc = 0, this.__v_skip = !0, process.env.NODE_ENV !== "production" && (this.subsHead = void 0);
  }
  track(s) {
    if (!G || !$e || G === this.computed)
      return;
    let t = this.activeLink;
    if (t === void 0 || t.sub !== G)
      t = this.activeLink = new Jf(G, this), G.deps ? (t.prevDep = G.depsTail, G.depsTail.nextDep = t, G.depsTail = t) : G.deps = G.depsTail = t, xo(t);
    else if (t.version === -1 && (t.version = this.version, t.nextDep)) {
      const r = t.nextDep;
      r.prevDep = t.prevDep, t.prevDep && (t.prevDep.nextDep = r), t.prevDep = G.depsTail, t.nextDep = void 0, G.depsTail.nextDep = t, G.depsTail = t, G.deps === t && (G.deps = r);
    }
    return process.env.NODE_ENV !== "production" && G.onTrack && G.onTrack(
      ue(
        {
          effect: G
        },
        s
      )
    ), t;
  }
  trigger(s) {
    this.version++, Ns++, this.notify(s);
  }
  notify(s) {
    Oi();
    try {
      if (process.env.NODE_ENV !== "production")
        for (let t = this.subsHead; t; t = t.nextSub)
          t.sub.onTrigger && !(t.sub.flags & 8) && t.sub.onTrigger(
            ue(
              {
                effect: t.sub
              },
              s
            )
          );
      for (let t = this.subs; t; t = t.prevSub)
        t.sub.notify() && t.sub.dep.notify();
    } finally {
      Ai();
    }
  }
}
function xo(e) {
  if (e.dep.sc++, e.sub.flags & 4) {
    const s = e.dep.computed;
    if (s && !e.dep.subs) {
      s.flags |= 20;
      for (let r = s.deps; r; r = r.nextDep)
        xo(r);
    }
    const t = e.dep.subs;
    t !== e && (e.prevSub = t, t && (t.nextSub = e)), process.env.NODE_ENV !== "production" && e.dep.subsHead === void 0 && (e.dep.subsHead = e), e.dep.subs = e;
  }
}
const ii = /* @__PURE__ */ new WeakMap(), Ot = Symbol(
  process.env.NODE_ENV !== "production" ? "Object iterate" : ""
), ni = Symbol(
  process.env.NODE_ENV !== "production" ? "Map keys iterate" : ""
), Ts = Symbol(
  process.env.NODE_ENV !== "production" ? "Array iterate" : ""
);
function he(e, s, t) {
  if ($e && G) {
    let r = ii.get(e);
    r || ii.set(e, r = /* @__PURE__ */ new Map());
    let i = r.get(t);
    i || (r.set(t, i = new wo()), i.map = r, i.key = t), process.env.NODE_ENV !== "production" ? i.track({
      target: e,
      type: s,
      key: t
    }) : i.track();
  }
}
function Ye(e, s, t, r, i, n) {
  const o = ii.get(e);
  if (!o) {
    Ns++;
    return;
  }
  const a = (c) => {
    c && (process.env.NODE_ENV !== "production" ? c.trigger({
      target: e,
      type: s,
      key: t,
      newValue: r,
      oldValue: i,
      oldTarget: n
    }) : c.trigger());
  };
  if (Oi(), s === "clear")
    o.forEach(a);
  else {
    const c = j(e), l = c && wi(t);
    if (c && t === "length") {
      const f = Number(r);
      o.forEach((h, p) => {
        (p === "length" || p === Ts || !Rs(p) && p >= f) && a(h);
      });
    } else
      switch ((t !== void 0 || o.has(void 0)) && a(o.get(t)), l && a(o.get(Ts)), s) {
        case "add":
          c ? l && a(o.get("length")) : (a(o.get(Ot)), kt(e) && a(o.get(ni)));
          break;
        case "delete":
          c || (a(o.get(Ot)), kt(e) && a(o.get(ni)));
          break;
        case "set":
          kt(e) && a(o.get(Ot));
          break;
      }
  }
  Ai();
}
function Mt(e) {
  const s = H(e);
  return s === e ? s : (he(s, "iterate", Ts), Ce(e) ? s : s.map(De));
}
function Di(e) {
  return he(e = H(e), "iterate", Ts), e;
}
const Zf = {
  __proto__: null,
  [Symbol.iterator]() {
    return Br(this, Symbol.iterator, De);
  },
  concat(...e) {
    return Mt(this).concat(
      ...e.map((s) => j(s) ? Mt(s) : s)
    );
  },
  entries() {
    return Br(this, "entries", (e) => (e[1] = De(e[1]), e));
  },
  every(e, s) {
    return Ze(this, "every", e, s, void 0, arguments);
  },
  filter(e, s) {
    return Ze(this, "filter", e, s, (t) => t.map(De), arguments);
  },
  find(e, s) {
    return Ze(this, "find", e, s, De, arguments);
  },
  findIndex(e, s) {
    return Ze(this, "findIndex", e, s, void 0, arguments);
  },
  findLast(e, s) {
    return Ze(this, "findLast", e, s, De, arguments);
  },
  findLastIndex(e, s) {
    return Ze(this, "findLastIndex", e, s, void 0, arguments);
  },
  // flat, flatMap could benefit from ARRAY_ITERATE but are not straight-forward to implement
  forEach(e, s) {
    return Ze(this, "forEach", e, s, void 0, arguments);
  },
  includes(...e) {
    return Hr(this, "includes", e);
  },
  indexOf(...e) {
    return Hr(this, "indexOf", e);
  },
  join(e) {
    return Mt(this).join(e);
  },
  // keys() iterator only reads `length`, no optimization required
  lastIndexOf(...e) {
    return Hr(this, "lastIndexOf", e);
  },
  map(e, s) {
    return Ze(this, "map", e, s, void 0, arguments);
  },
  pop() {
    return ss(this, "pop");
  },
  push(...e) {
    return ss(this, "push", e);
  },
  reduce(e, ...s) {
    return Cn(this, "reduce", e, s);
  },
  reduceRight(e, ...s) {
    return Cn(this, "reduceRight", e, s);
  },
  shift() {
    return ss(this, "shift");
  },
  // slice could use ARRAY_ITERATE but also seems to beg for range tracking
  some(e, s) {
    return Ze(this, "some", e, s, void 0, arguments);
  },
  splice(...e) {
    return ss(this, "splice", e);
  },
  toReversed() {
    return Mt(this).toReversed();
  },
  toSorted(e) {
    return Mt(this).toSorted(e);
  },
  toSpliced(...e) {
    return Mt(this).toSpliced(...e);
  },
  unshift(...e) {
    return ss(this, "unshift", e);
  },
  values() {
    return Br(this, "values", De);
  }
};
function Br(e, s, t) {
  const r = Di(e), i = r[s]();
  return r !== e && !Ce(e) && (i._next = i.next, i.next = () => {
    const n = i._next();
    return n.value && (n.value = t(n.value)), n;
  }), i;
}
const Qf = Array.prototype;
function Ze(e, s, t, r, i, n) {
  const o = Di(e), a = o !== e && !Ce(e), c = o[s];
  if (c !== Qf[s]) {
    const h = c.apply(e, n);
    return a ? De(h) : h;
  }
  let l = t;
  o !== e && (a ? l = function(h, p) {
    return t.call(this, De(h), p, e);
  } : t.length > 2 && (l = function(h, p) {
    return t.call(this, h, p, e);
  }));
  const f = c.call(o, l, r);
  return a && i ? i(f) : f;
}
function Cn(e, s, t, r) {
  const i = Di(e);
  let n = t;
  return i !== e && (Ce(e) ? t.length > 3 && (n = function(o, a, c) {
    return t.call(this, o, a, c, e);
  }) : n = function(o, a, c) {
    return t.call(this, o, De(a), c, e);
  }), i[s](n, ...r);
}
function Hr(e, s, t) {
  const r = H(e);
  he(r, "iterate", Ts);
  const i = r[s](...t);
  return (i === -1 || i === !1) && or(t[0]) ? (t[0] = H(t[0]), r[s](...t)) : i;
}
function ss(e, s, t = []) {
  je(), Oi();
  const r = H(e)[s].apply(e, t);
  return Ai(), Le(), r;
}
const eu = /* @__PURE__ */ Ds("__proto__,__v_isRef,__isVue"), No = new Set(
  /* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((e) => e !== "arguments" && e !== "caller").map((e) => Symbol[e]).filter(Rs)
);
function tu(e) {
  Rs(e) || (e = String(e));
  const s = H(this);
  return he(s, "has", e), s.hasOwnProperty(e);
}
class To {
  constructor(s = !1, t = !1) {
    this._isReadonly = s, this._isShallow = t;
  }
  get(s, t, r) {
    if (t === "__v_skip") return s.__v_skip;
    const i = this._isReadonly, n = this._isShallow;
    if (t === "__v_isReactive")
      return !i;
    if (t === "__v_isReadonly")
      return i;
    if (t === "__v_isShallow")
      return n;
    if (t === "__v_raw")
      return r === (i ? n ? Co : Ro : n ? Do : So).get(s) || // receiver is not the reactive proxy, but has the same prototype
      // this means the receiver is a user proxy of the reactive proxy
      Object.getPrototypeOf(s) === Object.getPrototypeOf(r) ? s : void 0;
    const o = j(s);
    if (!i) {
      let c;
      if (o && (c = Zf[t]))
        return c;
      if (t === "hasOwnProperty")
        return tu;
    }
    const a = Reflect.get(
      s,
      t,
      // if this is a proxy wrapping a ref, return methods using the raw ref
      // as receiver so that we don't have to call `toRaw` on the ref in all
      // its class methods
      fe(s) ? s : r
    );
    return (Rs(t) ? No.has(t) : eu(t)) || (i || he(s, "get", t), n) ? a : fe(a) ? o && wi(t) ? a : a.value : re(a) ? i ? Io(a) : Ri(a) : a;
  }
}
class Oo extends To {
  constructor(s = !1) {
    super(!1, s);
  }
  set(s, t, r, i) {
    let n = s[t];
    if (!this._isShallow) {
      const c = pt(n);
      if (!Ce(r) && !pt(r) && (n = H(n), r = H(r)), !j(s) && fe(n) && !fe(r))
        return c ? (process.env.NODE_ENV !== "production" && ke(
          `Set operation on key "${String(t)}" failed: target is readonly.`,
          s[t]
        ), !0) : (n.value = r, !0);
    }
    const o = j(s) && wi(t) ? Number(t) < s.length : X(s, t), a = Reflect.set(
      s,
      t,
      r,
      fe(s) ? s : i
    );
    return s === H(i) && (o ? Tt(r, n) && Ye(s, "set", t, r, n) : Ye(s, "add", t, r)), a;
  }
  deleteProperty(s, t) {
    const r = X(s, t), i = s[t], n = Reflect.deleteProperty(s, t);
    return n && r && Ye(s, "delete", t, void 0, i), n;
  }
  has(s, t) {
    const r = Reflect.has(s, t);
    return (!Rs(t) || !No.has(t)) && he(s, "has", t), r;
  }
  ownKeys(s) {
    return he(
      s,
      "iterate",
      j(s) ? "length" : Ot
    ), Reflect.ownKeys(s);
  }
}
class Ao extends To {
  constructor(s = !1) {
    super(!0, s);
  }
  set(s, t) {
    return process.env.NODE_ENV !== "production" && ke(
      `Set operation on key "${String(t)}" failed: target is readonly.`,
      s
    ), !0;
  }
  deleteProperty(s, t) {
    return process.env.NODE_ENV !== "production" && ke(
      `Delete operation on key "${String(t)}" failed: target is readonly.`,
      s
    ), !0;
  }
}
const su = /* @__PURE__ */ new Oo(), ru = /* @__PURE__ */ new Ao(), iu = /* @__PURE__ */ new Oo(!0), nu = /* @__PURE__ */ new Ao(!0), oi = (e) => e, js = (e) => Reflect.getPrototypeOf(e);
function ou(e, s, t) {
  return function(...r) {
    const i = this.__v_raw, n = H(i), o = kt(n), a = e === "entries" || e === Symbol.iterator && o, c = e === "keys" && o, l = i[e](...r), f = t ? oi : s ? ai : De;
    return !s && he(
      n,
      "iterate",
      c ? ni : Ot
    ), {
      // iterator protocol
      next() {
        const { value: h, done: p } = l.next();
        return p ? { value: h, done: p } : {
          value: a ? [f(h[0]), f(h[1])] : f(h),
          done: p
        };
      },
      // iterable protocol
      [Symbol.iterator]() {
        return this;
      }
    };
  };
}
function Ls(e) {
  return function(...s) {
    if (process.env.NODE_ENV !== "production") {
      const t = s[0] ? `on key "${s[0]}" ` : "";
      ke(
        `${xi(e)} operation ${t}failed: target is readonly.`,
        H(this)
      );
    }
    return e === "delete" ? !1 : e === "clear" ? void 0 : this;
  };
}
function au(e, s) {
  const t = {
    get(i) {
      const n = this.__v_raw, o = H(n), a = H(i);
      e || (Tt(i, a) && he(o, "get", i), he(o, "get", a));
      const { has: c } = js(o), l = s ? oi : e ? ai : De;
      if (c.call(o, i))
        return l(n.get(i));
      if (c.call(o, a))
        return l(n.get(a));
      n !== o && n.get(i);
    },
    get size() {
      const i = this.__v_raw;
      return !e && he(H(i), "iterate", Ot), i.size;
    },
    has(i) {
      const n = this.__v_raw, o = H(n), a = H(i);
      return e || (Tt(i, a) && he(o, "has", i), he(o, "has", a)), i === a ? n.has(i) : n.has(i) || n.has(a);
    },
    forEach(i, n) {
      const o = this, a = o.__v_raw, c = H(a), l = s ? oi : e ? ai : De;
      return !e && he(c, "iterate", Ot), a.forEach((f, h) => i.call(n, l(f), l(h), o));
    }
  };
  return ue(
    t,
    e ? {
      add: Ls("add"),
      set: Ls("set"),
      delete: Ls("delete"),
      clear: Ls("clear")
    } : {
      add(i) {
        !s && !Ce(i) && !pt(i) && (i = H(i));
        const n = H(this);
        return js(n).has.call(n, i) || (n.add(i), Ye(n, "add", i, i)), this;
      },
      set(i, n) {
        !s && !Ce(n) && !pt(n) && (n = H(n));
        const o = H(this), { has: a, get: c } = js(o);
        let l = a.call(o, i);
        l ? process.env.NODE_ENV !== "production" && In(o, a, i) : (i = H(i), l = a.call(o, i));
        const f = c.call(o, i);
        return o.set(i, n), l ? Tt(n, f) && Ye(o, "set", i, n, f) : Ye(o, "add", i, n), this;
      },
      delete(i) {
        const n = H(this), { has: o, get: a } = js(n);
        let c = o.call(n, i);
        c ? process.env.NODE_ENV !== "production" && In(n, o, i) : (i = H(i), c = o.call(n, i));
        const l = a ? a.call(n, i) : void 0, f = n.delete(i);
        return c && Ye(n, "delete", i, void 0, l), f;
      },
      clear() {
        const i = H(this), n = i.size !== 0, o = process.env.NODE_ENV !== "production" ? kt(i) ? new Map(i) : new Set(i) : void 0, a = i.clear();
        return n && Ye(
          i,
          "clear",
          void 0,
          void 0,
          o
        ), a;
      }
    }
  ), [
    "keys",
    "values",
    "entries",
    Symbol.iterator
  ].forEach((i) => {
    t[i] = ou(i, e, s);
  }), t;
}
function wr(e, s) {
  const t = au(e, s);
  return (r, i, n) => i === "__v_isReactive" ? !e : i === "__v_isReadonly" ? e : i === "__v_raw" ? r : Reflect.get(
    X(t, i) && i in r ? t : r,
    i,
    n
  );
}
const cu = {
  get: /* @__PURE__ */ wr(!1, !1)
}, lu = {
  get: /* @__PURE__ */ wr(!1, !0)
}, hu = {
  get: /* @__PURE__ */ wr(!0, !1)
}, fu = {
  get: /* @__PURE__ */ wr(!0, !0)
};
function In(e, s, t) {
  const r = H(t);
  if (r !== t && s.call(e, r)) {
    const i = Ei(e);
    ke(
      `Reactive ${i} contains both the raw and reactive versions of the same object${i === "Map" ? " as keys" : ""}, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`
    );
  }
}
const So = /* @__PURE__ */ new WeakMap(), Do = /* @__PURE__ */ new WeakMap(), Ro = /* @__PURE__ */ new WeakMap(), Co = /* @__PURE__ */ new WeakMap();
function uu(e) {
  switch (e) {
    case "Object":
    case "Array":
      return 1;
    case "Map":
    case "Set":
    case "WeakMap":
    case "WeakSet":
      return 2;
    default:
      return 0;
  }
}
function du(e) {
  return e.__v_skip || !Object.isExtensible(e) ? 0 : uu(Ei(e));
}
function Ri(e) {
  return pt(e) ? e : xr(
    e,
    !1,
    su,
    cu,
    So
  );
}
function pu(e) {
  return xr(
    e,
    !1,
    iu,
    lu,
    Do
  );
}
function Io(e) {
  return xr(
    e,
    !0,
    ru,
    hu,
    Ro
  );
}
function qe(e) {
  return xr(
    e,
    !0,
    nu,
    fu,
    Co
  );
}
function xr(e, s, t, r, i) {
  if (!re(e))
    return process.env.NODE_ENV !== "production" && ke(
      `value cannot be made ${s ? "readonly" : "reactive"}: ${String(
        e
      )}`
    ), e;
  if (e.__v_raw && !(s && e.__v_isReactive))
    return e;
  const n = du(e);
  if (n === 0)
    return e;
  const o = i.get(e);
  if (o)
    return o;
  const a = new Proxy(
    e,
    n === 2 ? r : t
  );
  return i.set(e, a), a;
}
function jt(e) {
  return pt(e) ? jt(e.__v_raw) : !!(e && e.__v_isReactive);
}
function pt(e) {
  return !!(e && e.__v_isReadonly);
}
function Ce(e) {
  return !!(e && e.__v_isShallow);
}
function or(e) {
  return e ? !!e.__v_raw : !1;
}
function H(e) {
  const s = e && e.__v_raw;
  return s ? H(s) : e;
}
function gu(e) {
  return !X(e, "__v_skip") && Object.isExtensible(e) && nr(e, "__v_skip", !0), e;
}
const De = (e) => re(e) ? Ri(e) : e, ai = (e) => re(e) ? Io(e) : e;
function fe(e) {
  return e ? e.__v_isRef === !0 : !1;
}
function mu(e) {
  return fe(e) ? e.value : e;
}
const vu = {
  get: (e, s, t) => s === "__v_raw" ? e : mu(Reflect.get(e, s, t)),
  set: (e, s, t, r) => {
    const i = e[s];
    return fe(i) && !fe(t) ? (i.value = t, !0) : Reflect.set(e, s, t, r);
  }
};
function Po(e) {
  return jt(e) ? e : new Proxy(e, vu);
}
class bu {
  constructor(s, t, r) {
    this.fn = s, this.setter = t, this._value = void 0, this.dep = new wo(this), this.__v_isRef = !0, this.deps = void 0, this.depsTail = void 0, this.flags = 16, this.globalVersion = Ns - 1, this.next = void 0, this.effect = this, this.__v_isReadonly = !t, this.isSSR = r;
  }
  /**
   * @internal
   */
  notify() {
    if (this.flags |= 16, !(this.flags & 8) && // avoid infinite self recursion
    G !== this)
      return vo(this, !0), !0;
    process.env.NODE_ENV;
  }
  get value() {
    const s = process.env.NODE_ENV !== "production" ? this.dep.track({
      target: this,
      type: "get",
      key: "value"
    }) : this.dep.track();
    return yo(this), s && (s.version = this.dep.version), this._value;
  }
  set value(s) {
    this.setter ? this.setter(s) : process.env.NODE_ENV !== "production" && ke("Write operation failed: computed value is readonly");
  }
}
function _u(e, s, t = !1) {
  let r, i;
  L(e) ? r = e : (r = e.get, i = e.set);
  const n = new bu(r, i, t);
  return process.env.NODE_ENV, n;
}
const Bs = {}, ar = /* @__PURE__ */ new WeakMap();
let Et;
function yu(e, s = !1, t = Et) {
  if (t) {
    let r = ar.get(t);
    r || ar.set(t, r = []), r.push(e);
  } else process.env.NODE_ENV !== "production" && !s && ke(
    "onWatcherCleanup() was called when there was no active watcher to associate with."
  );
}
function Eu(e, s, t = ee) {
  const { immediate: r, deep: i, once: n, scheduler: o, augmentJob: a, call: c } = t, l = (w) => {
    (t.onWarn || ke)(
      "Invalid watch source: ",
      w,
      "A watch source can only be a getter/effect function, a ref, a reactive object, or an array of these types."
    );
  }, f = (w) => i ? w : Ce(w) || i === !1 || i === 0 ? lt(w, 1) : lt(w);
  let h, p, m, v, _ = !1, x = !1;
  if (fe(e) ? (p = () => e.value, _ = Ce(e)) : jt(e) ? (p = () => f(e), _ = !0) : j(e) ? (x = !0, _ = e.some((w) => jt(w) || Ce(w)), p = () => e.map((w) => {
    if (fe(w))
      return w.value;
    if (jt(w))
      return f(w);
    if (L(w))
      return c ? c(w, 2) : w();
    process.env.NODE_ENV !== "production" && l(w);
  })) : L(e) ? s ? p = c ? () => c(e, 2) : e : p = () => {
    if (m) {
      je();
      try {
        m();
      } finally {
        Le();
      }
    }
    const w = Et;
    Et = h;
    try {
      return c ? c(e, 3, [v]) : e(v);
    } finally {
      Et = w;
    }
  } : (p = pe, process.env.NODE_ENV !== "production" && l(e)), s && i) {
    const w = p, P = i === !0 ? 1 / 0 : i;
    p = () => lt(w(), P);
  }
  const I = qf(), M = () => {
    h.stop(), I && I.active && _i(I.effects, h);
  };
  if (n && s) {
    const w = s;
    s = (...P) => {
      w(...P), M();
    };
  }
  let N = x ? new Array(e.length).fill(Bs) : Bs;
  const $ = (w) => {
    if (!(!(h.flags & 1) || !h.dirty && !w))
      if (s) {
        const P = h.run();
        if (i || _ || (x ? P.some((Y, V) => Tt(Y, N[V])) : Tt(P, N))) {
          m && m();
          const Y = Et;
          Et = h;
          try {
            const V = [
              P,
              // pass undefined as the old value when it's changed for the first time
              N === Bs ? void 0 : x && N[0] === Bs ? [] : N,
              v
            ];
            N = P, c ? c(s, 3, V) : (
              // @ts-expect-error
              s(...V)
            );
          } finally {
            Et = Y;
          }
        }
      } else
        h.run();
  };
  return a && a($), h = new go(p), h.scheduler = o ? () => o($, !1) : $, v = (w) => yu(w, !1, h), m = h.onStop = () => {
    const w = ar.get(h);
    if (w) {
      if (c)
        c(w, 4);
      else
        for (const P of w) P();
      ar.delete(h);
    }
  }, process.env.NODE_ENV !== "production" && (h.onTrack = t.onTrack, h.onTrigger = t.onTrigger), s ? r ? $(!0) : N = h.run() : o ? o($.bind(null, !0), !0) : h.run(), M.pause = h.pause.bind(h), M.resume = h.resume.bind(h), M.stop = M, M;
}
function lt(e, s = 1 / 0, t) {
  if (s <= 0 || !re(e) || e.__v_skip || (t = t || /* @__PURE__ */ new Set(), t.has(e)))
    return e;
  if (t.add(e), s--, fe(e))
    lt(e.value, s, t);
  else if (j(e))
    for (let r = 0; r < e.length; r++)
      lt(e[r], s, t);
  else if (Uf(e) || kt(e))
    e.forEach((r) => {
      lt(r, s, t);
    });
  else if (jf(e)) {
    for (const r in e)
      lt(e[r], s, t);
    for (const r of Object.getOwnPropertySymbols(e))
      Object.prototype.propertyIsEnumerable.call(e, r) && lt(e[r], s, t);
  }
  return e;
}
/**
* @vue/runtime-core v3.5.20
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/
const At = [];
function Ys(e) {
  At.push(e);
}
function qs() {
  At.pop();
}
let zr = !1;
function D(e, ...s) {
  if (zr) return;
  zr = !0, je();
  const t = At.length ? At[At.length - 1].component : null, r = t && t.appContext.config.warnHandler, i = wu();
  if (r)
    Yt(
      r,
      t,
      11,
      [
        // eslint-disable-next-line no-restricted-syntax
        e + s.map((n) => {
          var o, a;
          return (a = (o = n.toString) == null ? void 0 : o.call(n)) != null ? a : JSON.stringify(n);
        }).join(""),
        t && t.proxy,
        i.map(
          ({ vnode: n }) => `at <${Ar(t, n.type)}>`
        ).join(`
`),
        i
      ]
    );
  else {
    const n = [`[Vue warn]: ${e}`, ...s];
    i.length && n.push(`
`, ...xu(i)), console.warn(...n);
  }
  Le(), zr = !1;
}
function wu() {
  let e = At[At.length - 1];
  if (!e)
    return [];
  const s = [];
  for (; e; ) {
    const t = s[0];
    t && t.vnode === e ? t.recurseCount++ : s.push({
      vnode: e,
      recurseCount: 0
    });
    const r = e.component && e.component.parent;
    e = r && r.vnode;
  }
  return s;
}
function xu(e) {
  const s = [];
  return e.forEach((t, r) => {
    s.push(...r === 0 ? [] : [`
`], ...Nu(t));
  }), s;
}
function Nu({ vnode: e, recurseCount: s }) {
  const t = s > 0 ? `... (${s} recursive calls)` : "", r = e.component ? e.component.parent == null : !1, i = ` at <${Ar(
    e.component,
    e.type,
    r
  )}`, n = ">" + t;
  return e.props ? [i, ...Tu(e.props), n] : [i + n];
}
function Tu(e) {
  const s = [], t = Object.keys(e);
  return t.slice(0, 3).forEach((r) => {
    s.push(...Mo(r, e[r]));
  }), t.length > 3 && s.push(" ..."), s;
}
function Mo(e, s, t) {
  return be(s) ? (s = JSON.stringify(s), t ? s : [`${e}=${s}`]) : typeof s == "number" || typeof s == "boolean" || s == null ? t ? s : [`${e}=${s}`] : fe(s) ? (s = Mo(e, H(s.value), !0), t ? s : [`${e}=Ref<`, s, ">"]) : L(s) ? [`${e}=fn${s.name ? `<${s.name}>` : ""}`] : (s = H(s), t ? s : [`${e}=`, s]);
}
const Ci = {
  sp: "serverPrefetch hook",
  bc: "beforeCreate hook",
  c: "created hook",
  bm: "beforeMount hook",
  m: "mounted hook",
  bu: "beforeUpdate hook",
  u: "updated",
  bum: "beforeUnmount hook",
  um: "unmounted hook",
  a: "activated hook",
  da: "deactivated hook",
  ec: "errorCaptured hook",
  rtc: "renderTracked hook",
  rtg: "renderTriggered hook",
  0: "setup function",
  1: "render function",
  2: "watcher getter",
  3: "watcher callback",
  4: "watcher cleanup function",
  5: "native event handler",
  6: "component event handler",
  7: "vnode hook",
  8: "directive hook",
  9: "transition hook",
  10: "app errorHandler",
  11: "app warnHandler",
  12: "ref function",
  13: "async component loader",
  14: "scheduler flush",
  15: "component update",
  16: "app unmount cleanup function"
};
function Yt(e, s, t, r) {
  try {
    return r ? e(...r) : e();
  } catch (i) {
    Is(i, s, t);
  }
}
function tt(e, s, t, r) {
  if (L(e)) {
    const i = Yt(e, s, t, r);
    return i && yi(i) && i.catch((n) => {
      Is(n, s, t);
    }), i;
  }
  if (j(e)) {
    const i = [];
    for (let n = 0; n < e.length; n++)
      i.push(tt(e[n], s, t, r));
    return i;
  } else process.env.NODE_ENV !== "production" && D(
    `Invalid value type passed to callWithAsyncErrorHandling(): ${typeof e}`
  );
}
function Is(e, s, t, r = !0) {
  const i = s ? s.vnode : null, { errorHandler: n, throwUnhandledErrorInProduction: o } = s && s.appContext.config || ee;
  if (s) {
    let a = s.parent;
    const c = s.proxy, l = process.env.NODE_ENV !== "production" ? Ci[t] : `https://vuejs.org/error-reference/#runtime-${t}`;
    for (; a; ) {
      const f = a.ec;
      if (f) {
        for (let h = 0; h < f.length; h++)
          if (f[h](e, c, l) === !1)
            return;
      }
      a = a.parent;
    }
    if (n) {
      je(), Yt(n, null, 10, [
        e,
        c,
        l
      ]), Le();
      return;
    }
  }
  Ou(e, t, i, r, o);
}
function Ou(e, s, t, r = !0, i = !1) {
  if (process.env.NODE_ENV !== "production") {
    const n = Ci[s];
    if (t && Ys(t), D(`Unhandled error${n ? ` during execution of ${n}` : ""}`), t && qs(), r)
      throw e;
    console.error(e);
  } else {
    if (i)
      throw e;
    console.error(e);
  }
}
const Ee = [];
let We = -1;
const Lt = [];
let at = null, Ut = 0;
const $o = /* @__PURE__ */ Promise.resolve();
let cr = null;
const Au = 100;
function Su(e) {
  const s = cr || $o;
  return e ? s.then(this ? e.bind(this) : e) : s;
}
function Du(e) {
  let s = We + 1, t = Ee.length;
  for (; s < t; ) {
    const r = s + t >>> 1, i = Ee[r], n = Os(i);
    n < e || n === e && i.flags & 2 ? s = r + 1 : t = r;
  }
  return s;
}
function Nr(e) {
  if (!(e.flags & 1)) {
    const s = Os(e), t = Ee[Ee.length - 1];
    !t || // fast path when the job id is larger than the tail
    !(e.flags & 2) && s >= Os(t) ? Ee.push(e) : Ee.splice(Du(s), 0, e), e.flags |= 1, Fo();
  }
}
function Fo() {
  cr || (cr = $o.then(jo));
}
function Uo(e) {
  j(e) ? Lt.push(...e) : at && e.id === -1 ? at.splice(Ut + 1, 0, e) : e.flags & 1 || (Lt.push(e), e.flags |= 1), Fo();
}
function Pn(e, s, t = We + 1) {
  for (process.env.NODE_ENV !== "production" && (s = s || /* @__PURE__ */ new Map()); t < Ee.length; t++) {
    const r = Ee[t];
    if (r && r.flags & 2) {
      if (e && r.id !== e.uid || process.env.NODE_ENV !== "production" && Ii(s, r))
        continue;
      Ee.splice(t, 1), t--, r.flags & 4 && (r.flags &= -2), r(), r.flags & 4 || (r.flags &= -2);
    }
  }
}
function ko(e) {
  if (Lt.length) {
    const s = [...new Set(Lt)].sort(
      (t, r) => Os(t) - Os(r)
    );
    if (Lt.length = 0, at) {
      at.push(...s);
      return;
    }
    for (at = s, process.env.NODE_ENV !== "production" && (e = e || /* @__PURE__ */ new Map()), Ut = 0; Ut < at.length; Ut++) {
      const t = at[Ut];
      process.env.NODE_ENV !== "production" && Ii(e, t) || (t.flags & 4 && (t.flags &= -2), t.flags & 8 || t(), t.flags &= -2);
    }
    at = null, Ut = 0;
  }
}
const Os = (e) => e.id == null ? e.flags & 2 ? -1 : 1 / 0 : e.id;
function jo(e) {
  process.env.NODE_ENV !== "production" && (e = e || /* @__PURE__ */ new Map());
  const s = process.env.NODE_ENV !== "production" ? (t) => Ii(e, t) : pe;
  try {
    for (We = 0; We < Ee.length; We++) {
      const t = Ee[We];
      if (t && !(t.flags & 8)) {
        if (process.env.NODE_ENV !== "production" && s(t))
          continue;
        t.flags & 4 && (t.flags &= -2), Yt(
          t,
          t.i,
          t.i ? 15 : 14
        ), t.flags & 4 || (t.flags &= -2);
      }
    }
  } finally {
    for (; We < Ee.length; We++) {
      const t = Ee[We];
      t && (t.flags &= -2);
    }
    We = -1, Ee.length = 0, ko(e), cr = null, (Ee.length || Lt.length) && jo(e);
  }
}
function Ii(e, s) {
  const t = e.get(s) || 0;
  if (t > Au) {
    const r = s.i, i = r && ba(r.type);
    return Is(
      `Maximum recursive updates exceeded${i ? ` in component <${i}>` : ""}. This means you have a reactive effect that is mutating its own dependencies and thus recursively triggering itself. Possible sources include component template, render function, updated hook or watcher source function.`,
      null,
      10
    ), !0;
  }
  return e.set(s, t + 1), !1;
}
let Ge = !1;
const Gs = /* @__PURE__ */ new Map();
process.env.NODE_ENV !== "production" && (Cs().__VUE_HMR_RUNTIME__ = {
  createRecord: Vr(Lo),
  rerender: Vr(Iu),
  reload: Vr(Pu)
});
const Rt = /* @__PURE__ */ new Map();
function Ru(e) {
  const s = e.type.__hmrId;
  let t = Rt.get(s);
  t || (Lo(s, e.type), t = Rt.get(s)), t.instances.add(e);
}
function Cu(e) {
  Rt.get(e.type.__hmrId).instances.delete(e);
}
function Lo(e, s) {
  return Rt.has(e) ? !1 : (Rt.set(e, {
    initialDef: lr(s),
    instances: /* @__PURE__ */ new Set()
  }), !0);
}
function lr(e) {
  return _a(e) ? e.__vccOpts : e;
}
function Iu(e, s) {
  const t = Rt.get(e);
  t && (t.initialDef.render = s, [...t.instances].forEach((r) => {
    s && (r.render = s, lr(r.type).render = s), r.renderCache = [], Ge = !0, r.job.flags & 8 || r.update(), Ge = !1;
  }));
}
function Pu(e, s) {
  const t = Rt.get(e);
  if (!t) return;
  s = lr(s), Mn(t.initialDef, s);
  const r = [...t.instances];
  for (let i = 0; i < r.length; i++) {
    const n = r[i], o = lr(n.type);
    let a = Gs.get(o);
    a || (o !== t.initialDef && Mn(o, s), Gs.set(o, a = /* @__PURE__ */ new Set())), a.add(n), n.appContext.propsCache.delete(n.type), n.appContext.emitsCache.delete(n.type), n.appContext.optionsCache.delete(n.type), n.ceReload ? (a.add(n), n.ceReload(s.styles), a.delete(n)) : n.parent ? Nr(() => {
      Ge = !0, n.parent.update(), Ge = !1, a.delete(n);
    }) : n.appContext.reload ? n.appContext.reload() : typeof window < "u" ? window.location.reload() : console.warn(
      "[HMR] Root or manually mounted instance modified. Full reload required."
    ), n.root.ce && n !== n.root && n.root.ce._removeChildStyle(o);
  }
  Uo(() => {
    Gs.clear();
  });
}
function Mn(e, s) {
  ue(e, s);
  for (const t in e)
    t !== "__file" && !(t in s) && delete e[t];
}
function Vr(e) {
  return (s, t) => {
    try {
      return e(s, t);
    } catch (r) {
      console.error(r), console.warn(
        "[HMR] Something went wrong during Vue component hot-reload. Full reload required."
      );
    }
  };
}
let Pe, os = [], ci = !1;
function Ps(e, ...s) {
  Pe ? Pe.emit(e, ...s) : ci || os.push({ event: e, args: s });
}
function Pi(e, s) {
  var t, r;
  Pe = e, Pe ? (Pe.enabled = !0, os.forEach(({ event: i, args: n }) => Pe.emit(i, ...n)), os = []) : /* handle late devtools injection - only do this if we are in an actual */ /* browser environment to avoid the timer handle stalling test runner exit */ /* (#4815) */ typeof window < "u" && // some envs mock window but not fully
  window.HTMLElement && // also exclude jsdom
  // eslint-disable-next-line no-restricted-syntax
  !((r = (t = window.navigator) == null ? void 0 : t.userAgent) != null && r.includes("jsdom")) ? ((s.__VUE_DEVTOOLS_HOOK_REPLAY__ = s.__VUE_DEVTOOLS_HOOK_REPLAY__ || []).push((n) => {
    Pi(n, s);
  }), setTimeout(() => {
    Pe || (s.__VUE_DEVTOOLS_HOOK_REPLAY__ = null, ci = !0, os = []);
  }, 3e3)) : (ci = !0, os = []);
}
function Mu(e, s) {
  Ps("app:init", e, s, {
    Fragment: Xe,
    Text: Ms,
    Comment: Fe,
    Static: Qs
  });
}
function $u(e) {
  Ps("app:unmount", e);
}
const Fu = /* @__PURE__ */ Mi(
  "component:added"
  /* COMPONENT_ADDED */
), Bo = /* @__PURE__ */ Mi(
  "component:updated"
  /* COMPONENT_UPDATED */
), Uu = /* @__PURE__ */ Mi(
  "component:removed"
  /* COMPONENT_REMOVED */
), ku = (e) => {
  Pe && typeof Pe.cleanupBuffer == "function" && // remove the component if it wasn't buffered
  !Pe.cleanupBuffer(e) && Uu(e);
};
/*! #__NO_SIDE_EFFECTS__ */
// @__NO_SIDE_EFFECTS__
function Mi(e) {
  return (s) => {
    Ps(
      e,
      s.appContext.app,
      s.uid,
      s.parent ? s.parent.uid : void 0,
      s
    );
  };
}
const ju = /* @__PURE__ */ Ho(
  "perf:start"
  /* PERFORMANCE_START */
), Lu = /* @__PURE__ */ Ho(
  "perf:end"
  /* PERFORMANCE_END */
);
function Ho(e) {
  return (s, t, r) => {
    Ps(e, s.appContext.app, s.uid, s, t, r);
  };
}
function Bu(e, s, t) {
  Ps(
    "component:emit",
    e.appContext.app,
    e,
    s,
    t
  );
}
let Re = null, zo = null;
function hr(e) {
  const s = Re;
  return Re = e, zo = e && e.type.__scopeId || null, s;
}
function Hu(e, s = Re, t) {
  if (!s || e._n)
    return e;
  const r = (...i) => {
    r._d && Xn(-1);
    const n = hr(s);
    let o;
    try {
      o = e(...i);
    } finally {
      hr(n), r._d && Xn(1);
    }
    return process.env.NODE_ENV !== "production" && Bo(s), o;
  };
  return r._n = !0, r._c = !0, r._d = !0, r;
}
function Vo(e) {
  Lf(e) && D("Do not use built-in directive ids as custom directive id: " + e);
}
function bt(e, s, t, r) {
  const i = e.dirs, n = s && s.dirs;
  for (let o = 0; o < i.length; o++) {
    const a = i[o];
    n && (a.oldValue = n[o].value);
    let c = a.dir[r];
    c && (je(), tt(c, t, 8, [
      e.el,
      a,
      e,
      s
    ]), Le());
  }
}
const zu = Symbol("_vte"), Vu = (e) => e.__isTeleport, Ku = Symbol("_leaveCb");
function $i(e, s) {
  e.shapeFlag & 6 && e.component ? (e.transition = s, $i(e.component.subTree, s)) : e.shapeFlag & 128 ? (e.ssContent.transition = s.clone(e.ssContent), e.ssFallback.transition = s.clone(e.ssFallback)) : e.transition = s;
}
/*! #__NO_SIDE_EFFECTS__ */
// @__NO_SIDE_EFFECTS__
function Wu(e, s) {
  return L(e) ? (
    // #8236: extend call and options.name access are considered side-effects
    // by Rollup, so we have to wrap it in a pure-annotated IIFE.
    ue({ name: e.name }, s, { setup: e })
  ) : e;
}
function Ko(e) {
  e.ids = [e.ids[0] + e.ids[2]++ + "-", 0, 0];
}
const $n = /* @__PURE__ */ new WeakSet();
function gs(e, s, t, r, i = !1) {
  if (j(e)) {
    e.forEach(
      (_, x) => gs(
        _,
        s && (j(s) ? s[x] : s),
        t,
        r,
        i
      )
    );
    return;
  }
  if (ms(r) && !i) {
    r.shapeFlag & 512 && r.type.__asyncResolved && r.component.subTree.component && gs(e, s, t, r.component.subTree);
    return;
  }
  const n = r.shapeFlag & 4 ? zi(r.component) : r.el, o = i ? null : n, { i: a, r: c } = e;
  if (process.env.NODE_ENV !== "production" && !a) {
    D(
      "Missing ref owner context. ref cannot be used on hoisted vnodes. A vnode with ref must be created inside the render function."
    );
    return;
  }
  const l = s && s.r, f = a.refs === ee ? a.refs = {} : a.refs, h = a.setupState, p = H(h), m = h === ee ? po : (_) => process.env.NODE_ENV !== "production" && (X(p, _) && !fe(p[_]) && D(
    `Template ref "${_}" used on a non-ref value. It will not work in the production build.`
  ), $n.has(p[_])) ? !1 : X(p, _), v = (_) => process.env.NODE_ENV === "production" || !$n.has(_);
  if (l != null && l !== c) {
    if (be(l))
      f[l] = null, m(l) && (h[l] = null);
    else if (fe(l)) {
      v(l) && (l.value = null);
      const _ = s;
      _.k && (f[_.k] = null);
    }
  }
  if (L(c))
    Yt(c, a, 12, [o, f]);
  else {
    const _ = be(c), x = fe(c);
    if (_ || x) {
      const I = () => {
        if (e.f) {
          const M = _ ? m(c) ? h[c] : f[c] : v(c) || !e.k ? c.value : f[e.k];
          if (i)
            j(M) && _i(M, n);
          else if (j(M))
            M.includes(n) || M.push(n);
          else if (_)
            f[c] = [n], m(c) && (h[c] = f[c]);
          else {
            const N = [n];
            v(c) && (c.value = N), e.k && (f[e.k] = N);
          }
        } else _ ? (f[c] = o, m(c) && (h[c] = o)) : x ? (v(c) && (c.value = o), e.k && (f[e.k] = o)) : process.env.NODE_ENV !== "production" && D("Invalid template ref type:", c, `(${typeof c})`);
      };
      o ? (I.id = -1, Ae(I, t)) : I();
    } else process.env.NODE_ENV !== "production" && D("Invalid template ref type:", c, `(${typeof c})`);
  }
}
Cs().requestIdleCallback;
Cs().cancelIdleCallback;
const ms = (e) => !!e.type.__asyncLoader, Fi = (e) => e.type.__isKeepAlive;
function Xu(e, s) {
  Wo(e, "a", s);
}
function Yu(e, s) {
  Wo(e, "da", s);
}
function Wo(e, s, t = ge) {
  const r = e.__wdc || (e.__wdc = () => {
    let i = t;
    for (; i; ) {
      if (i.isDeactivated)
        return;
      i = i.parent;
    }
    return e();
  });
  if (Tr(s, r, t), t) {
    let i = t.parent;
    for (; i && i.parent; )
      Fi(i.parent.vnode) && qu(r, s, t, i), i = i.parent;
  }
}
function qu(e, s, t, r) {
  const i = Tr(
    s,
    e,
    r,
    !0
    /* prepend */
  );
  qt(() => {
    _i(r[s], i);
  }, t);
}
function Tr(e, s, t = ge, r = !1) {
  if (t) {
    const i = t[e] || (t[e] = []), n = s.__weh || (s.__weh = (...o) => {
      je();
      const a = $s(t), c = tt(s, t, e, o);
      return a(), Le(), c;
    });
    return r ? i.unshift(n) : i.push(n), n;
  } else if (process.env.NODE_ENV !== "production") {
    const i = yt(Ci[e].replace(/ hook$/, ""));
    D(
      `${i} is called when there is no active component instance to be associated with. Lifecycle injection APIs can only be used during execution of setup(). If you are using async setup(), make sure to register lifecycle hooks before the first await statement.`
    );
  }
}
const rt = (e) => (s, t = ge) => {
  (!As || e === "sp") && Tr(e, (...r) => s(...r), t);
}, Gu = rt("bm"), Xo = rt("m"), Ju = rt(
  "bu"
), Zu = rt("u"), Qu = rt(
  "bum"
), qt = rt("um"), ed = rt(
  "sp"
), td = rt("rtg"), sd = rt("rtc");
function rd(e, s = ge) {
  Tr("ec", e, s);
}
const id = Symbol.for("v-ndc"), li = (e) => e ? ma(e) ? zi(e) : li(e.parent) : null, St = (
  // Move PURE marker to new line to workaround compiler discarding it
  // due to type annotation
  /* @__PURE__ */ ue(/* @__PURE__ */ Object.create(null), {
    $: (e) => e,
    $el: (e) => e.vnode.el,
    $data: (e) => e.data,
    $props: (e) => process.env.NODE_ENV !== "production" ? qe(e.props) : e.props,
    $attrs: (e) => process.env.NODE_ENV !== "production" ? qe(e.attrs) : e.attrs,
    $slots: (e) => process.env.NODE_ENV !== "production" ? qe(e.slots) : e.slots,
    $refs: (e) => process.env.NODE_ENV !== "production" ? qe(e.refs) : e.refs,
    $parent: (e) => li(e.parent),
    $root: (e) => li(e.root),
    $host: (e) => e.ce,
    $emit: (e) => e.emit,
    $options: (e) => Go(e),
    $forceUpdate: (e) => e.f || (e.f = () => {
      Nr(e.update);
    }),
    $nextTick: (e) => e.n || (e.n = Su.bind(e.proxy)),
    $watch: (e) => Ud.bind(e)
  })
), Ui = (e) => e === "_" || e === "$", Kr = (e, s) => e !== ee && !e.__isScriptSetup && X(e, s), Yo = {
  get({ _: e }, s) {
    if (s === "__v_skip")
      return !0;
    const { ctx: t, setupState: r, data: i, props: n, accessCache: o, type: a, appContext: c } = e;
    if (process.env.NODE_ENV !== "production" && s === "__isVue")
      return !0;
    let l;
    if (s[0] !== "$") {
      const m = o[s];
      if (m !== void 0)
        switch (m) {
          case 1:
            return r[s];
          case 2:
            return i[s];
          case 4:
            return t[s];
          case 3:
            return n[s];
        }
      else {
        if (Kr(r, s))
          return o[s] = 1, r[s];
        if (i !== ee && X(i, s))
          return o[s] = 2, i[s];
        if (
          // only cache other properties when instance has declared (thus stable)
          // props
          (l = e.propsOptions[0]) && X(l, s)
        )
          return o[s] = 3, n[s];
        if (t !== ee && X(t, s))
          return o[s] = 4, t[s];
        hi && (o[s] = 0);
      }
    }
    const f = St[s];
    let h, p;
    if (f)
      return s === "$attrs" ? (he(e.attrs, "get", ""), process.env.NODE_ENV !== "production" && dr()) : process.env.NODE_ENV !== "production" && s === "$slots" && he(e, "get", s), f(e);
    if (
      // css module (injected by vue-loader)
      (h = a.__cssModules) && (h = h[s])
    )
      return h;
    if (t !== ee && X(t, s))
      return o[s] = 4, t[s];
    if (
      // global properties
      p = c.config.globalProperties, X(p, s)
    )
      return p[s];
    process.env.NODE_ENV !== "production" && Re && (!be(s) || // #1091 avoid internal isRef/isVNode checks on component instance leading
    // to infinite warning loop
    s.indexOf("__v") !== 0) && (i !== ee && Ui(s[0]) && X(i, s) ? D(
      `Property ${JSON.stringify(
        s
      )} must be accessed via $data because it starts with a reserved character ("$" or "_") and is not proxied on the render context.`
    ) : e === Re && D(
      `Property ${JSON.stringify(s)} was accessed during render but is not defined on instance.`
    ));
  },
  set({ _: e }, s, t) {
    const { data: r, setupState: i, ctx: n } = e;
    return Kr(i, s) ? (i[s] = t, !0) : process.env.NODE_ENV !== "production" && i.__isScriptSetup && X(i, s) ? (D(`Cannot mutate <script setup> binding "${s}" from Options API.`), !1) : r !== ee && X(r, s) ? (r[s] = t, !0) : X(e.props, s) ? (process.env.NODE_ENV !== "production" && D(`Attempting to mutate prop "${s}". Props are readonly.`), !1) : s[0] === "$" && s.slice(1) in e ? (process.env.NODE_ENV !== "production" && D(
      `Attempting to mutate public property "${s}". Properties starting with $ are reserved and readonly.`
    ), !1) : (process.env.NODE_ENV !== "production" && s in e.appContext.config.globalProperties ? Object.defineProperty(n, s, {
      enumerable: !0,
      configurable: !0,
      value: t
    }) : n[s] = t, !0);
  },
  has({
    _: { data: e, setupState: s, accessCache: t, ctx: r, appContext: i, propsOptions: n, type: o }
  }, a) {
    let c, l;
    return !!(t[a] || e !== ee && a[0] !== "$" && X(e, a) || Kr(s, a) || (c = n[0]) && X(c, a) || X(r, a) || X(St, a) || X(i.config.globalProperties, a) || (l = o.__cssModules) && l[a]);
  },
  defineProperty(e, s, t) {
    return t.get != null ? e._.accessCache[s] = 0 : X(t, "value") && this.set(e, s, t.value, null), Reflect.defineProperty(e, s, t);
  }
};
process.env.NODE_ENV !== "production" && (Yo.ownKeys = (e) => (D(
  "Avoid app logic that relies on enumerating keys on a component instance. The keys will be empty in production mode to avoid performance overhead."
), Reflect.ownKeys(e)));
function nd(e) {
  const s = {};
  return Object.defineProperty(s, "_", {
    configurable: !0,
    enumerable: !1,
    get: () => e
  }), Object.keys(St).forEach((t) => {
    Object.defineProperty(s, t, {
      configurable: !0,
      enumerable: !1,
      get: () => St[t](e),
      // intercepted by the proxy so no need for implementation,
      // but needed to prevent set errors
      set: pe
    });
  }), s;
}
function od(e) {
  const {
    ctx: s,
    propsOptions: [t]
  } = e;
  t && Object.keys(t).forEach((r) => {
    Object.defineProperty(s, r, {
      enumerable: !0,
      configurable: !0,
      get: () => e.props[r],
      set: pe
    });
  });
}
function ad(e) {
  const { ctx: s, setupState: t } = e;
  Object.keys(H(t)).forEach((r) => {
    if (!t.__isScriptSetup) {
      if (Ui(r[0])) {
        D(
          `setup() return property ${JSON.stringify(
            r
          )} should not start with "$" or "_" which are reserved prefixes for Vue internals.`
        );
        return;
      }
      Object.defineProperty(s, r, {
        enumerable: !0,
        configurable: !0,
        get: () => t[r],
        set: pe
      });
    }
  });
}
function Fn(e) {
  return j(e) ? e.reduce(
    (s, t) => (s[t] = null, s),
    {}
  ) : e;
}
function cd() {
  const e = /* @__PURE__ */ Object.create(null);
  return (s, t) => {
    e[t] ? D(`${s} property "${t}" is already defined in ${e[t]}.`) : e[t] = s;
  };
}
let hi = !0;
function ld(e) {
  const s = Go(e), t = e.proxy, r = e.ctx;
  hi = !1, s.beforeCreate && Un(s.beforeCreate, e, "bc");
  const {
    // state
    data: i,
    computed: n,
    methods: o,
    watch: a,
    provide: c,
    inject: l,
    // lifecycle
    created: f,
    beforeMount: h,
    mounted: p,
    beforeUpdate: m,
    updated: v,
    activated: _,
    deactivated: x,
    beforeDestroy: I,
    beforeUnmount: M,
    destroyed: N,
    unmounted: $,
    render: w,
    renderTracked: P,
    renderTriggered: Y,
    errorCaptured: V,
    serverPrefetch: Z,
    // public API
    expose: ae,
    inheritAttrs: ce,
    // assets
    components: oe,
    directives: me,
    filters: te
  } = s, we = process.env.NODE_ENV !== "production" ? cd() : null;
  if (process.env.NODE_ENV !== "production") {
    const [K] = e.propsOptions;
    if (K)
      for (const z in K)
        we("Props", z);
  }
  if (l && hd(l, r, we), o)
    for (const K in o) {
      const z = o[K];
      L(z) ? (process.env.NODE_ENV !== "production" ? Object.defineProperty(r, K, {
        value: z.bind(t),
        configurable: !0,
        enumerable: !0,
        writable: !0
      }) : r[K] = z.bind(t), process.env.NODE_ENV !== "production" && we("Methods", K)) : process.env.NODE_ENV !== "production" && D(
        `Method "${K}" has type "${typeof z}" in the component definition. Did you reference the function correctly?`
      );
    }
  if (i) {
    process.env.NODE_ENV !== "production" && !L(i) && D(
      "The data option must be a function. Plain object usage is no longer supported."
    );
    const K = i.call(t, t);
    if (process.env.NODE_ENV !== "production" && yi(K) && D(
      "data() returned a Promise - note data() cannot be async; If you intend to perform data fetching before component renders, use async setup() + <Suspense>."
    ), !re(K))
      process.env.NODE_ENV !== "production" && D("data() should return an object.");
    else if (e.data = Ri(K), process.env.NODE_ENV !== "production")
      for (const z in K)
        we("Data", z), Ui(z[0]) || Object.defineProperty(r, z, {
          configurable: !0,
          enumerable: !0,
          get: () => K[z],
          set: pe
        });
  }
  if (hi = !0, n)
    for (const K in n) {
      const z = n[K], Be = L(z) ? z.bind(t, t) : L(z.get) ? z.get.bind(t, t) : pe;
      process.env.NODE_ENV !== "production" && Be === pe && D(`Computed property "${K}" has no getter.`);
      const Dr = !L(z) && L(z.set) ? z.set.bind(t) : process.env.NODE_ENV !== "production" ? () => {
        D(
          `Write operation failed: computed property "${K}" is readonly.`
        );
      } : pe, Gt = ap({
        get: Be,
        set: Dr
      });
      Object.defineProperty(r, K, {
        enumerable: !0,
        configurable: !0,
        get: () => Gt.value,
        set: (Pt) => Gt.value = Pt
      }), process.env.NODE_ENV !== "production" && we("Computed", K);
    }
  if (a)
    for (const K in a)
      qo(a[K], r, t, K);
  if (c) {
    const K = L(c) ? c.call(t) : c;
    Reflect.ownKeys(K).forEach((z) => {
      md(z, K[z]);
    });
  }
  f && Un(f, e, "c");
  function xe(K, z) {
    j(z) ? z.forEach((Be) => K(Be.bind(t))) : z && K(z.bind(t));
  }
  if (xe(Gu, h), xe(Xo, p), xe(Ju, m), xe(Zu, v), xe(Xu, _), xe(Yu, x), xe(rd, V), xe(sd, P), xe(td, Y), xe(Qu, M), xe(qt, $), xe(ed, Z), j(ae))
    if (ae.length) {
      const K = e.exposed || (e.exposed = {});
      ae.forEach((z) => {
        Object.defineProperty(K, z, {
          get: () => t[z],
          set: (Be) => t[z] = Be,
          enumerable: !0
        });
      });
    } else e.exposed || (e.exposed = {});
  w && e.render === pe && (e.render = w), ce != null && (e.inheritAttrs = ce), oe && (e.components = oe), me && (e.directives = me), Z && Ko(e);
}
function hd(e, s, t = pe) {
  j(e) && (e = fi(e));
  for (const r in e) {
    const i = e[r];
    let n;
    re(i) ? "default" in i ? n = Js(
      i.from || r,
      i.default,
      !0
    ) : n = Js(i.from || r) : n = Js(i), fe(n) ? Object.defineProperty(s, r, {
      enumerable: !0,
      configurable: !0,
      get: () => n.value,
      set: (o) => n.value = o
    }) : s[r] = n, process.env.NODE_ENV !== "production" && t("Inject", r);
  }
}
function Un(e, s, t) {
  tt(
    j(e) ? e.map((r) => r.bind(s.proxy)) : e.bind(s.proxy),
    s,
    t
  );
}
function qo(e, s, t, r) {
  let i = r.includes(".") ? ca(t, r) : () => t[r];
  if (be(e)) {
    const n = s[e];
    L(n) ? Xr(i, n) : process.env.NODE_ENV !== "production" && D(`Invalid watch handler specified by key "${e}"`, n);
  } else if (L(e))
    Xr(i, e.bind(t));
  else if (re(e))
    if (j(e))
      e.forEach((n) => qo(n, s, t, r));
    else {
      const n = L(e.handler) ? e.handler.bind(t) : s[e.handler];
      L(n) ? Xr(i, n, e) : process.env.NODE_ENV !== "production" && D(`Invalid watch handler specified by key "${e.handler}"`, n);
    }
  else process.env.NODE_ENV !== "production" && D(`Invalid watch option: "${r}"`, e);
}
function Go(e) {
  const s = e.type, { mixins: t, extends: r } = s, {
    mixins: i,
    optionsCache: n,
    config: { optionMergeStrategies: o }
  } = e.appContext, a = n.get(s);
  let c;
  return a ? c = a : !i.length && !t && !r ? c = s : (c = {}, i.length && i.forEach(
    (l) => fr(c, l, o, !0)
  ), fr(c, s, o)), re(s) && n.set(s, c), c;
}
function fr(e, s, t, r = !1) {
  const { mixins: i, extends: n } = s;
  n && fr(e, n, t, !0), i && i.forEach(
    (o) => fr(e, o, t, !0)
  );
  for (const o in s)
    if (r && o === "expose")
      process.env.NODE_ENV !== "production" && D(
        '"expose" option is ignored when declared in mixins or extends. It should only be declared in the base component itself.'
      );
    else {
      const a = fd[o] || t && t[o];
      e[o] = a ? a(e[o], s[o]) : s[o];
    }
  return e;
}
const fd = {
  data: kn,
  props: jn,
  emits: jn,
  // objects
  methods: as,
  computed: as,
  // lifecycle
  beforeCreate: ye,
  created: ye,
  beforeMount: ye,
  mounted: ye,
  beforeUpdate: ye,
  updated: ye,
  beforeDestroy: ye,
  beforeUnmount: ye,
  destroyed: ye,
  unmounted: ye,
  activated: ye,
  deactivated: ye,
  errorCaptured: ye,
  serverPrefetch: ye,
  // assets
  components: as,
  directives: as,
  // watch
  watch: dd,
  // provide / inject
  provide: kn,
  inject: ud
};
function kn(e, s) {
  return s ? e ? function() {
    return ue(
      L(e) ? e.call(this, this) : e,
      L(s) ? s.call(this, this) : s
    );
  } : s : e;
}
function ud(e, s) {
  return as(fi(e), fi(s));
}
function fi(e) {
  if (j(e)) {
    const s = {};
    for (let t = 0; t < e.length; t++)
      s[e[t]] = e[t];
    return s;
  }
  return e;
}
function ye(e, s) {
  return e ? [...new Set([].concat(e, s))] : s;
}
function as(e, s) {
  return e ? ue(/* @__PURE__ */ Object.create(null), e, s) : s;
}
function jn(e, s) {
  return e ? j(e) && j(s) ? [.../* @__PURE__ */ new Set([...e, ...s])] : ue(
    /* @__PURE__ */ Object.create(null),
    Fn(e),
    Fn(s ?? {})
  ) : s;
}
function dd(e, s) {
  if (!e) return s;
  if (!s) return e;
  const t = ue(/* @__PURE__ */ Object.create(null), e);
  for (const r in s)
    t[r] = ye(e[r], s[r]);
  return t;
}
function Jo() {
  return {
    app: null,
    config: {
      isNativeTag: po,
      performance: !1,
      globalProperties: {},
      optionMergeStrategies: {},
      errorHandler: void 0,
      warnHandler: void 0,
      compilerOptions: {}
    },
    mixins: [],
    components: {},
    directives: {},
    provides: /* @__PURE__ */ Object.create(null),
    optionsCache: /* @__PURE__ */ new WeakMap(),
    propsCache: /* @__PURE__ */ new WeakMap(),
    emitsCache: /* @__PURE__ */ new WeakMap()
  };
}
let pd = 0;
function gd(e, s) {
  return function(r, i = null) {
    L(r) || (r = ue({}, r)), i != null && !re(i) && (process.env.NODE_ENV !== "production" && D("root props passed to app.mount() must be an object."), i = null);
    const n = Jo(), o = /* @__PURE__ */ new WeakSet(), a = [];
    let c = !1;
    const l = n.app = {
      _uid: pd++,
      _component: r,
      _props: i,
      _container: null,
      _context: n,
      _instance: null,
      version: Jn,
      get config() {
        return n.config;
      },
      set config(f) {
        process.env.NODE_ENV !== "production" && D(
          "app.config cannot be replaced. Modify individual options instead."
        );
      },
      use(f, ...h) {
        return o.has(f) ? process.env.NODE_ENV !== "production" && D("Plugin has already been applied to target app.") : f && L(f.install) ? (o.add(f), f.install(l, ...h)) : L(f) ? (o.add(f), f(l, ...h)) : process.env.NODE_ENV !== "production" && D(
          'A plugin must either be a function or an object with an "install" function.'
        ), l;
      },
      mixin(f) {
        return n.mixins.includes(f) ? process.env.NODE_ENV !== "production" && D(
          "Mixin has already been applied to target app" + (f.name ? `: ${f.name}` : "")
        ) : n.mixins.push(f), l;
      },
      component(f, h) {
        return process.env.NODE_ENV !== "production" && mi(f, n.config), h ? (process.env.NODE_ENV !== "production" && n.components[f] && D(`Component "${f}" has already been registered in target app.`), n.components[f] = h, l) : n.components[f];
      },
      directive(f, h) {
        return process.env.NODE_ENV !== "production" && Vo(f), h ? (process.env.NODE_ENV !== "production" && n.directives[f] && D(`Directive "${f}" has already been registered in target app.`), n.directives[f] = h, l) : n.directives[f];
      },
      mount(f, h, p) {
        if (c)
          process.env.NODE_ENV !== "production" && D(
            "App has already been mounted.\nIf you want to remount the same app, move your app creation logic into a factory function and create fresh app instances for each mount - e.g. `const createMyApp = () => createApp(App)`"
          );
        else {
          process.env.NODE_ENV !== "production" && f.__vue_app__ && D(
            "There is already an app instance mounted on the host container.\n If you want to mount another app on the same host container, you need to unmount the previous app by calling `app.unmount()` first."
          );
          const m = l._ceVNode || Me(r, i);
          return m.appContext = n, p === !0 ? p = "svg" : p === !1 && (p = void 0), process.env.NODE_ENV !== "production" && (n.reload = () => {
            const v = gt(m);
            v.el = null, e(v, f, p);
          }), e(m, f, p), c = !0, l._container = f, f.__vue_app__ = l, process.env.NODE_ENV !== "production" && (l._instance = m.component, Mu(l, Jn)), zi(m.component);
        }
      },
      onUnmount(f) {
        process.env.NODE_ENV !== "production" && typeof f != "function" && D(
          `Expected function as first argument to app.onUnmount(), but got ${typeof f}`
        ), a.push(f);
      },
      unmount() {
        c ? (tt(
          a,
          l._instance,
          16
        ), e(null, l._container), process.env.NODE_ENV !== "production" && (l._instance = null, $u(l)), delete l._container.__vue_app__) : process.env.NODE_ENV !== "production" && D("Cannot unmount an app that is not mounted.");
      },
      provide(f, h) {
        return process.env.NODE_ENV !== "production" && f in n.provides && (X(n.provides, f) ? D(
          `App already provides property with key "${String(f)}". It will be overwritten with the new value.`
        ) : D(
          `App already provides property with key "${String(f)}" inherited from its parent element. It will be overwritten with the new value.`
        )), n.provides[f] = h, l;
      },
      runWithContext(f) {
        const h = Bt;
        Bt = l;
        try {
          return f();
        } finally {
          Bt = h;
        }
      }
    };
    return l;
  };
}
let Bt = null;
function md(e, s) {
  if (!ge)
    process.env.NODE_ENV !== "production" && D("provide() can only be used inside setup().");
  else {
    let t = ge.provides;
    const r = ge.parent && ge.parent.provides;
    r === t && (t = ge.provides = Object.create(r)), t[e] = s;
  }
}
function Js(e, s, t = !1) {
  const r = ga();
  if (r || Bt) {
    let i = Bt ? Bt._context.provides : r ? r.parent == null || r.ce ? r.vnode.appContext && r.vnode.appContext.provides : r.parent.provides : void 0;
    if (i && e in i)
      return i[e];
    if (arguments.length > 1)
      return t && L(s) ? s.call(r && r.proxy) : s;
    process.env.NODE_ENV !== "production" && D(`injection "${String(e)}" not found.`);
  } else process.env.NODE_ENV !== "production" && D("inject() can only be used inside setup() or functional components.");
}
const Zo = {}, Qo = () => Object.create(Zo), ea = (e) => Object.getPrototypeOf(e) === Zo;
function vd(e, s, t, r = !1) {
  const i = {}, n = Qo();
  e.propsDefaults = /* @__PURE__ */ Object.create(null), ta(e, s, i, n);
  for (const o in e.propsOptions[0])
    o in i || (i[o] = void 0);
  process.env.NODE_ENV !== "production" && ra(s || {}, i, e), t ? e.props = r ? i : pu(i) : e.type.props ? e.props = i : e.props = n, e.attrs = n;
}
function bd(e) {
  for (; e; ) {
    if (e.type.__hmrId) return !0;
    e = e.parent;
  }
}
function _d(e, s, t, r) {
  const {
    props: i,
    attrs: n,
    vnode: { patchFlag: o }
  } = e, a = H(i), [c] = e.propsOptions;
  let l = !1;
  if (
    // always force full diff in dev
    // - #1942 if hmr is enabled with sfc component
    // - vite#872 non-sfc component used by sfc component
    !(process.env.NODE_ENV !== "production" && bd(e)) && (r || o > 0) && !(o & 16)
  ) {
    if (o & 8) {
      const f = e.vnode.dynamicProps;
      for (let h = 0; h < f.length; h++) {
        let p = f[h];
        if (Or(e.emitsOptions, p))
          continue;
        const m = s[p];
        if (c)
          if (X(n, p))
            m !== n[p] && (n[p] = m, l = !0);
          else {
            const v = et(p);
            i[v] = ui(
              c,
              a,
              v,
              m,
              e,
              !1
            );
          }
        else
          m !== n[p] && (n[p] = m, l = !0);
      }
    }
  } else {
    ta(e, s, i, n) && (l = !0);
    let f;
    for (const h in a)
      (!s || // for camelCase
      !X(s, h) && // it's possible the original props was passed in as kebab-case
      // and converted to camelCase (#955)
      ((f = Vt(h)) === h || !X(s, f))) && (c ? t && // for camelCase
      (t[h] !== void 0 || // for kebab-case
      t[f] !== void 0) && (i[h] = ui(
        c,
        a,
        h,
        void 0,
        e,
        !0
      )) : delete i[h]);
    if (n !== a)
      for (const h in n)
        (!s || !X(s, h)) && (delete n[h], l = !0);
  }
  l && Ye(e.attrs, "set", ""), process.env.NODE_ENV !== "production" && ra(s || {}, i, e);
}
function ta(e, s, t, r) {
  const [i, n] = e.propsOptions;
  let o = !1, a;
  if (s)
    for (let c in s) {
      if (us(c))
        continue;
      const l = s[c];
      let f;
      i && X(i, f = et(c)) ? !n || !n.includes(f) ? t[f] = l : (a || (a = {}))[f] = l : Or(e.emitsOptions, c) || (!(c in r) || l !== r[c]) && (r[c] = l, o = !0);
    }
  if (n) {
    const c = H(t), l = a || ee;
    for (let f = 0; f < n.length; f++) {
      const h = n[f];
      t[h] = ui(
        i,
        c,
        h,
        l[h],
        e,
        !X(l, h)
      );
    }
  }
  return o;
}
function ui(e, s, t, r, i, n) {
  const o = e[t];
  if (o != null) {
    const a = X(o, "default");
    if (a && r === void 0) {
      const c = o.default;
      if (o.type !== Function && !o.skipFactory && L(c)) {
        const { propsDefaults: l } = i;
        if (t in l)
          r = l[t];
        else {
          const f = $s(i);
          r = l[t] = c.call(
            null,
            s
          ), f();
        }
      } else
        r = c;
      i.ce && i.ce._setProp(t, r);
    }
    o[
      0
      /* shouldCast */
    ] && (n && !a ? r = !1 : o[
      1
      /* shouldCastTrue */
    ] && (r === "" || r === Vt(t)) && (r = !0));
  }
  return r;
}
const yd = /* @__PURE__ */ new WeakMap();
function sa(e, s, t = !1) {
  const r = t ? yd : s.propsCache, i = r.get(e);
  if (i)
    return i;
  const n = e.props, o = {}, a = [];
  let c = !1;
  if (!L(e)) {
    const f = (h) => {
      c = !0;
      const [p, m] = sa(h, s, !0);
      ue(o, p), m && a.push(...m);
    };
    !t && s.mixins.length && s.mixins.forEach(f), e.extends && f(e.extends), e.mixins && e.mixins.forEach(f);
  }
  if (!n && !c)
    return re(e) && r.set(e, fs), fs;
  if (j(n))
    for (let f = 0; f < n.length; f++) {
      process.env.NODE_ENV !== "production" && !be(n[f]) && D("props must be strings when using array syntax.", n[f]);
      const h = et(n[f]);
      Ln(h) && (o[h] = ee);
    }
  else if (n) {
    process.env.NODE_ENV !== "production" && !re(n) && D("invalid props options", n);
    for (const f in n) {
      const h = et(f);
      if (Ln(h)) {
        const p = n[f], m = o[h] = j(p) || L(p) ? { type: p } : ue({}, p), v = m.type;
        let _ = !1, x = !0;
        if (j(v))
          for (let I = 0; I < v.length; ++I) {
            const M = v[I], N = L(M) && M.name;
            if (N === "Boolean") {
              _ = !0;
              break;
            } else N === "String" && (x = !1);
          }
        else
          _ = L(v) && v.name === "Boolean";
        m[
          0
          /* shouldCast */
        ] = _, m[
          1
          /* shouldCastTrue */
        ] = x, (_ || X(m, "default")) && a.push(h);
      }
    }
  }
  const l = [o, a];
  return re(e) && r.set(e, l), l;
}
function Ln(e) {
  return e[0] !== "$" && !us(e) ? !0 : (process.env.NODE_ENV !== "production" && D(`Invalid prop name: "${e}" is a reserved property.`), !1);
}
function Ed(e) {
  return e === null ? "null" : typeof e == "function" ? e.name || "" : typeof e == "object" && e.constructor && e.constructor.name || "";
}
function ra(e, s, t) {
  const r = H(s), i = t.propsOptions[0], n = Object.keys(e).map((o) => et(o));
  for (const o in i) {
    let a = i[o];
    a != null && wd(
      o,
      r[o],
      a,
      process.env.NODE_ENV !== "production" ? qe(r) : r,
      !n.includes(o)
    );
  }
}
function wd(e, s, t, r, i) {
  const { type: n, required: o, validator: a, skipCheck: c } = t;
  if (o && i) {
    D('Missing required prop: "' + e + '"');
    return;
  }
  if (!(s == null && !o)) {
    if (n != null && n !== !0 && !c) {
      let l = !1;
      const f = j(n) ? n : [n], h = [];
      for (let p = 0; p < f.length && !l; p++) {
        const { valid: m, expectedType: v } = Nd(s, f[p]);
        h.push(v || ""), l = m;
      }
      if (!l) {
        D(Td(e, s, h));
        return;
      }
    }
    a && !a(s, r) && D('Invalid prop: custom validator check failed for prop "' + e + '".');
  }
}
const xd = /* @__PURE__ */ Ds(
  "String,Number,Boolean,Function,Symbol,BigInt"
);
function Nd(e, s) {
  let t;
  const r = Ed(s);
  if (r === "null")
    t = e === null;
  else if (xd(r)) {
    const i = typeof e;
    t = i === r.toLowerCase(), !t && i === "object" && (t = e instanceof s);
  } else r === "Object" ? t = re(e) : r === "Array" ? t = j(e) : t = e instanceof s;
  return {
    valid: t,
    expectedType: r
  };
}
function Td(e, s, t) {
  if (t.length === 0)
    return `Prop type [] for prop "${e}" won't match anything. Did you mean to use type Array instead?`;
  let r = `Invalid prop: type check failed for prop "${e}". Expected ${t.map(xi).join(" | ")}`;
  const i = t[0], n = Ei(s), o = Bn(s, i), a = Bn(s, n);
  return t.length === 1 && Hn(i) && !Od(i, n) && (r += ` with value ${o}`), r += `, got ${n} `, Hn(n) && (r += `with value ${a}.`), r;
}
function Bn(e, s) {
  return s === "String" ? `"${e}"` : s === "Number" ? `${Number(e)}` : `${e}`;
}
function Hn(e) {
  return ["string", "number", "boolean"].some((t) => e.toLowerCase() === t);
}
function Od(...e) {
  return e.some((s) => s.toLowerCase() === "boolean");
}
const ki = (e) => e === "_" || e === "_ctx" || e === "$stable", ji = (e) => j(e) ? e.map(Ie) : [Ie(e)], Ad = (e, s, t) => {
  if (s._n)
    return s;
  const r = Hu((...i) => (process.env.NODE_ENV !== "production" && ge && !(t === null && Re) && !(t && t.root !== ge.root) && D(
    `Slot "${e}" invoked outside of the render function: this will not track dependencies used in the slot. Invoke the slot function inside the render function instead.`
  ), ji(s(...i))), t);
  return r._c = !1, r;
}, ia = (e, s, t) => {
  const r = e._ctx;
  for (const i in e) {
    if (ki(i)) continue;
    const n = e[i];
    if (L(n))
      s[i] = Ad(i, n, r);
    else if (n != null) {
      process.env.NODE_ENV !== "production" && D(
        `Non-function value encountered for slot "${i}". Prefer function slots for better performance.`
      );
      const o = ji(n);
      s[i] = () => o;
    }
  }
}, na = (e, s) => {
  process.env.NODE_ENV !== "production" && !Fi(e.vnode) && D(
    "Non-function value encountered for default slot. Prefer function slots for better performance."
  );
  const t = ji(s);
  e.slots.default = () => t;
}, di = (e, s, t) => {
  for (const r in s)
    (t || !ki(r)) && (e[r] = s[r]);
}, Sd = (e, s, t) => {
  const r = e.slots = Qo();
  if (e.vnode.shapeFlag & 32) {
    const i = s._;
    i ? (di(r, s, t), t && nr(r, "_", i, !0)) : ia(s, r);
  } else s && na(e, s);
}, Dd = (e, s, t) => {
  const { vnode: r, slots: i } = e;
  let n = !0, o = ee;
  if (r.shapeFlag & 32) {
    const a = s._;
    a ? process.env.NODE_ENV !== "production" && Ge ? (di(i, s, t), Ye(e, "set", "$slots")) : t && a === 1 ? n = !1 : di(i, s, t) : (n = !s.$stable, ia(s, i)), o = s;
  } else s && (na(e, s), o = { default: 1 });
  if (n)
    for (const a in i)
      !ki(a) && o[a] == null && delete i[a];
};
let rs, Qe;
function $t(e, s) {
  e.appContext.config.performance && ur() && Qe.mark(`vue-${s}-${e.uid}`), process.env.NODE_ENV !== "production" && ju(e, s, ur() ? Qe.now() : Date.now());
}
function Ft(e, s) {
  if (e.appContext.config.performance && ur()) {
    const t = `vue-${s}-${e.uid}`, r = t + ":end", i = `<${Ar(e, e.type)}> ${s}`;
    Qe.mark(r), Qe.measure(i, t, r), Qe.clearMeasures(i), Qe.clearMarks(t), Qe.clearMarks(r);
  }
  process.env.NODE_ENV !== "production" && Lu(e, s, ur() ? Qe.now() : Date.now());
}
function ur() {
  return rs !== void 0 || (typeof window < "u" && window.performance ? (rs = !0, Qe = window.performance) : rs = !1), rs;
}
function Rd() {
  const e = [];
  if (process.env.NODE_ENV !== "production" && e.length) {
    const s = e.length > 1;
    console.warn(
      `Feature flag${s ? "s" : ""} ${e.join(", ")} ${s ? "are" : "is"} not explicitly defined. You are running the esm-bundler build of Vue, which expects these compile-time feature flags to be globally injected via the bundler config in order to get better tree-shaking in the production bundle.

For more details, see https://link.vuejs.org/feature-flags.`
    );
  }
}
const Ae = Vd;
function Cd(e) {
  return Id(e);
}
function Id(e, s) {
  Rd();
  const t = Cs();
  t.__VUE__ = !0, process.env.NODE_ENV !== "production" && Pi(t.__VUE_DEVTOOLS_GLOBAL_HOOK__, t);
  const {
    insert: r,
    remove: i,
    patchProp: n,
    createElement: o,
    createText: a,
    createComment: c,
    setText: l,
    setElementText: f,
    parentNode: h,
    nextSibling: p,
    setScopeId: m = pe,
    insertStaticContent: v
  } = e, _ = (u, g, b, T = null, y = null, E = null, R = void 0, S = null, A = process.env.NODE_ENV !== "production" && Ge ? !1 : !!g.dynamicChildren) => {
    if (u === g)
      return;
    u && !is(u, g) && (T = Fs(u), it(u, y, E, !0), u = null), g.patchFlag === -2 && (A = !1, g.dynamicChildren = null);
    const { type: O, ref: U, shapeFlag: C } = g;
    switch (O) {
      case Ms:
        x(u, g, b, T);
        break;
      case Fe:
        I(u, g, b, T);
        break;
      case Qs:
        u == null ? M(g, b, T, R) : process.env.NODE_ENV !== "production" && N(u, g, b, R);
        break;
      case Xe:
        me(
          u,
          g,
          b,
          T,
          y,
          E,
          R,
          S,
          A
        );
        break;
      default:
        C & 1 ? P(
          u,
          g,
          b,
          T,
          y,
          E,
          R,
          S,
          A
        ) : C & 6 ? te(
          u,
          g,
          b,
          T,
          y,
          E,
          R,
          S,
          A
        ) : C & 64 || C & 128 ? O.process(
          u,
          g,
          b,
          T,
          y,
          E,
          R,
          S,
          A,
          Zt
        ) : process.env.NODE_ENV !== "production" && D("Invalid VNode type:", O, `(${typeof O})`);
    }
    U != null && y ? gs(U, u && u.ref, E, g || u, !g) : U == null && u && u.ref != null && gs(u.ref, null, E, u, !0);
  }, x = (u, g, b, T) => {
    if (u == null)
      r(
        g.el = a(g.children),
        b,
        T
      );
    else {
      const y = g.el = u.el;
      g.children !== u.children && l(y, g.children);
    }
  }, I = (u, g, b, T) => {
    u == null ? r(
      g.el = c(g.children || ""),
      b,
      T
    ) : g.el = u.el;
  }, M = (u, g, b, T) => {
    [u.el, u.anchor] = v(
      u.children,
      g,
      b,
      T,
      u.el,
      u.anchor
    );
  }, N = (u, g, b, T) => {
    if (g.children !== u.children) {
      const y = p(u.anchor);
      w(u), [g.el, g.anchor] = v(
        g.children,
        b,
        y,
        T
      );
    } else
      g.el = u.el, g.anchor = u.anchor;
  }, $ = ({ el: u, anchor: g }, b, T) => {
    let y;
    for (; u && u !== g; )
      y = p(u), r(u, b, T), u = y;
    r(g, b, T);
  }, w = ({ el: u, anchor: g }) => {
    let b;
    for (; u && u !== g; )
      b = p(u), i(u), u = b;
    i(g);
  }, P = (u, g, b, T, y, E, R, S, A) => {
    g.type === "svg" ? R = "svg" : g.type === "math" && (R = "mathml"), u == null ? Y(
      g,
      b,
      T,
      y,
      E,
      R,
      S,
      A
    ) : ae(
      u,
      g,
      y,
      E,
      R,
      S,
      A
    );
  }, Y = (u, g, b, T, y, E, R, S) => {
    let A, O;
    const { props: U, shapeFlag: C, transition: F, dirs: k } = u;
    if (A = u.el = o(
      u.type,
      E,
      U && U.is,
      U
    ), C & 8 ? f(A, u.children) : C & 16 && Z(
      u.children,
      A,
      null,
      T,
      y,
      Wr(u, E),
      R,
      S
    ), k && bt(u, null, T, "created"), V(A, u, u.scopeId, R, T), U) {
      for (const se in U)
        se !== "value" && !us(se) && n(A, se, null, U[se], E, T);
      "value" in U && n(A, "value", null, U.value, E), (O = U.onVnodeBeforeMount) && Ke(O, T, u);
    }
    process.env.NODE_ENV !== "production" && (nr(A, "__vnode", u, !0), nr(A, "__vueParentComponent", T, !0)), k && bt(u, null, T, "beforeMount");
    const W = Pd(y, F);
    W && F.beforeEnter(A), r(A, g, b), ((O = U && U.onVnodeMounted) || W || k) && Ae(() => {
      O && Ke(O, T, u), W && F.enter(A), k && bt(u, null, T, "mounted");
    }, y);
  }, V = (u, g, b, T, y) => {
    if (b && m(u, b), T)
      for (let E = 0; E < T.length; E++)
        m(u, T[E]);
    if (y) {
      let E = y.subTree;
      if (process.env.NODE_ENV !== "production" && E.patchFlag > 0 && E.patchFlag & 2048 && (E = Li(E.children) || E), g === E || fa(E.type) && (E.ssContent === g || E.ssFallback === g)) {
        const R = y.vnode;
        V(
          u,
          R,
          R.scopeId,
          R.slotScopeIds,
          y.parent
        );
      }
    }
  }, Z = (u, g, b, T, y, E, R, S, A = 0) => {
    for (let O = A; O < u.length; O++) {
      const U = u[O] = S ? ct(u[O]) : Ie(u[O]);
      _(
        null,
        U,
        g,
        b,
        T,
        y,
        E,
        R,
        S
      );
    }
  }, ae = (u, g, b, T, y, E, R) => {
    const S = g.el = u.el;
    process.env.NODE_ENV !== "production" && (S.__vnode = g);
    let { patchFlag: A, dynamicChildren: O, dirs: U } = g;
    A |= u.patchFlag & 16;
    const C = u.props || ee, F = g.props || ee;
    let k;
    if (b && _t(b, !1), (k = F.onVnodeBeforeUpdate) && Ke(k, b, g, u), U && bt(g, u, b, "beforeUpdate"), b && _t(b, !0), process.env.NODE_ENV !== "production" && Ge && (A = 0, R = !1, O = null), (C.innerHTML && F.innerHTML == null || C.textContent && F.textContent == null) && f(S, ""), O ? (ce(
      u.dynamicChildren,
      O,
      S,
      b,
      T,
      Wr(g, y),
      E
    ), process.env.NODE_ENV !== "production" && Zs(u, g)) : R || Be(
      u,
      g,
      S,
      null,
      b,
      T,
      Wr(g, y),
      E,
      !1
    ), A > 0) {
      if (A & 16)
        oe(S, C, F, b, y);
      else if (A & 2 && C.class !== F.class && n(S, "class", null, F.class, y), A & 4 && n(S, "style", C.style, F.style, y), A & 8) {
        const W = g.dynamicProps;
        for (let se = 0; se < W.length; se++) {
          const Q = W[se], Ne = C[Q], Te = F[Q];
          (Te !== Ne || Q === "value") && n(S, Q, Ne, Te, y, b);
        }
      }
      A & 1 && u.children !== g.children && f(S, g.children);
    } else !R && O == null && oe(S, C, F, b, y);
    ((k = F.onVnodeUpdated) || U) && Ae(() => {
      k && Ke(k, b, g, u), U && bt(g, u, b, "updated");
    }, T);
  }, ce = (u, g, b, T, y, E, R) => {
    for (let S = 0; S < g.length; S++) {
      const A = u[S], O = g[S], U = (
        // oldVNode may be an errored async setup() component inside Suspense
        // which will not have a mounted element
        A.el && // - In the case of a Fragment, we need to provide the actual parent
        // of the Fragment itself so it can move its children.
        (A.type === Xe || // - In the case of different nodes, there is going to be a replacement
        // which also requires the correct parent container
        !is(A, O) || // - In the case of a component, it could contain anything.
        A.shapeFlag & 198) ? h(A.el) : (
          // In other cases, the parent container is not actually used so we
          // just pass the block element here to avoid a DOM parentNode call.
          b
        )
      );
      _(
        A,
        O,
        U,
        null,
        T,
        y,
        E,
        R,
        !0
      );
    }
  }, oe = (u, g, b, T, y) => {
    if (g !== b) {
      if (g !== ee)
        for (const E in g)
          !us(E) && !(E in b) && n(
            u,
            E,
            g[E],
            null,
            y,
            T
          );
      for (const E in b) {
        if (us(E)) continue;
        const R = b[E], S = g[E];
        R !== S && E !== "value" && n(u, E, S, R, y, T);
      }
      "value" in b && n(u, "value", g.value, b.value, y);
    }
  }, me = (u, g, b, T, y, E, R, S, A) => {
    const O = g.el = u ? u.el : a(""), U = g.anchor = u ? u.anchor : a("");
    let { patchFlag: C, dynamicChildren: F, slotScopeIds: k } = g;
    process.env.NODE_ENV !== "production" && // #5523 dev root fragment may inherit directives
    (Ge || C & 2048) && (C = 0, A = !1, F = null), k && (S = S ? S.concat(k) : k), u == null ? (r(O, b, T), r(U, b, T), Z(
      // #10007
      // such fragment like `<></>` will be compiled into
      // a fragment which doesn't have a children.
      // In this case fallback to an empty array
      g.children || [],
      b,
      U,
      y,
      E,
      R,
      S,
      A
    )) : C > 0 && C & 64 && F && // #2715 the previous fragment could've been a BAILed one as a result
    // of renderSlot() with no valid children
    u.dynamicChildren ? (ce(
      u.dynamicChildren,
      F,
      b,
      y,
      E,
      R,
      S
    ), process.env.NODE_ENV !== "production" ? Zs(u, g) : (
      // #2080 if the stable fragment has a key, it's a <template v-for> that may
      //  get moved around. Make sure all root level vnodes inherit el.
      // #2134 or if it's a component root, it may also get moved around
      // as the component is being moved.
      (g.key != null || y && g === y.subTree) && Zs(
        u,
        g,
        !0
        /* shallow */
      )
    )) : Be(
      u,
      g,
      b,
      U,
      y,
      E,
      R,
      S,
      A
    );
  }, te = (u, g, b, T, y, E, R, S, A) => {
    g.slotScopeIds = S, u == null ? g.shapeFlag & 512 ? y.ctx.activate(
      g,
      b,
      T,
      R,
      A
    ) : we(
      g,
      b,
      T,
      y,
      E,
      R,
      A
    ) : xe(u, g, A);
  }, we = (u, g, b, T, y, E, R) => {
    const S = u.component = Zd(
      u,
      T,
      y
    );
    if (process.env.NODE_ENV !== "production" && S.type.__hmrId && Ru(S), process.env.NODE_ENV !== "production" && (Ys(u), $t(S, "mount")), Fi(u) && (S.ctx.renderer = Zt), process.env.NODE_ENV !== "production" && $t(S, "init"), ep(S, !1, R), process.env.NODE_ENV !== "production" && Ft(S, "init"), process.env.NODE_ENV !== "production" && Ge && (u.el = null), S.asyncDep) {
      if (y && y.registerDep(S, K, R), !u.el) {
        const A = S.subTree = Me(Fe);
        I(null, A, g, b), u.placeholder = A.el;
      }
    } else
      K(
        S,
        u,
        g,
        b,
        y,
        E,
        R
      );
    process.env.NODE_ENV !== "production" && (qs(), Ft(S, "mount"));
  }, xe = (u, g, b) => {
    const T = g.component = u.component;
    if (Hd(u, g, b))
      if (T.asyncDep && !T.asyncResolved) {
        process.env.NODE_ENV !== "production" && Ys(g), z(T, g, b), process.env.NODE_ENV !== "production" && qs();
        return;
      } else
        T.next = g, T.update();
    else
      g.el = u.el, T.vnode = g;
  }, K = (u, g, b, T, y, E, R) => {
    const S = () => {
      if (u.isMounted) {
        let { next: C, bu: F, u: k, parent: W, vnode: se } = u;
        {
          const ze = oa(u);
          if (ze) {
            C && (C.el = se.el, z(u, C, R)), ze.asyncDep.then(() => {
              u.isUnmounted || S();
            });
            return;
          }
        }
        let Q = C, Ne;
        process.env.NODE_ENV !== "production" && Ys(C || u.vnode), _t(u, !1), C ? (C.el = se.el, z(u, C, R)) : C = se, F && ts(F), (Ne = C.props && C.props.onVnodeBeforeUpdate) && Ke(Ne, W, C, se), _t(u, !0), process.env.NODE_ENV !== "production" && $t(u, "render");
        const Te = Vn(u);
        process.env.NODE_ENV !== "production" && Ft(u, "render");
        const He = u.subTree;
        u.subTree = Te, process.env.NODE_ENV !== "production" && $t(u, "patch"), _(
          He,
          Te,
          // parent may have changed if it's in a teleport
          h(He.el),
          // anchor may have changed if it's in a fragment
          Fs(He),
          u,
          y,
          E
        ), process.env.NODE_ENV !== "production" && Ft(u, "patch"), C.el = Te.el, Q === null && zd(u, Te.el), k && Ae(k, y), (Ne = C.props && C.props.onVnodeUpdated) && Ae(
          () => Ke(Ne, W, C, se),
          y
        ), process.env.NODE_ENV !== "production" && Bo(u), process.env.NODE_ENV !== "production" && qs();
      } else {
        let C;
        const { el: F, props: k } = g, { bm: W, m: se, parent: Q, root: Ne, type: Te } = u, He = ms(g);
        _t(u, !1), W && ts(W), !He && (C = k && k.onVnodeBeforeMount) && Ke(C, Q, g), _t(u, !0);
        {
          Ne.ce && // @ts-expect-error _def is private
          Ne.ce._def.shadowRoot !== !1 && Ne.ce._injectChildStyle(Te), process.env.NODE_ENV !== "production" && $t(u, "render");
          const ze = u.subTree = Vn(u);
          process.env.NODE_ENV !== "production" && Ft(u, "render"), process.env.NODE_ENV !== "production" && $t(u, "patch"), _(
            null,
            ze,
            b,
            T,
            u,
            y,
            E
          ), process.env.NODE_ENV !== "production" && Ft(u, "patch"), g.el = ze.el;
        }
        if (se && Ae(se, y), !He && (C = k && k.onVnodeMounted)) {
          const ze = g;
          Ae(
            () => Ke(C, Q, ze),
            y
          );
        }
        (g.shapeFlag & 256 || Q && ms(Q.vnode) && Q.vnode.shapeFlag & 256) && u.a && Ae(u.a, y), u.isMounted = !0, process.env.NODE_ENV !== "production" && Fu(u), g = b = T = null;
      }
    };
    u.scope.on();
    const A = u.effect = new go(S);
    u.scope.off();
    const O = u.update = A.run.bind(A), U = u.job = A.runIfDirty.bind(A);
    U.i = u, U.id = u.uid, A.scheduler = () => Nr(U), _t(u, !0), process.env.NODE_ENV !== "production" && (A.onTrack = u.rtc ? (C) => ts(u.rtc, C) : void 0, A.onTrigger = u.rtg ? (C) => ts(u.rtg, C) : void 0), O();
  }, z = (u, g, b) => {
    g.component = u;
    const T = u.vnode.props;
    u.vnode = g, u.next = null, _d(u, g.props, T, b), Dd(u, g.children, b), je(), Pn(u), Le();
  }, Be = (u, g, b, T, y, E, R, S, A = !1) => {
    const O = u && u.children, U = u ? u.shapeFlag : 0, C = g.children, { patchFlag: F, shapeFlag: k } = g;
    if (F > 0) {
      if (F & 128) {
        Gt(
          O,
          C,
          b,
          T,
          y,
          E,
          R,
          S,
          A
        );
        return;
      } else if (F & 256) {
        Dr(
          O,
          C,
          b,
          T,
          y,
          E,
          R,
          S,
          A
        );
        return;
      }
    }
    k & 8 ? (U & 16 && Jt(O, y, E), C !== O && f(b, C)) : U & 16 ? k & 16 ? Gt(
      O,
      C,
      b,
      T,
      y,
      E,
      R,
      S,
      A
    ) : Jt(O, y, E, !0) : (U & 8 && f(b, ""), k & 16 && Z(
      C,
      b,
      T,
      y,
      E,
      R,
      S,
      A
    ));
  }, Dr = (u, g, b, T, y, E, R, S, A) => {
    u = u || fs, g = g || fs;
    const O = u.length, U = g.length, C = Math.min(O, U);
    let F;
    for (F = 0; F < C; F++) {
      const k = g[F] = A ? ct(g[F]) : Ie(g[F]);
      _(
        u[F],
        k,
        b,
        null,
        y,
        E,
        R,
        S,
        A
      );
    }
    O > U ? Jt(
      u,
      y,
      E,
      !0,
      !1,
      C
    ) : Z(
      g,
      b,
      T,
      y,
      E,
      R,
      S,
      A,
      C
    );
  }, Gt = (u, g, b, T, y, E, R, S, A) => {
    let O = 0;
    const U = g.length;
    let C = u.length - 1, F = U - 1;
    for (; O <= C && O <= F; ) {
      const k = u[O], W = g[O] = A ? ct(g[O]) : Ie(g[O]);
      if (is(k, W))
        _(
          k,
          W,
          b,
          null,
          y,
          E,
          R,
          S,
          A
        );
      else
        break;
      O++;
    }
    for (; O <= C && O <= F; ) {
      const k = u[C], W = g[F] = A ? ct(g[F]) : Ie(g[F]);
      if (is(k, W))
        _(
          k,
          W,
          b,
          null,
          y,
          E,
          R,
          S,
          A
        );
      else
        break;
      C--, F--;
    }
    if (O > C) {
      if (O <= F) {
        const k = F + 1, W = k < U ? g[k].el : T;
        for (; O <= F; )
          _(
            null,
            g[O] = A ? ct(g[O]) : Ie(g[O]),
            b,
            W,
            y,
            E,
            R,
            S,
            A
          ), O++;
      }
    } else if (O > F)
      for (; O <= C; )
        it(u[O], y, E, !0), O++;
    else {
      const k = O, W = O, se = /* @__PURE__ */ new Map();
      for (O = W; O <= F; O++) {
        const _e = g[O] = A ? ct(g[O]) : Ie(g[O]);
        _e.key != null && (process.env.NODE_ENV !== "production" && se.has(_e.key) && D(
          "Duplicate keys found during update:",
          JSON.stringify(_e.key),
          "Make sure keys are unique."
        ), se.set(_e.key, O));
      }
      let Q, Ne = 0;
      const Te = F - W + 1;
      let He = !1, ze = 0;
      const Qt = new Array(Te);
      for (O = 0; O < Te; O++) Qt[O] = 0;
      for (O = k; O <= C; O++) {
        const _e = u[O];
        if (Ne >= Te) {
          it(_e, y, E, !0);
          continue;
        }
        let Ve;
        if (_e.key != null)
          Ve = se.get(_e.key);
        else
          for (Q = W; Q <= F; Q++)
            if (Qt[Q - W] === 0 && is(_e, g[Q])) {
              Ve = Q;
              break;
            }
        Ve === void 0 ? it(_e, y, E, !0) : (Qt[Ve - W] = O + 1, Ve >= ze ? ze = Ve : He = !0, _(
          _e,
          g[Ve],
          b,
          null,
          y,
          E,
          R,
          S,
          A
        ), Ne++);
      }
      const Ki = He ? Md(Qt) : fs;
      for (Q = Ki.length - 1, O = Te - 1; O >= 0; O--) {
        const _e = W + O, Ve = g[_e], Wi = g[_e + 1], Xi = _e + 1 < U ? (
          // #13559, fallback to el placeholder for unresolved async component
          Wi.el || Wi.placeholder
        ) : T;
        Qt[O] === 0 ? _(
          null,
          Ve,
          b,
          Xi,
          y,
          E,
          R,
          S,
          A
        ) : He && (Q < 0 || O !== Ki[Q] ? Pt(Ve, b, Xi, 2) : Q--);
      }
    }
  }, Pt = (u, g, b, T, y = null) => {
    const { el: E, type: R, transition: S, children: A, shapeFlag: O } = u;
    if (O & 6) {
      Pt(u.component.subTree, g, b, T);
      return;
    }
    if (O & 128) {
      u.suspense.move(g, b, T);
      return;
    }
    if (O & 64) {
      R.move(u, g, b, Zt);
      return;
    }
    if (R === Xe) {
      r(E, g, b);
      for (let C = 0; C < A.length; C++)
        Pt(A[C], g, b, T);
      r(u.anchor, g, b);
      return;
    }
    if (R === Qs) {
      $(u, g, b);
      return;
    }
    if (T !== 2 && O & 1 && S)
      if (T === 0)
        S.beforeEnter(E), r(E, g, b), Ae(() => S.enter(E), y);
      else {
        const { leave: C, delayLeave: F, afterLeave: k } = S, W = () => {
          u.ctx.isUnmounted ? i(E) : r(E, g, b);
        }, se = () => {
          E._isLeaving && E[Ku](
            !0
            /* cancelled */
          ), C(E, () => {
            W(), k && k();
          });
        };
        F ? F(E, W, se) : se();
      }
    else
      r(E, g, b);
  }, it = (u, g, b, T = !1, y = !1) => {
    const {
      type: E,
      props: R,
      ref: S,
      children: A,
      dynamicChildren: O,
      shapeFlag: U,
      patchFlag: C,
      dirs: F,
      cacheIndex: k
    } = u;
    if (C === -2 && (y = !1), S != null && (je(), gs(S, null, b, u, !0), Le()), k != null && (g.renderCache[k] = void 0), U & 256) {
      g.ctx.deactivate(u);
      return;
    }
    const W = U & 1 && F, se = !ms(u);
    let Q;
    if (se && (Q = R && R.onVnodeBeforeUnmount) && Ke(Q, g, u), U & 6)
      Ea(u.component, b, T);
    else {
      if (U & 128) {
        u.suspense.unmount(b, T);
        return;
      }
      W && bt(u, null, g, "beforeUnmount"), U & 64 ? u.type.remove(
        u,
        g,
        b,
        Zt,
        T
      ) : O && // #5154
      // when v-once is used inside a block, setBlockTracking(-1) marks the
      // parent block with hasOnce: true
      // so that it doesn't take the fast path during unmount - otherwise
      // components nested in v-once are never unmounted.
      !O.hasOnce && // #1153: fast path should not be taken for non-stable (v-for) fragments
      (E !== Xe || C > 0 && C & 64) ? Jt(
        O,
        g,
        b,
        !1,
        !0
      ) : (E === Xe && C & 384 || !y && U & 16) && Jt(A, g, b), T && Rr(u);
    }
    (se && (Q = R && R.onVnodeUnmounted) || W) && Ae(() => {
      Q && Ke(Q, g, u), W && bt(u, null, g, "unmounted");
    }, b);
  }, Rr = (u) => {
    const { type: g, el: b, anchor: T, transition: y } = u;
    if (g === Xe) {
      process.env.NODE_ENV !== "production" && u.patchFlag > 0 && u.patchFlag & 2048 && y && !y.persisted ? u.children.forEach((R) => {
        R.type === Fe ? i(R.el) : Rr(R);
      }) : ya(b, T);
      return;
    }
    if (g === Qs) {
      w(u);
      return;
    }
    const E = () => {
      i(b), y && !y.persisted && y.afterLeave && y.afterLeave();
    };
    if (u.shapeFlag & 1 && y && !y.persisted) {
      const { leave: R, delayLeave: S } = y, A = () => R(b, E);
      S ? S(u.el, E, A) : A();
    } else
      E();
  }, ya = (u, g) => {
    let b;
    for (; u !== g; )
      b = p(u), i(u), u = b;
    i(g);
  }, Ea = (u, g, b) => {
    process.env.NODE_ENV !== "production" && u.type.__hmrId && Cu(u);
    const { bum: T, scope: y, job: E, subTree: R, um: S, m: A, a: O } = u;
    zn(A), zn(O), T && ts(T), y.stop(), E && (E.flags |= 8, it(R, u, g, b)), S && Ae(S, g), Ae(() => {
      u.isUnmounted = !0;
    }, g), process.env.NODE_ENV !== "production" && ku(u);
  }, Jt = (u, g, b, T = !1, y = !1, E = 0) => {
    for (let R = E; R < u.length; R++)
      it(u[R], g, b, T, y);
  }, Fs = (u) => {
    if (u.shapeFlag & 6)
      return Fs(u.component.subTree);
    if (u.shapeFlag & 128)
      return u.suspense.next();
    const g = p(u.anchor || u.el), b = g && g[zu];
    return b ? p(b) : g;
  };
  let Cr = !1;
  const Vi = (u, g, b) => {
    u == null ? g._vnode && it(g._vnode, null, null, !0) : _(
      g._vnode || null,
      u,
      g,
      null,
      null,
      null,
      b
    ), g._vnode = u, Cr || (Cr = !0, Pn(), ko(), Cr = !1);
  }, Zt = {
    p: _,
    um: it,
    m: Pt,
    r: Rr,
    mt: we,
    mc: Z,
    pc: Be,
    pbc: ce,
    n: Fs,
    o: e
  };
  return {
    render: Vi,
    hydrate: void 0,
    createApp: gd(Vi)
  };
}
function Wr({ type: e, props: s }, t) {
  return t === "svg" && e === "foreignObject" || t === "mathml" && e === "annotation-xml" && s && s.encoding && s.encoding.includes("html") ? void 0 : t;
}
function _t({ effect: e, job: s }, t) {
  t ? (e.flags |= 32, s.flags |= 4) : (e.flags &= -33, s.flags &= -5);
}
function Pd(e, s) {
  return (!e || e && !e.pendingBranch) && s && !s.persisted;
}
function Zs(e, s, t = !1) {
  const r = e.children, i = s.children;
  if (j(r) && j(i))
    for (let n = 0; n < r.length; n++) {
      const o = r[n];
      let a = i[n];
      a.shapeFlag & 1 && !a.dynamicChildren && ((a.patchFlag <= 0 || a.patchFlag === 32) && (a = i[n] = ct(i[n]), a.el = o.el), !t && a.patchFlag !== -2 && Zs(o, a)), a.type === Ms && // avoid cached text nodes retaining detached dom nodes
      a.patchFlag !== -1 && (a.el = o.el), a.type === Fe && !a.el && (a.el = o.el), process.env.NODE_ENV !== "production" && a.el && (a.el.__vnode = a);
    }
}
function Md(e) {
  const s = e.slice(), t = [0];
  let r, i, n, o, a;
  const c = e.length;
  for (r = 0; r < c; r++) {
    const l = e[r];
    if (l !== 0) {
      if (i = t[t.length - 1], e[i] < l) {
        s[r] = i, t.push(r);
        continue;
      }
      for (n = 0, o = t.length - 1; n < o; )
        a = n + o >> 1, e[t[a]] < l ? n = a + 1 : o = a;
      l < e[t[n]] && (n > 0 && (s[r] = t[n - 1]), t[n] = r);
    }
  }
  for (n = t.length, o = t[n - 1]; n-- > 0; )
    t[n] = o, o = s[o];
  return t;
}
function oa(e) {
  const s = e.subTree.component;
  if (s)
    return s.asyncDep && !s.asyncResolved ? s : oa(s);
}
function zn(e) {
  if (e)
    for (let s = 0; s < e.length; s++)
      e[s].flags |= 8;
}
const $d = Symbol.for("v-scx"), Fd = () => {
  {
    const e = Js($d);
    return e || process.env.NODE_ENV !== "production" && D(
      "Server rendering context not provided. Make sure to only call useSSRContext() conditionally in the server build."
    ), e;
  }
};
function Xr(e, s, t) {
  return process.env.NODE_ENV !== "production" && !L(s) && D(
    "`watch(fn, options?)` signature has been moved to a separate API. Use `watchEffect(fn, options?)` instead. `watch` now only supports `watch(source, cb, options?) signature."
  ), aa(e, s, t);
}
function aa(e, s, t = ee) {
  const { immediate: r, deep: i, flush: n, once: o } = t;
  process.env.NODE_ENV !== "production" && !s && (r !== void 0 && D(
    'watch() "immediate" option is only respected when using the watch(source, callback, options?) signature.'
  ), i !== void 0 && D(
    'watch() "deep" option is only respected when using the watch(source, callback, options?) signature.'
  ), o !== void 0 && D(
    'watch() "once" option is only respected when using the watch(source, callback, options?) signature.'
  ));
  const a = ue({}, t);
  process.env.NODE_ENV !== "production" && (a.onWarn = D);
  const c = s && r || !s && n !== "post";
  let l;
  if (As) {
    if (n === "sync") {
      const m = Fd();
      l = m.__watcherHandles || (m.__watcherHandles = []);
    } else if (!c) {
      const m = () => {
      };
      return m.stop = pe, m.resume = pe, m.pause = pe, m;
    }
  }
  const f = ge;
  a.call = (m, v, _) => tt(m, f, v, _);
  let h = !1;
  n === "post" ? a.scheduler = (m) => {
    Ae(m, f && f.suspense);
  } : n !== "sync" && (h = !0, a.scheduler = (m, v) => {
    v ? m() : Nr(m);
  }), a.augmentJob = (m) => {
    s && (m.flags |= 4), h && (m.flags |= 2, f && (m.id = f.uid, m.i = f));
  };
  const p = Eu(e, s, a);
  return As && (l ? l.push(p) : c && p()), p;
}
function Ud(e, s, t) {
  const r = this.proxy, i = be(e) ? e.includes(".") ? ca(r, e) : () => r[e] : e.bind(r, r);
  let n;
  L(s) ? n = s : (n = s.handler, t = s);
  const o = $s(this), a = aa(i, n.bind(r), t);
  return o(), a;
}
function ca(e, s) {
  const t = s.split(".");
  return () => {
    let r = e;
    for (let i = 0; i < t.length && r; i++)
      r = r[t[i]];
    return r;
  };
}
const kd = (e, s) => s === "modelValue" || s === "model-value" ? e.modelModifiers : e[`${s}Modifiers`] || e[`${et(s)}Modifiers`] || e[`${Vt(s)}Modifiers`];
function jd(e, s, ...t) {
  if (e.isUnmounted) return;
  const r = e.vnode.props || ee;
  if (process.env.NODE_ENV !== "production") {
    const {
      emitsOptions: f,
      propsOptions: [h]
    } = e;
    if (f)
      if (!(s in f))
        (!h || !(yt(et(s)) in h)) && D(
          `Component emitted event "${s}" but it is neither declared in the emits option nor as an "${yt(et(s))}" prop.`
        );
      else {
        const p = f[s];
        L(p) && (p(...t) || D(
          `Invalid event arguments: event validation failed for event "${s}".`
        ));
      }
  }
  let i = t;
  const n = s.startsWith("update:"), o = n && kd(r, s.slice(7));
  if (o && (o.trim && (i = t.map((f) => be(f) ? f.trim() : f)), o.number && (i = t.map(zf))), process.env.NODE_ENV !== "production" && Bu(e, s, i), process.env.NODE_ENV !== "production") {
    const f = s.toLowerCase();
    f !== s && r[yt(f)] && D(
      `Event "${f}" is emitted in component ${Ar(
        e,
        e.type
      )} but the handler is registered for "${s}". Note that HTML attributes are case-insensitive and you cannot use v-on to listen to camelCase events when using in-DOM templates. You should probably use "${Vt(
        s
      )}" instead of "${s}".`
    );
  }
  let a, c = r[a = yt(s)] || // also try camelCase event handler (#2249)
  r[a = yt(et(s))];
  !c && n && (c = r[a = yt(Vt(s))]), c && tt(
    c,
    e,
    6,
    i
  );
  const l = r[a + "Once"];
  if (l) {
    if (!e.emitted)
      e.emitted = {};
    else if (e.emitted[a])
      return;
    e.emitted[a] = !0, tt(
      l,
      e,
      6,
      i
    );
  }
}
function la(e, s, t = !1) {
  const r = s.emitsCache, i = r.get(e);
  if (i !== void 0)
    return i;
  const n = e.emits;
  let o = {}, a = !1;
  if (!L(e)) {
    const c = (l) => {
      const f = la(l, s, !0);
      f && (a = !0, ue(o, f));
    };
    !t && s.mixins.length && s.mixins.forEach(c), e.extends && c(e.extends), e.mixins && e.mixins.forEach(c);
  }
  return !n && !a ? (re(e) && r.set(e, null), null) : (j(n) ? n.forEach((c) => o[c] = null) : ue(o, n), re(e) && r.set(e, o), o);
}
function Or(e, s) {
  return !e || !_r(s) ? !1 : (s = s.slice(2).replace(/Once$/, ""), X(e, s[0].toLowerCase() + s.slice(1)) || X(e, Vt(s)) || X(e, s));
}
let pi = !1;
function dr() {
  pi = !0;
}
function Vn(e) {
  const {
    type: s,
    vnode: t,
    proxy: r,
    withProxy: i,
    propsOptions: [n],
    slots: o,
    attrs: a,
    emit: c,
    render: l,
    renderCache: f,
    props: h,
    data: p,
    setupState: m,
    ctx: v,
    inheritAttrs: _
  } = e, x = hr(e);
  let I, M;
  process.env.NODE_ENV !== "production" && (pi = !1);
  try {
    if (t.shapeFlag & 4) {
      const w = i || r, P = process.env.NODE_ENV !== "production" && m.__isScriptSetup ? new Proxy(w, {
        get(Y, V, Z) {
          return D(
            `Property '${String(
              V
            )}' was accessed via 'this'. Avoid using 'this' in templates.`
          ), Reflect.get(Y, V, Z);
        }
      }) : w;
      I = Ie(
        l.call(
          P,
          w,
          f,
          process.env.NODE_ENV !== "production" ? qe(h) : h,
          m,
          p,
          v
        )
      ), M = a;
    } else {
      const w = s;
      process.env.NODE_ENV !== "production" && a === h && dr(), I = Ie(
        w.length > 1 ? w(
          process.env.NODE_ENV !== "production" ? qe(h) : h,
          process.env.NODE_ENV !== "production" ? {
            get attrs() {
              return dr(), qe(a);
            },
            slots: o,
            emit: c
          } : { attrs: a, slots: o, emit: c }
        ) : w(
          process.env.NODE_ENV !== "production" ? qe(h) : h,
          null
        )
      ), M = s.props ? a : Ld(a);
    }
  } catch (w) {
    Is(w, e, 1), I = Me(Fe);
  }
  let N = I, $;
  if (process.env.NODE_ENV !== "production" && I.patchFlag > 0 && I.patchFlag & 2048 && ([N, $] = ha(I)), M && _ !== !1) {
    const w = Object.keys(M), { shapeFlag: P } = N;
    if (w.length) {
      if (P & 7)
        n && w.some(si) && (M = Bd(
          M,
          n
        )), N = gt(N, M, !1, !0);
      else if (process.env.NODE_ENV !== "production" && !pi && N.type !== Fe) {
        const Y = Object.keys(a), V = [], Z = [];
        for (let ae = 0, ce = Y.length; ae < ce; ae++) {
          const oe = Y[ae];
          _r(oe) ? si(oe) || V.push(oe[2].toLowerCase() + oe.slice(3)) : Z.push(oe);
        }
        Z.length && D(
          `Extraneous non-props attributes (${Z.join(", ")}) were passed to component but could not be automatically inherited because component renders fragment or text or teleport root nodes.`
        ), V.length && D(
          `Extraneous non-emits event listeners (${V.join(", ")}) were passed to component but could not be automatically inherited because component renders fragment or text root nodes. If the listener is intended to be a component custom event listener only, declare it using the "emits" option.`
        );
      }
    }
  }
  return t.dirs && (process.env.NODE_ENV !== "production" && !Kn(N) && D(
    "Runtime directive used on component with non-element root node. The directives will not function as intended."
  ), N = gt(N, null, !1, !0), N.dirs = N.dirs ? N.dirs.concat(t.dirs) : t.dirs), t.transition && (process.env.NODE_ENV !== "production" && !Kn(N) && D(
    "Component inside <Transition> renders non-element root node that cannot be animated."
  ), $i(N, t.transition)), process.env.NODE_ENV !== "production" && $ ? $(N) : I = N, hr(x), I;
}
const ha = (e) => {
  const s = e.children, t = e.dynamicChildren, r = Li(s, !1);
  if (r) {
    if (process.env.NODE_ENV !== "production" && r.patchFlag > 0 && r.patchFlag & 2048)
      return ha(r);
  } else return [e, void 0];
  const i = s.indexOf(r), n = t ? t.indexOf(r) : -1, o = (a) => {
    s[i] = a, t && (n > -1 ? t[n] = a : a.patchFlag > 0 && (e.dynamicChildren = [...t, a]));
  };
  return [Ie(r), o];
};
function Li(e, s = !0) {
  let t;
  for (let r = 0; r < e.length; r++) {
    const i = e[r];
    if (Kt(i)) {
      if (i.type !== Fe || i.children === "v-if") {
        if (t)
          return;
        if (t = i, process.env.NODE_ENV !== "production" && s && t.patchFlag > 0 && t.patchFlag & 2048)
          return Li(t.children);
      }
    } else
      return;
  }
  return t;
}
const Ld = (e) => {
  let s;
  for (const t in e)
    (t === "class" || t === "style" || _r(t)) && ((s || (s = {}))[t] = e[t]);
  return s;
}, Bd = (e, s) => {
  const t = {};
  for (const r in e)
    (!si(r) || !(r.slice(9) in s)) && (t[r] = e[r]);
  return t;
}, Kn = (e) => e.shapeFlag & 7 || e.type === Fe;
function Hd(e, s, t) {
  const { props: r, children: i, component: n } = e, { props: o, children: a, patchFlag: c } = s, l = n.emitsOptions;
  if (process.env.NODE_ENV !== "production" && (i || a) && Ge || s.dirs || s.transition)
    return !0;
  if (t && c >= 0) {
    if (c & 1024)
      return !0;
    if (c & 16)
      return r ? Wn(r, o, l) : !!o;
    if (c & 8) {
      const f = s.dynamicProps;
      for (let h = 0; h < f.length; h++) {
        const p = f[h];
        if (o[p] !== r[p] && !Or(l, p))
          return !0;
      }
    }
  } else
    return (i || a) && (!a || !a.$stable) ? !0 : r === o ? !1 : r ? o ? Wn(r, o, l) : !0 : !!o;
  return !1;
}
function Wn(e, s, t) {
  const r = Object.keys(s);
  if (r.length !== Object.keys(e).length)
    return !0;
  for (let i = 0; i < r.length; i++) {
    const n = r[i];
    if (s[n] !== e[n] && !Or(t, n))
      return !0;
  }
  return !1;
}
function zd({ vnode: e, parent: s }, t) {
  for (; s; ) {
    const r = s.subTree;
    if (r.suspense && r.suspense.activeBranch === e && (r.el = e.el), r === e)
      (e = s.vnode).el = t, s = s.parent;
    else
      break;
  }
}
const fa = (e) => e.__isSuspense;
function Vd(e, s) {
  s && s.pendingBranch ? j(e) ? s.effects.push(...e) : s.effects.push(e) : Uo(e);
}
const Xe = Symbol.for("v-fgt"), Ms = Symbol.for("v-txt"), Fe = Symbol.for("v-cmt"), Qs = Symbol.for("v-stc");
let ht = null, Bi = 1;
function Xn(e, s = !1) {
  Bi += e, e < 0 && ht && s && (ht.hasOnce = !0);
}
function Kt(e) {
  return e ? e.__v_isVNode === !0 : !1;
}
function is(e, s) {
  if (process.env.NODE_ENV !== "production" && s.shapeFlag & 6 && e.component) {
    const t = Gs.get(s.type);
    if (t && t.has(e.component))
      return e.shapeFlag &= -257, s.shapeFlag &= -513, !1;
  }
  return e.type === s.type && e.key === s.key;
}
const Kd = (...e) => da(
  ...e
), ua = ({ key: e }) => e ?? null, er = ({
  ref: e,
  ref_key: s,
  ref_for: t
}) => (typeof e == "number" && (e = "" + e), e != null ? be(e) || fe(e) || L(e) ? { i: Re, r: e, k: s, f: !!t } : e : null);
function Wd(e, s = null, t = null, r = 0, i = null, n = e === Xe ? 0 : 1, o = !1, a = !1) {
  const c = {
    __v_isVNode: !0,
    __v_skip: !0,
    type: e,
    props: s,
    key: s && ua(s),
    ref: s && er(s),
    scopeId: zo,
    slotScopeIds: null,
    children: t,
    component: null,
    suspense: null,
    ssContent: null,
    ssFallback: null,
    dirs: null,
    transition: null,
    el: null,
    anchor: null,
    target: null,
    targetStart: null,
    targetAnchor: null,
    staticCount: 0,
    shapeFlag: n,
    patchFlag: r,
    dynamicProps: i,
    dynamicChildren: null,
    appContext: null,
    ctx: Re
  };
  return a ? (Hi(c, t), n & 128 && e.normalize(c)) : t && (c.shapeFlag |= be(t) ? 8 : 16), process.env.NODE_ENV !== "production" && c.key !== c.key && D("VNode created with invalid key (NaN). VNode type:", c.type), Bi > 0 && // avoid a block node from tracking itself
  !o && // has current parent block
  ht && // presence of a patch flag indicates this node needs patching on updates.
  // component nodes also should always be patched, because even if the
  // component doesn't need to update, it needs to persist the instance on to
  // the next vnode so that it can be properly unmounted later.
  (c.patchFlag > 0 || n & 6) && // the EVENTS flag is only for hydration and if it is the only flag, the
  // vnode should not be considered dynamic due to handler caching.
  c.patchFlag !== 32 && ht.push(c), c;
}
const Me = process.env.NODE_ENV !== "production" ? Kd : da;
function da(e, s = null, t = null, r = 0, i = null, n = !1) {
  if ((!e || e === id) && (process.env.NODE_ENV !== "production" && !e && D(`Invalid vnode type when creating vnode: ${e}.`), e = Fe), Kt(e)) {
    const a = gt(
      e,
      s,
      !0
      /* mergeRef: true */
    );
    return t && Hi(a, t), Bi > 0 && !n && ht && (a.shapeFlag & 6 ? ht[ht.indexOf(e)] = a : ht.push(a)), a.patchFlag = -2, a;
  }
  if (_a(e) && (e = e.__vccOpts), s) {
    s = Xd(s);
    let { class: a, style: c } = s;
    a && !be(a) && (s.class = Ti(a)), re(c) && (or(c) && !j(c) && (c = ue({}, c)), s.style = Ni(c));
  }
  const o = be(e) ? 1 : fa(e) ? 128 : Vu(e) ? 64 : re(e) ? 4 : L(e) ? 2 : 0;
  return process.env.NODE_ENV !== "production" && o & 4 && or(e) && (e = H(e), D(
    "Vue received a Component that was made a reactive object. This can lead to unnecessary performance overhead and should be avoided by marking the component with `markRaw` or using `shallowRef` instead of `ref`.",
    `
Component that was made reactive: `,
    e
  )), Wd(
    e,
    s,
    t,
    r,
    i,
    o,
    n,
    !0
  );
}
function Xd(e) {
  return e ? or(e) || ea(e) ? ue({}, e) : e : null;
}
function gt(e, s, t = !1, r = !1) {
  const { props: i, ref: n, patchFlag: o, children: a, transition: c } = e, l = s ? qd(i || {}, s) : i, f = {
    __v_isVNode: !0,
    __v_skip: !0,
    type: e.type,
    props: l,
    key: l && ua(l),
    ref: s && s.ref ? (
      // #2078 in the case of <component :is="vnode" ref="extra"/>
      // if the vnode itself already has a ref, cloneVNode will need to merge
      // the refs so the single vnode can be set on multiple refs
      t && n ? j(n) ? n.concat(er(s)) : [n, er(s)] : er(s)
    ) : n,
    scopeId: e.scopeId,
    slotScopeIds: e.slotScopeIds,
    children: process.env.NODE_ENV !== "production" && o === -1 && j(a) ? a.map(pa) : a,
    target: e.target,
    targetStart: e.targetStart,
    targetAnchor: e.targetAnchor,
    staticCount: e.staticCount,
    shapeFlag: e.shapeFlag,
    // if the vnode is cloned with extra props, we can no longer assume its
    // existing patch flag to be reliable and need to add the FULL_PROPS flag.
    // note: preserve flag for fragments since they use the flag for children
    // fast paths only.
    patchFlag: s && e.type !== Xe ? o === -1 ? 16 : o | 16 : o,
    dynamicProps: e.dynamicProps,
    dynamicChildren: e.dynamicChildren,
    appContext: e.appContext,
    dirs: e.dirs,
    transition: c,
    // These should technically only be non-null on mounted VNodes. However,
    // they *should* be copied for kept-alive vnodes. So we just always copy
    // them since them being non-null during a mount doesn't affect the logic as
    // they will simply be overwritten.
    component: e.component,
    suspense: e.suspense,
    ssContent: e.ssContent && gt(e.ssContent),
    ssFallback: e.ssFallback && gt(e.ssFallback),
    placeholder: e.placeholder,
    el: e.el,
    anchor: e.anchor,
    ctx: e.ctx,
    ce: e.ce
  };
  return c && r && $i(
    f,
    c.clone(f)
  ), f;
}
function pa(e) {
  const s = gt(e);
  return j(e.children) && (s.children = e.children.map(pa)), s;
}
function Yd(e = " ", s = 0) {
  return Me(Ms, null, e, s);
}
function Ie(e) {
  return e == null || typeof e == "boolean" ? Me(Fe) : j(e) ? Me(
    Xe,
    null,
    // #3666, avoid reference pollution when reusing vnode
    e.slice()
  ) : Kt(e) ? ct(e) : Me(Ms, null, String(e));
}
function ct(e) {
  return e.el === null && e.patchFlag !== -1 || e.memo ? e : gt(e);
}
function Hi(e, s) {
  let t = 0;
  const { shapeFlag: r } = e;
  if (s == null)
    s = null;
  else if (j(s))
    t = 16;
  else if (typeof s == "object")
    if (r & 65) {
      const i = s.default;
      i && (i._c && (i._d = !1), Hi(e, i()), i._c && (i._d = !0));
      return;
    } else {
      t = 32;
      const i = s._;
      !i && !ea(s) ? s._ctx = Re : i === 3 && Re && (Re.slots._ === 1 ? s._ = 1 : (s._ = 2, e.patchFlag |= 1024));
    }
  else L(s) ? (s = { default: s, _ctx: Re }, t = 32) : (s = String(s), r & 64 ? (t = 16, s = [Yd(s)]) : t = 8);
  e.children = s, e.shapeFlag |= t;
}
function qd(...e) {
  const s = {};
  for (let t = 0; t < e.length; t++) {
    const r = e[t];
    for (const i in r)
      if (i === "class")
        s.class !== r.class && (s.class = Ti([s.class, r.class]));
      else if (i === "style")
        s.style = Ni([s.style, r.style]);
      else if (_r(i)) {
        const n = s[i], o = r[i];
        o && n !== o && !(j(n) && n.includes(o)) && (s[i] = n ? [].concat(n, o) : o);
      } else i !== "" && (s[i] = r[i]);
  }
  return s;
}
function Ke(e, s, t, r = null) {
  tt(e, s, 7, [
    t,
    r
  ]);
}
const Gd = Jo();
let Jd = 0;
function Zd(e, s, t) {
  const r = e.type, i = (s ? s.appContext : e.appContext) || Gd, n = {
    uid: Jd++,
    vnode: e,
    type: r,
    parent: s,
    appContext: i,
    root: null,
    // to be immediately set
    next: null,
    subTree: null,
    // will be set synchronously right after creation
    effect: null,
    update: null,
    // will be set synchronously right after creation
    job: null,
    scope: new Yf(
      !0
      /* detached */
    ),
    render: null,
    proxy: null,
    exposed: null,
    exposeProxy: null,
    withProxy: null,
    provides: s ? s.provides : Object.create(i.provides),
    ids: s ? s.ids : ["", 0, 0],
    accessCache: null,
    renderCache: [],
    // local resolved assets
    components: null,
    directives: null,
    // resolved props and emits options
    propsOptions: sa(r, i),
    emitsOptions: la(r, i),
    // emit
    emit: null,
    // to be set immediately
    emitted: null,
    // props default value
    propsDefaults: ee,
    // inheritAttrs
    inheritAttrs: r.inheritAttrs,
    // state
    ctx: ee,
    data: ee,
    props: ee,
    attrs: ee,
    slots: ee,
    refs: ee,
    setupState: ee,
    setupContext: null,
    // suspense related
    suspense: t,
    suspenseId: t ? t.pendingId : 0,
    asyncDep: null,
    asyncResolved: !1,
    // lifecycle hooks
    // not using enums here because it results in computed properties
    isMounted: !1,
    isUnmounted: !1,
    isDeactivated: !1,
    bc: null,
    c: null,
    bm: null,
    m: null,
    bu: null,
    u: null,
    um: null,
    bum: null,
    da: null,
    a: null,
    rtg: null,
    rtc: null,
    ec: null,
    sp: null
  };
  return process.env.NODE_ENV !== "production" ? n.ctx = nd(n) : n.ctx = { _: n }, n.root = s ? s.root : n, n.emit = jd.bind(null, n), e.ce && e.ce(n), n;
}
let ge = null;
const ga = () => ge || Re;
let pr, gi;
{
  const e = Cs(), s = (t, r) => {
    let i;
    return (i = e[t]) || (i = e[t] = []), i.push(r), (n) => {
      i.length > 1 ? i.forEach((o) => o(n)) : i[0](n);
    };
  };
  pr = s(
    "__VUE_INSTANCE_SETTERS__",
    (t) => ge = t
  ), gi = s(
    "__VUE_SSR_SETTERS__",
    (t) => As = t
  );
}
const $s = (e) => {
  const s = ge;
  return pr(e), e.scope.on(), () => {
    e.scope.off(), pr(s);
  };
}, Yn = () => {
  ge && ge.scope.off(), pr(null);
}, Qd = /* @__PURE__ */ Ds("slot,component");
function mi(e, { isNativeTag: s }) {
  (Qd(e) || s(e)) && D(
    "Do not use built-in or reserved HTML elements as component id: " + e
  );
}
function ma(e) {
  return e.vnode.shapeFlag & 4;
}
let As = !1;
function ep(e, s = !1, t = !1) {
  s && gi(s);
  const { props: r, children: i } = e.vnode, n = ma(e);
  vd(e, r, n, s), Sd(e, i, t || s);
  const o = n ? tp(e, s) : void 0;
  return s && gi(!1), o;
}
function tp(e, s) {
  var t;
  const r = e.type;
  if (process.env.NODE_ENV !== "production") {
    if (r.name && mi(r.name, e.appContext.config), r.components) {
      const n = Object.keys(r.components);
      for (let o = 0; o < n.length; o++)
        mi(n[o], e.appContext.config);
    }
    if (r.directives) {
      const n = Object.keys(r.directives);
      for (let o = 0; o < n.length; o++)
        Vo(n[o]);
    }
    r.compilerOptions && sp() && D(
      '"compilerOptions" is only supported when using a build of Vue that includes the runtime compiler. Since you are using a runtime-only build, the options should be passed via your build tool config instead.'
    );
  }
  e.accessCache = /* @__PURE__ */ Object.create(null), e.proxy = new Proxy(e.ctx, Yo), process.env.NODE_ENV !== "production" && od(e);
  const { setup: i } = r;
  if (i) {
    je();
    const n = e.setupContext = i.length > 1 ? ip(e) : null, o = $s(e), a = Yt(
      i,
      e,
      0,
      [
        process.env.NODE_ENV !== "production" ? qe(e.props) : e.props,
        n
      ]
    ), c = yi(a);
    if (Le(), o(), (c || e.sp) && !ms(e) && Ko(e), c) {
      if (a.then(Yn, Yn), s)
        return a.then((l) => {
          qn(e, l, s);
        }).catch((l) => {
          Is(l, e, 0);
        });
      if (e.asyncDep = a, process.env.NODE_ENV !== "production" && !e.suspense) {
        const l = (t = r.name) != null ? t : "Anonymous";
        D(
          `Component <${l}>: setup function returned a promise, but no <Suspense> boundary was found in the parent component tree. A component with async setup() must be nested in a <Suspense> in order to be rendered.`
        );
      }
    } else
      qn(e, a, s);
  } else
    va(e, s);
}
function qn(e, s, t) {
  L(s) ? e.type.__ssrInlineRender ? e.ssrRender = s : e.render = s : re(s) ? (process.env.NODE_ENV !== "production" && Kt(s) && D(
    "setup() should not return VNodes directly - return a render function instead."
  ), process.env.NODE_ENV !== "production" && (e.devtoolsRawSetupState = s), e.setupState = Po(s), process.env.NODE_ENV !== "production" && ad(e)) : process.env.NODE_ENV !== "production" && s !== void 0 && D(
    `setup() should return an object. Received: ${s === null ? "null" : typeof s}`
  ), va(e, t);
}
const sp = () => !0;
function va(e, s, t) {
  const r = e.type;
  e.render || (e.render = r.render || pe);
  {
    const i = $s(e);
    je();
    try {
      ld(e);
    } finally {
      Le(), i();
    }
  }
  process.env.NODE_ENV !== "production" && !r.render && e.render === pe && !s && (r.template ? D(
    'Component provided template option but runtime compilation is not supported in this build of Vue. Configure your bundler to alias "vue" to "vue/dist/vue.esm-bundler.js".'
  ) : D("Component is missing template or render function: ", r));
}
const Gn = process.env.NODE_ENV !== "production" ? {
  get(e, s) {
    return dr(), he(e, "get", ""), e[s];
  },
  set() {
    return D("setupContext.attrs is readonly."), !1;
  },
  deleteProperty() {
    return D("setupContext.attrs is readonly."), !1;
  }
} : {
  get(e, s) {
    return he(e, "get", ""), e[s];
  }
};
function rp(e) {
  return new Proxy(e.slots, {
    get(s, t) {
      return he(e, "get", "$slots"), s[t];
    }
  });
}
function ip(e) {
  const s = (t) => {
    if (process.env.NODE_ENV !== "production" && (e.exposed && D("expose() should be called only once per setup()."), t != null)) {
      let r = typeof t;
      r === "object" && (j(t) ? r = "array" : fe(t) && (r = "ref")), r !== "object" && D(
        `expose() should be passed a plain object, received ${r}.`
      );
    }
    e.exposed = t || {};
  };
  if (process.env.NODE_ENV !== "production") {
    let t, r;
    return Object.freeze({
      get attrs() {
        return t || (t = new Proxy(e.attrs, Gn));
      },
      get slots() {
        return r || (r = rp(e));
      },
      get emit() {
        return (i, ...n) => e.emit(i, ...n);
      },
      expose: s
    });
  } else
    return {
      attrs: new Proxy(e.attrs, Gn),
      slots: e.slots,
      emit: e.emit,
      expose: s
    };
}
function zi(e) {
  return e.exposed ? e.exposeProxy || (e.exposeProxy = new Proxy(Po(gu(e.exposed)), {
    get(s, t) {
      if (t in s)
        return s[t];
      if (t in St)
        return St[t](e);
    },
    has(s, t) {
      return t in s || t in St;
    }
  })) : e.proxy;
}
const np = /(?:^|[-_])(\w)/g, op = (e) => e.replace(np, (s) => s.toUpperCase()).replace(/[-_]/g, "");
function ba(e, s = !0) {
  return L(e) ? e.displayName || e.name : e.name || s && e.__name;
}
function Ar(e, s, t = !1) {
  let r = ba(s);
  if (!r && s.__file) {
    const i = s.__file.match(/([^/\\]+)\.\w+$/);
    i && (r = i[1]);
  }
  if (!r && e && e.parent) {
    const i = (n) => {
      for (const o in n)
        if (n[o] === s)
          return o;
    };
    r = i(
      e.components || e.parent.type.components
    ) || i(e.appContext.components);
  }
  return r ? op(r) : t ? "App" : "Anonymous";
}
function _a(e) {
  return L(e) && "__vccOpts" in e;
}
const ap = (e, s) => {
  const t = _u(e, s, As);
  if (process.env.NODE_ENV !== "production") {
    const r = ga();
    r && r.appContext.config.warnRecursiveComputed && (t._warnRecursive = !0);
  }
  return t;
};
function cp(e, s, t) {
  const r = arguments.length;
  return r === 2 ? re(s) && !j(s) ? Kt(s) ? Me(e, null, [s]) : Me(e, s) : Me(e, null, s) : (r > 3 ? t = Array.prototype.slice.call(arguments, 2) : r === 3 && Kt(t) && (t = [t]), Me(e, s, t));
}
function lp() {
  if (process.env.NODE_ENV === "production" || typeof window > "u")
    return;
  const e = { style: "color:#3ba776" }, s = { style: "color:#1677ff" }, t = { style: "color:#f5222d" }, r = { style: "color:#eb2f96" }, i = {
    __vue_custom_formatter: !0,
    header(h) {
      if (!re(h))
        return null;
      if (h.__isVue)
        return ["div", e, "VueInstance"];
      if (fe(h)) {
        je();
        const p = h.value;
        return Le(), [
          "div",
          {},
          ["span", e, f(h)],
          "<",
          a(p),
          ">"
        ];
      } else {
        if (jt(h))
          return [
            "div",
            {},
            ["span", e, Ce(h) ? "ShallowReactive" : "Reactive"],
            "<",
            a(h),
            `>${pt(h) ? " (readonly)" : ""}`
          ];
        if (pt(h))
          return [
            "div",
            {},
            ["span", e, Ce(h) ? "ShallowReadonly" : "Readonly"],
            "<",
            a(h),
            ">"
          ];
      }
      return null;
    },
    hasBody(h) {
      return h && h.__isVue;
    },
    body(h) {
      if (h && h.__isVue)
        return [
          "div",
          {},
          ...n(h.$)
        ];
    }
  };
  function n(h) {
    const p = [];
    h.type.props && h.props && p.push(o("props", H(h.props))), h.setupState !== ee && p.push(o("setup", h.setupState)), h.data !== ee && p.push(o("data", H(h.data)));
    const m = c(h, "computed");
    m && p.push(o("computed", m));
    const v = c(h, "inject");
    return v && p.push(o("injected", v)), p.push([
      "div",
      {},
      [
        "span",
        {
          style: r.style + ";opacity:0.66"
        },
        "$ (internal): "
      ],
      ["object", { object: h }]
    ]), p;
  }
  function o(h, p) {
    return p = ue({}, p), Object.keys(p).length ? [
      "div",
      { style: "line-height:1.25em;margin-bottom:0.6em" },
      [
        "div",
        {
          style: "color:#476582"
        },
        h
      ],
      [
        "div",
        {
          style: "padding-left:1.25em"
        },
        ...Object.keys(p).map((m) => [
          "div",
          {},
          ["span", r, m + ": "],
          a(p[m], !1)
        ])
      ]
    ] : ["span", {}];
  }
  function a(h, p = !0) {
    return typeof h == "number" ? ["span", s, h] : typeof h == "string" ? ["span", t, JSON.stringify(h)] : typeof h == "boolean" ? ["span", r, h] : re(h) ? ["object", { object: p ? H(h) : h }] : ["span", t, String(h)];
  }
  function c(h, p) {
    const m = h.type;
    if (L(m))
      return;
    const v = {};
    for (const _ in h.ctx)
      l(m, _, p) && (v[_] = h.ctx[_]);
    return v;
  }
  function l(h, p, m) {
    const v = h[m];
    if (j(v) && v.includes(p) || re(v) && p in v || h.extends && l(h.extends, p, m) || h.mixins && h.mixins.some((_) => l(_, p, m)))
      return !0;
  }
  function f(h) {
    return Ce(h) ? "ShallowRef" : h.effect ? "ComputedRef" : "Ref";
  }
  window.devtoolsFormatters ? window.devtoolsFormatters.push(i) : window.devtoolsFormatters = [i];
}
const Jn = "3.5.20";
process.env.NODE_ENV;
process.env.NODE_ENV;
process.env.NODE_ENV;
/**
* vue v3.5.20
* (c) 2018-present Yuxi (Evan) You and Vue contributors
* @license MIT
**/
function hp() {
  lp();
}
process.env.NODE_ENV !== "production" && hp();
function yp(e) {
  return /* @__PURE__ */ Wu((t, r) => () => {
    const i = {
      ...t,
      ...r.attrs,
      _item: e
    };
    return cp("custom", i, r.slots);
  });
}
class fp {
  constructor() {
    d(this, "map", /* @__PURE__ */ new Map());
  }
  /**
   * 注册一个标签，每个标签对应一类元素，重复注册会覆盖之前的
   * @param tag 标签名称
   * @param ele 对应的元素类或其构造器
   */
  register(s, t) {
    this.map.has(s) && q.warn(34, s), this.map.set(s, t);
  }
  /**
   * 获取一个标签对应的元素构造器
   * @param tag 标签名
   */
  get(s) {
    return this.map.get(s);
  }
}
const de = new fp(), Sr = (e) => (s, t, r) => {
  if (r) {
    const {
      type: i = "static",
      cache: n = !0,
      fall: o = !1,
      nocache: a = !1
    } = r;
    return new e(i, n && !a, o);
  } else
    return new e("static");
}, vt = (e) => (s, t, r) => {
  if (r) {
    const {
      type: i = "static",
      cache: n = !1,
      fall: o = !1,
      nocache: a = !0
    } = r;
    return new e(i, n && !a, o);
  } else
    return new e("static");
};
de.register("container", Sr(br));
de.register("container-custom", Sr(cf));
de.register("template", Sr(br));
de.register("mota-renderer", (e, s, t) => new xs(t == null ? void 0 : t.id));
de.register("sprite", Sr(Nf));
de.register("text", (e, s, t) => {
  if (t) {
    const { type: r = "static", text: i = "" } = t;
    return new hs(i, r);
  } else
    return new hs();
});
const gr = document.createElement("canvas");
gr.width = 1;
gr.height = 1;
de.register("image", (e, s, t) => {
  if (t) {
    const { image: r = gr, type: i = "static" } = t;
    return new Sn(r, i);
  } else
    return new Sn(gr);
});
de.register("comment", (e, s, t) => {
  if (t) {
    const { text: r = "" } = t;
    return new ir(r);
  } else
    return new ir();
});
de.register("shader", (e, s, t) => {
  if (t) {
    const { type: r = "static" } = t;
    return new An(r);
  } else
    return new An();
});
de.register("custom", (e, s, t) => {
  if (t) {
    const r = t._item;
    if (!r)
      throw q.error(22), new Error("Cannot create custom element.");
    return r(t);
  } else
    throw q.error(22), new Error("Cannot create custom element.");
});
de.register("g-rect", vt(Of));
de.register("g-circle", vt(Af));
de.register("g-ellipse", vt(Sf));
de.register("g-line", vt(Df));
de.register("g-bezier", vt(Rf));
de.register("g-quad", vt(Cf));
de.register("g-path", vt(If));
de.register("g-rectr", vt(Mf));
const { createApp: Ep, render: wp } = Cd({
  patchProp: function(e, s, t, r, i, n) {
    e.patchProp(s, t, r, i, n);
  },
  insert: function(e, s, t) {
    s.appendChild(e);
  },
  remove: function(e) {
    e.destroy();
  },
  createElement: function(e, s, t, r) {
    const i = de.get(e);
    if (!i)
      throw q.error(20, e), new Error(`Cannot create element '${e}'`);
    return i(s, t, r);
  },
  createText: function(e) {
    return /^\s*$/.test(e) ? new ir() : (q.warn(38), new hs(e));
  },
  createComment: function(e) {
    return new ir(e);
  },
  setText: function(e, s) {
    e instanceof hs ? e.setText(s) : q.warn(39);
  },
  setElementText: function(e, s) {
    e instanceof hs ? e.setText(s) : q.warn(39);
  },
  parentNode: function(e) {
    return e.parent ?? null;
  },
  nextSibling: function(e) {
    if (!e) return null;
    if (e.parent) {
      const t = [...e.parent.children], r = t.indexOf(e);
      return t[r] ?? null;
    } else
      return null;
  }
}), Zn = new bi();
function xp(e) {
  Xo(() => {
    Zn.add(e);
  }), qt(() => {
    Zn.remove(e);
  });
}
function Np() {
  const e = new Ch();
  return qt(() => {
    e.ticker.destroy();
  }), [e];
}
function Tp() {
  const e = new Ih();
  return qt(() => {
    e.ticker.destroy();
  }), [e];
}
function Op(e, s, t) {
  e.on(s, t), qt(() => {
    e.off(s, t);
  });
}
export {
  B as ActionType,
  uf as AttribType,
  Rf as BezierCurve,
  Af as Circle,
  ir as Comment,
  br as Container,
  cf as ContainerCustom,
  Sf as Ellipse,
  wt as EventProgress,
  rr as Font,
  $f as FontWeight,
  ti as GL2,
  yf as GL2Program,
  mt as GraphicItemBase,
  Tf as GraphicMode,
  Sn as Image,
  Df as Line,
  Ss as MotaOffscreenCanvas2D,
  xs as MotaRenderer,
  le as MouseType,
  If as Path,
  Cf as QuadraticCurve,
  Of as Rect,
  Mf as RectR,
  Pf as RectRCorner,
  Yi as RenderAdapter,
  Ue as RenderItem,
  An as Shader,
  bp as ShaderProgram,
  Nf as Sprite,
  hs as Text,
  Nt as Transform,
  Vs as Transform3D,
  ff as UniformMatrix,
  hf as UniformType,
  ns as WheelType,
  gp as addTiming,
  Ep as createApp,
  Pr as eventNameMap,
  vp as isSetEqual,
  nf as isWebGL2Supported,
  pp as isWebGLSupported,
  mp as multiplyTiming,
  Op as onEvent,
  xp as onTick,
  wp as render,
  Sr as standardElement,
  vt as standardElementNoCache,
  de as tagMap,
  of as transformCanvas,
  Np as useAnimation,
  Tp as useTransition,
  yp as wrapInstancedComponent
};
//# sourceMappingURL=render.es.js.map
