var data_a1e2fb4a_e986_4524_b0da_9b7ba7c0874d = 
{
	"main": {
		"floorIds": [
			"items",
			"monsters",
			"start",
			"map1",
			"map2",
			"map3",
			"map4",
			"map5",
			"map6",
			"map7",
			"map8",
			"map9",
			"map10",
			"map11",
			"map12",
			"map13",
			"map14",
			"map15",
			"map16",
			"map17",
			"map18",
			"map19",
			"map20",
			"map21",
			"map22",
			"map23",
			"map24",
			"map25",
			"map26",
			"map27",
			"start_r",
			"map1_r",
			"map2_r",
			"map3_r",
			"map4_r",
			"map5_r",
			"map6_r",
			"map7_r",
			"map8_r",
			"map9_r",
			"map10_r",
			"map11_r",
			"map12_r",
			"map13_r",
			"map14_r",
			"map15_r",
			"map16_r",
			"map17_r",
			"map18_r",
			"map19_r",
			"map20_r",
			"map21_r",
			"map22_r",
			"map23_r",
			"map24_r",
			"map25_r",
			"map26_r",
			"map27_r",
			"battle",
			"final"
		],
		"floorPartitions": [
			[
				"start",
				"map27"
			],
			[
				"start_r",
				"map27_r"
			]
		],
		"images": [
			"cover.jpeg",
			"hero.png"
		],
		"tilesets": [
			"magictower.png",
			"1.png",
			"2.png",
			"forest.png",
			"cave.png",
			"8.png"
		],
		"animates": [
			"hand",
			"jianji",
			"sword",
			"zone"
		],
		"bgms": [
			"bgm1.m4a",
			"bgm2.m4a",
			"bgm3.m4a",
			"bgm4.m4a",
			"bgm5.m4a"
		],
		"sounds": [
			"attack.mp3",
			"bomb.mp3",
			"cancel.mp3",
			"centerFly.mp3",
			"confirm.mp3",
			"cursor.mp3",
			"door.mp3",
			"equip.mp3",
			"error.mp3",
			"floor.mp3",
			"gem.mp3",
			"icePickaxe.mp3",
			"item.mp3",
			"jump.mp3",
			"load.mp3",
			"open_ui.mp3",
			"pickaxe.mp3",
			"recovery.mp3",
			"save.mp3",
			"shop.mp3",
			"zone.mp3"
		],
		"fonts": [],
		"nameMap": {
			"确定": "confirm.mp3",
			"取消": "cancel.mp3",
			"操作失败": "error.mp3",
			"光标移动": "cursor.mp3",
			"打开界面": "open_ui.mp3",
			"读档": "load.mp3",
			"存档": "save.mp3",
			"获得道具": "item.mp3",
			"回血": "recovery.mp3",
			"炸弹": "bomb.mp3",
			"飞行器": "centerFly.mp3",
			"开关门": "door.mp3",
			"上下楼": "floor.mp3",
			"跳跃": "jump.mp3",
			"破墙镐": "pickaxe.mp3",
			"破冰镐": "icePickaxe.mp3",
			"宝石": "gem.mp3",
			"阻激夹域": "zone.mp3",
			"穿脱装备": "equip.mp3",
			"背景音乐": "bgm.mp3",
			"攻击": "attack.mp3",
			"背景图": "bg.jpg",
			"商店": "shop.mp3",
			"领域": "zone"
		},
		"levelChoose": [],
		"equipName": [],
		"startBgm": "bgm1.m4a",
		"styles": {
			"startBackground": "project/images/cover.jpeg",
			"startVerticalBackground": "project/images/cover.jpeg",
			"startLogoStyle": "color: white; font-family: 'STHeiti', 'Heiti SC', 'Microsoft Yahei'; margin-top: 16%;",
			"startButtonsStyle": "background-color: #32369F; opacity: 0.85; color: #FFFFFF; border: #FFFFFF 2px solid; caret-color: #FFD700;",
			"statusLeftBackground": "linear-gradient(180deg, rgb(55,55,100) 0%, rgb(11,11,20) 100%)",
			"statusTopBackground": "linear-gradient(135deg, rgb(55,55,100) 0%, rgb(11,11,20) 100%)",
			"toolsBackground": "linear-gradient(135deg, rgb(55,55,100) 0%, rgb(11,11,20) 100%)",
			"floorChangingStyle": "background-color: black; color: white;",
			"borderColor": [
				204,
				204,
				204,
				1
			],
			"statusBarColor": [
				255,
				255,
				255,
				1
			],
			"selectColor": [
				255,
				215,
				0,
				1
			],
			"font": "Verdana"
		},
		"splitImages": []
	},
	"firstData": {
		"title": "宝物探险家",
		"name": "adventureandcollection",
		"version": "1.0",
		"floorId": "start",
		"hero": {
			"image": "hero.png",
			"animate": false,
			"name": "探险家",
			"lv": 1,
			"hpmax": -1,
			"hp": 1000,
			"manamax": -1,
			"mana": 0,
			"atk": 20,
			"def": 10,
			"mdef": 0,
			"money": 0,
			"exp": 0,
			"equipment": [],
			"items": {
				"constants": {
					"book": 1,
					"fly": 1
				},
				"tools": {},
				"equips": {}
			},
			"loc": {
				"direction": "down",
				"x": 6,
				"y": 4
			},
			"flags": {
				"__atk_buff__": 1,
				"__def_buff__": 1,
				"matk": 0,
				"decdef": 0,
				"decdamage": 0,
				"tempbuffs": [],
				"itemDetail": true
			},
			"followers": [],
			"steps": 0
		},
		"startCanvas": [
			{
				"type": "comment",
				"text": "在这里可以用事件来自定义绘制标题界面的背景图等"
			},
			{
				"type": "comment",
				"text": "也可以直接切换到其他楼层（比如某个开始剧情楼层）进行操作。"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 0,
						"y": 0,
						"width": "core.__PIXELS__",
						"height": "core.__PIXELS__",
						"style": [
							82,
							82,
							82,
							1
						]
					},
					{
						"type": "setAttribute",
						"align": "center"
					},
					{
						"type": "fillBoldText",
						"x": "core.__PIXELS__ / 2",
						"y": 80,
						"style": [
							255,
							255,
							255,
							1
						],
						"strokeStyle": [
							0,
							0,
							0,
							1
						],
						"font": "bold 40px Verdana",
						"text": "${core.firstData.title}"
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "0"
			},
			{
				"type": "comment",
				"text": "在右下方自绘一个对话框进行显示选择项"
			},
			{
				"type": "previewUI",
				"action": [
					{
						"type": "fillRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							50,
							54,
							159,
							0.85
						]
					},
					{
						"type": "strokeRect",
						"x": 230,
						"y": 250,
						"width": 150,
						"height": 142,
						"radius": 10,
						"style": [
							255,
							255,
							255,
							1
						],
						"lineWidth": 2
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 290,
						"style": [
							255,
							255,
							255,
							1
						],
						"font": "bold 25px Verdana",
						"text": "开始游戏"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 330,
						"font": "bold 25px Verdana",
						"text": "读取存档"
					},
					{
						"type": "fillBoldText",
						"x": 305,
						"y": 370,
						"font": "bold 25px Verdana",
						"text": "回放录像"
					}
				]
			},
			{
				"type": "while",
				"condition": "1",
				"data": [
					{
						"type": "drawSelector",
						"image": "winskin.png",
						"code": 1,
						"x": 245,
						"y": "261 + 40*flag:selection",
						"width": 120,
						"height": 40
					},
					{
						"type": "wait",
						"data": [
							{
								"case": "keyboard",
								"keycode": "13,32",
								"break": true,
								"action": [
									{
										"type": "switch",
										"condition": "flag:selection",
										"caseList": [
											{
												"case": "0",
												"action": [
													{
														"type": "comment",
														"text": "在“开始游戏”确定"
													},
													{
														"type": "break",
														"n": 1
													}
												]
											},
											{
												"case": "1",
												"action": [
													{
														"type": "comment",
														"text": "在“读取存档”确定"
													},
													{
														"type": "callLoad"
													}
												]
											},
											{
												"case": "2",
												"action": [
													{
														"type": "comment",
														"text": "在“回放录像”确定"
													},
													{
														"type": "if",
														"condition": "(!core.isReplaying())",
														"true": [
															{
																"type": "function",
																"function": "function(){\ncore.chooseReplayFile()\n}"
															}
														]
													}
												]
											}
										]
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "38",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标上键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 2) % 3"
									}
								]
							},
							{
								"case": "keyboard",
								"keycode": "40",
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "光标下键"
									},
									{
										"type": "setValue",
										"name": "flag:selection",
										"value": "(flag:selection + 1) % 3"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									261,
									300
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“开始游戏”"
									},
									{
										"type": "break",
										"n": 1
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									301,
									340
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“读取存档”"
									},
									{
										"type": "callLoad"
									}
								]
							},
							{
								"case": "mouse",
								"px": [
									245,
									365
								],
								"py": [
									341,
									380
								],
								"break": true,
								"action": [
									{
										"type": "comment",
										"text": "点击“播放录像”"
									},
									{
										"type": "if",
										"condition": "(!core.isReplaying())",
										"true": [
											{
												"type": "function",
												"function": "function(){\ncore.chooseReplayFile()\n}"
											}
										]
									}
								]
							}
						]
					}
				]
			},
			{
				"type": "setValue",
				"name": "flag:selection",
				"value": "null"
			},
			{
				"type": "drawSelector",
				"code": 1
			},
			{
				"type": "clearMap"
			},
			{
				"type": "function",
				"function": "function(){\ncore.control.checkBgm()\n}"
			},
			{
				"type": "if",
				"condition": "(main.levelChoose.length == 0)",
				"true": [
					{
						"type": "comment",
						"text": "没有难度选择：直接开始游戏"
					}
				],
				"false": [
					{
						"type": "comment",
						"text": "难度选择：作为样例，这里只提供了一个显示选择项。"
					},
					{
						"type": "function",
						"function": "function(){\nvar choices = [];\nmain.levelChoose.forEach(function (one) {\n\tchoices.push({\n\t\t\"text\": one.title || '',\n\t\t\"action\": [\n\t\t\t{ \"type\": \"function\", \"function\": \"function() { core.status.hard = '\" + (one.name || '') + \"'; }\" }\n\t\t]\n\t});\n})\ncore.insertAction({ \"type\": \"choices\", \"choices\": choices });\n}"
					},
					{
						"type": "comment",
						"text": "你也可以仿照上面的样例进行自己创建等待用户操作来处理不同的难度分歧。\n如需自己处理，请设置 core.status.hard \n（例如，自定义js脚本：core.status.hard = 'Easy' ）"
					}
				]
			},
			{
				"type": "clearMap"
			},
			{
				"type": "comment",
				"text": "接下来会执行startText中的事件"
			},
			{
				"type": "comment",
				"text": "状态栏默认处于隐藏状态；可以使用“显示状态栏”事件进行显示。"
			}
		],
		"startText": [
			{
				"type": "comment",
				"text": "初始剧情"
			},
			{
				"type": "choices",
				"text": "\t[选择模式]普通：固定模式，剧情完整，首次游玩建议选择。\n随机：道具和怪物随机，富有趣味性。\n随机-困难：在随机的基础上，敌人属性更高。",
				"choices": [
					{
						"text": "普通",
						"action": [
							{
								"type": "function",
								"function": "function(){\ncore.status.hard = '普通';\ncore.firstData.floorId='start';\n}"
							}
						]
					},
					{
						"text": "随机",
						"action": [
							{
								"type": "function",
								"function": "function(){\ncore.status.hard = '随机';\ncore.firstData.floorId='start_r';\ncore.plugin.randomMode_init();\n}"
							}
						]
					},
					{
						"text": "随机-困难",
						"action": [
							{
								"type": "function",
								"function": "function(){\ncore.status.hard = '随机-困难';\ncore.firstData.floorId='start_r';\ncore.plugin.randomMode_init();\n}"
							}
						]
					}
				]
			},
			{
				"type": "setCurtain",
				"color": [
					0,
					0,
					0
				],
				"time": 500
			},
			"你是一名探险家，来到一个偏僻的村庄附近寻找宝藏。根据情报，这个村子附近曾经是战场，散落着不少遗失的宝藏。",
			"这里地处王国边陲，周围人迹罕至，甚至这个村庄的位置也鲜有人知。"
		],
		"shops": [
			{
				"id": "shop1",
				"text": "\t[丽儿,npc0]100金币可以购买一个道具。你想要什么？",
				"textInList": "商店",
				"mustEnable": true,
				"disablePreview": true,
				"choices": [
					{
						"text": "镐（剩余${3 - flag:buypickaxe}）",
						"need": "status:money>=100 && flag:buypickaxe<3",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "function",
								"function": "function(){\ncore.getItem('pickaxe')\n}"
							},
							{
								"type": "setValue",
								"name": "flag:buypickaxe",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "炸弹（剩余${2 - flag:buybomb}）",
						"need": "status:money>=100 && flag:buybomb<2",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "function",
								"function": "function(){\ncore.getItem('bomb')\n}"
							},
							{
								"type": "setValue",
								"name": "flag:buybomb",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "机关修理工具（剩余${2 - flag:buykey}）",
						"need": "status:money>=100 && flag:buykey<2",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "function",
								"function": "function(){\ncore.getItem('specialKey')\n}"
							},
							{
								"type": "setValue",
								"name": "flag:buykey",
								"operator": "+=",
								"value": "1"
							}
						]
					},
					{
						"text": "力量药剂",
						"need": "status:money>=100",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "function",
								"function": "function(){\ncore.getItem('I546')\n}"
							}
						]
					},
					{
						"text": "抵抗药剂",
						"need": "status:money>=100",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "function",
								"function": "function(){\ncore.getItem('I547')\n}"
							}
						]
					},
					{
						"text": "回复药剂",
						"need": "status:money>=100",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "function",
								"function": "function(){\ncore.getItem('I548')\n}"
							}
						]
					},
					{
						"text": "生命+1000",
						"need": "status:money>=100",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "1000"
							},
							{
								"type": "playSound",
								"name": "shop.mp3"
							}
						]
					}
				]
			},
			{
				"id": "shop2",
				"text": "\t[丽儿,npc0]100金币可以购买一个随机道具。你想要么？",
				"textInList": "商店",
				"mustEnable": true,
				"disablePreview": true,
				"choices": [
					{
						"text": "随机道具",
						"need": "status:money>=100",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "function",
								"function": "function(){\ncore.getItem(core.plugin.getRandomItem(5))\n}"
							}
						]
					},
					{
						"text": "生命+1000",
						"need": "status:money>=100",
						"action": [
							{
								"type": "setValue",
								"name": "status:money",
								"operator": "-=",
								"value": "100"
							},
							{
								"type": "setValue",
								"name": "status:hp",
								"operator": "+=",
								"value": "1000"
							},
							{
								"type": "playSound",
								"name": "shop.mp3"
							}
						]
					}
				]
			}
		],
		"levelUp": [
			{
				"need": "0",
				"title": "",
				"action": [
					{
						"type": "comment",
						"text": "此处是初始等级，只需填写称号"
					}
				]
			},
			{
				"need": "20",
				"title": "",
				"action": [
					{
						"type": "setValue",
						"name": "status:atk",
						"operator": "+=",
						"value": "10"
					},
					{
						"type": "setValue",
						"name": "status:def",
						"operator": "+=",
						"value": "10"
					}
				]
			},
			{
				"need": "40",
				"title": "",
				"action": [
					{
						"type": "tip",
						"text": "恭喜升级"
					}
				]
			}
		]
	},
	"values": {
		"lavaDamage": 0,
		"poisonDamage": 0,
		"weakValue": 0,
		"redGem": 2,
		"blueGem": 2,
		"greenGem": 5,
		"redPotion": 100,
		"bluePotion": 200,
		"yellowPotion": 400,
		"greenPotion": 800,
		"breakArmor": 0,
		"counterAttack": 0,
		"purify": 0,
		"hatred": 0,
		"animateSpeed": 400,
		"moveSpeed": 100,
		"statusCanvasRowsOnMobile": 3,
		"floorChangeTime": 400,
		"shootingatk": 1
	},
	"flags": {
		"statusBarItems": [
			"enableFloor",
			"enableHP",
			"enableAtk",
			"enableDef",
			"enableMDef",
			"enableMoney",
			"enableSkill"
		],
		"extendToolbar": false,
		"flyNearStair": false,
		"flyRecordPosition": true,
		"itemFirstText": true,
		"equipboxButton": false,
		"enableAddPoint": false,
		"enableNegativeDamage": false,
		"betweenAttackMax": false,
		"useLoop": true,
		"startUsingCanvas": false,
		"statusCanvas": false,
		"enableEnemyPoint": true,
		"enableGentleClick": true,
		"ignoreChangeFloor": true,
		"canGoDeadZone": false,
		"enableMoveDirectly": true,
		"enableRouteFolding": true,
		"disableShopOnDamage": false,
		"blurFg": false,
		"multiple_shooting": false,
		"unrestrained_shooting": false
	}
}